//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx
//	Include File:	tdoslynx.h
//	Purpose:	The DosLynx WWW client.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-31-94	created
#include"tdoslynx.h"
#include"globals.h"
#include"image.h"
#include<string.h>
#include<fstream.h>

void TDosLynx::EvalConfigFile()	{
//	Purpose:	Go through pertinent DosLynx options in the
//			configuration file.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-31-94	created

	const char *cp_configname = "DOSLYNX.CFG";
	auto char *cp_openname;

	//	Create the config file name.
	if(cp_inipath != NULL)	{
		cp_openname = new char[strlen(cp_inipath) +
			strlen(cp_configname) + 2];
		strcpy(cp_openname, cp_inipath);
		strcat(cp_openname, "\\");
		strcat(cp_openname, cp_configname);
	}
	else	{
		cp_openname = newStr(cp_configname);
	}

	//	Open the configuration file for reading.
	auto fstream *fsp_config = new fstream(cp_openname, ios::in |
		ios::nocreate);
	if(fsp_config == NULL)	{
		doslynxmessage("Unable to open configuration file " <<
			cp_openname);
		delete(cp_openname);
		return;
	}

	//	Begin reading the file line by line.
	//	Skip all comment lines, blank lines, and unknown keyword
	//	lines.
	auto char ca_linebuffer[256];
	while(fsp_config->eof() == 0 && fsp_config->bad() == 0)	{
		//	Reset the line, get a new line.
		ca_linebuffer[0] = '\0';
		fsp_config->getline(ca_linebuffer, 256);

		//	Continue the loop if a comment.
		if(ca_linebuffer[0] == '#' || ca_linebuffer[0] == ';')	{
			continue;
		}
		//	Continue the loop if a blank.
		else if(isspace(ca_linebuffer[0]))	{
			continue;
		}
		//	Continue the loop if not a recognized keyword.
		else	{
			//	If there is no '=' in the line, this is not
			//	a valid entry.
			auto char *cp_temp = strchr(ca_linebuffer, '=');
			if(cp_temp == NULL)	{
				continue;
			}

			//	Move past the '=' and any space.
			cp_temp++;
			while(isspace(*cp_temp) && *cp_temp != '\0')	{
				cp_temp++;
			}

			//	If the line ended, continue on.
			if(*cp_temp == '\0')	{
				continue;
			}

			//	End the line on the first space.
			//	May cause problem with tagged URL.
			auto char *cp_trailer = cp_temp;
			while(!isspace(*cp_trailer) && *cp_trailer != ';' &&
				*cp_trailer != '#' && *cp_trailer != '\0')
			{
				cp_trailer++;
			}
			*cp_trailer = '\0';

			//	Look for known keywords.
			if(strnicmp("tempdir", ca_linebuffer, 7))	{
			if(strnicmp("textmode", ca_linebuffer, 8))	{
			if(strnicmp("printer", ca_linebuffer, 7))	{
			if(strnicmp("loaded", ca_linebuffer, 6))	{
			if(strnicmp("home", ca_linebuffer, 4))	{
			if(strnicmp("loadhome", ca_linebuffer, 8))	{
			if(strnicmp("graphicsmode", ca_linebuffer, 12))	{
			if(strnicmp("hotlistfile", ca_linebuffer, 11))	{
			if(strnicmp("errorhtml", ca_linebuffer, 9))	{
			if(strnicmp("mailaddr", ca_linebuffer, 8))	{
			if(strnicmp("networked", ca_linebuffer, 9))	{
			if(strnicmp("nntphost", ca_linebuffer, 8))	{
			if(strnicmp("emspages", ca_linebuffer, 8))	{
			if(strnicmp("ems", ca_linebuffer, 3))	{
			if(strnicmp("xmslength", ca_linebuffer, 9))	{
			if(strnicmp("xmsstart", ca_linebuffer, 8))	{
			if(strnicmp("xms", ca_linebuffer, 3))	{
			if(strnicmp("http_proxy", ca_linebuffer, 10))	{
			if(strnicmp("gopher_proxy", ca_linebuffer, 12))	{
			if(strnicmp("ftp_proxy", ca_linebuffer, 9))	{
			if(strnicmp("wais_proxy", ca_linebuffer, 10))	{
				//	No recognized keywords.
				continue;
			}
			else	{
				//	wais_proxy entry.

				//	If there was an old one, free it.
				if(cp_wais_proxy != NULL)	{
					delete(cp_wais_proxy);
				}

				//	Just copy it over.
				cp_wais_proxy = newStr(cp_temp);
			}
			}
			else	{
				//	ftp_proxy entry.

				//	If there was an old one, free it.
				if(cp_ftp_proxy != NULL)	{
					delete(cp_ftp_proxy);
				}

				//	Just copy it over.
				cp_ftp_proxy = newStr(cp_temp);
			}
			}
			else	{
				//	gopher_proxy entry.

				//	If there was an old one, free it.
				if(cp_gopher_proxy != NULL)	{
					delete(cp_gopher_proxy);
				}

				//	Just copy it over.
				cp_gopher_proxy = newStr(cp_temp);
			}
			}
			else	{
				//	http_proxy entry.

				//	If there was an old one, free it.
				if(cp_http_proxy != NULL)	{
					delete(cp_http_proxy);
				}

				//	Just copy it over.
				cp_http_proxy = newStr(cp_temp);
			}
			}
			else	{
				//	xms entry.

				//	check for values.
				if(stricmp("YES", cp_temp))	{
				if(stricmp("NO", cp_temp))	{
					//	bad value.
				}
				else	{
					B_xms = False;
				}
				}
				else	{
					B_xms = True;
				}
			}
			}
			else	{
				//	xmsstart entry.

				//	Make sure a valid long integer.
				auto unsigned long int uli_temp =
					strtoul(cp_temp, NULL, 0);
				if(uli_temp != 0UL)	{
					uli_xmsstart = uli_temp;
				}
			}
			}
			else	{
				//	xmslength entry.

				//	Make sure a valid long integer.
				auto unsigned long int uli_temp =
					strtoul(cp_temp, NULL, 0);
				if(uli_temp != 0UL)	{
					uli_xmslength = uli_temp;
				}
			}
			}
			else	{
				//	ems entry.

				//	check for values.
				if(stricmp("YES", cp_temp))	{
				if(stricmp("NO", cp_temp))	{
					//	bad value.
				}
				else	{
					B_ems = False;
				}
				}
				else	{
					B_ems = True;
				}
			}
			}
			else	{
				//	emspages entry.

				//	Make sure a valid long integer.
				auto unsigned long int uli_temp =
					strtoul(cp_temp, NULL, 0);
				if(uli_temp != 0UL)	{
					usi_emspages = (unsigned short int)
						uli_temp;
				}
			}
			}
			else	{
				//	nntphost entry.

				//	If there is an old entry, get rid.
				if(cp_nntphost != NULL)	{
					delete(cp_nntphost);
				}
				cp_nntphost = newStr(cp_temp);
			}
			}
			else	{
				//	networked entry.

				//	check for values.
				if(stricmp("YES", cp_temp))	{
				if(stricmp("NO", cp_temp))	{
					//	bad value.
				}
				else	{
					i_networked = 0;
				}
				}
				else	{
					i_networked = 1;
				}
			}
			}
			else	{
				//	mailaddr entry.

				//	If there is a prior entry....
				if(::cp_ReplyTo != NULL)	{
					delete(::cp_ReplyTo);
				}
				cp_ReplyTo = newStr(cp_temp);
			}
			}
			else	{
				//	errorhtml entry.

				//	If there is a previos entry....
				if(::cp_ErrorHTML != NULL)	{
					delete(::cp_ErrorHTML);
				}
				cp_ErrorHTML = newStr(cp_temp);
			}
			}
			else	{
				//	hotlistfile entry

				//	If there is a previous hotlistfile
				//	entry, get rid of it.
				if(::cp_HotList != NULL)	{
					delete(::cp_HotList);
				}
				cp_HotList = newStr(cp_temp);
			}
			}
			else	{
				//	graphicsmode entry

				//	Take action on the proper value.
				if(stricmp("none", cp_temp))	{
				if(stricmp("720x348x2", cp_temp))	{
				if(stricmp("640x200x2", cp_temp))	{
				if(stricmp("640x350x16", cp_temp))	{
				if(stricmp("640x480x16", cp_temp))	{
					//	Bad value.
				}
				else	{
					//	640x480x16
					usi_graphicsmode = (image_modes)
						image_mode_vga_640x480x16;
				}
				}
				else	{
					//	640x350x16
					usi_graphicsmode = (image_modes)
						image_mode_ega;
				}
				}
				else	{
					//	640x200x2
					usi_graphicsmode = (image_modes)
						image_mode_cga;
				}
				}
				else	{
					//	720x348x2
					usi_graphicsmode = (image_modes)
						image_mode_herc;
				}
				}
				else	{
					//	NONE
					usi_graphicsmode = (image_modes)
						image_modes_total;
				}
			}
			}
			else	{
				//	loadhome entry

				//	Take action on the proper value.
				if(stricmp("ON", cp_temp))	{
				if(stricmp("OFF", cp_temp))	{
					//	Bad value.
				}
				else	{
					//	OFF
					B_loadHome = False;
				}
				}
				else	{
					//	ON
					B_loadHome = True;
				}
			}
			}
			else	{
				//	home entry

				//	If there is a previous home entry,
				//	get rid of it.
				if(::cp_Home != NULL)	{
					delete(::cp_Home);
				}
                                ::cp_Home = newStr(cp_temp);
			}
			}
			else	{
				//	loaded entry

				//	Set our maximum loaded HText limit.
				auto unsigned short int usi_newmax =
					(unsigned short int)atoi(cp_temp);
				if(usi_newmax)	{
                                	usi_MaxLoadedHTexts = usi_newmax;
				}
			}
			}
			else	{
				//	printer entry

				//	If there is a prior entry, get rid
				//	of it.
				if(::cp_Printer != NULL)	{
					delete(cp_Printer);
				}
				::cp_Printer = newStr(cp_temp);
			}
			}
			else	{
				//	textmode entry

				//	Take action on the proper value.
				if(stricmp("low", cp_temp))	{
				if(stricmp("high", cp_temp))	{
					//	Bad value.
				}
				else	{
					//	HIGH
					if(B_isLow == True)	{
						switchVideo();
					}
				}
				}
				else	{
					//	LOW
					if(B_isLow == False)	{
						switchVideo();
					}
				}
			}
			}
			else	{
				//	tempdir entry

				//	If there was a previous tempdir
				//	entry, get rid of it.
				if(::cp_TempDir != NULL)	{
					delete(::cp_TempDir);
				}
				::cp_TempDir = newStr(cp_temp);
			}
		}
	}

	//	Done with the file.
	fsp_config->close();
	delete(fsp_config);
}