#ifndef __TDOSLYNX_H
//	Avoid include redundancy
#define __TDOSLYNX_H

//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Include File:	TDosLynx.h
//	Purpose:	Declare the TDosLynx class
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-09-93

//	Constant defines
#define Uses_TApplication
#define Uses_TStatusLine
#define Uses_TMenuBar
#define Uses_TEvent

//	Required includes
#include<tv.h>
#include"THeapVie.h"
#include"TClockVi.h"
#include"tsockvie.h"
#include"tdiskvie.h"

//	Class declaraions
class TDosLynx : public TApplication	{
public:
	TDosLynx(int i_argc, char **cpp_argv);
	~TDosLynx();
	static TStatusLine *initStatusLine(TRect TR_r);
	static TMenuBar *initMenuBar(TRect TR_r);
	static TDeskTop *initDeskTop(TRect TR_r);
	virtual void idle();
	virtual void handleEvent(TEvent& TE_Event);
	virtual void getEvent(TEvent& TE_Event);
	virtual void outOfMemory();
private:
	THeapView *THV_heap;
	TClockView *TCV_clock;
	TSockView *TSV_sock;
	TDiskView *TDV_disk;
	void EvalOption(int i_sequence, char *cp_argument);
	void OpenURL(const char *cp_URL = NULL);
	void OpenLocal(const char *cp_path = NULL);
	TView *TVp_ToBeRemoved;
	char *cp_ToBeViewed;
	void EvalConfigFile();
	void mailDeveloper();
	void switchVideo();
	Boolean B_isLow;
	Boolean B_loadHome;
};

//	Global variable declarations

//	Macros/Inline code

#endif // __TDOSLYNX_H
