#!/usr/bin/perl
#
# archieplexsimple.pl --  Simple Archie search
#
# $Id: archieplexsimple.pl,v 1.6 1994/08/07 17:23:33 www Exp $
#
# By Martijn Koster (m.koster@nexor.co.uk)
# This code is placed in the public domain.

# archieplex*.pl files:
$packages = '/nexor/users/www/data/archieplex-info';

unshift(@INC,$packages);
require "archieplexengine.pl";

package archieplexsimple;

# CGI interface
if (!defined $main'plexus_configured)
{
    &main'do_archieplexsimple($ENV{'QUERY_STRING'});
}

sub main'do_archieplexsimple
{
    local($query) = @_;    # $query is the query string

    $query ? &do_search($query) : &do_dialog();
}

sub do_dialog
{
    &main'MIME_header('ok', 'text/html');

    print <<"EOM";
<html>
<HEAD>
<ISINDEX>
<TITLE>Simple ArchiePlex Search</TITLE>
</HEAD>
<BODY>
<H1>Simple ArchiePlex Search</H1>
This gateway searches FTP sites world-wide for filenames.
Please specify a search term.
</BODY>
</HTML>
EOM
}

sub do_search
{
    local($query) = @_;

    $query =~ s/\+/ /g;
    $query =~ s/%([\da-f]{1,2})/pack(C,hex($1))/eig;

    &archieplexengine'execute(undef, undef, undef, undef, $query);
}

1;
