#import <PercentView.h>
#import <dpsclient/dpsclient.h>
#import <dpsclient/wraps.h>
#import <appkit/nextstd.h>
#import <appkit/graphics.h>

@implementation PercentView

- displayPercent: (float) p
{
float dp;
	dp = ABS(percent - p);
	if(p != 1.0 && dp < 0.02)
		return nil; 
	percent = p;
	[self display];
	return self;
}

- drawSelf: (const NXRect *) rects :(int) rectCount
{
float x,y,dx,dy;
float r,endAngle;

	if(rectCount == 0)
		return self;

	/* Calculate my center and half width */
	dx = bounds.size.width / 2.0;
	x =  dx + bounds.origin.x;
	dy = bounds.size.height / 2.0;
	y = dy + bounds.origin.y;
	r = MIN(dx,dy);
	r -= 2;
	endAngle = 90.0 - 360.0 * percent;
	/* Erase my bounds */
	PSsetgray(NX_LTGRAY);
	NXRectFill(&bounds);

	/* Draw black circle */
	PSsetgray(NX_BLACK);
	PSarc(x, y, r, 0.0, 360.0);
	PSstroke();
	r --;
	PSsetgray(NX_DKGRAY);
	PSmoveto(x,y);
	PSarcn(x,y,r,90.0, endAngle);
	PSfill();

	return self;
}

@end
