/* A subclass of Object that performs ftp excursions on behalf of the
	invoking program */

#import <objc/Object.h>
#import <dpsclient/dpsclient.h>
#import <stdio.h>
#import <sys/param.h>

@interface FTPManager : Object
{
	char ftpDirectory[MAXPATHLEN];	// Local target directory for ftp transfers
	char *localFilePath ;	// The local system's path for the file being received
	id pwdPanelID;		// The OpenPanel displayed to set the transfer directory
	id saveAsPanelID;	// The SavePanel displayed if file name collision occurs
	id ftpPanelID;		// The Panel displayed during the ftp process
	id ftpErrPanelID;	// A panel that can be brought up by the user to view the last
						// ftp output if an error occurs
	id ftpErrViewID;		// The scrollview in the ftpErrPanel
	id hostnameFieldID;	// TextField for displaying the hostname
	id messageFieldID;	// TextField for status messages
	id sizeFieldID;		// TextField for displaying the number of bytes transfered
	id statusBoxID;		// The Box which encloses the status objects
	id statusViewID;		// A PercentView object for displaying the percent transfered
	id timerViewID;		// A ClockView for displaying the process time
	int ftpProcessPID;	// The id of the child process running the ftp program
	int ftpMode;			// A variable used to coordinate parent/child communication
	int targetFileSize;	// The size of the remote file being retrieved
	int listingTECalls;	// The number of times the dirListingTE has executed without
						// seeing the size of the listingBuffer increase
	DPSTimedEntry ftpDaemonTE;	// The process which reads the ftp output
	DPSTimedEntry dirListingTE;		// The process which tries to make sure that
									// we don't stall while waiting for a dir listing
	BOOL transferComplete;	// A flag on which the main modal session loops
	BOOL listingTEStarted;	// A flag indicating if the dirListingTE is running
	id errStringTable;		// The NXStringTable of the program error messages

// Debugging
	int ftpDebugLevel;
	FILE *errFile;
}

	// Ftp process initiation methods
/* Initiate the ftp process to host hostName and retrieve the file targetPathName.
	anonymous is a flag indicating if this should be run as an anonymous ftp and
	as such does not prompt for login info.  The overWrite flag indicates whether
	an alert panel should be displayed when a local file has the same name as
	the remote file.  NO means the user will be prompted, YES means the local
	file will be wiped out without user verification.  A directory listing is
	requested by passing a non-nil value for dirVLINK.  On return, the listing instance
	variable of dirVLINK will be set to a linked list of DirEntry's. */
- runModal: (const char *) hostName get: (const char *) targetPathName;
- runModal: (const char *) hostName get: (const char *) targetPathName anon: (BOOL) anonymous;
- runModal: (const char *) hostName get: (const char *) targetPathName dir: (BOOL) listing;
- runModal: (const char *) hostName get: (const char *) targetPathName anon: (BOOL) anonymous
	write: (BOOL) overWrite binary: (BOOL) mode vlink: dirVLINK;
- abortTransfer: sender;
- displayErrOutput: sender;

/* Write a command line to the ftp program */
- writeFtp : sender;
- writeFtpCommand : (char *) formatString, ...;

/* Future routines */
- runBatch: (const char *) hostName get: (const char *) targetPathName;
- runBatch: (const char *) hostName get: (const char *) targetPathName priority: (int) priority;

/* Set the local transfer directory */
- setLocalDir: sender;
- setLocalPath: (const char *) dirName file: (const char *) fileName panel: (BOOL) display;

/* Error handling */
- error:(int) severity key:(const char *) keyString;

/* My debugging methods */
	// Required arguemts are: (int) debugLevel,(char *)formatString
- debug: (int) debugLevel, ...;
	// Required arguemts are: (int)condition,(int) debugLevel,(char *)formatString
- conditionalDebug: (BOOL) condition : (int) debugLevel, ...;
- setDebugLevel: sender;
- setErrFile: (FILE *) err;

@end
