/*
 * dfile.c - SGI IRIX file processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.9 95/02/24 11:15:28 abe Exp $";
#endif


#include "lsof.h"


/*
 * is_file_named() - is this file named?
 */

int
is_file_named(p, ty)
	char *p;			/* path name; NULL = search by device
					 * and inode (from *Lf) */

#if	_IRIXV>=50101
	vtype_t ty;			/* vnode type */
#else	/* _IRIXV<50101 */
	int ty;				/* inode type */
#endif	/* _IRIXV>=50101 */

{
	int f;
	struct sfile *s;
/*
 * Search the file chain.
 */
	for (f = 0, s = Sfile; s; s = s->next) {

	/*
	 * Search by path name, as requested.
	 */
		if (p != NULL) {
			if (strcmp(p, s->aname) == 0
			||  strcmp(p, s->name)  == 0)
			{
				f = 2;
				break;
			}
			continue;
		}
	/*
	 * Check for a clone file.
	 */

#if    _IRIXV<50101
		if (Lf->is_com)
#endif	/* _IRIXV<50101 */

		{

			if (major(s->dev) == USEMA_MAJOR
			&&  major(Lf->dev) == USEMA_MAJOR) {
				f = 1;
				break;
			}

#if    _IRIXV<50101
			if (major(s->dev) == CLN2_MAJOR
#else	/* _IRIXV>=50101 */
			if (major(s->dev) == CLN_MAJOR
#endif	/* _IRIXV<50101 */

			&&  major(Lf->dev) == minor(s->dev)) {
				f = 1;
				break;
			}
		}
	/*
	 * Check for a regular file or directory -- the device and
	 * indoe numbers must match.
	 */
		if (s->type) {
			if (Lf->dev == s->dev && (ino_t)Lf->inode == s->i) {
				f = 1;
				break;
			}
			continue;
		}
	/*
	 * Check for a file system match.
	 * Try to avoid matching character files to non-character devices.
	 */
		if (Lf->dev == s->dev) {

#if    _IRIXV<50101
			if ( ! (ty == IFCHR && s->mode != S_IFCHR)) {
#else	/* _IRIXV>=50101 */
			if ( ! (ty == VCHR && s->mode != S_IFCHR)) {
#endif	/* _IRIXV<50101 */

				f = 1;
				break;
			}
		}
	}
/*
 * Convert the name if a match occurred.
 */
	if (f) {
		if (f == 2)
			(void) strcpy(Namech, p);
		else {
			(void) strcpy(Namech, s->name);
			if (s->devnm)
				(void) sprintf(endnm(), " (%s)", s->devnm);
		}
		s->f = 1;
		return(1);
	}
	return(0);
}


/*
 * process_file() - process file
 */

void
process_file(fp)
	struct file *fp;		/* kernel file structure address */
{
	struct file f;
	int flag;

	if (kread((KA_T)fp, (char *)&f, sizeof(f))) {
		(void) sprintf(Namech, "can't read file struct from %#x", fp);
		enter_nm(Namech);
		return;
	}
	Lf->off = f.f_offset;

	if (f.f_count) {

	/*
	 * Construct access code.
	 */
		if ((flag = (f.f_flag & (FREAD | FWRITE))) == FREAD)
			Lf->access = 'r';
		else if (flag == FWRITE)
			Lf->access = 'w';
		else if (flag == (FREAD | FWRITE))
			Lf->access = 'u';
	/*
	 * Process structure.
	 */

#if	_IRIXV<50101
		process_node((caddr_t)f.f_inode);
#else	/* _IRIXV>=50101 */
		process_node((caddr_t)f.f_vnode);
#endif	/* _IRIXV<50101 */

		return;

	}
	enter_nm("no more information");
}


/*
 * The ck_file_arg() function is obtained from ../common/ckfa.frag.
 * The print_file() function is obtained from ../common/prtf.frag.
 */

/* CKFA_EXPDEV is not defined. */
/* CKFA_MPXCHAN is not defined. */
/* CKFA_XDEVTST is not defined. */
