/*
 * dstore.c - SCO Unix global storage for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.9 95/09/12 07:56:17 abe Exp $";
#endif


#include "lsof.h"


char **Cdevsw = NULL;		/* names from kernel's cdevsw[].d_name */
int Cdevcnt = 0;		/* Cdevsw[] count */
struct clone *Clone = NULL;	/* clone device list */
int CloneMajor;			/* clone major device */
char **Fsinfo = NULL;		/* file system information */
int Fsinfomax = 0;		/* maximum file system type */
int HaveCloneMajor = 0;		/* have clone major device number = 1 */
int HaveSockdev = 0;		/* socket device number status: 1 = available */
int Hz = -1;			/* system clock frequency */
int Kmem = -1;			/* /dev/kmem file descriptor */

struct nlist Nl[] = {
	{ "cdevsw",	0, 0, 0, 0, 0 },
	{ "cdevcnt",	0, 0, 0, 0, 0 },
	{ "Hz",		0, 0, 0, 0, 0 },
	{ "lbolt",	0, 0, 0, 0, 0 },
	{ "proc",	0, 0, 0, 0, 0 },
	{ "sockdev",	0, 0, 0, 0, 0 },
	{ "socktab",	0, 0, 0, 0, 0 },
	{ "v",		0, 0, 0, 0, 0 },

#if	_SCOV>=40
	{ "nxdevmaps",	0, 0, 0, 0, 0 },
	{ "xdevmap",	0, 0, 0, 0, 0 },

# if	_SCOV<500
	{ "pregpp",	0, 0, 0, 0, 0 },
# endif	/* _SCOV<500 */
#endif	/* _SCOV>=40 */

	{ NULL,		0, 0, 0, 0, 0 }
};

int Sockdev;			/* socket device number */
KA_T Socktab;			/* address of socket pointer table */


#if	_SCOV>=40
/*
 * The following items are needed by the internal kernel major()
 * and minor() macros for mapping extended minor numbers.
 */

int nxdevmaps = -1;		/* maximum kernel xdevmap[] index */
struct XDEVMAP XDEVMAP[1];	/* dummy */
struct XDEVMAP *Xdevmap;	/* dynamically allocated xdevmap[] */
#endif	/* _SCOV>=40 */
