/*
 * *****************************************************************
 * *                                                               *
 * *    Copyright (c) Digital Equipment Corporation, 1991, 1994    *
 * *                                                               *
 * *   All Rights Reserved.  Unpublished rights  reserved  under   *
 * *   the copyright laws of the United States.                    *
 * *                                                               *
 * *   The software contained on this media  is  proprietary  to   *
 * *   and  embodies  the  confidential  technology  of  Digital   *
 * *   Equipment Corporation.  Possession, use,  duplication  or   *
 * *   dissemination of the software and media is authorized only  *
 * *   pursuant to a valid written license from Digital Equipment  *
 * *   Corporation.                                                *
 * *                                                               *
 * *   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure  *
 * *   by the U.S. Government is subject to restrictions  as  set  *
 * *   forth in Subparagraph (c)(1)(ii)  of  DFARS  252.227-7013,  *
 * *   or  in  FAR 52.227-19, as applicable.                       *
 * *                                                               *
 * *****************************************************************
 */
/*
 * HISTORY
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 *
 *	File:	pmap.h
 *
 *	Alpha version
 *
 *	Machine-dependent structures for the physical map module.
 *
 */

#ifndef	_PMAP_MACHINE_
#define	_PMAP_MACHINE_

#define MMF_READ	0
#define MMF_IFETCH	-1
#define MMF_WRITE	1
#define MMF_PMAPINIT	2 /* used by pmap_bootstrap call to pmap_fault_on */

#ifndef	ASSEMBLER
#include <standards.h>
#include <mach/boolean.h>
#include <kern/zalloc.h>
#include <kern/lock.h>
#include <kern/processor.h>
#include <mach/machine/vm_param.h>
#include <mach/vm_statistics.h>
#include <mach/vm_prot.h>
#include <machine/cpu.h> 
#include <machine/counters.h> 

/*
 *	Alpha Page Table Entry.
 */

union pt_entry {
	unsigned long	quadword;	/* for alignment and atomic writes */
	struct {
		unsigned int	_v:1,		/* valid */
				_for:1,		/* fault on read */
				_fow:1,		/* fault on write */
				_foe:1,		/* fault on execute */
				_asm:1,		/* address space match */
				_gh:2,		/* granularity hint */
				:1,		/* RESERVED future hardware */
				_prot:8,	/* {K|E|S|U}{R|W}E */
				_exec:1,	/* execute access flag */
				_wire:1,	/* wired */
				_seg:1,		/* segment pte entry */
		                _soft:13,	/* unused software bits */
				_pfn:32;	/* page frame number */
	}		PTE_BITFIELD;
};

#define pg_v		PTE_BITFIELD._v
#define pg_for		PTE_BITFIELD._for
#define pg_fow		PTE_BITFIELD._fow
#define pg_foe		PTE_BITFIELD._foe
#define pg_asm		PTE_BITFIELD._asm
#define pg_gh		PTE_BITFIELD._gh
#define pg_prot		PTE_BITFIELD._prot
#define pg_exec		PTE_BITFIELD._exec
#define pg_wire		PTE_BITFIELD._wire
#define pg_seg		PTE_BITFIELD._seg
#define pg_soft		PTE_BITFIELD._soft
#define pg_pfn		PTE_BITFIELD._pfn

#if	!defined(LSOF)
typedef union pt_entry	pt_entry_t;
#endif

#define	PT_ENTRY_NULL	((pt_entry_t *) 0)

/*
 * The following 2 tables will contain prototype PTEs indexed by the OSF
 * VM protection code.  Each prototype contains the appropriate settings
 * for the pg_prot, pg_exec, pg_foe, pg_asm, and pg_v fields.  All of the
 * remaining bits will be clear.
 *
 * The first table is for PTEs in the kernel pmap, the second one is for
 * PTEs in user pmap's.  Since indexing into these tables depends on the
 * VM protection codes being 0-7, a dummy structure declaration exists to
 * generate a compile error if the current VM_PROT_xxx flag settings change.
 *
 * These tables are initialized in pmap_bootstrap() because initialized
 * data can't be used with unions.  The patchable global variable named
 * alpha_independent_vm_exec_access controls whether the prototype PTEs
 * specify independent execute access from read access.  (Setting it to
 * 0 will grant execute permission for any memory having read access.)
 *
 * Use of the previous single prototype for system PTEs will be replaced
 * by an appropriate reference to the kernel prototype pte table.
 */
pt_entry_t proto_kern_ptetab[VM_PROT_ALL + 1];
pt_entry_t proto_user_ptetab[VM_PROT_ALL + 1];
pt_entry_t proto_user_segpte;
struct dependency_on_vm_prot_flag_values { char x[VM_PROT_ALL == 7]; };
#define proto_sys_pte proto_kern_ptetab[VM_PROT_READ | VM_PROT_WRITE]

#define NOTaPFN	((unsigned int)0)
/* The lowest address which is not accessible at any page size. */
#define NOTaVA	((vm_offset_t)(1L<<54))

/*
 * Assumptions:
 *	1) Supervisor and executive modes are not used.
 *	2) User mode accessibility implies kernel mode accessibility.
 */
#define PROT_UW		0x33
#define PROT_KW		0x11
#define PROT_NA		0x00
#define PROT_URKW	0x13
#define PROT_UR		0x03
#define PROT_KR		0x01

/* (some) pte fields as quadword masks */
#define PTEQ_MASK_KWE	(1L << 12)
#define PTEQ_MASK_UWE	(1L << 13)
#define PTEQ_MASK_EXEC	(1L << 16)
#define PTEQ_MASK_FLTON	(7L << 1)

#define PTES_PER_PAGE	(ALPHA_PGBYTES / sizeof(pt_entry_t))

#define PTETOPHYS(pte)	alpha_ptob((pte)->pg_pfn)

#define LEVEL1_PT_OFFSET(ADDR) \
	(((vm_offset_t)(ADDR) >> (3 * PGSHIFT - 6)) & (PGOFSET>>3))
#define LEVEL2_PT_OFFSET(ADDR) \
	(((vm_offset_t)(ADDR) >> (2 * PGSHIFT - 3)) & (PGOFSET>>3))
#define LEVEL3_PT_OFFSET(ADDR) (((vm_offset_t)(ADDR) >> PGSHIFT) & (PGOFSET>>3))
#define EQ_LEVEL1_VPN(XADDR, YADDR) \
	((((XADDR) ^ (YADDR)) >> (3 * PGSHIFT - 6)) == 0)
#define EQ_LEVEL2_VPN(XADDR, YADDR) \
	((((XADDR) ^ (YADDR)) >> (2 * PGSHIFT - 3)) == 0)
#define EQ_LEVEL3_VPN(XADDR, YADDR) ((((XADDR) ^ (YADDR)) >> PGSHIFT) == 0)
#define in_Othermap(PTE) \
	EQ_LEVEL1_VPN((vm_offset_t)(PTE), (vm_offset_t)Othermap)

#ifndef NCPUS
#define NCPUS 1
#endif

/*
 *	Pmap proper
 */
struct pmap {
	simple_lock_data_t	lock;	   /* lock on map		*/
	pt_entry_t *		level1_pt; /* level 1 page table	*/
	cpumask_t		active_on; /* one bit for each CPU	*/
	unsigned long           lw_trans;  /* no. of lw_wire trans.     */
	cpumask_t		new_asn;   /* advance asn on these CPUs	*/
	int			(*coproc_tbi)(); /* synch with PXG maps */
	int			ref_count; /* Reference count.		*/
	simple_lock_data_t	other_lock;/* task mapping window.	*/
	struct pmap_statistics	stats;	   /* Map statistics.		*/
	unsigned short		asn[NCPUS];/* per-cpu ASN assignment	*/
};

typedef struct pmap	*pmap_t;
#define	PMAP_NULL	((pmap_t) 0)
#define	PMAP_PTE	((pmap_t) 1)

struct zone	*pmap_zone;	/* Zone of pmap structures  */

#define PMAP_MAXASN	63	/* good through EV4, pass 3 */

typedef int memory_atom;

memory_atom	latest_asn[NCPUS];	 /* < 2^16 */
unsigned long	asn_ext[NCPUS];

struct sys_space {
	vm_size_t   s_size;
	vm_offset_t *s_va;
	vm_size_t   s_cpuid;
};

struct scavenge_list {
	long		count;
	vm_offset_t	kseg_start;
};

extern struct scavenge_list scavenge_info;
_BEGIN_CPLUSPLUS
extern void	end_of_boot_text();
_END_CPLUSPLUS
#define END_OF_BOOT_TEXT	((vm_offset_t)end_of_boot_text)
vm_offset_t	end_of_scavenge;
#define scavenged(KSEG_ADDR)	((KSEG_ADDR) < end_of_scavenge)

/*
 *	Macros
 */

#ifdef	KERNEL

#define vtopte(v)	(&Selfmap[((vm_offset_t)(v) & ADDRESS_MASK) >> PGSHIFT])
#define Root_pt		vtopte(vtopte(Selfmap))

#define PHYS_TO_KSEG(addr) ((vm_offset_t)(addr) + UNITY_BASE)
#define KSEG_TO_PHYS(addr) ((vm_offset_t)(addr) - UNITY_BASE)

#define PMAP_CONTEXT(pmap, new_thread)

#define PMAP_ACTIVATE(pmap, th, my_cpu) pmap_activate(pmap, th, my_cpu)

#define PMAP_DEACTIVATE(pmap, thread, cpu) pmap_deactivate(pmap, thread, cpu)

/*
 * LIVE_CPU_P should be in ./cpu.h.  It is a predicate which is true
 * when "cpu_no" can receive and could acknowledge an interprocessor
 * interrupt.
 */
#define LIVE_CPU_P(cpu_no)						\
	(cpu_to_processor(cpu_no)					\
	 && (cpu_to_processor(cpu_no)->state != PROCESSOR_OFF_LINE)	\
	 && (cpu_to_processor(cpu_no)->state != PROCESSOR_SHUTDOWN))

#if	NCPUS > 1

#define INVALIDATE_ASNS(pmap)	((pmap)->new_asn |= ~(pmap)->active_on)
#define PMAP_UPDATE(pmap, addr)	((!multicpu) ? INVALIDATE_ASNS(pmap) : \
					pmap_update_send((pmap), (addr)))
struct pmap_update_info {
	int             from_cpu[2];
	vm_offset_t     addr[2];
	memory_atom	shoot_pending;
	unsigned int	xcpu_intrs;
};

#else	/* NCPUS == 1 */

#define INVALIDATE_ASNS(pmap)		((pmap)->new_asn = ~1L)
#define PMAP_UPDATE(pmap, addr)		(INVALIDATE_ASNS(pmap))
#define pmap_update_info_init()

#endif	/* NCPUS */

struct pmap_seg {
	simple_lock_data_t
			ps_seglock;		/* Segment lock */
	unsigned short	ps_refcnt;		/* Segment ref count */
	unsigned short	ps_rescnt;		/* Segment resident count */
	unsigned int	ps_loadedpte;		/* Ptes in page table */
	vm_offset_t	ps_pagetable;		/* Page table */
	struct pv_entry *ps_pvsegment;		/* PV for segment */
};

typedef struct pmap_seg * pmap_seg_t;
#define	PMAP_SEG_NULL	((pmap_seg_t) 0)

/*
 *	For each vm_page_t, there is a list of all currently
 *	valid virtual mappings of that page.  An entry is
 *	a pv_entry_t; the lists' heads are in the pv_table.
 *
 *	Rather than maintain separate arrays for lock, modify,
 *	and reference bits, we steal the three low-order bits
 *	of the virtual address field in each list header.  It
 *	works because operations on the virtual address are really
 *	operations on the virtual page number, and the low-order
 *	bits are "noise".
 */
struct pv_entry {
	union {				 /* overlaid with pv_bits (below) */
		vm_offset_t	_pv_va;	 /* va for this mapping */
		struct vm_page	*_pv_pg; /* vm page for this (pte)page */
	} _upv0;
	union {
		pmap_t		_pv_pmap;	/* pmap where mapping lies */
		pmap_seg_t	_pv_seg;	/* segment */
		int		_pv_mappings;	/* valid mapping count */
	} _upv1;
	struct pv_entry	*pv_next;	/* next pv_entry */
};

#define	pv_va		_upv0._pv_va
#define	pv_pg		_upv0._pv_pg
#define	pv_pmap		_upv1._pv_pmap
#define	pv_seg		_upv1._pv_seg
#define	pv_mappings	_upv1._pv_mappings


union pv_list_head {
	long bits;
#define PV_BIT_UNLOCK	1L /* assumed to be lowest order bit in atomic_ops.s */
#define PV_BIT_MODIFY	2L
#define	PV_BIT_REF	4L
	struct pv_entry	entry;
};

#define PV_BITS	(PV_BIT_UNLOCK | PV_BIT_MODIFY | PV_BIT_REF)

#define PV_LIST_HEAD_NULL ((union pv_list_head *) 0)

typedef struct pv_entry *pv_entry_t;
#define	PV_ENTRY_NULL	((pv_entry_t) 0)

/*
 * The pv_list proper, which is actually an array of lists
 */
union pv_list_head	*pv_head_table;	/* array of entries, one per page */
zone_t			pv_list_zone;	/* zone of pv_entry structures */

vm_offset_t	pmap_first_phys;   /* range of phys pages which we can handle */
vm_offset_t	pmap_last_phys;
#define managed(PA)	((PA) >= pmap_first_phys && (PA) < pmap_last_phys)

/*
 * Steal bit 3 of the VA to identify the pv entry
 * as belonging to a segment.  We chose 3 because 
 * bits 0 thru 2 are being used in the pv head for other purposes.
 * Also bit 3 with be preserved because it will be treated a part of the VA.
 */

#define	PV_SEGFLAG	0x00000008L		/* Ored in pv_va for seg id. */

/*
 * Enable segmentation
 */

#define	PMAP_SEGMENTATION	1

#define	PMAP_SEG_SIZE		(PTES_PER_PAGE * ALPHA_PGBYTES)
#define	PMAP_SEG_MASK		((PMAP_SEG_SIZE) - 1)

#define	pmap_seg_lock(SP)	simple_lock(&(SP)->ps_seglock)
#define	pmap_seg_lock_try(SP)	simple_lock_try(&(SP)->ps_seglock)
#define	pmap_seg_unlock(SP)	simple_unlock(&(SP)->ps_seglock)

#define PMAP_COPROC_INVALIDATE_STLB  0
#define PMAP_COPROC_EXIT             1

#define PDEVCMD_ONE     PMAP_COPROC_INVALIDATE_STLB
#define PDEVCMD_ALL     PMAP_COPROC_EXIT

#define ALL_THRESHHOLD	(1<<20)

#define pmap_set_coproc_tbi(pmap, func)			\
	((pmap)->coproc_tbi = (func))

#define pmap_clear_coproc_tbi(pmap)			\
	if ((pmap)->coproc_tbi) {			\
		(*(pmap)->coproc_tbi)(PDEVCMD_ALL, 0);	\
		(pmap)->coproc_tbi = (int(*)())NULL;	\
	} else

#define pmap_load           pmap_mmu_load
#define pmap_unload         pmap_mmu_unload
#define pmap_tb             pmap_mmu_tb
#define svatophys           pmap_svatophys
#define tbsync              pmap_tbsync

#define TB_SYNC_NONE        1
#define TB_SYNC_LOCAL       2
#define TB_SYNC_ALL         4

typedef unsigned int        vm_tbop_t;

_BEGIN_CPLUSPLUS
extern void pmap_pagemove __((vm_offset_t, vm_offset_t, vm_size_t));
_END_CPLUSPLUS

#define pmap_pageable(p_map, sva, eva, pageable)
#define	pmap_resident_count(pmap)	((pmap)->stats.resident_count)
#define pmap_resident_text(pmap)	((pmap)->stats.resident_text)
#define pmap_resident_data(pmap)	(pmap_resident_count(pmap)	\
					 - pmap_resident_stack(pmap)	\
					 - pmap_resident_text(pmap))

#define	pmap_phys_address(frame)	((vm_offset_t) (alpha_ptob(frame)))
#define pmap_phys_to_frame(phys)	((int) (alpha_btop(phys)))
#define pmap_copy(dst,src,from,len,to)
#define pmap_update()
#define pmap_kernel()			kernel_pmap

/*
 *	Data structures this module exports
 */
extern	pmap_t	kernel_pmap;		/* pointer to the kernel pmap	*/
extern	pmap_t	active_pmap;		/* pmap for the current thread  */

#define	mtpr_tbis(vaddr)	mtpr_tbi(3, vaddr)
#define	mtpr_tbisi(vaddr)	mtpr_tbi(1, vaddr)
#define	mtpr_tbisd(vaddr)	mtpr_tbi(2, vaddr)
#define	mtpr_tbia()		mtpr_tbi(-2L)
#define	mtpr_tbiap()		mtpr_tbi(-1L)

#endif	/* KERNEL */
#endif	/* !ASSEMBLER */
#endif	/* _PMAP_MACHINE_ */
