/*
 * dmnt.c - Motorola V/88 mount support functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.13 95/09/19 10:50:44 abe Exp $";
#endif


#include "lsof.h"


/*
 * readmnt() - read mount table
 */

int
readmnt()

{

#if	V88<40401
	int br, fd;
	int bx = sizeof(struct mnttab);
	char *dn = NULL;
	struct mnttab m;
	int err = 0;
	char *ln;
	struct mounts *mtp;
	char *opt, *opte;
	struct stat sb;
/*
 * Open access to the mount table.
 */
	if ((fd = open(MNTTAB, O_RDONLY, 0)) < 0) {
		(void) fprintf(stderr, "%s: can't open %s\n", Pn, MNTTAB);
		return(0);
	}
/*
 * Read mount table entries.
 */
	while ((br = read(fd, (char *)&m, bx)) == bx) {

	/*
	 * Interpolate a possible symbolic directory link.
	 */
		if (dn)
			(void) free((FREE_P *)dn);
		if ((dn = (char *)malloc((MALLOC_S)(strlen(m.mt_filsys) + 1)))
		== NULL) {
			err = 1;
			break;
		}
		(void) strcpy(dn, m.mt_filsys);
		if ((ln = Readlink(dn)) == NULL) {
		    if (!Fwarn){
			(void) fprintf(stderr,
			    "      Output information may be incomplete.\n");
		    }
		    err = 2;
		    continue;
		}
		if (ln != dn) {
			(void) free((FREE_P *)dn);
			dn = ln;
		}
	/*
	 * Stat() the directory.
	 */
		if (statsafely(dn, &sb)) {
		    if (!Fwarn) {
			(void) fprintf(stderr,

#if	defined(HASFSTYPE)
			    "%s: WARNING: can't stat() %s file system %s\n",
			    Pn, m.mt_fstyp, m.mt_filsys
#else	/* !defined(HASFSTYPE) */
			    "%s: WARNING: can't stat() file system %s\n",
			    Pn, m.mt_filsys
#endif	/* defined(HASFSTYPE) */

			);
			(void) fprintf(stderr,
			    "      Output information may be incomplete.\n");
		    }
		    err = 2;
		    if ((opt = strstr(m.mt_mntopts, "dev=")) != NULL) {
			(void) memset(&sb, 0, sizeof(sb));
			if ((opte = x2dev(opt + 4, &sb.st_dev)) != NULL) {
			    sb.st_mode = S_IFDIR | 0777;

#if     defined(HASFSTYPE)
			    (void) strncpy(sb.st_fstype, m.mt_fstyp,
				sizeof(sb.st_fstype));
			    sb.st_fstype[sizeof(sb.st_fstype) - 1 ] = '\0';
#endif  /* defined(HASFSTYPE */

			    if (!Fwarn)
				(void) fprintf(stderr,
				    "      assuming \"%.*s\" from %s\n",
				    (opte - opt), opt, MNTTAB);
			} else
				opt = NULL;
		    }
		    if (opt == NULL)
			continue;
		}
	/*
	 * Allocate and fill a local mount structure.
	 */
		if ((mtp = (struct mounts *)malloc(sizeof(struct mounts)))
		== NULL) {
			err = 1;
			break;
		}
		if ((mtp->fsname =
			(char *)malloc((MALLOC_S)(strlen(m.mt_dev) + 1)))
		== NULL) {
			err = 1;
			break;
		}
		(void) strcpy(mtp->fsname, m.mt_dev);

#if	defined(HASFSTYPE)
		if ((mtp->fstype =
			(char *)malloc((MALLOC_S)(strlen(sb.st_fstype) + 1)))
		== NULL) {
			err = 1;
			break;
		}
		(void) strcpy(mtp->fstype, sb.st_fstype);
#endif	/* HASFSTYPE */

		mtp->dir = dn;
		dn = NULL;
		mtp->next = Mtab;
		mtp->dev = sb.st_dev;
		mtp->rdev = sb.st_rdev;
		mtp->inode = sb.st_ino;
		mtp->mode = sb.st_mode;
		Mtab = mtp;
	}
	(void) close(fd);
	if (dn)
		(void) free((FREE_P *)dn);
/*
 * Handle errors.
 */
	switch (err) {
	case 1:
		(void) fprintf(stderr, "%s: no space for mount at %s (%s)\n",
			Pn, m.mt_filsys, m.mt_dev);
		return(0);
	case 2:
		return(1);
	}
	return(1);

#else	/* V88>=40401 */

	int err = 0;
	char *dn = NULL;
	char *ln;
	struct mnttab me;
	FILE *mfp;
	struct mounts *mtp;
	char *opt, *opte;
	struct stat sb;

# if	defined(HASPROCFS)
	int procfs = 0;
# endif	/* defined(HASPROCFS) */
/*
 * Open access to the mount table and read mount table entries.
 */

	if ((mfp = fopen(MNTTAB, "r")) == NULL) {
                (void) fprintf(stderr, "%s: can't access %s\n", Pn, MNTTAB);
                return(0);
        }
	while (getmntent(mfp, &me) == 0) {

	/*
	 * Skip loop-back mounts, since they are aliases for legitimate file
	 * systems and there is no way to determine that a vnode refers to a
	 * loop-back alias.
	 *
	 * Also skip file systems of type MNTTYPE_IGNORE or with the option
	 * MNTOPT_IGNORE, since they are auto-mounted file systems whose
	 * real entries (if they are mounted) will be separately identified
	 * by getmntent().
	 */
		if (strcmp(me.mnt_fstype, MNTTYPE_LO) == 0
		||  strcmp(me.mnt_fstype, MNTTYPE_IGNORE) == 0)
			continue;
	/*
	 * Interpolate a possible symbolic directory link.
	 */
		if (dn)
			(void) free((FREE_P *)dn);
		if ((dn=(char *)malloc((MALLOC_S)(strlen(me.mnt_mountp) + 1)))
		== NULL) {
			err = 1;
			break;
		}
		(void) strcpy(dn, me.mnt_mountp);
		if ((ln = Readlink(dn)) == NULL) {
		    if (!Fwarn){
			(void) fprintf(stderr,
			    "      Output information may be incomplete.\n");
		    }
		    err = 2;
		    continue;
		}
		if (ln != dn) {
			(void) free((FREE_P *)dn);
			dn = ln;
		}
	/*
	 * Stat() the directory.
	 */
                if (statsafely(dn, &sb)) {
		    if (!Fwarn) {
			(void) fprintf(stderr,
			    "%s: WARNING: can't stat() %s file system %s\n",
			    Pn, me.mnt_fstype, me.mnt_mountp);
			(void) fprintf(stderr,
			    "      Output information may be incomplete.\n");
		    }
		    err = 2;
		    if ((opt = strstr(me.mnt_mntopts, "dev=")) != NULL) {
			(void) memset(&sb, 0, sizeof(sb));
			if ((opte = x2dev(opt + 4, &sb.st_dev)) != NULL) {
			    sb.st_mode = S_IFDIR | 0777;
			    if (!Fwarn)
				(void) fprintf(stderr,
				    "      assuming \"%.*s\" from %s\n",
				    (opte - opt), opt, MNTTAB);
			} else
				opt = NULL;
		    }
		    if (opt == NULL)
			continue;
		}
	/*
	 * Allocate and fill a local mount structure.
	 */
		if ((mtp = (struct mounts *)malloc(sizeof(struct mounts)))
		== NULL) {
			err = 1;
			break;
		}
		if ((mtp->fsname =
			(char *)malloc((MALLOC_S)(strlen(me.mnt_special) + 1)))
		== NULL) {
			err = 1;
			break;
		}
		(void) strcpy(mtp->fsname, me.mnt_special);
		mtp->dir = dn;
		dn = NULL;
		mtp->next = Mtab;
		mtp->dev = sb.st_dev;
		mtp->rdev = sb.st_rdev;
		mtp->inode = sb.st_ino;
		mtp->mode = sb.st_mode;

#if	defined(HASPROCFS)
# if	defined(HASFSTYPE)
		if (strcmp(sb.st_fstype, HASPROCFS) == 0)
# else	/* !defined(HASFSTYPE) */
		if (strcmp(me.mnt_special, "/proc") == 0)
# endif	/* defined(HASFSTYPE) */ 

		{

		/*
		 * Save information on exactly one procfs file system.
		 */
			if (procfs)
				Mtprocfs = NULL;
			else {
				procfs = 1;
				Mtprocfs = mtp;
			}
		}
#endif	/* defined(HASPROCFS) */

		Mtab = mtp;
        }
	(void) fclose(mfp);
	if (dn)
		(void) free((FREE_P *)dn);
/*
 * Handle errors.
 */
	switch (err) {
	case 1:
		(void) fprintf(stderr, "%s: no space for mount at %s (%s)\n",
			Pn, me.mnt_special, me.mnt_mountp);
		return(0);
	case 2:
		return(1);
	}
	return(1);
#endif	/* V88<40401 */

}


#if	V88>=40401
/*
 * readvfs() - read vfs structure
 */

struct l_vfs *
readvfs(ka, la)
	struct vfs *ka;			/* vfs structure kernel address, if
					 * must be read from kernel */
	struct vfs *la;			/* local vfs structure address, non-
					 * NULL if already read from kernel */
{
	struct vfs *v, tv;
	struct l_vfs *vp;

	if (!ka && !la)
		return(NULL);
/*
 * Search the local cache.
 */
	for (vp = Lvfs; vp; vp = vp->next) {
		if (ka == vp->addr)
			return(vp);
	}
/*
 * Allocate a new cache entry.
 */
	if ((vp = (struct l_vfs *)malloc(sizeof(struct l_vfs))) == NULL) {
		(void) fprintf(stderr, "%s: PID %d, no space for vfs\n",
			Pn, Lp->pid);
		exit(1);
	}
	vp->dir = NULL;
	vp->fsname = NULL;
/*
 * Fill in the new cache entry from kernel data.
 */
	if (la)
		v = la;
	else if (kread((KA_T)ka, (char *)&tv, sizeof(tv))) {
		(void) free((FREE_P *)vp);
		return(NULL);
	} else
		v = &tv;
	(void) completevfs(vp, (dev_t *)&v->vfs_dev);
	vp->next = Lvfs;
	vp->addr = ka;
	Lvfs = vp;
	return(vp);
}
#endif	/* V88>40401 */


/*
 * The completevfs() function is obtained from ../common/cvfs.frag.
 */

/* CVFS_DEVSAVE is not defined. */
#define	EXPDEV(n)	n

#if	V88>=40401
#define	USECVFS		1
#endif	/* V88>=40401 */
