/*
 * dlsof.h - Pyramid DC/OSx header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * Modified for Pyramid DC/OSx by Anthony Shortland
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


#if	!defined(UW_LSOF_H)
#define	UW_LSOF_H	1

#define	_KMEMUSER	1

#include <dirent.h>
#include <fcntl.h>
#include <malloc.h>
#include <unistd.h>
#include <sys/mkdev.h>
#include <sys/mntent.h>
#include <sys/mnttab.h>
#include <netdb.h>
#include <string.h>
#include <nlist.h>
#include <sys/file.h>
#include <sys/flock.h>
#include <sys/immu.h>
#include <sys/fstyp.h>
#include <sys/fsid.h>
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <sys/fs/fifonode.h>
#include <sys/fs/snode.h>
#include <sys/mount.h>
#include <sys/stream.h>
#include <sys/strsubr.h>
#include <sys/time.h>
#include <sys/fs/s5dir.h>
#include <signal.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/var.h>
#include <sys/procfs.h>
#include <sys/priocntl.h>
#include <sys/tiuser.h>

#include <rpc/types.h>
#include <nfs/nfs.h>
#include <nfs/rnode.h>
#define	r_nfsattr	r_attr
#define	na_nodeid	va_nodeid
#define	na_size		va_size
#include <netinet/in.h>
#include <sys/socket.h>
#include <net/route.h>

# if	!defined(STRNET)
#define	STRNET	1
# endif

#include <netinet/in_pcb.h>
#include <sys/protosw.h>
#include <sys/socketvar.h>
#include <vm/hat.h>
#include <vm/as.h>
#include <vm/seg.h>
#include <vm/seg_dev.h>
#include <vm/seg_map.h>
#include <vm/seg_vn.h>


/*
 * The definition of the prnode structure only appears in UnixWare
 * sources, hence it is replicated here.
 */

typedef struct prnode {
        struct prnode   *pr_free;       /* freelist pointer */
        struct vnode    *pr_vnext;      /* linked list of invalid vnodes */
        struct vnode    pr_vnode;       /* associated vnode */
        struct proc     *pr_proc;       /* process being traced */
        short           pr_mode;        /* file mode bits */
        short           pr_opens;       /* count of opens */
        short           pr_writers;     /* count of opens for writing */
        short           pr_flags;       /* private flags */
} prnode_t;


#define	COMP_P		char
#define DEVINCR		1024	/* device table malloc() increment */
#define	FSNAMEL		4
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define N_UNIX		"/unix"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MALLOC_S	unsigned
#define MAXSEGS		100	/* maximum text segments */
#define	PROCFS		"/proc"
#define	PROCSIZE	sizeof(struct proc)
#define QSORT_P		char
#define	READLEN_T	unsigned

# if	defined(HASPROCFS)
#define	PNSIZ		5	/* size of /HASPROCFS names */
#define	PR_INOBIAS	64L	/* /HASPROCFS PID to i_number bias */
#define	PR_ROOTINO	2	/* /HASPROCFS root inode number */
# endif

#define STRNCPY_L	size_t
#define	STRNML		32
#define U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

extern char **Fsinfo;
extern int Fsinfomax;
extern int Kmem;

struct l_ino {
	dev_t dev;			/* device */
	dev_t rdev;			/* real device */
	ino_t number;			/* inode number */
	long size;			/* file size */
};

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */
	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */

# if	defined(HASFSTYPE)
	char *fstype;			/* st_fstype */
# endif

};

extern short Nfstyp;

#define	X_SEGVN		0
#define X_VAR		1

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

#include <setjmp.h>

#endif	/* UW_LSOF_H	*/
