

/*
 * The caller must define RVFS_DEVSAVE to enable the saving of the
 * device number in the local vfs sturcture.
 */


/*
 * readvfs() - read vfs structure
 */

struct l_vfs *
readvfs(ka)
	struct vfs *ka;			/* vfs structure kernel address */
{
	struct l_vfs *vp;

	if (!ka)
		return(NULL);
	for (vp = Lvfs; vp; vp = vp->next) {
		if (ka == vp->addr)
			return(vp);
	}
	if ((vp = (struct l_vfs *)malloc(sizeof(struct l_vfs))) == NULL) {
		(void) fprintf(stderr, "%s: PID %d, no space for vfs\n",
			Pn, Lp->pid);
		exit(1);
	}

#if	defined(RVFS_DEVSAVE)
	vp->dev = 0;
#endif

	vp->dir = NULL;
	vp->fsname = NULL;
	vp->next = Lvfs;
	vp->addr = ka;
	Lvfs = vp;
	return(vp);
}
