

/*
 * The caller must define USECVFS to activate this function.
 *
 * The caller must define CVFS_DEVSAVE to have the device number moved
 * from the mounts entry to the local vfs structure.
 */


#if	defined(USECVFS)
/*
 * completevfs() - complete local vfs structure
 */

void
completevfs(vfs, dev)
	struct l_vfs *vfs;		/* local vfs structure pointer */
	dev_t *dev;			/* device */
{
	struct mounts *mp;
/*
 * Search for a match on device number.
 */
	for (mp = Mtab; mp; mp = mp->next) {
		if (mp->dev == *dev) {

# if	defined(CVFS_DEVSAVE)
			vfs->dev = mp->dev;
# endif

			vfs->dir = mp->dir;
			vfs->fsname = mp->fsname;
			return;
		}
	}
}
#endif	/* USECVFS */
