/*
 * dlsof.h - Ultrix header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


#if	!defined(ULTRIX_LSOF_H)
#define	ULTRIX_LSOF_H	1

# if	ULTRIXV==20200
#define	mode_t		u_short
typedef	int		pid_t;
#define unp_addr	unp_remaddr
# endif
#include <strings.h>
#include <nlist.h>
#include <rpc/types.h>
#include <sys/time.h>
#include <sys/dir.h>
#include <sys/domain.h>
#include <sys/mbuf.h>
#include <sys/mount.h>
#include <sys/proc.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/text.h>
#include <sys/un.h>
#include <sys/unpcb.h>
#include <machine/pte.h>
#include <netinet/in.h>
#include <net/route.h>
#include <net/raw_cb.h>
#include <netinet/in_pcb.h>
#include <nfs/nfs.h>
#include <nfs/nfs_clnt.h>
#include <nfs/vfs.h>
#include <nfs/vnode.h>
#define KERNEL
#include <sys/file.h>
#include <sys/gnode.h>
#undef KERNEL
#include <sys/user.h>

# if	ULTRIXV>=40200
/*
 * Dummy fifonode structure definition.  This should come from
 * <specfs/fifonode.h>, but DEC doesn't ship that header file
 * with Ultrix 4.2.
 */

struct fifo_bufhdr {
        struct fifo_bufhdr *fb_next;
        char fb_data[1];
};
struct fifonode {
        struct fifo_bufhdr *fn_buf;     /* ptr to first buffer */
        struct fifo_bufhdr *fn_bufend;  /* ptr to last buffer */
        struct proc     *fn_wselp;      /* ptr to write proc sleeping on select*/
        struct proc     *fn_rselp;      /* ptr to read proc sleeping on select */
        u_long          fn_size;        /* number of bytes in fifo */
        u_long          fn_wcnt;        /* number of waiting readers */
        u_long          fn_rcnt;        /* number of waiting writers */
        u_long          fn_rpgrp;       /* process group of read side */
        u_long          fn_wpgrp;       /* process group of write side */
        u_long          fn_wptr;        /* write offset */
        u_long          fn_rptr;        /* read offset */
        u_long          fn_flag;        /* (see fifo.h) */
        u_long          fn_nbuf;        /* number of buffers allocated */
};
# endif	/* ULTRIXV>=40200 */

# if     defined(RHF)
/*
 * Local header files for the Purdue University Computing Center's
 * implementation of CDC Remote Host Facility (RHF) sockets.
 */
#include <net/if.h>
#include <netlcn/rhf.h>
#include <netlcn/rhf_timer.h>
#include <netlcn/rhfcb.h>
# endif	/* RHF */

# if	defined(HASPWSTAYOPEN)
extern int _pw_stayopen;
#define	pw_stay_open()	_pw_stayopen=1
# endif

extern char *sys_errlist[];
#define strerror(errno) sys_errlist[errno]

# if	ULTRIXV==20200
#define	COMP_P		char
# else
#define	COMP_P		void
# endif

#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MALLOC_S	unsigned
#define N_UNIX		"/vmunix"
#define QSORT_P		char

# if	ULTRIXV>=40200
#define	READLEN_T	size_t
#define STRNCPY_L	size_t
# else
#define	READLEN_T	int
#define STRNCPY_L	int
# endif

#define SWAP		"/dev/drum"
#define	U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

extern int Kmem;

extern int Mem;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
};

#define X_PROC          0
#define X_NPROC         1
#define	X_NCACHE	2
#define	X_NCSIZE	3
#define X_NFS_OPS	4

# if	ULTRIXV>=40200
#define	X_CDFS_OPS	5
#define X_FIFO_OPS	6
#define X_SPEC_OPS	7
#define X_UFS_OPS	8
# endif

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

extern int Swap;

/*
 * This #include and accompanying #undef's is placed last, lest the
 * #undef's disturb something else.  The #undef's prevent symbol
 * conflicts between <setjmp.h> and <sys/pcb.h>.
 */

#undef	JB_S0
#undef	JB_S1
#undef	JB_S2
#undef	JB_S3
#undef	JB_S4
#undef	JB_S5
#undef	JB_S6
#undef	JB_S7
#undef	JB_S8
#undef	JB_SP
#undef	JB_FP
#undef	JB_PC
#undef	NJBREGS

#include <setjmp.h>

#endif	/* ULTRIX_LSOF_H */
