/*
 * dmnt.c - SCO Unix mount support functions for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.7 95/09/12 07:52:46 abe Exp $";
#endif


#include "lsof.h"


/*
 * readmnt() - read mount table
 */

int
readmnt()

{
	int br, fd;
	int bx = sizeof(struct mnttab);
	char *dn = NULL;
	struct mnttab m;
	int err = 0;
	char *ln;
	struct mounts *mtp;
	struct stat sb;
/*
 * Open access to the mount table.
 */
	if ((fd = open(MNTTAB, O_RDONLY, 0)) < 0) {
		(void) fprintf(stderr, "%s: can't open %s\n", Pn, MNTTAB);
		return(0);
	}
/*
 * Read mount table entries.
 */
	while ((br = read(fd, (char *)&m, bx)) == bx) {

	/*
	 * Interpolate a possible symbolic directory link.
	 */
		if (dn)
			(void) free((FREE_P *)dn);
		if ((dn = (char *)malloc((MALLOC_S)(strlen(m.mt_filsys) + 1)))
		== NULL) {
			err = 1;
			break;
		}
		(void) strcpy(dn, m.mt_filsys);
		if ((ln = Readlink(dn)) == NULL) {
		    if (!Fwarn){
			(void) fprintf(stderr,
			    "      Output information may be incomplete.\n");
		    }
		    err = 2;
		    continue;
		}
		if (ln != dn) {
			(void) free((FREE_P *)dn);
			dn = ln;
		}
	/*
	 * Stat() the directory.
	 */
		if (statsafely(dn, &sb)) {
		    if (!Fwarn) {
			(void) fprintf(stderr,

#if	defined(HASFSTYPE)
			    "%s: WARNING: can't stat() %s file system %s\n",
			    Pn, m.mt_fstyp, m.mt_filsys
#else	/* !defined(HASFSTYPE) */
			    "%s: WARNING: can't stat() file system %s\n",
			    Pn, m.mt_filsys
#endif	/* defined(HASFSTYPE) */

			);
			(void) fprintf(stderr,
			    "      Output information may be incomplete.\n");
		    }
		    err = 2;
		    continue;
		}
	/*
	 * Allocate and fill a local mount structure.
	 */
		if ((mtp = (struct mounts *)malloc(sizeof(struct mounts)))
		== NULL) {
			err = 1;
			break;
		}
		if ((mtp->fsname =
			(char *)malloc((MALLOC_S)(strlen(m.mt_dev) + 1)))
		== NULL) {
			err = 1;
			break;
		}
		(void) strcpy(mtp->fsname, m.mt_dev);

#if	defined(HASFSTYPE)
		if ((mtp->fstype =
			(char *)malloc((MALLOC_S)(strlen(sb.st_fstype) + 1)))
		== NULL) {
			err = 1;
			break;
		}
		(void) strcpy(mtp->fstype, sb.st_fstype);
#endif	/* HASFSTYPE */

		mtp->dir = dn;
		dn = NULL;
		mtp->next = Mtab;
		mtp->dev = sb.st_dev;
		mtp->rdev = sb.st_rdev;
		mtp->inode = sb.st_ino;
		mtp->mode = sb.st_mode;
		Mtab = mtp;
	}
	(void) close(fd);
	if (dn)
		(void) free((FREE_P *)dn);
/*
 * Handle errors.
 */
	switch (err) {
	case 1:
		(void) fprintf(stderr, "%s: no space for mount at %s (%s)\n",
			Pn, m.mt_filsys, m.mt_dev);
		return(0);
	case 2:
		return(1);
	}
	return(1);
}
