/*
 * dstore.c - DEC OSF/1 global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.8 95/03/31 12:32:27 abe Exp $";
#endif


#include "lsof.h"


struct clone *Clone = NULL;
dev_t Clonedev = -1;			/* clone device number */
int Kmem = -1;

#if	_OSF1V<30000
KA_T Kp;				/* kernel proc[] address */
#endif	/* _OSF1V<30000 */

struct l_vfs *Lvfs = NULL;

struct nlist Nl[] = {
        { "clonedev",	   0L, 0, 0 },
	{ "namecache",	   0L, 0, 0 },
	{ "nchsize",	   0L, 0, 0 },
        { "vn_maxprivate", 0L, 0, 0 },

#if	_OSF1V<30000
        { "proc",	   0L, 0, 0 },
        { "nproc",	   0L, 0, 0 },
#else	/* _OSF1V>=30000 */
        { "npid",	   0L, 0, 0 },
        { "pidtab",	   0L, 0, 0 },
#endif	/* _OSF1V<30000 */

	{ "",		   0L, 0, 0 },
};

#if	_OSF1V>=30000
KA_T	Pidtab;				/* kernel's pidtab[] address */
#endif	/* _OSF1V>=30000 */

int Vnmxp;				/* vnode's max private area length */
