/*
 * ddev.c - Motorola V/88 device support functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: ddev.c,v 1.14 95/09/01 08:32:38 abe Exp $";
#endif


#include "lsof.h"

#define	DIRTYPE	dirent

#if	defined(HASDCACHE)
_PROTOTYPE(static int rw_clone_sect,(int m));
#endif	/* defined(HASDCACHE) */

_PROTOTYPE(static void stkdir,(char ***d, int *n, int *x, char *p));


#if	V88>=40403
/*
 * findclones() - find clone devices and build a list of them
 */

void
findclones()
{
	struct clone *c;
	int i;

	if ( ! HaveCloneMajor)
		return;
	readdev();
	for (i = 0; i < Ndev; i++) {
		if (get_major(Devtp[i].rdev) == CloneMajor) {
			if ((c = (struct clone *)malloc(sizeof(struct clone)))
			== NULL) {
				(void) fprintf(stderr,
					"%s: no space for clone device: %s\n",
					Pn, Devtp[i].name);
				exit(1);
			}
			c->dx = i;
			c->next = Clone;
			Clone = c;
		}
	}
}
#endif	/* V88>=40403 */


/*
 * printchdevname() - print character device name
 */

int
printchdevname(rdev, f)
	dev_t *rdev;			/* device */
	int f;				/* 1 = follow with '\n' */
{

#if     V88>=40403
	struct clone *c;
#endif  /* V88>=40403 */

	struct l_dev *dp;

	if ((dp = lkupdev(rdev, 1)) != (struct l_dev *)NULL) {
	    if (f)
		(void) puts(dp->name);
	    else
		(void) fputs(dp->name, stdout);
	    return(1);
	}

#if     V88>=40403
/*
 * Search for clone.
 */
	if (Clone) {
	    for (c = Clone; c; c = c->next) {
		if (get_major(*rdev) == get_minor(Devtp[c->dx].rdev)) {
		    if (f)
			(void) puts(Devtp[c->dx].name);
		     else
			(void) fputs(Devtp[c->dx].name, stdout);
		    return(1);
		}
	    }
	}
#endif  /* V88>=40403 */

	return(0);
}


/*
 * find_ch_ino() comes from ../common/fchi.frag.
 * lkupdev() comes from ../common/lkud.frag.
 * read_dcache() and write_dcache() come from ../common/dvch.frag.
 * readdev() and stkdir() come from ../common/rdev.frag.
 */

#if	V88>=40402
#define	DVCH_FCHOWN	1		/* Since we're setuid(root), ask
					 * open_dcache() to change ownerships
					 * of the device cache file after
					 * creating it. */
#endif	/* V88>=40402 */
