/*
 * dmnt.c - DYNIX mount support functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.4 95/01/25 11:40:23 abe Exp $";
#endif


#include "lsof.h"


/*
 * local_strstr() - local version of strstr
 */

static char *
local_strstr(s1, s2)
	char *s1;			/* string to search */
	char *s2;			/* string to find */
{
	int len1 = strlen(s1);
	int len2 = strlen(s2);
	
	while (len1 >= len2) {
		if (strncmp(s1, s2, len2) == 0)
			return(s1);
		s1++;
		len1--;
	}
	return(NULL);
}


/*
 * readvfs() - read vfs structure
 */

struct l_vfs *
readvfs(ka)
	struct vfs *ka;			/* vfs structure kernel address */
{
	struct mount m;
	struct mntinfo mi;
	dev_t td;
	struct vfs tv;
	struct l_vfs *vp;

	if (!ka)
		return(NULL);
	for (vp = Lvfs; vp; vp = vp->next) {
		if (ka == vp->addr)
			return(vp);
	}
	if ((vp = (struct l_vfs *)malloc(sizeof(struct l_vfs))) == NULL) {
		(void) fprintf(stderr, "%s: PID %d, no space for vfs\n",
			Pn, Lp->pid);
		exit(1);
	}
	vp->dev = 0;
	vp->dir = NULL;
	vp->fsname = NULL;
	if (kread((KA_T)ka, (char *)&tv, sizeof(tv))) {
		(void) free((FREE_P *)vp);
		return(NULL);
	}
/*
 * Complete mount information.
 */
	if (Ntype == N_NFS) {

	/*
	 * DYNIX NFS vnode device values have a major number of 255.
	 * The minor number is a serial number found in the mntinfo
	 * structure to which the virtual file system's vfs_data points.
	 */ 
		if (tv.vfs_data
		&&  kread((KA_T)tv.vfs_data, (char *)&mi, sizeof(mi)) == 0) {
			td = (dev_t)makedev(255, (int)mi.mi_mntno);
			(void) completevfs(vp, &td);
		}
	} else {
		if (kread((KA_T)tv.vfs_data, (char *)&m, sizeof(m)) == 0)
			(void) completevfs(vp, (dev_t *)&m.m_dev);
	}
	vp->next = Lvfs;
	vp->addr = ka;
	Lvfs = vp;
	return(vp);
}


/*
 * The readmnt() function is obtained from ../common/rmnt.frag.
 * The completevfs() function is obtained from ../common/cvfs.frag.
 */

#define	strstr	local_strstr
#define	CVFS_DEVSAVE 	1
#define	EXPDEV(n)	n
/* MNTSKIP is not defined. */
#define	USECVFS		1
