/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jde.wizards.ClassRegistry;
import jde.wizards.NameFactory;

public class Signature {
    private Method method;
    private Class[] parameters;
    private Class[] exceptions;
    private Class return_value;
    private Class declaring;
    private ClassRegistry registry;
    private boolean truncate;

    public void setTruncating(boolean bl) {
        this.truncate = bl;
    }

    public void setRegistry(ClassRegistry classRegistry) {
        this.registry = classRegistry;
    }

    public Class getDeclaringClass() {
        return this.declaring;
    }

    public String toJavaDoc() {
        NameFactory nameFactory = this.registry.getNameFactory();
        StringBuffer stringBuffer = new StringBuffer("/**\n *\n *");
        int n = 0;
        while (n < this.parameters.length) {
            stringBuffer.append(" @param " + nameFactory.getParameterName(this.parameters[n], n + 1, this.parameters.length) + " <description>\n *");
            ++n;
        }
        if (!"void".equals(this.return_value.getName())) {
            stringBuffer.append(" @return <description>" + "\n *");
        }
        n = 0;
        while (n < this.exceptions.length) {
            stringBuffer.append(" @exception " + this.exceptions[n].getName() + " <description>\n *");
            ++n;
        }
        stringBuffer.append("/");
        return stringBuffer.toString();
    }

    public String toString() {
        String string = this.getModifiers();
        String string2 = this.baseName(this.return_value);
        String string3 = this.method.getName();
        String string4 = this.getParameters(this.parameters);
        String string5 = this.getExceptions(this.exceptions);
        return string + " " + string2 + " " + string3 + "(" + string4 + ")" + string5;
    }

    public boolean paramsEqual(Class[] classArray) {
        boolean bl;
        int n = this.parameters.length;
        boolean bl2 = bl = classArray.length == n;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                if (!classArray[n2].equals(this.parameters[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object instanceof Signature) {
            Signature signature = (Signature)object;
            return this.method.getName().equals(signature.getMethod().getName()) && this.paramsEqual(signature.getMethod().getParameterTypes());
        }
        return false;
    }

    public Method getMethod() {
        return this.method;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String baseName(Class var1_1) {
        block7: {
            block5: {
                var2_2 = null;
                if (!var1_1.isArray()) break block5;
                try {
                    var3_3 = var1_1;
                    var4_6 = 0;
                    while (true) {
                        block6: {
                            if (var3_3.isArray()) break block6;
                            var5_7 = new StringBuffer();
                            var5_7.append(var3_3.getName());
                            var6_8 = 0;
                            if (true) ** GOTO lbl28
                        }
                        var3_3 = var3_3.getComponentType();
                        ++var4_6;
                    }
                }
                catch (Throwable var3_4) {
                    var2_2 = var1_1.getName();
                }
                break block7;
            }
            var2_2 = var1_1.getName();
            break block7;
            do {
                var5_7.append("[]");
                ++var6_8;
lbl28:
                // 2 sources

            } while (var6_8 < var4_6);
            var2_2 = var5_7.toString();
        }
        if (this.truncate && (var3_5 = var2_2.lastIndexOf(46)) > -1) {
            return var2_2.substring(var3_5 + 1);
        }
        return var2_2;
    }

    private final String getExceptions(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(" throws ");
        int n = 0;
        while (n < classArray.length) {
            String string = this.baseName(classArray[n]);
            stringBuffer.append(string);
            if (n < classArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final String getParameters(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        NameFactory nameFactory = this.registry.getNameFactory();
        int n = 0;
        while (n < classArray.length) {
            String string = this.baseName(classArray[n]);
            String string2 = nameFactory.getParameterName(classArray[n], n + 1, classArray.length);
            stringBuffer.append(string + " " + string2);
            if (n < classArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String getModifiers() {
        StringBuffer stringBuffer = new StringBuffer("public");
        int n = this.method.getModifiers();
        if (Modifier.isSynchronized(n)) {
            stringBuffer.append(" synchronized");
        }
        return stringBuffer.toString();
    }

    private final void register() {
        if (this.registry != null) {
            this.registry.registerImport(this.declaring);
            this.registry.registerImport(this.return_value);
            int n = 0;
            while (n < this.parameters.length) {
                this.registry.registerImport(this.parameters[n]);
                ++n;
            }
            n = 0;
            while (n < this.exceptions.length) {
                this.registry.registerImport(this.exceptions[n]);
                ++n;
            }
        }
    }

    public Signature(Method method, ClassRegistry classRegistry) {
        this(method, classRegistry, true);
    }

    public Signature(Method method, ClassRegistry classRegistry, boolean bl) {
        this.method = method;
        this.registry = classRegistry;
        this.truncate = bl;
        this.parameters = this.method.getParameterTypes();
        this.exceptions = this.method.getExceptionTypes();
        this.return_value = this.method.getReturnType();
        this.declaring = this.method.getDeclaringClass();
        this.register();
    }
}

