;;; ucs-sp-modifier.el --- Spacing Modifier Letters table of UCS

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Spacing Modifier Letters

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

;; MODIFIER LETTER APOSTROPHE
(ucs-set-char #x02BC ?.FN") ; ISO-8859-7-A2

;; MODIFIER LETTER REVERSED COMMA
(ucs-set-char #x02BD ?.FN!) ; ISO-8859-7-A1

;; CARON
(ucs-set-char #x02C7 ?$(C"'(B) ; KS0-C-2227
(ucs-set-char #x02C7 ?$(D"0(B) ; J90-D-2230
(ucs-set-char #x02C7 ?$(G%o(B) ; C01-G-256F
(ucs-set-char #x02C7 ?$A!&(B) ; GB0-A-2126
(ucs-set-char #x02C7 ?.DN7) ; ISO-8859-4-B7
(ucs-set-char #x02C7 ?.BN7) ; ISO-8859-2-B7

;; MODIFIER LETTER MACRON
(ucs-set-char #x02C9 ?$A!%(B) ; GB0-A-2125

;; MODIFIER LETTER ACUTE ACCENT
(ucs-set-char #x02CA ?$(G%n(B) ; C01-G-256E

;; MODIFIER LETTER GRAVE ACCENT
(ucs-set-char #x02CB ?$(G%p(B) ; C01-G-2570

;; MODIFIER LETTER TRIANGULAR COLON
(ucs-set-char #x02D0 ?$(C"0(B) ; KS0-C-2230
(ucs-set-char #x02D0 ?.0Nr) ; MULE-IPA-72

;; BREVE
(ucs-set-char #x02D8 ?$(C"((B) ; KS0-C-2228
(ucs-set-char #x02D8 ?$(D"/(B) ; J90-D-222F
(ucs-set-char #x02D8 ?.CN") ; ISO-8859-3-A2
(ucs-set-char #x02D8 ?.BN") ; ISO-8859-2-A2

;; DOT ABOVE
(ucs-set-char #x02D9 ?$(C"+(B) ; KS0-C-222B
(ucs-set-char #x02D9 ?$(D"2(B) ; J90-D-2232
(ucs-set-char #x02D9 ?$(G%l(B) ; C01-G-256C
(ucs-set-char #x02D9 ?.DN) ; ISO-8859-4-FF
(ucs-set-char #x02D9 ?.CN) ; ISO-8859-3-FF
(ucs-set-char #x02D9 ?.BN) ; ISO-8859-2-FF

;; RING ABOVE
(ucs-set-char #x02DA ?$(C"*(B) ; KS0-C-222A
(ucs-set-char #x02DA ?$(D"6(B) ; J90-D-2236

;; OGONEK
(ucs-set-char #x02DB ?$(C"-(B) ; KS0-C-222D
(ucs-set-char #x02DB ?$(D"5(B) ; J90-D-2235
(ucs-set-char #x02DB ?.DN2) ; ISO-8859-4-B2
(ucs-set-char #x02DB ?.BN2) ; ISO-8859-2-B2

;; DOUBLE ACUTE ACCENT
(ucs-set-char #x02DD ?$(C")(B) ; KS0-C-2229
(ucs-set-char #x02DD ?$(D"3(B) ; J90-D-2233
(ucs-set-char #x02DD ?.BN=) ; ISO-8859-2-BD

;;; ucs-sp-modifier.el ends here
