;;; ucs-latin-1.el --- UCS table of C1 Controls and Latin-1 Supplement

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, C1 Controls, Latin-1

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

;; C1 Controls
(let ((i 0))
  (while (< i 32)
    (ucs-set-char (+ i 128) (make-char 'control-1 i))
    (setq i (1+ i))
    ))

;; NO-BREAK SPACE
(ucs-set-char #x00A0 ?-M) ; ISO-8859-9-A0-A
(ucs-set-char #x00A0 ?2]-H0]) ; ISO-8859-8-A0-A
(ucs-set-char #x00A0 ?-F) ; ISO-8859-7-A0-A
(ucs-set-char #x00A0 ?-L) ; ISO-8859-5-A0-A
(ucs-set-char #x00A0 ?-D) ; ISO-8859-4-A0-A
(ucs-set-char #x00A0 ?-C) ; ISO-8859-3-A0-A
(ucs-set-char #x00A0 ?-B) ; ISO-8859-2-A0-A
(ucs-set-char #x00A0 ?) ; ISO-8859-1-A0

;; INVERTED EXCLAMATION MARK
(ucs-set-char #x00A1 ?$(C".(B) ; KS0-C-222E
(ucs-set-char #x00A1 ?$(D"B(B) ; J90-D-2242
(ucs-set-char #x00A1 ?-M) ; ISO-8859-9-A1-A
(ucs-set-char #x00A1 ?) ; ISO-8859-1-A1

;; CENT SIGN
(ucs-set-char #x00A2 ?-M) ; ISO-8859-9-A2-A
(ucs-set-char #x00A2 ?2]-H0]) ; ISO-8859-8-A2-A
(ucs-set-char #x00A2 ?) ; ISO-8859-1-A2

;; POUND SIGN
(ucs-set-char #x00A3 ?-M) ; ISO-8859-9-A3-A
(ucs-set-char #x00A3 ?2]-H0]) ; ISO-8859-8-A3-A
(ucs-set-char #x00A3 ?-F) ; ISO-8859-7-A3-A
(ucs-set-char #x00A3 ?-C) ; ISO-8859-3-A3-A
(ucs-set-char #x00A3 ?) ; ISO-8859-1-A3

;; CURRENCY SIGN
(ucs-set-char #x00A4 ?$(C"4(B) ; KS0-C-2234
(ucs-set-char #x00A4 ?$(D"p(B) ; J90-D-2270
(ucs-set-char #x00A4 ?$(A!h(B) ; GB0-A-2168
(ucs-set-char #x00A4 ?-M) ; ISO-8859-9-A4-A
(ucs-set-char #x00A4 ?2]-H0]) ; ISO-8859-8-A4-A
(ucs-set-char #x00A4 ?-D) ; ISO-8859-4-A4-A
(ucs-set-char #x00A4 ?-C) ; ISO-8859-3-A4-A
(ucs-set-char #x00A4 ?-B) ; ISO-8859-2-A4-A
(ucs-set-char #x00A4 ?) ; ISO-8859-1-A4

;; YEN SIGN
(ucs-set-char #x00A5 (make-char 'latin-jisx0201 (char-int ?\\)))
(ucs-set-char #x00A5 ?-M) ; ISO-8859-9-A5-A
(ucs-set-char #x00A5 ?2]-H0]) ; ISO-8859-8-A5-A
(ucs-set-char #x00A5 ?) ; ISO-8859-1-A5

;; BROKEN BAR
(ucs-set-char #x00A6 ?-M) ; ISO-8859-9-A6-A
(ucs-set-char #x00A6 ?2]-H0]) ; ISO-8859-8-A6-A
(ucs-set-char #x00A6 ?-F) ; ISO-8859-7-A6-A
(ucs-set-char #x00A6 ?) ; ISO-8859-1-A6

;; SECTION SIGN
(ucs-set-char #x00A7 ?$(C!W(B) ; KS0-C-2157
(ucs-set-char #x00A7 ?$(G!p(B) ; C01-G-2170
(ucs-set-char #x00A7 ?$(@!x(B) ; J78-@-2178
(ucs-set-char #x00A7 ?$(A!l(B) ; GB0-A-216C
(ucs-set-char #x00A7 ?$(B!x(B) ; J83-B-2178
(ucs-set-char #x00A7 ?-M) ; ISO-8859-9-A7-A
(ucs-set-char #x00A7 ?2]-H0]) ; ISO-8859-8-A7-A
(ucs-set-char #x00A7 ?-F) ; ISO-8859-7-A7-A
(ucs-set-char #x00A7 ?-L) ; ISO-8859-5-FD-A
(ucs-set-char #x00A7 ?-D) ; ISO-8859-4-A7-A
(ucs-set-char #x00A7 ?-C) ; ISO-8859-3-A7-A
(ucs-set-char #x00A7 ?-B) ; ISO-8859-2-A7-A
(ucs-set-char #x00A7 ?) ; ISO-8859-1-A7

;; DIAERESIS
(ucs-set-char #x00A8 ?$(C!'(B) ; KS0-C-2127
(ucs-set-char #x00A8 ?$(@!/(B) ; J78-@-212F
(ucs-set-char #x00A8 ?$(A!'(B) ; GB0-A-2127
(ucs-set-char #x00A8 ?$(B!/(B) ; J83-B-212F
(ucs-set-char #x00A8 ?-M) ; ISO-8859-9-A8-A
(ucs-set-char #x00A8 ?2]-H0]) ; ISO-8859-8-A8-A
(ucs-set-char #x00A8 ?-F) ; ISO-8859-7-A8-A
(ucs-set-char #x00A8 ?-D) ; ISO-8859-4-A8-A
(ucs-set-char #x00A8 ?-C) ; ISO-8859-3-A8-A
(ucs-set-char #x00A8 ?-B) ; ISO-8859-2-A8-A
(ucs-set-char #x00A8 ?) ; ISO-8859-1-A8

;; COPYRIGHT SIGN
(ucs-set-char #x00A9 ?$(D"m(B) ; J90-D-226D
(ucs-set-char #x00A9 ?-M) ; ISO-8859-9-A9-A
(ucs-set-char #x00A9 ?2]-H0]) ; ISO-8859-8-A9-A
(ucs-set-char #x00A9 ?-F) ; ISO-8859-7-A9-A
(ucs-set-char #x00A9 ?) ; ISO-8859-1-A9

;; FEMININE ORDINAL INDICATOR
(ucs-set-char #x00AA ?$(C(#(B) ; KS0-C-2823
(ucs-set-char #x00AA ?$(D"l(B) ; J90-D-226C
(ucs-set-char #x00AA ?-M) ; ISO-8859-9-AA-A
(ucs-set-char #x00AA ?) ; ISO-8859-1-AA

;; LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
(ucs-set-char #x00AB ?-M) ; ISO-8859-9-AB-A
(ucs-set-char #x00AB ?2]-H0]) ; ISO-8859-8-AB-A
(ucs-set-char #x00AB ?-F) ; ISO-8859-7-AB-A
(ucs-set-char #x00AB ?) ; ISO-8859-1-AB

;; NOT SIGN
(ucs-set-char #x00AC ?-M) ; ISO-8859-9-AC-A
(ucs-set-char #x00AC ?2]-H0]) ; ISO-8859-8-AC-A
(ucs-set-char #x00AC ?-F) ; ISO-8859-7-AC-A
(ucs-set-char #x00AC ?) ; ISO-8859-1-AC

;; SOFT HYPHEN
(ucs-set-char #x00AD ?$(C!)(B) ; KS0-C-2129
(ucs-set-char #x00AD ?-M) ; ISO-8859-9-AD-A
(ucs-set-char #x00AD ?2]-H0]) ; ISO-8859-8-AD-A
(ucs-set-char #x00AD ?-F) ; ISO-8859-7-AD-A
(ucs-set-char #x00AD ?-L) ; ISO-8859-5-AD-A
(ucs-set-char #x00AD ?-D) ; ISO-8859-4-AD-A
(ucs-set-char #x00AD ?-C) ; ISO-8859-3-AD-A
(ucs-set-char #x00AD ?-B) ; ISO-8859-2-AD-A
(ucs-set-char #x00AD ?) ; ISO-8859-1-AD

;; REGISTERED SIGN
(ucs-set-char #x00AE ?$(D"n(B) ; J90-D-226E
(ucs-set-char #x00AE ?-M) ; ISO-8859-9-AE-A
(ucs-set-char #x00AE ?2]-H0]) ; ISO-8859-8-AE-A
(ucs-set-char #x00AE ?) ; ISO-8859-1-AE

;; MACRON
(ucs-set-char #x00AF ?-M) ; ISO-8859-9-AF-A
(ucs-set-char #x00AF ?-D) ; ISO-8859-4-AF-A
(ucs-set-char #x00AF ?) ; ISO-8859-1-AF

;; DEGREE SIGN
(ucs-set-char #x00B0 ?$(C!F(B) ; KS0-C-2146
(ucs-set-char #x00B0 ?$(G"x(B) ; C01-G-2278
(ucs-set-char #x00B0 ?$(@!k(B) ; J78-@-216B
(ucs-set-char #x00B0 ?$(A!c(B) ; GB0-A-2163
(ucs-set-char #x00B0 ?$(B!k(B) ; J83-B-216B
(ucs-set-char #x00B0 ?-M) ; ISO-8859-9-B0-A
(ucs-set-char #x00B0 ?2]-H0]) ; ISO-8859-8-B0-A
(ucs-set-char #x00B0 ?-F) ; ISO-8859-7-B0-A
(ucs-set-char #x00B0 ?-D) ; ISO-8859-4-B0-A
(ucs-set-char #x00B0 ?-C) ; ISO-8859-3-B0-A
(ucs-set-char #x00B0 ?-B) ; ISO-8859-2-B0-A
(ucs-set-char #x00B0 ?) ; ISO-8859-1-B0

;; PLUS-MINUS SIGN
(ucs-set-char #x00B1 ?$(C!>(B) ; KS0-C-213E
(ucs-set-char #x00B1 ?$(G"4(B) ; C01-G-2234
(ucs-set-char #x00B1 ?$(@!^(B) ; J78-@-215E
(ucs-set-char #x00B1 ?$(A!@(B) ; GB0-A-2140
(ucs-set-char #x00B1 ?$(B!^(B) ; J83-B-215E
(ucs-set-char #x00B1 ?-M) ; ISO-8859-9-B1-A
(ucs-set-char #x00B1 ?2]-H0]) ; ISO-8859-8-B1-A
(ucs-set-char #x00B1 ?-F) ; ISO-8859-7-B1-A
(ucs-set-char #x00B1 ?) ; ISO-8859-1-B1

;; SUPERSCRIPT TWO
(ucs-set-char #x00B2 ?$(C)w(B) ; KS0-C-2977
(ucs-set-char #x00B2 ?-M) ; ISO-8859-9-B2-A
(ucs-set-char #x00B2 ?2]-H0]) ; ISO-8859-8-B2-A
(ucs-set-char #x00B2 ?-F) ; ISO-8859-7-B2-A
(ucs-set-char #x00B2 ?-C) ; ISO-8859-3-B2-A
(ucs-set-char #x00B2 ?) ; ISO-8859-1-B2

;; SUPERSCRIPT THREE
(ucs-set-char #x00B3 ?$(C)x(B) ; KS0-C-2978
(ucs-set-char #x00B3 ?-M) ; ISO-8859-9-B3-A
(ucs-set-char #x00B3 ?2]-H0]) ; ISO-8859-8-B3-A
(ucs-set-char #x00B3 ?-F) ; ISO-8859-7-B3-A
(ucs-set-char #x00B3 ?-C) ; ISO-8859-3-B3-A
(ucs-set-char #x00B3 ?) ; ISO-8859-1-B3

;; ACUTE ACCENT
(ucs-set-char #x00B4 ?$(C"%(B) ; KS0-C-2225
(ucs-set-char #x00B4 ?$(@!-(B) ; J78-@-212D
(ucs-set-char #x00B4 ?$(B!-(B) ; J83-B-212D
(ucs-set-char #x00B4 ?-M) ; ISO-8859-9-B4-A
(ucs-set-char #x00B4 ?2]-H0]) ; ISO-8859-8-B4-A
(ucs-set-char #x00B4 ?-D) ; ISO-8859-4-B4-A
(ucs-set-char #x00B4 ?-C) ; ISO-8859-3-B4-A
(ucs-set-char #x00B4 ?-B) ; ISO-8859-2-B4-A
(ucs-set-char #x00B4 ?) ; ISO-8859-1-B4

;; MICRO SIGN
(ucs-set-char #x00B5 ?-M) ; ISO-8859-9-B5-A
(ucs-set-char #x00B5 ?2]-H0]) ; ISO-8859-8-B5-A
(ucs-set-char #x00B5 ?-C) ; ISO-8859-3-B5-A
(ucs-set-char #x00B5 ?) ; ISO-8859-1-B5

;; PILCROW SIGN
(ucs-set-char #x00B6 ?$(C"R(B) ; KS0-C-2252
(ucs-set-char #x00B6 ?$(B"y(B) ; J83-B-2279
(ucs-set-char #x00B6 ?-M) ; ISO-8859-9-B6-A
(ucs-set-char #x00B6 ?2]-H0]) ; ISO-8859-8-B6-A
(ucs-set-char #x00B6 ?) ; ISO-8859-1-B6

;; MIDDLE DOT
(ucs-set-char #x00B7 ?$(C!$(B) ; KS0-C-2124
(ucs-set-char #x00B7 ?$(G!&(B) ; C01-G-2126
(ucs-set-char #x00B7 ?-M) ; ISO-8859-9-B7-A
(ucs-set-char #x00B7 ?2]-H0]) ; ISO-8859-8-B7-A
(ucs-set-char #x00B7 ?-F) ; ISO-8859-7-B7-A
(ucs-set-char #x00B7 ?-C) ; ISO-8859-3-B7-A
(ucs-set-char #x00B7 ?) ; ISO-8859-1-B7

;; CEDILLA
(ucs-set-char #x00B8 ?$(C",(B) ; KS0-C-222C
(ucs-set-char #x00B8 ?$(D"1(B) ; J90-D-2231
(ucs-set-char #x00B8 ?-M) ; ISO-8859-9-B8-A
(ucs-set-char #x00B8 ?2]-H0]) ; ISO-8859-8-B8-A
(ucs-set-char #x00B8 ?-D) ; ISO-8859-4-B8-A
(ucs-set-char #x00B8 ?-C) ; ISO-8859-3-B8-A
(ucs-set-char #x00B8 ?-B) ; ISO-8859-2-B8-A
(ucs-set-char #x00B8 ?) ; ISO-8859-1-B8

;; SUPERSCRIPT ONE
(ucs-set-char #x00B9 ?$(C)v(B) ; KS0-C-2976
(ucs-set-char #x00B9 ?-M) ; ISO-8859-9-B9-A
(ucs-set-char #x00B9 ?2]-H0]) ; ISO-8859-8-B9-A
(ucs-set-char #x00B9 ?) ; ISO-8859-1-B9

;; MASCULINE ORDINAL INDICATOR
(ucs-set-char #x00BA ?$(C(,(B) ; KS0-C-282C
(ucs-set-char #x00BA ?$(D"k(B) ; J90-D-226B
(ucs-set-char #x00BA ?-M) ; ISO-8859-9-BA-A
(ucs-set-char #x00BA ?) ; ISO-8859-1-BA

;; RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
(ucs-set-char #x00BB ?-M) ; ISO-8859-9-BB-A
(ucs-set-char #x00BB ?2]-H0]) ; ISO-8859-8-BB-A
(ucs-set-char #x00BB ?-F) ; ISO-8859-7-BB-A
(ucs-set-char #x00BB ?) ; ISO-8859-1-BB

;; VULGAR FRACTION ONE QUARTER
(ucs-set-char #x00BC ?$(C(y(B) ; KS0-C-2879
(ucs-set-char #x00BC ?-M) ; ISO-8859-9-BC-A
(ucs-set-char #x00BC ?2]-H0]) ; ISO-8859-8-BC-A
(ucs-set-char #x00BC ?) ; ISO-8859-1-BC

;; VULGAR FRACTION ONE HALF
(ucs-set-char #x00BD ?$(C(v(B) ; KS0-C-2876
(ucs-set-char #x00BD ?-M) ; ISO-8859-9-BD-A
(ucs-set-char #x00BD ?2]-H0]) ; ISO-8859-8-BD-A
(ucs-set-char #x00BD ?-F) ; ISO-8859-7-BD-A
(ucs-set-char #x00BD ?-C) ; ISO-8859-3-BD-A
(ucs-set-char #x00BD ?) ; ISO-8859-1-BD

;; VULGAR FRACTION THREE QUARTERS
(ucs-set-char #x00BE ?$(C(z(B) ; KS0-C-287A
(ucs-set-char #x00BE ?-M) ; ISO-8859-9-BE-A
(ucs-set-char #x00BE ?2]-H0]) ; ISO-8859-8-BE-A
(ucs-set-char #x00BE ?) ; ISO-8859-1-BE

;; INVERTED QUESTION MARK
(ucs-set-char #x00BF ?$(C"/(B) ; KS0-C-222F
(ucs-set-char #x00BF ?$(D"D(B) ; J90-D-2244
(ucs-set-char #x00BF ?-M) ; ISO-8859-9-BF-A
(ucs-set-char #x00BF ?) ; ISO-8859-1-BF

;; LATIN CAPITAL LETTER A WITH GRAVE
(ucs-set-char #x00C0 ?$(D*"(B) ; J90-D-2A22
(ucs-set-char #x00C0 ?-2) ; VISCII-1.1-C0-A
(ucs-set-char #x00C0 ?-M) ; ISO-8859-9-C0-A
(ucs-set-char #x00C0 ?-C) ; ISO-8859-3-C0-A
(ucs-set-char #x00C0 ?) ; ISO-8859-1-C0

;; LATIN CAPITAL LETTER A WITH ACUTE
(ucs-set-char #x00C1 ?$(D*!(B) ; J90-D-2A21
(ucs-set-char #x00C1 ?-2) ; VISCII-1.1-C1-A
(ucs-set-char #x00C1 ?-M) ; ISO-8859-9-C1-A
(ucs-set-char #x00C1 ?-D) ; ISO-8859-4-C1-A
(ucs-set-char #x00C1 ?-C) ; ISO-8859-3-C1-A
(ucs-set-char #x00C1 ?-B) ; ISO-8859-2-C1-A
(ucs-set-char #x00C1 ?) ; ISO-8859-1-C1

;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX
(ucs-set-char #x00C2 ?$(D*$(B) ; J90-D-2A24
(ucs-set-char #x00C2 ?-2) ; VISCII-1.1-C2-A
(ucs-set-char #x00C2 ?-M) ; ISO-8859-9-C2-A
(ucs-set-char #x00C2 ?-D) ; ISO-8859-4-C2-A
(ucs-set-char #x00C2 ?-C) ; ISO-8859-3-C2-A
(ucs-set-char #x00C2 ?-B) ; ISO-8859-2-C2-A
(ucs-set-char #x00C2 ?) ; ISO-8859-1-C2

;; LATIN CAPITAL LETTER A WITH TILDE
(ucs-set-char #x00C3 ?$(D**(B) ; J90-D-2A2A
(ucs-set-char #x00C3 ?-2) ; VISCII-1.1-C3-A
(ucs-set-char #x00C3 ?-M) ; ISO-8859-9-C3-A
(ucs-set-char #x00C3 ?-D) ; ISO-8859-4-C3-A
(ucs-set-char #x00C3 ?) ; ISO-8859-1-C3

;; LATIN CAPITAL LETTER A WITH DIAERESIS
(ucs-set-char #x00C4 ?$(D*#(B) ; J90-D-2A23
(ucs-set-char #x00C4 ?-M) ; ISO-8859-9-C4-A
(ucs-set-char #x00C4 ?-D) ; ISO-8859-4-C4-A
(ucs-set-char #x00C4 ?-C) ; ISO-8859-3-C4-A
(ucs-set-char #x00C4 ?-B) ; ISO-8859-2-C4-A
(ucs-set-char #x00C4 ?) ; ISO-8859-1-C4

;; LATIN CAPITAL LETTER A WITH RING ABOVE
(ucs-set-char #x00C5 ?$(D*)(B) ; J90-D-2A29
(ucs-set-char #x00C5 ?-M) ; ISO-8859-9-C5-A
(ucs-set-char #x00C5 ?-D) ; ISO-8859-4-C5-A
(ucs-set-char #x00C5 ?) ; ISO-8859-1-C5

;; LATIN CAPITAL LETTER AE
(ucs-set-char #x00C6 ?$(C(!(B) ; KS0-C-2821
(ucs-set-char #x00C6 ?$(D)!(B) ; J90-D-2921
(ucs-set-char #x00C6 ?-M) ; ISO-8859-9-C6-A
(ucs-set-char #x00C6 ?-D) ; ISO-8859-4-C6-A
(ucs-set-char #x00C6 ?) ; ISO-8859-1-C6

;; LATIN CAPITAL LETTER C WITH CEDILLA
(ucs-set-char #x00C7 ?$(D*.(B) ; J90-D-2A2E
(ucs-set-char #x00C7 ?-M) ; ISO-8859-9-C7-A
(ucs-set-char #x00C7 ?-C) ; ISO-8859-3-C7-A
(ucs-set-char #x00C7 ?-B) ; ISO-8859-2-C7-A
(ucs-set-char #x00C7 ?) ; ISO-8859-1-C7

;; LATIN CAPITAL LETTER E WITH GRAVE
(ucs-set-char #x00C8 ?$(D*2(B) ; J90-D-2A32
(ucs-set-char #x00C8 ?-2) ; VISCII-1.1-C8-A
(ucs-set-char #x00C8 ?-M) ; ISO-8859-9-C8-A
(ucs-set-char #x00C8 ?-C) ; ISO-8859-3-C8-A
(ucs-set-char #x00C8 ?) ; ISO-8859-1-C8

;; LATIN CAPITAL LETTER E WITH ACUTE
(ucs-set-char #x00C9 ?$(D*1(B) ; J90-D-2A31
(ucs-set-char #x00C9 ?-2) ; VISCII-1.1-C9-A
(ucs-set-char #x00C9 ?-M) ; ISO-8859-9-C9-A
(ucs-set-char #x00C9 ?-D) ; ISO-8859-4-C9-A
(ucs-set-char #x00C9 ?-C) ; ISO-8859-3-C9-A
(ucs-set-char #x00C9 ?-B) ; ISO-8859-2-C9-A
(ucs-set-char #x00C9 ?) ; ISO-8859-1-C9

;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX
(ucs-set-char #x00CA ?$(D*4(B) ; J90-D-2A34
(ucs-set-char #x00CA ?-2) ; VISCII-1.1-CA-A
(ucs-set-char #x00CA ?-M) ; ISO-8859-9-CA-A
(ucs-set-char #x00CA ?-C) ; ISO-8859-3-CA-A
(ucs-set-char #x00CA ?) ; ISO-8859-1-CA

;; LATIN CAPITAL LETTER E WITH DIAERESIS
(ucs-set-char #x00CB ?$(D*3(B) ; J90-D-2A33
(ucs-set-char #x00CB ?-M) ; ISO-8859-9-CB-A
(ucs-set-char #x00CB ?-D) ; ISO-8859-4-CB-A
(ucs-set-char #x00CB ?-C) ; ISO-8859-3-CB-A
(ucs-set-char #x00CB ?-B) ; ISO-8859-2-CB-A
(ucs-set-char #x00CB ?) ; ISO-8859-1-CB

;; LATIN CAPITAL LETTER I WITH GRAVE
(ucs-set-char #x00CC ?$(D*@(B) ; J90-D-2A40
(ucs-set-char #x00CC ?-2) ; VISCII-1.1-CC-A
(ucs-set-char #x00CC ?-M) ; ISO-8859-9-CC-A
(ucs-set-char #x00CC ?-C) ; ISO-8859-3-CC-A
(ucs-set-char #x00CC ?) ; ISO-8859-1-CC

;; LATIN CAPITAL LETTER I WITH ACUTE
(ucs-set-char #x00CD ?$(D*?(B) ; J90-D-2A3F
(ucs-set-char #x00CD ?-2) ; VISCII-1.1-CD-A
(ucs-set-char #x00CD ?-M) ; ISO-8859-9-CD-A
(ucs-set-char #x00CD ?-D) ; ISO-8859-4-CD-A
(ucs-set-char #x00CD ?-C) ; ISO-8859-3-CD-A
(ucs-set-char #x00CD ?-B) ; ISO-8859-2-CD-A
(ucs-set-char #x00CD ?) ; ISO-8859-1-CD

;; LATIN CAPITAL LETTER I WITH CIRCUMFLEX
(ucs-set-char #x00CE ?$(D*B(B) ; J90-D-2A42
(ucs-set-char #x00CE ?-M) ; ISO-8859-9-CE-A
(ucs-set-char #x00CE ?-D) ; ISO-8859-4-CE-A
(ucs-set-char #x00CE ?-C) ; ISO-8859-3-CE-A
(ucs-set-char #x00CE ?-B) ; ISO-8859-2-CE-A
(ucs-set-char #x00CE ?) ; ISO-8859-1-CE

;; LATIN CAPITAL LETTER I WITH DIAERESIS
(ucs-set-char #x00CF ?$(D*A(B) ; J90-D-2A41
(ucs-set-char #x00CF ?-M) ; ISO-8859-9-CF-A
(ucs-set-char #x00CF ?-C) ; ISO-8859-3-CF-A
(ucs-set-char #x00CF ?) ; ISO-8859-1-CF

;; LATIN CAPITAL LETTER ETH
(ucs-set-char #x00D0 ?$(C("(B) ; KS0-C-2822
(ucs-set-char #x00D0 ?) ; ISO-8859-1-D0

;; LATIN CAPITAL LETTER N WITH TILDE
(ucs-set-char #x00D1 ?$(D*P(B) ; J90-D-2A50
(ucs-set-char #x00D1 ?-M) ; ISO-8859-9-D1-A
(ucs-set-char #x00D1 ?-C) ; ISO-8859-3-D1-A
(ucs-set-char #x00D1 ?) ; ISO-8859-1-D1

;; LATIN CAPITAL LETTER O WITH GRAVE
(ucs-set-char #x00D2 ?$(D*R(B) ; J90-D-2A52
(ucs-set-char #x00D2 ?-2) ; VISCII-1.1-D2-A
(ucs-set-char #x00D2 ?-M) ; ISO-8859-9-D2-A
(ucs-set-char #x00D2 ?-C) ; ISO-8859-3-D2-A
(ucs-set-char #x00D2 ?) ; ISO-8859-1-D2

;; LATIN CAPITAL LETTER O WITH ACUTE
(ucs-set-char #x00D3 ?$(D*Q(B) ; J90-D-2A51
(ucs-set-char #x00D3 ?-2) ; VISCII-1.1-D3-A
(ucs-set-char #x00D3 ?-M) ; ISO-8859-9-D3-A
(ucs-set-char #x00D3 ?-C) ; ISO-8859-3-D3-A
(ucs-set-char #x00D3 ?-B) ; ISO-8859-2-D3-A
(ucs-set-char #x00D3 ?) ; ISO-8859-1-D3

;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX
(ucs-set-char #x00D4 ?$(D*T(B) ; J90-D-2A54
(ucs-set-char #x00D4 ?-2) ; VISCII-1.1-D4-A
(ucs-set-char #x00D4 ?-M) ; ISO-8859-9-D4-A
(ucs-set-char #x00D4 ?-D) ; ISO-8859-4-D4-A
(ucs-set-char #x00D4 ?-C) ; ISO-8859-3-D4-A
(ucs-set-char #x00D4 ?-B) ; ISO-8859-2-D4-A
(ucs-set-char #x00D4 ?) ; ISO-8859-1-D4

;; LATIN CAPITAL LETTER O WITH TILDE
(ucs-set-char #x00D5 ?$(D*X(B) ; J90-D-2A58
(ucs-set-char #x00D5 ?-2) ; VISCII-1.1-A0-A
(ucs-set-char #x00D5 ?-M) ; ISO-8859-9-D5-A
(ucs-set-char #x00D5 ?-D) ; ISO-8859-4-D5-A
(ucs-set-char #x00D5 ?) ; ISO-8859-1-D5

;; LATIN CAPITAL LETTER O WITH DIAERESIS
(ucs-set-char #x00D6 ?$(D*S(B) ; J90-D-2A53
(ucs-set-char #x00D6 ?-M) ; ISO-8859-9-D6-A
(ucs-set-char #x00D6 ?-D) ; ISO-8859-4-D6-A
(ucs-set-char #x00D6 ?-C) ; ISO-8859-3-D6-A
(ucs-set-char #x00D6 ?-B) ; ISO-8859-2-D6-A
(ucs-set-char #x00D6 ?) ; ISO-8859-1-D6

;; MULTIPLICATION SIGN
(ucs-set-char #x00D7 ?$(C!?(B) ; KS0-C-213F
(ucs-set-char #x00D7 ?$(G"2(B) ; C01-G-2232
(ucs-set-char #x00D7 ?$(@!_(B) ; J78-@-215F
(ucs-set-char #x00D7 ?$(A!A(B) ; GB0-A-2141
(ucs-set-char #x00D7 ?$(B!_(B) ; J83-B-215F
(ucs-set-char #x00D7 ?-M) ; ISO-8859-9-D7-A
(ucs-set-char #x00D7 ?2]-H0]) ; ISO-8859-8-AA-A
(ucs-set-char #x00D7 ?-D) ; ISO-8859-4-D7-A
(ucs-set-char #x00D7 ?-C) ; ISO-8859-3-D7-A
(ucs-set-char #x00D7 ?-B) ; ISO-8859-2-D7-A
(ucs-set-char #x00D7 ?) ; ISO-8859-1-D7

;; LATIN CAPITAL LETTER O WITH STROKE
(ucs-set-char #x00D8 ?$(C(*(B) ; KS0-C-282A
(ucs-set-char #x00D8 ?$(D),(B) ; J90-D-292C
(ucs-set-char #x00D8 ?-M) ; ISO-8859-9-D8-A
(ucs-set-char #x00D8 ?-D) ; ISO-8859-4-D8-A
(ucs-set-char #x00D8 ?) ; ISO-8859-1-D8

;; LATIN CAPITAL LETTER U WITH GRAVE
(ucs-set-char #x00D9 ?$(D*c(B) ; J90-D-2A63
(ucs-set-char #x00D9 ?-2) ; VISCII-1.1-D9-A
(ucs-set-char #x00D9 ?-M) ; ISO-8859-9-D9-A
(ucs-set-char #x00D9 ?-C) ; ISO-8859-3-D9-A
(ucs-set-char #x00D9 ?) ; ISO-8859-1-D9

;; LATIN CAPITAL LETTER U WITH ACUTE
(ucs-set-char #x00DA ?$(D*b(B) ; J90-D-2A62
(ucs-set-char #x00DA ?-2) ; VISCII-1.1-DA-A
(ucs-set-char #x00DA ?-M) ; ISO-8859-9-DA-A
(ucs-set-char #x00DA ?-D) ; ISO-8859-4-DA-A
(ucs-set-char #x00DA ?-C) ; ISO-8859-3-DA-A
(ucs-set-char #x00DA ?-B) ; ISO-8859-2-DA-A
(ucs-set-char #x00DA ?) ; ISO-8859-1-DA

;; LATIN CAPITAL LETTER U WITH CIRCUMFLEX
(ucs-set-char #x00DB ?$(D*e(B) ; J90-D-2A65
(ucs-set-char #x00DB ?-M) ; ISO-8859-9-DB-A
(ucs-set-char #x00DB ?-D) ; ISO-8859-4-DB-A
(ucs-set-char #x00DB ?-C) ; ISO-8859-3-DB-A
(ucs-set-char #x00DB ?) ; ISO-8859-1-DB

;; LATIN CAPITAL LETTER U WITH DIAERESIS
(ucs-set-char #x00DC ?$(D*d(B) ; J90-D-2A64
(ucs-set-char #x00DC ?-M) ; ISO-8859-9-DC-A
(ucs-set-char #x00DC ?-D) ; ISO-8859-4-DC-A
(ucs-set-char #x00DC ?-C) ; ISO-8859-3-DC-A
(ucs-set-char #x00DC ?-B) ; ISO-8859-2-DC-A
(ucs-set-char #x00DC ?) ; ISO-8859-1-DC

;; LATIN CAPITAL LETTER Y WITH ACUTE
(ucs-set-char #x00DD ?$(D*r(B) ; J90-D-2A72
(ucs-set-char #x00DD ?-2) ; VISCII-1.1-DD-A
(ucs-set-char #x00DD ?-B) ; ISO-8859-2-DD-A
(ucs-set-char #x00DD ?) ; ISO-8859-1-DD

;; LATIN CAPITAL LETTER THORN
(ucs-set-char #x00DE ?$(C(-(B) ; KS0-C-282D
(ucs-set-char #x00DE ?$(D)0(B) ; J90-D-2930
(ucs-set-char #x00DE ?) ; ISO-8859-1-DE

;; LATIN SMALL LETTER SHARP S
(ucs-set-char #x00DF ?$(C),(B) ; KS0-C-292C
(ucs-set-char #x00DF ?$(D)N(B) ; J90-D-294E
(ucs-set-char #x00DF ?-M) ; ISO-8859-9-DF-A
(ucs-set-char #x00DF ?-D) ; ISO-8859-4-DF-A
(ucs-set-char #x00DF ?-C) ; ISO-8859-3-DF-A
(ucs-set-char #x00DF ?-B) ; ISO-8859-2-DF-A
(ucs-set-char #x00DF ?) ; ISO-8859-1-DF

;; LATIN SMALL LETTER A WITH GRAVE
(ucs-set-char #x00E0 ?$(D+"(B) ; J90-D-2B22
(ucs-set-char #x00E0 ?$(A($(B) ; GB0-A-2824
(ucs-set-char #x00E0 ?-1) ; VISCII-1.1-E0-A
(ucs-set-char #x00E0 ?-M) ; ISO-8859-9-E0-A
(ucs-set-char #x00E0 ?-C) ; ISO-8859-3-E0-A
(ucs-set-char #x00E0 ?) ; ISO-8859-1-E0

;; LATIN SMALL LETTER A WITH ACUTE
(ucs-set-char #x00E1 ?$(D+!(B) ; J90-D-2B21
(ucs-set-char #x00E1 ?$(A("(B) ; GB0-A-2822
(ucs-set-char #x00E1 ?-1) ; VISCII-1.1-E1-A
(ucs-set-char #x00E1 ?-M) ; ISO-8859-9-E1-A
(ucs-set-char #x00E1 ?-D) ; ISO-8859-4-E1-A
(ucs-set-char #x00E1 ?-C) ; ISO-8859-3-E1-A
(ucs-set-char #x00E1 ?-B) ; ISO-8859-2-E1-A
(ucs-set-char #x00E1 ?) ; ISO-8859-1-E1

;; LATIN SMALL LETTER A WITH CIRCUMFLEX
(ucs-set-char #x00E2 ?$(D+$(B) ; J90-D-2B24
(ucs-set-char #x00E2 ?-1) ; VISCII-1.1-E2-A
(ucs-set-char #x00E2 ?-M) ; ISO-8859-9-E2-A
(ucs-set-char #x00E2 ?-D) ; ISO-8859-4-E2-A
(ucs-set-char #x00E2 ?-C) ; ISO-8859-3-E2-A
(ucs-set-char #x00E2 ?-B) ; ISO-8859-2-E2-A
(ucs-set-char #x00E2 ?) ; ISO-8859-1-E2

;; LATIN SMALL LETTER A WITH TILDE
(ucs-set-char #x00E3 ?$(D+*(B) ; J90-D-2B2A
(ucs-set-char #x00E3 ?-1) ; VISCII-1.1-E3-A
(ucs-set-char #x00E3 ?-M) ; ISO-8859-9-E3-A
(ucs-set-char #x00E3 ?-D) ; ISO-8859-4-E3-A
(ucs-set-char #x00E3 ?) ; ISO-8859-1-E3

;; LATIN SMALL LETTER A WITH DIAERESIS
(ucs-set-char #x00E4 ?$(D+#(B) ; J90-D-2B23
(ucs-set-char #x00E4 ?-M) ; ISO-8859-9-E4-A
(ucs-set-char #x00E4 ?-D) ; ISO-8859-4-E4-A
(ucs-set-char #x00E4 ?-C) ; ISO-8859-3-E4-A
(ucs-set-char #x00E4 ?-B) ; ISO-8859-2-E4-A
(ucs-set-char #x00E4 ?) ; ISO-8859-1-E4

;; LATIN SMALL LETTER A WITH RING ABOVE
(ucs-set-char #x00E5 ?$(D+)(B) ; J90-D-2B29
(ucs-set-char #x00E5 ?-M) ; ISO-8859-9-E5-A
(ucs-set-char #x00E5 ?-D) ; ISO-8859-4-E5-A
(ucs-set-char #x00E5 ?) ; ISO-8859-1-E5

;; LATIN SMALL LETTER AE
(ucs-set-char #x00E6 ?$(C)!(B) ; KS0-C-2921
(ucs-set-char #x00E6 ?$(D)A(B) ; J90-D-2941
(ucs-set-char #x00E6 ?-M) ; ISO-8859-9-E6-A
(ucs-set-char #x00E6 ?-D) ; ISO-8859-4-E6-A
(ucs-set-char #x00E6 ?) ; ISO-8859-1-E6

;; LATIN SMALL LETTER C WITH CEDILLA
(ucs-set-char #x00E7 ?$(D+.(B) ; J90-D-2B2E
(ucs-set-char #x00E7 ?-M) ; ISO-8859-9-E7-A
(ucs-set-char #x00E7 ?-C) ; ISO-8859-3-E7-A
(ucs-set-char #x00E7 ?-B) ; ISO-8859-2-E7-A
(ucs-set-char #x00E7 ?) ; ISO-8859-1-E7

;; LATIN SMALL LETTER E WITH GRAVE
(ucs-set-char #x00E8 ?$(D+2(B) ; J90-D-2B32
(ucs-set-char #x00E8 ?$(A(((B) ; GB0-A-2828
(ucs-set-char #x00E8 ?-1) ; VISCII-1.1-E8-A
(ucs-set-char #x00E8 ?-M) ; ISO-8859-9-E8-A
(ucs-set-char #x00E8 ?-C) ; ISO-8859-3-E8-A
(ucs-set-char #x00E8 ?) ; ISO-8859-1-E8

;; LATIN SMALL LETTER E WITH ACUTE
(ucs-set-char #x00E9 ?$(D+1(B) ; J90-D-2B31
(ucs-set-char #x00E9 ?$(A(&(B) ; GB0-A-2826
(ucs-set-char #x00E9 ?-1) ; VISCII-1.1-E9-A
(ucs-set-char #x00E9 ?-M) ; ISO-8859-9-E9-A
(ucs-set-char #x00E9 ?-D) ; ISO-8859-4-E9-A
(ucs-set-char #x00E9 ?-C) ; ISO-8859-3-E9-A
(ucs-set-char #x00E9 ?-B) ; ISO-8859-2-E9-A
(ucs-set-char #x00E9 ?) ; ISO-8859-1-E9

;; LATIN SMALL LETTER E WITH CIRCUMFLEX
(ucs-set-char #x00EA ?$(D+4(B) ; J90-D-2B34
(ucs-set-char #x00EA ?$(A(:(B) ; GB0-A-283A
(ucs-set-char #x00EA ?-1) ; VISCII-1.1-EA-A
(ucs-set-char #x00EA ?-M) ; ISO-8859-9-EA-A
(ucs-set-char #x00EA ?-C) ; ISO-8859-3-EA-A
(ucs-set-char #x00EA ?) ; ISO-8859-1-EA

;; LATIN SMALL LETTER E WITH DIAERESIS
(ucs-set-char #x00EB ?$(D+3(B) ; J90-D-2B33
(ucs-set-char #x00EB ?-M) ; ISO-8859-9-EB-A
(ucs-set-char #x00EB ?-D) ; ISO-8859-4-EB-A
(ucs-set-char #x00EB ?-C) ; ISO-8859-3-EB-A
(ucs-set-char #x00EB ?-B) ; ISO-8859-2-EB-A
(ucs-set-char #x00EB ?) ; ISO-8859-1-EB

;; LATIN SMALL LETTER I WITH GRAVE
(ucs-set-char #x00EC ?$(D+@(B) ; J90-D-2B40
(ucs-set-char #x00EC ?$(A(,(B) ; GB0-A-282C
(ucs-set-char #x00EC ?-1) ; VISCII-1.1-EC-A
(ucs-set-char #x00EC ?-M) ; ISO-8859-9-EC-A
(ucs-set-char #x00EC ?-C) ; ISO-8859-3-EC-A
(ucs-set-char #x00EC ?) ; ISO-8859-1-EC

;; LATIN SMALL LETTER I WITH ACUTE
(ucs-set-char #x00ED ?$(D+?(B) ; J90-D-2B3F
(ucs-set-char #x00ED ?$(A(*(B) ; GB0-A-282A
(ucs-set-char #x00ED ?-1) ; VISCII-1.1-ED-A
(ucs-set-char #x00ED ?-M) ; ISO-8859-9-ED-A
(ucs-set-char #x00ED ?-D) ; ISO-8859-4-ED-A
(ucs-set-char #x00ED ?-C) ; ISO-8859-3-ED-A
(ucs-set-char #x00ED ?-B) ; ISO-8859-2-ED-A
(ucs-set-char #x00ED ?) ; ISO-8859-1-ED

;; LATIN SMALL LETTER I WITH CIRCUMFLEX
(ucs-set-char #x00EE ?$(D+B(B) ; J90-D-2B42
(ucs-set-char #x00EE ?-M) ; ISO-8859-9-EE-A
(ucs-set-char #x00EE ?-D) ; ISO-8859-4-EE-A
(ucs-set-char #x00EE ?-C) ; ISO-8859-3-EE-A
(ucs-set-char #x00EE ?-B) ; ISO-8859-2-EE-A
(ucs-set-char #x00EE ?) ; ISO-8859-1-EE

;; LATIN SMALL LETTER I WITH DIAERESIS
(ucs-set-char #x00EF ?$(D+A(B) ; J90-D-2B41
(ucs-set-char #x00EF ?-M) ; ISO-8859-9-EF-A
(ucs-set-char #x00EF ?-C) ; ISO-8859-3-EF-A
(ucs-set-char #x00EF ?) ; ISO-8859-1-EF

;; LATIN SMALL LETTER ETH
(ucs-set-char #x00F0 ?$(C)#(B) ; KS0-C-2923
(ucs-set-char #x00F0 ?$(D)C(B) ; J90-D-2943
(ucs-set-char #x00F0 ?) ; ISO-8859-1-F0

;; LATIN SMALL LETTER N WITH TILDE
(ucs-set-char #x00F1 ?$(D+P(B) ; J90-D-2B50
(ucs-set-char #x00F1 ?-M) ; ISO-8859-9-F1-A
(ucs-set-char #x00F1 ?-C) ; ISO-8859-3-F1-A
(ucs-set-char #x00F1 ?) ; ISO-8859-1-F1

;; LATIN SMALL LETTER O WITH GRAVE
(ucs-set-char #x00F2 ?$(D+R(B) ; J90-D-2B52
(ucs-set-char #x00F2 ?$(A(0(B) ; GB0-A-2830
(ucs-set-char #x00F2 ?-1) ; VISCII-1.1-F2-A
(ucs-set-char #x00F2 ?-M) ; ISO-8859-9-F2-A
(ucs-set-char #x00F2 ?-C) ; ISO-8859-3-F2-A
(ucs-set-char #x00F2 ?) ; ISO-8859-1-F2

;; LATIN SMALL LETTER O WITH ACUTE
(ucs-set-char #x00F3 ?$(D+Q(B) ; J90-D-2B51
(ucs-set-char #x00F3 ?$(A(.(B) ; GB0-A-282E
(ucs-set-char #x00F3 ?-1) ; VISCII-1.1-F3-A
(ucs-set-char #x00F3 ?-M) ; ISO-8859-9-F3-A
(ucs-set-char #x00F3 ?-C) ; ISO-8859-3-F3-A
(ucs-set-char #x00F3 ?-B) ; ISO-8859-2-F3-A
(ucs-set-char #x00F3 ?) ; ISO-8859-1-F3

;; LATIN SMALL LETTER O WITH CIRCUMFLEX
(ucs-set-char #x00F4 ?$(D+T(B) ; J90-D-2B54
(ucs-set-char #x00F4 ?-1) ; VISCII-1.1-F4-A
(ucs-set-char #x00F4 ?-M) ; ISO-8859-9-F4-A
(ucs-set-char #x00F4 ?-D) ; ISO-8859-4-F4-A
(ucs-set-char #x00F4 ?-C) ; ISO-8859-3-F4-A
(ucs-set-char #x00F4 ?-B) ; ISO-8859-2-F4-A
(ucs-set-char #x00F4 ?) ; ISO-8859-1-F4

;; LATIN SMALL LETTER O WITH TILDE
(ucs-set-char #x00F5 ?$(D+X(B) ; J90-D-2B58
(ucs-set-char #x00F5 ?-1) ; VISCII-1.1-F5-A
(ucs-set-char #x00F5 ?-M) ; ISO-8859-9-F5-A
(ucs-set-char #x00F5 ?-D) ; ISO-8859-4-F5-A
(ucs-set-char #x00F5 ?) ; ISO-8859-1-F5

;; LATIN SMALL LETTER O WITH DIAERESIS
(ucs-set-char #x00F6 ?$(D+S(B) ; J90-D-2B53
(ucs-set-char #x00F6 ?-M) ; ISO-8859-9-F6-A
(ucs-set-char #x00F6 ?-D) ; ISO-8859-4-F6-A
(ucs-set-char #x00F6 ?-C) ; ISO-8859-3-F6-A
(ucs-set-char #x00F6 ?-B) ; ISO-8859-2-F6-A
(ucs-set-char #x00F6 ?) ; ISO-8859-1-F6

;; DIVISION SIGN
(ucs-set-char #x00F7 ?$(C!@(B) ; KS0-C-2140
(ucs-set-char #x00F7 ?$(G"3(B) ; C01-G-2233
(ucs-set-char #x00F7 ?$(@!`(B) ; J78-@-2160
(ucs-set-char #x00F7 ?$(A!B(B) ; GB0-A-2142
(ucs-set-char #x00F7 ?$(B!`(B) ; J83-B-2160
(ucs-set-char #x00F7 ?-M) ; ISO-8859-9-F7-A
(ucs-set-char #x00F7 ?2]-H0]) ; ISO-8859-8-BA-A
(ucs-set-char #x00F7 ?-D) ; ISO-8859-4-F7-A
(ucs-set-char #x00F7 ?-C) ; ISO-8859-3-F7-A
(ucs-set-char #x00F7 ?-B) ; ISO-8859-2-F7-A
(ucs-set-char #x00F7 ?) ; ISO-8859-1-F7

;; LATIN SMALL LETTER O WITH STROKE
(ucs-set-char #x00F8 ?$(C)*(B) ; KS0-C-292A
(ucs-set-char #x00F8 ?$(D)L(B) ; J90-D-294C
(ucs-set-char #x00F8 ?-M) ; ISO-8859-9-F8-A
(ucs-set-char #x00F8 ?-D) ; ISO-8859-4-F8-A
(ucs-set-char #x00F8 ?) ; ISO-8859-1-F8

;; LATIN SMALL LETTER U WITH GRAVE
(ucs-set-char #x00F9 ?$(D+c(B) ; J90-D-2B63
(ucs-set-char #x00F9 ?$(A(4(B) ; GB0-A-2834
(ucs-set-char #x00F9 ?-1) ; VISCII-1.1-F9-A
(ucs-set-char #x00F9 ?-M) ; ISO-8859-9-F9-A
(ucs-set-char #x00F9 ?-C) ; ISO-8859-3-F9-A
(ucs-set-char #x00F9 ?) ; ISO-8859-1-F9

;; LATIN SMALL LETTER U WITH ACUTE
(ucs-set-char #x00FA ?$(D+b(B) ; J90-D-2B62
(ucs-set-char #x00FA ?$(A(2(B) ; GB0-A-2832
(ucs-set-char #x00FA ?-1) ; VISCII-1.1-FA-A
(ucs-set-char #x00FA ?-M) ; ISO-8859-9-FA-A
(ucs-set-char #x00FA ?-D) ; ISO-8859-4-FA-A
(ucs-set-char #x00FA ?-C) ; ISO-8859-3-FA-A
(ucs-set-char #x00FA ?-B) ; ISO-8859-2-FA-A
(ucs-set-char #x00FA ?) ; ISO-8859-1-FA

;; LATIN SMALL LETTER U WITH CIRCUMFLEX
(ucs-set-char #x00FB ?$(D+e(B) ; J90-D-2B65
(ucs-set-char #x00FB ?-M) ; ISO-8859-9-FB-A
(ucs-set-char #x00FB ?-D) ; ISO-8859-4-FB-A
(ucs-set-char #x00FB ?-C) ; ISO-8859-3-FB-A
(ucs-set-char #x00FB ?) ; ISO-8859-1-FB

;; LATIN SMALL LETTER U WITH DIAERESIS
(ucs-set-char #x00FC ?$(D+d(B) ; J90-D-2B64
(ucs-set-char #x00FC ?$(A(9(B) ; GB0-A-2839
(ucs-set-char #x00FC ?-M) ; ISO-8859-9-FC-A
(ucs-set-char #x00FC ?-D) ; ISO-8859-4-FC-A
(ucs-set-char #x00FC ?-C) ; ISO-8859-3-FC-A
(ucs-set-char #x00FC ?-B) ; ISO-8859-2-FC-A
(ucs-set-char #x00FC ?) ; ISO-8859-1-FC

;; LATIN SMALL LETTER Y WITH ACUTE
(ucs-set-char #x00FD ?$(D+r(B) ; J90-D-2B72
(ucs-set-char #x00FD ?-1) ; VISCII-1.1-FD-A
(ucs-set-char #x00FD ?-B) ; ISO-8859-2-FD-A
(ucs-set-char #x00FD ?) ; ISO-8859-1-FD

;; LATIN SMALL LETTER THORN
(ucs-set-char #x00FE ?$(C)-(B) ; KS0-C-292D
(ucs-set-char #x00FE ?$(D)P(B) ; J90-D-2950
(ucs-set-char #x00FE ?) ; ISO-8859-1-FE

;; LATIN SMALL LETTER Y WITH DIAERESIS
(ucs-set-char #x00FF ?$(D+s(B) ; J90-D-2B73
(ucs-set-char #x00FF ?-M) ; ISO-8859-9-FF-A
(ucs-set-char #x00FF ?) ; ISO-8859-1-FF

;;; ucs-latin-1.el ends here
