;;; uni-cjk-c-ideo.el --- UCS table of CJK Compatibility Ideographs

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE,
;;           CJK Compatibility Ideographs

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

(ucs-set-char #xF900 ?$(CKP(B) ; KS0-C-4B50
(ucs-set-char #xF901 ?$(CKV(B) ; KS0-C-4B56
(ucs-set-char #xF902 ?$(CKg(B) ; KS0-C-4B67
(ucs-set-char #xF903 ?$(CMO(B) ; KS0-C-4D4F
(ucs-set-char #xF904 ?$(CMh(B) ; KS0-C-4D68
(ucs-set-char #xF905 ?$(CN-(B) ; KS0-C-4E2D
(ucs-set-char #xF906 ?$(CO{(B) ; KS0-C-4F7B
(ucs-set-char #xF907 ?$(CP"(B) ; KS0-C-5022
(ucs-set-char #xF908 ?$(CP8(B) ; KS0-C-5038
(ucs-set-char #xF909 ?$(CPP(B) ; KS0-C-5050
(ucs-set-char #xF90A ?$(CP](B) ; KS0-C-505D
(ucs-set-char #xF90B ?$(CQT(B) ; KS0-C-5154
(ucs-set-char #xF90C ?$(CQU(B) ; KS0-C-5155
(ucs-set-char #xF90D ?$(CQX(B) ; KS0-C-5158
(ucs-set-char #xF90E ?$(CQ[(B) ; KS0-C-515B
(ucs-set-char #xF90F ?$(CQ\(B) ; KS0-C-515C
(ucs-set-char #xF910 ?$(CQ](B) ; KS0-C-515D
(ucs-set-char #xF911 ?$(CQ^(B) ; KS0-C-515E
(ucs-set-char #xF912 ?$(CQ_(B) ; KS0-C-515F
(ucs-set-char #xF913 ?$(CQ`(B) ; KS0-C-5160
(ucs-set-char #xF914 ?$(CQb(B) ; KS0-C-5162
(ucs-set-char #xF915 ?$(CQc(B) ; KS0-C-5163
(ucs-set-char #xF916 ?$(CQd(B) ; KS0-C-5164
(ucs-set-char #xF917 ?$(CQe(B) ; KS0-C-5165
(ucs-set-char #xF918 ?$(CQf(B) ; KS0-C-5166
(ucs-set-char #xF919 ?$(CQh(B) ; KS0-C-5168
(ucs-set-char #xF91A ?$(CQi(B) ; KS0-C-5169
(ucs-set-char #xF91B ?$(CQj(B) ; KS0-C-516A
(ucs-set-char #xF91C ?$(CQk(B) ; KS0-C-516B
(ucs-set-char #xF91D ?$(CQm(B) ; KS0-C-516D
(ucs-set-char #xF91E ?$(CQo(B) ; KS0-C-516F
(ucs-set-char #xF91F ?$(CQp(B) ; KS0-C-5170
(ucs-set-char #xF920 ?$(CQr(B) ; KS0-C-5172
(ucs-set-char #xF921 ?$(CQv(B) ; KS0-C-5176
(ucs-set-char #xF922 ?$(CQz(B) ; KS0-C-517A
(ucs-set-char #xF923 ?$(CQ|(B) ; KS0-C-517C
(ucs-set-char #xF924 ?$(CQ}(B) ; KS0-C-517D
(ucs-set-char #xF925 ?$(CQ~(B) ; KS0-C-517E
(ucs-set-char #xF926 ?$(CR"(B) ; KS0-C-5222
(ucs-set-char #xF927 ?$(CR#(B) ; KS0-C-5223
(ucs-set-char #xF928 ?$(CR'(B) ; KS0-C-5227
(ucs-set-char #xF929 ?$(CR((B) ; KS0-C-5228
(ucs-set-char #xF92A ?$(CR)(B) ; KS0-C-5229
(ucs-set-char #xF92B ?$(CR*(B) ; KS0-C-522A
(ucs-set-char #xF92C ?$(CR+(B) ; KS0-C-522B
(ucs-set-char #xF92D ?$(CR-(B) ; KS0-C-522D
(ucs-set-char #xF92E ?$(CR2(B) ; KS0-C-5232
(ucs-set-char #xF92F ?$(CR>(B) ; KS0-C-523E
(ucs-set-char #xF930 ?$(CRB(B) ; KS0-C-5242
(ucs-set-char #xF931 ?$(CRC(B) ; KS0-C-5243
(ucs-set-char #xF932 ?$(CRD(B) ; KS0-C-5244
(ucs-set-char #xF933 ?$(CRF(B) ; KS0-C-5246
(ucs-set-char #xF934 ?$(CRG(B) ; KS0-C-5247
(ucs-set-char #xF935 ?$(CRH(B) ; KS0-C-5248
(ucs-set-char #xF936 ?$(CRI(B) ; KS0-C-5249
(ucs-set-char #xF937 ?$(CRJ(B) ; KS0-C-524A
(ucs-set-char #xF938 ?$(CRK(B) ; KS0-C-524B
(ucs-set-char #xF939 ?$(CRM(B) ; KS0-C-524D
(ucs-set-char #xF93A ?$(CRN(B) ; KS0-C-524E
(ucs-set-char #xF93B ?$(CRO(B) ; KS0-C-524F
(ucs-set-char #xF93C ?$(CRP(B) ; KS0-C-5250
(ucs-set-char #xF93D ?$(CRQ(B) ; KS0-C-5251
(ucs-set-char #xF93E ?$(CRR(B) ; KS0-C-5252
(ucs-set-char #xF93F ?$(CRS(B) ; KS0-C-5253
(ucs-set-char #xF940 ?$(CRT(B) ; KS0-C-5254
(ucs-set-char #xF941 ?$(CRU(B) ; KS0-C-5255
(ucs-set-char #xF942 ?$(CRV(B) ; KS0-C-5256
(ucs-set-char #xF943 ?$(CRW(B) ; KS0-C-5257
(ucs-set-char #xF944 ?$(CRY(B) ; KS0-C-5259
(ucs-set-char #xF945 ?$(CRZ(B) ; KS0-C-525A
(ucs-set-char #xF946 ?$(CR^(B) ; KS0-C-525E
(ucs-set-char #xF947 ?$(CR_(B) ; KS0-C-525F
(ucs-set-char #xF948 ?$(CRa(B) ; KS0-C-5261
(ucs-set-char #xF949 ?$(CRb(B) ; KS0-C-5262
(ucs-set-char #xF94A ?$(CRd(B) ; KS0-C-5264
(ucs-set-char #xF94B ?$(CRe(B) ; KS0-C-5265
(ucs-set-char #xF94C ?$(CRf(B) ; KS0-C-5266
(ucs-set-char #xF94D ?$(CRg(B) ; KS0-C-5267
(ucs-set-char #xF94E ?$(CRh(B) ; KS0-C-5268
(ucs-set-char #xF94F ?$(CRi(B) ; KS0-C-5269
(ucs-set-char #xF950 ?$(CRj(B) ; KS0-C-526A
(ucs-set-char #xF951 ?$(CRk(B) ; KS0-C-526B
(ucs-set-char #xF952 ?$(CRp(B) ; KS0-C-5270
(ucs-set-char #xF953 ?$(CRq(B) ; KS0-C-5271
(ucs-set-char #xF954 ?$(CRr(B) ; KS0-C-5272
(ucs-set-char #xF955 ?$(CRs(B) ; KS0-C-5273
(ucs-set-char #xF956 ?$(CRt(B) ; KS0-C-5274
(ucs-set-char #xF957 ?$(CRu(B) ; KS0-C-5275
(ucs-set-char #xF958 ?$(CRw(B) ; KS0-C-5277
(ucs-set-char #xF959 ?$(CRx(B) ; KS0-C-5278
(ucs-set-char #xF95A ?$(CTf(B) ; KS0-C-5466
(ucs-set-char #xF95B ?$(CT|(B) ; KS0-C-547C
(ucs-set-char #xF95C ?$(CU%(B) ; KS0-C-5525
(ucs-set-char #xF95D ?$(CU+(B) ; KS0-C-552B
(ucs-set-char #xF95E ?$(CU.(B) ; KS0-C-552E
(ucs-set-char #xF95F ?$(CV8(B) ; KS0-C-5638
(ucs-set-char #xF960 ?$(CVM(B) ; KS0-C-564D
(ucs-set-char #xF961 ?$(CWK(B) ; KS0-C-574B
(ucs-set-char #xF962 ?$(CWd(B) ; KS0-C-5764
(ucs-set-char #xF963 ?$(C[E(B) ; KS0-C-5B45
(ucs-set-char #xF964 ?$(C[d(B) ; KS0-C-5B64
(ucs-set-char #xF965 ?$(C\%(B) ; KS0-C-5C25
(ucs-set-char #xF966 ?$(C]%(B) ; KS0-C-5D25
(ucs-set-char #xF967 ?$(C]U(B) ; KS0-C-5D55
(ucs-set-char #xF968 ?$(C]t(B) ; KS0-C-5D74
(ucs-set-char #xF969 ?$(C^|(B) ; KS0-C-5E7C
(ucs-set-char #xF96A ?$(C^~(B) ; KS0-C-5E7E
(ucs-set-char #xF96B ?$(C_3(B) ; KS0-C-5F33
(ucs-set-char #xF96C ?$(C_a(B) ; KS0-C-5F61
(ucs-set-char #xF96D ?$(C_h(B) ; KS0-C-5F68
(ucs-set-char #xF96E ?$(C`q(B) ; KS0-C-6071
(ucs-set-char #xF96F ?$(Ca-(B) ; KS0-C-612D
(ucs-set-char #xF970 ?$(Cam(B) ; KS0-C-616D
(ucs-set-char #xF971 ?$(Ccu(B) ; KS0-C-6375
(ucs-set-char #xF972 ?$(Cd!(B) ; KS0-C-6421
(ucs-set-char #xF973 ?$(Cd)(B) ; KS0-C-6429
(ucs-set-char #xF974 ?$(Ce.(B) ; KS0-C-652E
(ucs-set-char #xF975 ?$(Ce1(B) ; KS0-C-6531
(ucs-set-char #xF976 ?$(Ce2(B) ; KS0-C-6532
(ucs-set-char #xF977 ?$(Ce9(B) ; KS0-C-6539
(ucs-set-char #xF978 ?$(Ce;(B) ; KS0-C-653B
(ucs-set-char #xF979 ?$(Ce<(B) ; KS0-C-653C
(ucs-set-char #xF97A ?$(CeD(B) ; KS0-C-6544
(ucs-set-char #xF97B ?$(CeN(B) ; KS0-C-654E
(ucs-set-char #xF97C ?$(CeP(B) ; KS0-C-6550
(ucs-set-char #xF97D ?$(CeR(B) ; KS0-C-6552
(ucs-set-char #xF97E ?$(CeV(B) ; KS0-C-6556
(ucs-set-char #xF97F ?$(Cez(B) ; KS0-C-657A
(ucs-set-char #xF980 ?$(Ce{(B) ; KS0-C-657B
(ucs-set-char #xF981 ?$(Ce|(B) ; KS0-C-657C
(ucs-set-char #xF982 ?$(Ce~(B) ; KS0-C-657E
(ucs-set-char #xF983 ?$(Cf!(B) ; KS0-C-6621
(ucs-set-char #xF984 ?$(Cf$(B) ; KS0-C-6624
(ucs-set-char #xF985 ?$(Cf'(B) ; KS0-C-6627
(ucs-set-char #xF986 ?$(Cf-(B) ; KS0-C-662D
(ucs-set-char #xF987 ?$(Cf/(B) ; KS0-C-662F
(ucs-set-char #xF988 ?$(Cf0(B) ; KS0-C-6630
(ucs-set-char #xF989 ?$(Cf1(B) ; KS0-C-6631
(ucs-set-char #xF98A ?$(Cf3(B) ; KS0-C-6633
(ucs-set-char #xF98B ?$(Cf7(B) ; KS0-C-6637
(ucs-set-char #xF98C ?$(Cf8(B) ; KS0-C-6638
(ucs-set-char #xF98D ?$(Cf<(B) ; KS0-C-663C
(ucs-set-char #xF98E ?$(CfD(B) ; KS0-C-6644
(ucs-set-char #xF98F ?$(CfF(B) ; KS0-C-6646
(ucs-set-char #xF990 ?$(CfG(B) ; KS0-C-6647
(ucs-set-char #xF991 ?$(CfJ(B) ; KS0-C-664A
(ucs-set-char #xF992 ?$(CfR(B) ; KS0-C-6652
(ucs-set-char #xF993 ?$(CfV(B) ; KS0-C-6656
(ucs-set-char #xF994 ?$(CfY(B) ; KS0-C-6659
(ucs-set-char #xF995 ?$(Cf\(B) ; KS0-C-665C
(ucs-set-char #xF996 ?$(Cf_(B) ; KS0-C-665F
(ucs-set-char #xF997 ?$(Cfa(B) ; KS0-C-6661
(ucs-set-char #xF998 ?$(Cfd(B) ; KS0-C-6664
(ucs-set-char #xF999 ?$(Cfe(B) ; KS0-C-6665
(ucs-set-char #xF99A ?$(Cff(B) ; KS0-C-6666
(ucs-set-char #xF99B ?$(Cfh(B) ; KS0-C-6668
(ucs-set-char #xF99C ?$(Cfj(B) ; KS0-C-666A
(ucs-set-char #xF99D ?$(Cfk(B) ; KS0-C-666B
(ucs-set-char #xF99E ?$(Cfl(B) ; KS0-C-666C
(ucs-set-char #xF99F ?$(Cfo(B) ; KS0-C-666F
(ucs-set-char #xF9A0 ?$(Cfq(B) ; KS0-C-6671
(ucs-set-char #xF9A1 ?$(Cfr(B) ; KS0-C-6672
(ucs-set-char #xF9A2 ?$(Cfu(B) ; KS0-C-6675
(ucs-set-char #xF9A3 ?$(Cfv(B) ; KS0-C-6676
(ucs-set-char #xF9A4 ?$(Cfw(B) ; KS0-C-6677
(ucs-set-char #xF9A5 ?$(Cfy(B) ; KS0-C-6679
(ucs-set-char #xF9A6 ?$(Cg!(B) ; KS0-C-6721
(ucs-set-char #xF9A7 ?$(Cg&(B) ; KS0-C-6726
(ucs-set-char #xF9A8 ?$(Cg)(B) ; KS0-C-6729
(ucs-set-char #xF9A9 ?$(Cg*(B) ; KS0-C-672A
(ucs-set-char #xF9AA ?$(Cg,(B) ; KS0-C-672C
(ucs-set-char #xF9AB ?$(Cg-(B) ; KS0-C-672D
(ucs-set-char #xF9AC ?$(Cg0(B) ; KS0-C-6730
(ucs-set-char #xF9AD ?$(Cg?(B) ; KS0-C-673F
(ucs-set-char #xF9AE ?$(CgA(B) ; KS0-C-6741
(ucs-set-char #xF9AF ?$(CgF(B) ; KS0-C-6746
(ucs-set-char #xF9B0 ?$(CgG(B) ; KS0-C-6747
(ucs-set-char #xF9B1 ?$(CgK(B) ; KS0-C-674B
(ucs-set-char #xF9B2 ?$(CgM(B) ; KS0-C-674D
(ucs-set-char #xF9B3 ?$(CgO(B) ; KS0-C-674F
(ucs-set-char #xF9B4 ?$(CgP(B) ; KS0-C-6750
(ucs-set-char #xF9B5 ?$(CgS(B) ; KS0-C-6753
(ucs-set-char #xF9B6 ?$(Cg_(B) ; KS0-C-675F
(ucs-set-char #xF9B7 ?$(Cgd(B) ; KS0-C-6764
(ucs-set-char #xF9B8 ?$(Cgf(B) ; KS0-C-6766
(ucs-set-char #xF9B9 ?$(Cgw(B) ; KS0-C-6777
(ucs-set-char #xF9BA ?$(Chg(B) ; KS0-C-6867
(ucs-set-char #xF9BB ?$(Chh(B) ; KS0-C-6868
(ucs-set-char #xF9BC ?$(Chp(B) ; KS0-C-6870
(ucs-set-char #xF9BD ?$(Chq(B) ; KS0-C-6871
(ucs-set-char #xF9BE ?$(Chw(B) ; KS0-C-6877
(ucs-set-char #xF9BF ?$(Chy(B) ; KS0-C-6879
(ucs-set-char #xF9C0 ?$(Ch{(B) ; KS0-C-687B
(ucs-set-char #xF9C1 ?$(Ch~(B) ; KS0-C-687E
(ucs-set-char #xF9C2 ?$(Ci'(B) ; KS0-C-6927
(ucs-set-char #xF9C3 ?$(Ci,(B) ; KS0-C-692C
(ucs-set-char #xF9C4 ?$(CiL(B) ; KS0-C-694C
(ucs-set-char #xF9C5 ?$(Ciw(B) ; KS0-C-6977
(ucs-set-char #xF9C6 ?$(CjA(B) ; KS0-C-6A41
(ucs-set-char #xF9C7 ?$(Cje(B) ; KS0-C-6A65
(ucs-set-char #xF9C8 ?$(Cjt(B) ; KS0-C-6A74
(ucs-set-char #xF9C9 ?$(Cjw(B) ; KS0-C-6A77
(ucs-set-char #xF9CA ?$(Cj|(B) ; KS0-C-6A7C
(ucs-set-char #xF9CB ?$(Cj~(B) ; KS0-C-6A7E
(ucs-set-char #xF9CC ?$(Ck$(B) ; KS0-C-6B24
(ucs-set-char #xF9CD ?$(Ck'(B) ; KS0-C-6B27
(ucs-set-char #xF9CE ?$(Ck)(B) ; KS0-C-6B29
(ucs-set-char #xF9CF ?$(Ck*(B) ; KS0-C-6B2A
(ucs-set-char #xF9D0 ?$(Ck:(B) ; KS0-C-6B3A
(ucs-set-char #xF9D1 ?$(Ck;(B) ; KS0-C-6B3B
(ucs-set-char #xF9D2 ?$(Ck=(B) ; KS0-C-6B3D
(ucs-set-char #xF9D3 ?$(CkA(B) ; KS0-C-6B41
(ucs-set-char #xF9D4 ?$(CkB(B) ; KS0-C-6B42
(ucs-set-char #xF9D5 ?$(CkF(B) ; KS0-C-6B46
(ucs-set-char #xF9D6 ?$(CkG(B) ; KS0-C-6B47
(ucs-set-char #xF9D7 ?$(CkL(B) ; KS0-C-6B4C
(ucs-set-char #xF9D8 ?$(CkO(B) ; KS0-C-6B4F
(ucs-set-char #xF9D9 ?$(CkP(B) ; KS0-C-6B50
(ucs-set-char #xF9DA ?$(CkQ(B) ; KS0-C-6B51
(ucs-set-char #xF9DB ?$(CkR(B) ; KS0-C-6B52
(ucs-set-char #xF9DC ?$(CkX(B) ; KS0-C-6B58
(ucs-set-char #xF9DD ?$(Cl&(B) ; KS0-C-6C26
(ucs-set-char #xF9DE ?$(Cl'(B) ; KS0-C-6C27
(ucs-set-char #xF9DF ?$(Cl*(B) ; KS0-C-6C2A
(ucs-set-char #xF9E0 ?$(Cl/(B) ; KS0-C-6C2F
(ucs-set-char #xF9E1 ?$(Cl0(B) ; KS0-C-6C30
(ucs-set-char #xF9E2 ?$(Cl1(B) ; KS0-C-6C31
(ucs-set-char #xF9E3 ?$(Cl2(B) ; KS0-C-6C32
(ucs-set-char #xF9E4 ?$(Cl5(B) ; KS0-C-6C35
(ucs-set-char #xF9E5 ?$(Cl8(B) ; KS0-C-6C38
(ucs-set-char #xF9E6 ?$(Cl:(B) ; KS0-C-6C3A
(ucs-set-char #xF9E7 ?$(Cl@(B) ; KS0-C-6C40
(ucs-set-char #xF9E8 ?$(ClA(B) ; KS0-C-6C41
(ucs-set-char #xF9E9 ?$(ClE(B) ; KS0-C-6C45
(ucs-set-char #xF9EA ?$(ClF(B) ; KS0-C-6C46
(ucs-set-char #xF9EB ?$(ClI(B) ; KS0-C-6C49
(ucs-set-char #xF9EC ?$(ClJ(B) ; KS0-C-6C4A
(ucs-set-char #xF9ED ?$(ClU(B) ; KS0-C-6C55
(ucs-set-char #xF9EE ?$(Cl](B) ; KS0-C-6C5D
(ucs-set-char #xF9EF ?$(Cl^(B) ; KS0-C-6C5E
(ucs-set-char #xF9F0 ?$(Cla(B) ; KS0-C-6C61
(ucs-set-char #xF9F1 ?$(Cld(B) ; KS0-C-6C64
(ucs-set-char #xF9F2 ?$(Clg(B) ; KS0-C-6C67
(ucs-set-char #xF9F3 ?$(Clh(B) ; KS0-C-6C68
(ucs-set-char #xF9F4 ?$(Clw(B) ; KS0-C-6C77
(ucs-set-char #xF9F5 ?$(Clx(B) ; KS0-C-6C78
(ucs-set-char #xF9F6 ?$(Clz(B) ; KS0-C-6C7A
(ucs-set-char #xF9F7 ?$(Cm!(B) ; KS0-C-6D21
(ucs-set-char #xF9F8 ?$(Cm"(B) ; KS0-C-6D22
(ucs-set-char #xF9F9 ?$(Cm#(B) ; KS0-C-6D23
(ucs-set-char #xF9FA ?$(Cmn(B) ; KS0-C-6D6E
(ucs-set-char #xF9FB ?$(Cn[(B) ; KS0-C-6E5B
(ucs-set-char #xF9FC ?$(Cr=(B) ; KS0-C-723D
(ucs-set-char #xF9FD ?$(Crz(B) ; KS0-C-727A
(ucs-set-char #xF9FE ?$(Cs1(B) ; KS0-C-7331
(ucs-set-char #xF9FF ?$(Ct'(B) ; KS0-C-7427
(ucs-set-char #xFA00 ?$(Ctn(B) ; KS0-C-746E
(ucs-set-char #xFA01 ?$(Cvt(B) ; KS0-C-7674
(ucs-set-char #xFA02 ?$(Cvv(B) ; KS0-C-7676
(ucs-set-char #xFA03 ?$(Cw8(B) ; KS0-C-7738
(ucs-set-char #xFA04 ?$(CwH(B) ; KS0-C-7748
(ucs-set-char #xFA05 ?$(CwS(B) ; KS0-C-7753
(ucs-set-char #xFA06 ?$(Cx[(B) ; KS0-C-785B
(ucs-set-char #xFA07 ?$(Cxp(B) ; KS0-C-7870
(ucs-set-char #xFA08 ?$(Cz!(B) ; KS0-C-7A21
(ucs-set-char #xFA09 ?$(Cz"(B) ; KS0-C-7A22
(ucs-set-char #xFA0A ?$(Czf(B) ; KS0-C-7A66
(ucs-set-char #xFA0B ?$(C|)(B) ; KS0-C-7C29

;;; uni-cjk-c-ideo.el ends here
