;;; footnote-han.el --- Han Japanese footnote support

;; Copyright (C) 1997 by Free Software Foundation, Inc.

;; Author: Steven L Baur <steve@xemacs.org>
;; Keywords: mail, news, mule
;; Version: 0.17

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;; $B?t(B $BJQ$($k(B

;;; Change Log:

;; Apr-18-1997:	Added regexp to the footnote style alist.
;; Sep-30-1997: See ChangeLog file.

;;; Code:

(require 'footnote)

(defconst footnote-han-digits "$B0lFs;0;M8^O;<7H,6e(B"
  "$B7e(B")

(defconst footnote-han-digits-regexp
  (concat "[" footnote-han-digits "$B==(B" "]"))

(defun Footnote-han (n)
  "$B$+$($k(B $B$K(B $BF|K\8l(B."
  (cond ((<= n 9)
	 (char-to-string (aref footnote-han-digits (1- n))))
	((= n 10)
	 "$B==(B")
	((<= n 19)
	 (concat "$B==(B" (char-to-string (aref footnote-han-digits
					    (1- (mod n 10))))))
	(t
	 (concat
	  (char-to-string (aref footnote-han-digits (1- (/ n 10))))
	  "$B==(B"
	  (unless (= (mod n 10) 0)
	    (char-to-string (aref footnote-han-digits
				  (1- (mod n 10)))))))))

(setq footnote-style-alist
      (append (list `(han
		      Footnote-han
		      ,footnote-han-digits-regexp)) footnote-style-alist))

(provide 'footnote-han)

;;; footnote-han.el ends here
