;;; tex-site.el - Site specific variables.  Don't edit.

;; Copyright (C) 1991, 2000, 2001 Kresten Krab Thorup
;; Copyright (C) 1993, 1994, 1997, 1999,
;;               2003, 2004 Free Software Foundation, Inc.

;; Author: Per Abrahamsen <abraham@dina.kvl.dk>
;; Maintainer: auc-tex@sunsite.dk
;; Keywords: tex

;; This file is part of AUCTeX.

;; AUCTeX is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; AUCTeX is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with AUCTeX; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Commentary:

;; This file used to contain variables customized for the local site.
;; This way of customizing AUCTeX should no longer be used.  All
;; relevant variables can be customized by using
;; M-x customize-variable RET
;; on them.  Copying stuff into this file, as was recommended
;; previously, would interfere with the operation of customize.
;;
;; Basically, this file contains a bunch of autoloads and
;; automatically generated information.  AUCTeX is enabled by placing
;; (require 'tex-site)
;; into a user's .emacs file, or the administrator can insert it in
;; the site-start.el file for a site-wide default.
;;
;; The right place for this file is in the `site-lisp' directory.

;;; Code:

(if (< emacs-major-version 21)
  (error "AUCTeX requires Emacs 21 or later"))

(defvar no-doc
  "This function is part of AUCTeX, but has not yet been loaded.
Full documentation will be available after autoloading the function."
  "Documentation for autoload functions.")


;;<--- [HERE BEGINS A CHANGE] Sep  6, 2004 20:44: suggestion by SY
(defcustom TeX-auto-global (file-name-as-directory
			    (expand-file-name "auto"
					      (locate-data-directory "auctex")))
  "*Directory containing automatically generated information.
Must end with a directory separator.
 
For storing automatic extracted information about the TeX macros
shared by all users of a site."
  :group 'TeX-file
  :type 'directory)

(defcustom TeX-macro-global nil 
  "*The path to your global system wide TeX macro files.

The directory names *must* end with a slash.  If have system
administration rights, you open tex-site.el via the find-library
command in order to set the variable.  Otherwise set it in the
normal way via the custom interface.

A typical value could be:

  '\(\"/usr/share/texmf/tex/\"
    \"/usr/share/texmf/bibtex/bst/\"\)

You can possibly find these TeX directories on a GNU/Linux system
with the command:

  kpsewhich --progname latex --expand-braces $TEXMFLOCAL

Or:

  kpsewhich --progname latex --expand-braces $TEXMFCNF

Note that you may not need to set `TeX-macro-global' to anything and
the default value of nil may be the correct setting for you.

If you don't have administration rights contact your system
administrator.  If you are on MS Windows, look for the documentation
of your tex system, such as MikTex."
  :group 'TeX-file
  :type '(repeat (directory :format "%v")))

;; Inform the user if `TeX-macro-global' isn't set and it is likely
;; that it needs to be.
(eval-after-load "tex"
  '(if (and (not TeX-macro-global)
	    (or (getenv "TEXMFCNF")
		(getenv "TEXMFLOCAL")))
       (progn
	 (message "`TeX-macro-global' may not be set correctly.")
	 (sit-for 3)
	 (message "See `C-h v TeX-macro-global' for further information.")
	 (sit-for 3))))


;;; Autoloads:

;;;###autoload(add-to-list 'auto-mode-alist '("\\.dtx\\'" . doctex-mode))
;;;###autoload(add-to-list 'auto-mode-alist '("\\.drv\\'" . latex-mode))

;; This hook will store bibitems when you save a BibTeX buffer.
(add-hook 'bibtex-mode-hook 'BibTeX-auto-store)

(autoload 'tex-mode "tex" no-doc t)
(autoload 'plain-tex-mode "tex" no-doc t)
(autoload 'context-mode "context" no-doc t)
(autoload 'doctex-mode "latex" no-doc t)
(autoload 'texinfo-mode "tex-info" no-doc t)
(autoload 'latex-mode "latex" no-doc t)

(provide 'tex-site)

;;; tex-site.el ends here
