/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ASTAmbiguousName;
import bsh.ASTArguments;
import bsh.ASTArrayDimensions;
import bsh.ASTPrimitiveType;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

public class ASTAllocationExpression
extends SimpleNode {
    ASTAllocationExpression(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        SimpleNode simpleNode2 = (SimpleNode)this.jjtGetChild(1);
        if (simpleNode instanceof ASTAmbiguousName) {
            ASTAmbiguousName aSTAmbiguousName = (ASTAmbiguousName)simpleNode;
            if (simpleNode2 instanceof ASTArguments) {
                return this.objectAllocation(aSTAmbiguousName, (ASTArguments)simpleNode2, nameSpace, interpreter);
            }
            return this.objectArrayAllocation(aSTAmbiguousName, (ASTArrayDimensions)simpleNode2, nameSpace, interpreter);
        }
        return this.primitiveArrayAllocation((ASTPrimitiveType)simpleNode, (ASTArrayDimensions)simpleNode2, nameSpace, interpreter);
    }

    private Object objectAllocation(ASTAmbiguousName aSTAmbiguousName, ASTArguments aSTArguments, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Class clazz = aSTAmbiguousName.toClass(nameSpace);
        if (clazz == null) {
            throw new EvalError("Class " + aSTAmbiguousName.getName(nameSpace) + " not found.", this);
        }
        Object[] objectArray = aSTArguments.getArguments(nameSpace, interpreter);
        if (objectArray == null) {
            throw new EvalError("Trying to new a class...?", this);
        }
        try {
            return Reflect.constructObject(clazz, objectArray);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Constructor error: " + reflectError.getMessage(), this);
        }
        catch (InvocationTargetException invocationTargetException) {
            Interpreter.debug("The constructor threw an exception:\n\t" + invocationTargetException.getTargetException());
            throw new TargetError(invocationTargetException.getTargetException());
        }
    }

    private Object objectArrayAllocation(ASTAmbiguousName aSTAmbiguousName, ASTArrayDimensions aSTArrayDimensions, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Class clazz = aSTAmbiguousName.toClass(nameSpace);
        if (clazz == null) {
            throw new EvalError("Class " + aSTAmbiguousName.getName(nameSpace) + " not found.", this);
        }
        Object object = aSTArrayDimensions.eval(clazz, nameSpace, interpreter);
        if (object != Primitive.VOID) {
            return object;
        }
        try {
            return Array.newInstance(clazz, aSTArrayDimensions.dimensions);
        }
        catch (Exception exception) {
            throw new EvalError("Can't construct array: " + exception.getMessage(), this);
        }
    }

    private Object primitiveArrayAllocation(ASTPrimitiveType aSTPrimitiveType, ASTArrayDimensions aSTArrayDimensions, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Class clazz = aSTPrimitiveType.getType();
        Object object = aSTArrayDimensions.eval(clazz, nameSpace, interpreter);
        if (object != Primitive.VOID) {
            return object;
        }
        try {
            return Array.newInstance(clazz, aSTArrayDimensions.dimensions);
        }
        catch (Exception exception) {
            throw new EvalError("Can't construct primitive array: " + exception.getMessage(), this);
        }
    }
}

