/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jde.wizards.DefaultNameFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.NotAnInterfaceException;
import jde.wizards.Signature;

public class InterfaceFactory
extends MethodFactory {
    static InterfaceFactory interfaceFactory;
    private Hashtable interfaces = new Hashtable();

    private final void sortByDeclaringClass(Signature signature) {
        String string = signature.getDeclaringClass().getName();
        if (this.interfaces.containsKey(string)) {
            Vector vector = (Vector)this.interfaces.get(string);
            if (!vector.contains(signature)) {
                vector.addElement(signature);
            }
        } else {
            Vector<Signature> vector = new Vector<Signature>();
            vector.addElement(signature);
            this.interfaces.put(string, vector);
        }
    }

    public void flush() {
        super.flush();
        this.interfaces.clear();
    }

    public void process(String string) throws ClassNotFoundException, NotAnInterfaceException {
        this.process(string, true);
    }

    public void process(String string, boolean bl) throws ClassNotFoundException, NotAnInterfaceException {
        Class<?> clazz;
        if (this.namefactory == null) {
            this.namefactory = new DefaultNameFactory();
        }
        if (!(clazz = Class.forName(string)).isInterface()) {
            throw new NotAnInterfaceException(string);
        }
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            this.sortByDeclaringClass(new Signature(methodArray[n], this, bl));
            ++n;
        }
    }

    public static void makeInterface(String string, boolean bl, boolean bl2, boolean bl3) {
        if (interfaceFactory == null) {
            interfaceFactory = new InterfaceFactory();
        }
        interfaceFactory.flush();
        interfaceFactory.makeInterfaceInternal(string, bl, bl2, bl3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void makeInterfaceInternal(String string, boolean bl, boolean bl2, boolean bl3) {
        try {
            this.process(string, bl2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MethodFactory.println("(error \"Error: could not find interface named: " + string + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (NotAnInterfaceException notAnInterfaceException) {
            MethodFactory.println("(error \"Error: " + string + " is not an interface.\")");
            return;
        }
        catch (Exception exception) {
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.dump(new PrintWriter(System.out, true), bl, bl2, bl3);
    }

    public static void getImportedClasses() {
        String string = "(list ";
        Enumeration enumeration = InterfaceFactory.interfaceFactory.imports.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            string = string + "\"" + clazz.getName() + "\" ";
        }
        string = string + ")";
        MethodFactory.println(string);
    }

    public void dump(PrintWriter printWriter, boolean bl, boolean bl2, boolean bl3) {
        String string = "";
        Enumeration enumeration = this.interfaces.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)this.interfaces.get(string2);
            string = "\"// implementation of " + string2 + " interface\n";
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Signature signature = (Signature)enumeration2.nextElement();
                String string3 = "  // TODO: implement this " + string2 + " method\n";
                string = string + this.getMethodSkeleton(signature, bl, bl3, string3);
            }
        }
        string = string + "\"";
        MethodFactory.println(string);
    }

    public InterfaceFactory() {
    }

    public InterfaceFactory(NameFactory nameFactory) {
        super(nameFactory);
    }
}

