/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractImportCheck;

public class IllegalImportCheck
extends AbstractImportCheck {
    private String[] mIllegalPkgs;

    public IllegalImportCheck() {
        this.setIllegalPkgs(new String[]{"sun"});
    }

    public void setIllegalPkgs(String[] aFrom) {
        this.mIllegalPkgs = aFrom;
    }

    public int[] getDefaultTokens() {
        return new int[]{30};
    }

    public void visitToken(DetailAST aAST) {
        FullIdent imp = this.getImportText(aAST);
        if (this.isIllegalImport(imp.getText())) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.illegal", (Object)imp.getText());
        }
    }

    private boolean isIllegalImport(String aImportText) {
        int i = 0;
        while (i < this.mIllegalPkgs.length) {
            if (aImportText.startsWith(this.mIllegalPkgs[i] + ".")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

