/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JdeUtilities {
    public static Vector CLASS_LIST = new Vector(500);

    public static void buildClassList() {
        String string = System.getProperty("java.class.path");
        String string2 = File.pathSeparator;
        String string3 = System.getProperty("sun.boot.class.path");
        if (string3 != null) {
            string = string + string2 + string3;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            File file = new File(string4);
            if (!file.exists()) continue;
            if (string4.toLowerCase().endsWith(".jar")) {
                JdeUtilities.addClassesFromZip(CLASS_LIST, file);
                continue;
            }
            if (string4.toLowerCase().endsWith(".zip")) {
                JdeUtilities.addClassesFromZip(CLASS_LIST, file);
                continue;
            }
            if (!file.isDirectory()) continue;
            JdeUtilities.addClassesFromDir(CLASS_LIST, file, file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addClassesFromZip(Vector vector, File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (!string.toLowerCase().endsWith(".class")) continue;
                string = string.substring(0, string.length() - 6);
                string = string.replace('/', '.');
                string = string.replace('\\', '.');
                vector.addElement(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Problem opening " + file + " with zip.");
        }
    }

    public static void addClassesFromDir(Vector vector, File file, File file2) {
        String[] stringArray = file2.list();
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            String string = stringArray[n];
            if (string.toLowerCase().endsWith(".class")) {
                string = string.substring(0, string.length() - 6);
                object = file.getPath();
                String string2 = file2.getPath();
                if (string2.indexOf((String)object) != 0) {
                    System.err.println("currentPath doesn't start with rootPath!\n" + "rootPath: " + (String)object + "\n" + "currentPath: " + string2 + "\n");
                } else {
                    String string3 = string2.substring(((String)object).length());
                    if (string3.length() > 0) {
                        string3 = string3.replace('\\', '.');
                        string3 = string3.replace('/', '.');
                        vector.addElement(string3.substring(1) + '.' + string);
                    } else {
                        vector.addElement(string);
                    }
                }
            } else {
                object = new File(file2, string);
                if (((File)object).isDirectory()) {
                    JdeUtilities.addClassesFromDir(vector, file, (File)object);
                }
            }
            ++n;
        }
    }

    public static void getQualifiedName(String string) {
        String string2 = "(list";
        int n = 0;
        while (n < CLASS_LIST.size()) {
            String string3 = (String)CLASS_LIST.elementAt(n);
            if ((string3.length() > string.length() && string3.endsWith(string) && string3.charAt(string3.length() - string.length() - 1) == '.' || string3.length() == string.length() && string3.equals(string)) && string2.indexOf(string3 = " \"" + string3 + "\"") == -1) {
                string2 = string2 + string3;
            }
            ++n;
        }
        string2 = string2 + ")";
        System.out.println(string2);
        System.out.flush();
    }

    static {
        JdeUtilities.buildClassList();
    }
}

