/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#include <config.h>

#ifdef HAVE_LIBX11

/* This file has all the drawing routines */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>

#include <stdio.h>
#ifdef HAVE_STRING_H
# include <string.h>
#else
# include <strings.h>
#endif
#include <stdlib.h>

#include "xwin.h"
#include "xinit.h"
#include "map.h"

extern Display *display;
extern XrmDatabase DB;
extern XColor *player_col, *occupied_col, *misc_col;
extern int screen_num;

extern Window main_win;
extern Window but_win[NBUTS];
extern Window map_win;
extern Window turn_win;

extern GC mapgc, capitalgc, crossgc, turngc;
extern Pixmap *att_pix, def_pix, gue_pix;
extern Pixmap d_att_pix, d_def_pix, d_gue_pix;

static void update_borders (void);
static int set_fill_color (map_val);
static void draw_map_function (Coord, Coord);

static void
update_borders ()
{
  static unsigned char last_sel = 0;
  if (last_sel != game_map.sel_mode)
    {
      switch (last_sel)
	{
	case MODE_ATT:
	  XSetWindowBorderWidth (display, but_win[ATT], 1);
	  break;
	case MODE_DEF:
	  XSetWindowBorderWidth (display, but_win[DEF], 1);
	  break;
	case MODE_GUE:
	  XSetWindowBorderWidth (display, but_win[GUE], 1);
	  break;
	}
      switch (game_map.sel_mode)
	{
	case MODE_ATT:
	  XSetWindowBorderWidth (display, but_win[ATT],
				 db_val_tab.sel_width);
	  break;
	case MODE_DEF:
	  XSetWindowBorderWidth (display, but_win[DEF],
				 db_val_tab.sel_width);
	  break;
	case MODE_GUE:
	  XSetWindowBorderWidth (display, but_win[GUE],
				 db_val_tab.sel_width);
	  break;
	}
      last_sel = game_map.sel_mode;
    }
}

extern void
update_buttons (uses_def_mode)
     const int uses_def_mode;
{
  char update;
  update = need_update ();
  if (uses_def_mode)
    update_borders ();

  if (update & MODE_ATT)
    {
      if (game_map.modes & MODE_ATT)
#ifdef __GNUC__		/* Work around a bug in gcc.  */
	XSetWindowBackgroundPixmap (display, but_win[ATT],
				    *(&att_pix+(5 - game_map.n_att)));
#else
        XSetWindowBackgroundPixmap (display, but_win[ATT],
				    att_pix[5 - game_map.n_att]);
#endif /* __GNUC__ */
      else
	XSetWindowBackgroundPixmap (display, but_win[ATT], d_att_pix);
      XClearWindow (display, but_win[ATT]);
    }

  if (update & MODE_DEF)
    {
      if (game_map.modes & MODE_DEF)
	XSetWindowBackgroundPixmap (display, but_win[DEF], def_pix);
      else
	XSetWindowBackgroundPixmap (display, but_win[DEF], d_def_pix);
      XClearWindow (display, but_win[DEF]);
    }

  if (update & MODE_GUE)
    {
      if (game_map.modes & MODE_GUE)
	XSetWindowBackgroundPixmap (display, but_win[GUE], gue_pix);
      else
	XSetWindowBackgroundPixmap (display, but_win[GUE], d_gue_pix);
      XClearWindow (display, but_win[GUE]);
    }
}

extern void
update_cross_win (new_turn)
     int new_turn;
{
  char symbol_n;
  const char *turn_num[] = {"6", "5", "4", "3", "2", "1", "0", "*"};
  if (new_turn)
    {
      XSetBackground (display, turngc,
		      occupied_col[game_map.turn-1].pixel);
      XSetWindowBackground (display, turn_win,
			    player_col[game_map.turn-1].pixel);
    }
  if (!(game_map.modes & MODE_ATT))
    symbol_n = 7;
  else
    symbol_n = game_map.n_cross;

  XClearWindow (display, turn_win);
  XDrawImageString (display, turn_win, turngc,
		    turnwin_num_base[symbol_n].x,
		    turnwin_num_base[symbol_n].y, turn_num[symbol_n],
		    1);
}

/* TODO: map background should be defined as none instead of the sea
   color, since it's all anyway overdrawn.  Somehow drawing to the map
   with sea color crashes the program.  Weird.  */
static int
set_fill_color (status)
     map_val status;
{
  int color;
  if (status & MASK_OCCUPIED)
    color = occupied_col[(status & MASK_PLAYER)-1].pixel;
  else if(status != SEA_VAL)
    color = player_col[(status & MASK_PLAYER)-1].pixel;
  else
    /* Sea color is the background color.  */
    return 0;
  XSetForeground (display, mapgc, color);
  return 1;
}
  
static void
draw_map_function (loc, dim)
     Coord loc, dim;
{
  Coord offset;
  short basex;

  basex = loc.x;

  if (dim.x == loc.x)
    dim.x++;
  for (offset.y = loc.y; offset.y <= dim.y; offset.y++)
    {
      map_val last_status, status;
      short lastx;
      lastx = basex;
      last_status = get_map_val (loc);

      for (offset.x = loc.x; offset.x <= dim.x; offset.x++)
	{
	  status = get_map_val (offset);
	  if (last_status != status || offset.x == dim.x)
	    {
	      if (set_fill_color (last_status))
		{
		  XFillRectangle (display, map_win, mapgc, lastx *
				  db_val_tab.map_square_size, offset.y
				  * db_val_tab.map_square_size,
				  (offset.x-lastx) *
				  db_val_tab.map_square_size,
				  db_val_tab.map_square_size);

		  if (last_status & MASK_CAPITAL)
		    {
		      XFillRectangle (display, map_win, capitalgc,
				      lastx *
				      db_val_tab.map_square_size,
				      offset.y *
				      db_val_tab.map_square_size,
				      (offset.x-lastx) *
				      db_val_tab.map_square_size,
				      db_val_tab.map_square_size);
		    }
		  if (last_status & MASK_CROSS)
		    {
		      XFillRectangle (display, map_win, crossgc, lastx
				      * db_val_tab.map_square_size,
				      offset.y *
				      db_val_tab.map_square_size,
				      (offset.x-lastx) *
				      db_val_tab.map_square_size,
				      db_val_tab.map_square_size);
		    }
		}
	      lastx = offset.x;
	      last_status = status;
	    }
	}
    }
}

extern void
draw_map (x, y, width, height)
     int x, y, width, height;
{
  Coord loc, dim;

  loc.x = x / db_val_tab.map_square_size;
  loc.y = y / db_val_tab.map_square_size;
  dim.x = (width % db_val_tab.map_square_size ? width /
	   db_val_tab.map_square_size + 1 :
	   width / db_val_tab.map_square_size)+loc.x; 
  dim.y = (height % db_val_tab.map_square_size ? height /
	   db_val_tab.map_square_size + 1 :
	   height / db_val_tab.map_square_size)+loc.y;

  draw_map_function (loc, dim);
}

extern void
draw_effects (map_events)
     Action map_events;
{
  if (map_events.type & EVENT_NEWTURN)
    update_cross_win (1);
  else if (map_events.count != 0)
    update_cross_win (0);

  if ((map_events.type & (EVENT_ENCIRCLEMENT | EVENT_UNOCCUPY |
			  EVENT_DEFEAT | EVENT_REFRESH)) ||
      ((map_events.type & EVENT_ATT) &&
      (map_events.type & EVENT_NEWTURN)))
    {
      Coord top_left = {0, 0}, down_right;
      down_right.x = game_map.width;
      down_right.y = game_map.height;
      draw_map_function (top_left, down_right);
    }
  else
    {
      register int i;
      for (i = 0; i < map_events.count; i++)
	draw_map_function (map_events.loc[i], map_events.loc[i]);
    }
  free (map_events.loc);
}

extern Coord
win_pos2map_coord (x, y)
     int x, y;
{
  Coord ret_coord;
  ret_coord.x = x / db_val_tab.map_square_size;
  ret_coord.y = y / db_val_tab.map_square_size;
  return ret_coord;
}

#endif /* have_libx11 */
