/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "StringMenuDrawable.h"


StringMenuDrawable::StringMenuDrawable(std::vector<BoxElement *> list,std::string title,int startX,int startY,int &screenWidth, int &screenHeight,StringDrawer *drawer):
StringMessageBoxDrawable(list,title, startX, startY, screenWidth,screenHeight,drawer)
{
	setSelected(0);
}

 
StringMenuDrawable::~StringMenuDrawable(void)
{
}

void StringMenuDrawable::draw(){
	drawComplex();
}


void StringMenuDrawable::setSelected(int p){
	selected_=p;
}

int StringMenuDrawable::getSelected(){
	return selected_;
}

void StringMenuDrawable::setTitle(std::string pp){
	actualTitle_=pp;
}
void StringMenuDrawable::setMenuElements(std::vector<BoxElement *> p){
	std::vector<BoxElement *>::iterator itt=stringList_.begin();
	while (itt!=stringList_.end())
	{
		BoxElement *po=*itt;
		stringList_.erase(itt);
		itt=stringList_.begin();
		delete po;

	}
	stringList_=p;
}

const std::vector<BoxElement *> &StringMenuDrawable::getMenuElements(){
	return stringList_;
}
