// Copyright (C) 2000-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

#ifdef	XML_SCRIPTS

URLAudio::URLAudio() :
AudioFile(), URLStream()
{
	offset = 0;
	setProtocol(protocolHttp1_0);
}

URLAudio::~URLAudio()
{
	AudioFile::close();
}

bool URLAudio::afOpen(const char *path)
{
	offset = 0;

	if(!strnicmp(path, "http:", 5))
		setProxy(keyproxy.getHTTPServer(), keyproxy.getHTTPPort());
	else
		setProxy(NULL, 0);

	if(URLStream::errSuccess == get(path, 0))
	{
		file.fd = so;
		return true;
	}
	file.fd = -1;
	return false;
}

bool URLAudio::isOpen(void)
{
	if(so > -1)
		return true;

	return false;
}

bool URLAudio::hasPositioning(void)
{
	if(Socket::state == Socket::STREAM)
		return true;

	return false;
}

unsigned long URLAudio::getTransfered(void)
{
	unsigned long pos;

	if(so < 0)
		return 0;

	if(Socket::state == Socket::STREAM)
		pos = ::lseek(so, 0l, SEEK_CUR) - getHeader();
	else
		pos = offset;

	return toSamples(getEncoding(), pos);
}

bool URLAudio::afPeek(unsigned char *buffer, unsigned len)
{
	int got;
	if(Socket::state == Socket::STREAM)
		got = ::read(so, buffer, len);
	else
		got = ::recv(so, buffer, len, MSG_PEEK | MSG_WAITALL);
	if(got < (int)len)
		return false;
	return true;
}

bool URLAudio::afSeek(unsigned long pos)
{
	char temp[128];
	unsigned len;
	if(Socket::state == Socket::STREAM)
	{
		::lseek(so, pos, SEEK_SET);
		return true;
	}
	if(offset == pos)
		return true;

	if(offset > pos)
		return false;	

	while(offset < pos)
	{
		len = pos - offset;
		if(len < sizeof(temp))
			len = sizeof(temp);
		len = ::recv(so, temp, len, MSG_WAITALL);
		if(len < 1)
			return false;
		offset += len;
	}
	return true;
}

int URLAudio::afRead(unsigned char *buffer, unsigned len)
{
	if(Socket::state == Socket::STREAM)
		len = ::read(so, buffer, len);
	else
		len = ::recv(so, buffer, len, MSG_WAITALL);
	if(len > 0)
		offset += len;
	return len;
}


void URLAudio::afClose(void)
{
	if(file.fd != -1 && file.fd != so)
		::close(file.fd);
	file.fd = -1;
	URLStream::close();
}

#endif

#ifdef	CCXX_NAMESPACES
};
#endif



