/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkitemfactory.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#ifndef GTOOLKIT_GTKITEMFACTORY_H
#define GTOOLKIT_GTKITEMFACTORY_H

#include <GToolKit/GTKObject.h>
#include <gtk/gtkitemfactory.h>

@class GTKAccelGroup;
@class GTKWidget;

typedef struct _GTKItemFactoryEntry GTKItemFactoryEntry;

struct _GTKItemFactoryEntry
{
    GtkItemFactoryEntry item;		// menu item
    SEL selector;			// menu selector
};

@interface GTKItemFactory : GTKObject
+ (GtkType) getType;
+ (id) itemFactoryWithContainerType:(GtkType) container_type path:(NSString *) path accelGroup:(GTKAccelGroup *) accel_group;
- (id) initWithContainerType:(GtkType) container_type path:(NSString *) path accelGroup:(GTKAccelGroup *) accel_group;
+ (void) parseRc:(NSString *) file_name;
+ (void) parseRcString:(NSString *) rc_string;
+ (void) parseRcScanner:(GScanner *) scanner;
+ (void) addForeign:(GTKWidget *) accel_widget fullPath:(NSString *) full_path accelGroup:(GTKAccelGroup *) accel_group keyval:(guint) keyval modifiers:(GdkModifierType) modifiers;
+ (GTKItemFactory*) fromWidget:(GTKWidget *) widget;
+ (NSString *) pathFromWidget:(GTKWidget *) widget;
- (GTKWidget*) getItem:(NSString *) path;
- (GTKWidget*) getWidget:(NSString *) path;
- (GTKWidget*) getWidgetByAction:(guint) action;
- (GTKWidget*) getItemByAction:(guint) action;
+ (void) dumpItems:(GtkPatternSpec *) path_pspec modifiedOnly:(gboolean) modified_only printFunc:(GtkPrintFunc) print_func funcData:(gpointer) func_data;
+ (void) dumpRc:(NSString *) file_name pathPspec:(GtkPatternSpec *) path_pspec modifiedOnly:(gboolean) modified_only;
- (void) createItem:(GtkItemFactoryEntry *) entry callbackData:(gpointer) callback_data callbackType:(guint) callback_type;
- (void) createItems:(guint) n_entries entries:(GtkItemFactoryEntry *) entries callbackData:(gpointer) callback_data;
- (void) deleteItem:(NSString *) path;
- (void) deleteEntry:(GtkItemFactoryEntry *) entry;
- (void) deleteEntries:(guint) n_entries entries:(GtkItemFactoryEntry *) entries;
- (void) popup:(guint) x y:(guint) y mouseButton:(guint) mouse_button time:(guint32) time;
- (void) popupWithData:(gpointer) popup_data destroy:(GtkDestroyNotify) destroy x:(guint) x y:(guint) y mouseButton:(guint) mouse_button time:(guint32) time;
- (gpointer) popupData;
+ (gpointer) popupDataFromWidget:(GTKWidget *) widget;
- (void) setTranslateFunc:(GtkTranslateFunc) func data:(gpointer) data notify:(GtkDestroyNotify) notify;
- (void) createItems:(GTKItemFactoryEntry *) entries count:(guint) count
	 forTarget:(id) target;
- (void) deleteEntries:(GTKItemFactoryEntry *) entries count:(guint) count;
- (GTKAccelGroup *) accelGroup;
@end

#endif /* GTOOLKIT_GTKITEMFACTORY_H */
