/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 2000  Elmar Ludwig - Universitaet Osnabrueck
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GTOOLKIT_GTKGLADEXML_H
#define GTOOLKIT_GTKGLADEXML_H

#include <GToolKit/GTKData.h>

@class NSDictionary;

/*
 * Instead of creating a program's user interface "by hand", this class uses
 * libglade and libxml to load an interface description from a file and build
 * it at runtime. Each GTKGladeXML object represents a single loaded user
 * interface description file (i.e. an XML file created by the Glade interface
 * builder). All signal connections defined in the XML file are automatically
 * established when the file is loaded.<p>
 * Interface files loaded through this class use an extended signal handler
 * syntax (within Glade) that differs slightly from the standard syntax used
 * for C function calls. However, you can still load all standard Glade files
 * by directly calling the C functions in libglade (|glade_xml_new| etc.).
 * In this case, you can create Objective-C wrapper objects using the
 * |GTK_GET_OBJECT| macro.
 */
@interface GTKGladeXML : GTKData

/* selecting the translation domain */
+ (void) setDefaultTranslationDomain:(NSString *) domain;
+ (NSString *) defaultTranslationDomain;

/* loading interface description files */
+ gladeXMLFromFile:(NSString *) file rootObject:(NSString *) root owner:owner;
+ gladeXMLFromFile:(NSString *) file rootObject:(NSString *) root
  nameTable:(NSDictionary *) context;
- initFromFile:(NSString *) file rootObject:(NSString *) root owner:owner;
- initFromFile:(NSString *) file rootObject:(NSString *) root
  nameTable:(NSDictionary *) context;

/* looking up specific widgets */
- (BOOL) resolveReferences:(NSString *) name, ...;
- (GTKWidget *) getWidget:(NSString *) name;
- (GTKWidget *) getWidgetByLongName:(NSString *) name;
@end

#endif
