#!/usr/bin/perl -w # -*- mode: perl -*-


package XML::Handler::EasyTree::Writer;
@ISA=qw(Exporter);
@EXPORT_OK=qw(new
	      write_to_stream);
use strict;
use XML::Handler::EasyTree::WriteVisitor;
use XML::Handler::EasyTree::Traversal;

sub new(){
  my $class = shift;
  my $self = {};
  bless $self, $class;
  $self->initialize(@_);
  return $self;
}

sub initialize(){
  my$self=shift;
}

sub write_to_stream( $$ ){
  my $self=shift;
  
  my $inRoot=shift;
  my $inStream=shift;
  
  $self->{'visitor'}=new XML::Handler::EasyTree::WriteVisitor(outstream=>$inStream);
  my $lTraversal=new XML::Handler::EasyTree::Traversal();
  $lTraversal->traverse($inRoot,
			$self->{'visitor'});
}

