#! /usr/bin/perl -w

use strict;
#use lib ".";
use MRML::Server::Base;
use Getopt::Long;

my $VERSION="0.01";

package MRML::Server::CLIAdapter::Visitor;
require Exporter;
use strict;
use English;
use IO::File;
use vars qw(@ISA @EXPORT_OK);

@ISA= qw(Exporter MRML::Server::Base::Visitor);
@EXPORT_OK= qw(new
	      );

=pod

=head1 NAME

MRML::CLIAdapter::Visitor - a visitor for XML elements

=head1 SYNOPSIS

use MRML::Server::Base;
use MRML::CLIAdapter;
use MRML::CLIAdapter::Visitor;

# Oh gosh this smells dirty programming 

my $l_harness= MRML::CLIAdapter->new();
my $l_visitor= new MRML::CLIAdapter::Visitor(harness => $l_harness,
                                          images => [
                                                     "http://localhost/a.jpg",
                                                     "http://localhost/b.jpg"
                                                    ]);

#
# making and starting the perl based MRML server
#
my $l_server=new MRML::Server::Base(address => "localhost",
				     port    => "10101");
$lServer->serve(VISITOR => $l_visitor);


$lVisitor->start_visit($lDocumentRoot);

$lVisitor->end_visit($lDocumentRoot);

$lVisitor->getResponse();

=head1 DESCRIPTION

This visitor is designed for visiting MRML messages.
After the traversal of a complete query MRML tree you can
get an MRML parse tree from the visitor that contains
the I<response> to the query MRML tree visited.

This class is used by the MRML::Example server class 
for processing MRML messages.

=head1 The node format

The format of the node of an MRML parse tree is I<extremely> simple
compared to other XML representations. A node (==element) is
represented as the reference to a hash, that contains four
hash-elements:

=over 4

=item C<type> 
       either 't'(ext) or 'e'(lement)

=item C<element> 
       contains the name of the XML element

=item C<attrib>
       contains a reference to a hash containing 
       attributes and values of the XML element

=item C<content>
       contains a (possibly empty) list of other such XML elements
       (or the text), if a text node

=back

If you have trouble with the notation, please consult the perlref or
the perlreftut manpage, or in case of need the author of this file.

=head1 Functions:

=cut


sub new(){
  my $class = shift;
  my $self = {};
  bless $self, $class;
  $self->initialize(@_);
  return $self;

  print "NEW VISITOR\n";
}

sub initialize{
    my $self=shift;
    $self->MRML::Server::Base::Visitor::initialize(@_);
}

#
# here we need some URL translation
#
sub do_random_query{
  my $self=shift;

  die unless $self->{harness};

  return($self->{harness}->do_random_query(@_));  
}

#
# here we still need to know the size
#
sub do_query_by_images{
  my $self=shift;

  die unless $self->{harness};

  return($self->{harness}->do_query_by_images(@_));
}

