;; sysvconfig.scm -- Absorb an existing System V Init configuration.
;; Copyright (C) 2002 Wolfgang Jhrling <wolfgang@pro-linux.de>
;;
;; This is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING. If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA  02111-1307, USA.

(use-modules (ice-9 pretty-print))

(define services-dir "/etc/init.d")

;; Return symbolic expressions representing the SysVInit config.
(define (make-config)
  `(register-services
    ,@(init.d-services)))

(define (init.d-services)
  (let ((dir (opendir services-dir)))
    (letrec ((next-entry
	      (lambda (new-entry entries)
		(if (eof-object? new-entry)
		    entries
		    (next-entry (readdir dir)
				(if (member new-entry '("." ".."))
				    entries
				    (cons `(make-init.d-service ,new-entry)
					  entries)))))))
      (next-entry (readdir dir) '()))))

;; The header comment, placing no restrictions on the output.
(display ";; This file was generated by sysvconfig.scm
;; Unlimited permission is granted to distribute and/or modify this
;; file and to place additional restrictions on the further
;; distribution and/or modification.

")

(pretty-print (make-config))
