/*  Qt based GUI for GNU Gama -- adjustment of geodetic networks
    Copyright (C) 2014  Ales Cepek <cepek@gnu.org>

    This file is a part of GNU Gama.

    GNU Gama is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    GNU Gama is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QApplication>
#include <QSettings>
#include "gamaq2controlpanel.h"

int main(int argc, char *argv[])
{
    QCoreApplication::setOrganizationName("GNU Gama");
    QCoreApplication::setOrganizationDomain("gnu.org/software/gama/");
    QCoreApplication::setApplicationName("gama-q2");

    QApplication a(argc, argv);
    // QIcon icon(":/img/q2-icon.png");
    // QIcon icon(":/img/g-icon.png");
    QIcon icon(":/img/g-logo.svg");
    a.setWindowIcon(icon);

    GamaQ2ControlPanel w;
    w.show();

    return a.exec();
}
