import { AmountJson, Amounts, CurrencySpecification } from "@gnu-taler/taler-util";
import { h, VNode } from "preact";

/**
 * Common way to render amount
 * 
 * @param value the amount to be rendered
 * @param spec currency specification
 * @param hideSmall don't show very tiny value
 * @param withColor show negative as red and positive as green
 * @param negative show a minus sign on negative value
 * @returns 
 */
export function RenderAmount({
  value,
  spec,
  negative,
  withColor,
  hideSmall,
}: {
  spec: CurrencySpecification;
  value: AmountJson;
  hideSmall?: boolean;
  negative?: boolean;
  withColor?: boolean;
}): VNode {
  const neg = !!negative; // convert to true or false

  const { currency, normal, small } = Amounts.stringifyValueWithSpec(
    value,
    spec,
  );

  return (
    <span
      data-negative={withColor ? neg : undefined}
      class="whitespace-nowrap data-[negative=false]:text-green-600 data-[negative=true]:text-red-600"
    >
      {negative ? "- " : undefined}
      {currency} {normal}{" "}
      {!hideSmall && small && <sup class="-ml-1">{small}</sup>}
    </span>
  );
}
