/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { ComponentChildren, createContext, h, VNode } from "preact";
import { useContext } from "preact/hooks";

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

export type Type = Notifier;
export type Listener = (event: Event) => void;
export type Event = {
  type: string;
  payload: string;
};
class Notifier {
  private listener: Listener[] = [];
  subscribe(f: Listener) {
    this.listener.push(f);
    return () => {
      const idx = this.listener.findIndex((elem) => elem == f);
      this.listener.splice(idx, 1);
    };
  }
  emit(event: Event) {
    this.listener.forEach((l) => l(event));
  }
}

const Context = createContext<Type>(new Notifier());

export const useNotifierContext = (): Type => useContext(Context);

export const NotifierProvider = ({
  children,
}: {
  children: ComponentChildren;
}): VNode => {
  return h(Context.Provider, {
    value: new Notifier(),
    children,
  });
};
