/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import { TranslatedString } from "@gnu-taler/taler-util";
import { h, VNode } from "preact";
import { useState } from "preact/hooks";
import arrowDown from "../svg/chevron-down.inline.svg";
import { ErrorBox } from "./styled/index.js";
import { useTranslationContext } from "@gnu-taler/web-util/browser";

export function ErrorMessage({
  title,
  description,
}: {
  title: TranslatedString;
  description?: string | VNode | Error;
}): VNode | null {
  const [showErrorDetail, setShowErrorDetail] = useState(false);
  const [showMore, setShowMore] = useState(false);
  const { i18n } = useTranslationContext();
  return (
    <ErrorBox style={{ paddingTop: 0, paddingBottom: 0 }}>
      <div>
        <p>{title}</p>
        {description && (
          <button
            onClick={() => {
              setShowErrorDetail((v) => !v);
            }}
          >
            <div
              style={{ height: "1.5em" }}
              dangerouslySetInnerHTML={{ __html: arrowDown }}
            />
          </button>
        )}
      </div>
      {showErrorDetail && description && <p>
        {description instanceof Error && !showMore ? description.message : description.toString()}
        {description instanceof Error && <div>
          <a href="#" onClick={(e) => {
            setShowMore(!showMore)
            e.preventDefault()
          }}>{showMore ? i18n.str`show less` : i18n.str`show more`}  </a> </div>}
      </p>}
    </ErrorBox>
  );
}
