#
# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# the files that get installed into $(datadir)/$(PACKAGE)/$(VERSION)/$(name)
data-installfiles = $(wildcard *.html)

# the files to include in the tarball at "make dist"
dist_files = Makefile $(wildcard *.xml *.sgml)

easy_dist_files = $(wildcard *.html build-stamp)

# the extra files distributed in solfege-x.y.z-win32.zip
win32_dist_files = $(wildcard *.html)
I18NDEFS=--stringparam chunker.output.encoding "UTF-8"
XSLTPARAMS=--stringparam suppress.navigation 1 --param use.id.as.filename 1

ifeq ($(WITH_LOCAL_XMLCATALOG),yes)
SGML_CATALOG_FILES += ../stupid_catalog_file.cat
endif

destdir="out"

dvi: ../png/built-ps-stamp
	rm -rf $(destdir)
	mkdir -p $(destdir)
	-cp *.xml *.sgml $(destdir)
	cd $(destdir) && $(PYTHON) ../../xml-to-sgml.py *.xml
	cd $(destdir) && cp solfege.xml .tmpfile && cat .tmpfile | sed -e "s/DTD DocBook XML V4\.1\.2/DTD DocBook V4\.1/" -e "s/  \"http\:\/\/www\.oasis-open\.org\/docbook\/xml\/4\.1\.2\/docbookx.dtd\" \[/[/" -e "s/<!ENTITY % ISOnum PUBLIC \"ISO 8879:1986\/\/ENTITIES Numeric and Special Graphic\/\/EN\/\/XML\" \"http:\/\/www.oasis-open.org\/docbook\/xml\/4.1.2\/ent\/iso-num.ent\">//" -e "s/%ISOnum;//" > solfege.sgml
	cd $(destdir) && jade -t tex -d /usr/share/sgml/docbook/stylesheet/dsssl/modular/print/docbook.dsl solfege.sgml
	cd $(destdir) && jadetex solfege.tex

update-version-strings:
	cat solfege.xml | sed 's/ENTITY version ".*"/ENTITY version "$(VERSION)"/' | sed 's/ENTITY shortversion ".*"/ENTITY shortversion "$(MAJOR_VERSION).$(MINOR_VERSION)"/' > _mk.tmp && rm -f solfege.xml && mv _mk.tmp solfege.xml

all-alllang: $(wildcard *.xml *.sgml) ../create_toc.py
ifeq ($(WITH_LOCAL_XMLCATALOG),yes)
	SGML_CATALOG_FILES=$(SGML_CATALOG_FILES) $(XSLTPROC) $(XSLTPARAMS) $(I18NDEFS) --catalogs  --nonet $(stylesheet_filename) solfege.xml
else
	$(XSLTPROC) $(XSLTPARAMS) $(I18NDEFS) $(stylesheet_filename) solfege.xml
endif
	$(PYTHON) ../addstyle.py *.html
	touch build-stamp

install: data-install

uninstall: data-uninstall

clean:
	rm -f *.html
	rm -rf out
	rm -f build-stamp
	rm -f *.aux *.cp *.dvi *.fn *.ky *.log *.pg *.toc *.tp *.vr *.info *.cps

distclean: clean

.PHONY: dvi clean distclean
