
(defvar wiki-mode-syntax-table
  (make-syntax-table)
  )

(defvar wiki-mode-mode-map
  (make-keymap))




(setq auto-mode-alist (cons '("\\.wiki$" . wiki-mode) auto-mode-alist))

(defun wiki-mode ()
  (interactive)
  (progn
    (fundamental-mode)
    (font-lock-mode 0)
    (kill-all-local-variables)
    (setq major-mode 'wiki-mode)
    (setq mode-name "Wiki")

    (set-syntax-table wiki-mode-syntax-table)
    (use-local-map wiki-mode-mode-map)
    (local-set-key "`" 'self-insert-command)
    (local-set-key "'" 'self-insert-command)

    (setq font-lock-keywords-case-fold-search nil)
    (setq wiki-mode-font-lock-keywords
          '(

            ;; NOTE: Wikipedia Wiki
            ("^\\*"        0 'fg:lightred t)
            ("\\[\\[[^]]*\\]\\]" 0 'fg:lightblue t)
            ("<br>" 0 'fg:lightred t)
            ;;("\\~*$" 0 'bg:yellow t) ;;;; WTF????????????????

            ;; NOTE: Cosc Wiki

            ("^ \\*"        0 'fg:lightblue t)
            ("^  \\*"        0 'fg:lightred t)
            ("^   \\*"        0 'fg:lightblue t)
            ("^    \\*"        0 'fg:lightred t)
            ("^     \\*"        0 'fg:lightblue t)

            ("\\<\\([A-Z][a-z0-9]+\\([A-Z][a-z0-9.]+\\)+\\)" 1 'fg:lightred t)


            ("`[^`]+`"      0 'fg:yellow t)
            ("__[^_\n]+__"   0 'underline t)
            ("''[^'\n]+''"   0 'italic t)
            ("'''[^'\n]+'''" 0 'bold t)

            ("{{{" 0 'fg:lightred t)
            ("}}}" 0 'fg:lightred t)

            ("\\(http://\\)\\([^ ]*\\)" (1 'd-face-m4 t) (2 'fg:lightred t))
            ("\\[\\(http://[^ ]*\\) \\(.*\\)\\]" (0 'fg:lightred t) (1 'd-face-m4 t))

            ("\\(http://\\)\\([^ ]*\\.\\(gif\\|jpg\\)\\)" (1 'd-face-m4 t) (2 'fg:lightblue t))

            ;;("^\\*.*\n"             0 'fg:cyan t)
            ;;("^\\*\\*.*\n"          0 'fg:green t)
            ;;("^\\*\\*\\*.*\n"       0 'fg:lightred t)
            ;;("^\\*\\*\\*\\*.*\n"    0 'fg:white t)

            ("^=[^=]+=$"         0 'fg:white    t)
            ("^==[^=]+==$"       0 'fg:yellow   t)
            ("^===[^=]+===$"     0 'fg:lightred t)
            ("^====[^=]+====$"   0 'fg:green    t)
            ("^=====[^=]+=====$" 0 'fg:cyan     t)

            ))

    (make-local-variable 'font-lock-defaults)
    (setq font-lock-defaults '(wiki-mode-font-lock-keywords nil))

    (font-lock-mode 3)


    ))

(provide 'd-wiki)
;;; d-wiki.el ends here
