## Copyright (C) 2007 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
## 02110-1301, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} news ()
## Display the current NEWS file for Octave.
## @end deftypefn

function news ()

  datadir = octave_config_info ("datadir");
  newsfile = fullfile (datadir, "octave", version (), "NEWS");

  if (exist (newsfile, "file"))
    f = fopen (newsfile, "r");
    while (isstr (line = fgets (f)))
      printf (line);
    endwhile
  else
    error ("news: unable to locate NEWS file");
  endif

endfunction
