/* search.c generated by valac 0.50.1.44-10688, the Vala compiler
 * generated from search.vala, do not modify */

/* Search and replace functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#define _GNU_SOURCE

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <regex.h>
#include <estr.h>
#include <glib-object.h>
#include <gee.h>

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
typedef struct _WindowPrivate WindowPrivate;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
#define _marker_unref0(var) ((var == NULL) ? NULL : (var = (marker_unref (var), NULL)))
typedef enum  {
	CASE_upper = 1,
	CASE_lower,
	CASE_capitalized
} Case;

#define TYPE_CASE (case_get_type ())
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
#define _region_unref0(var) ((var == NULL) ? NULL : (var = (region_unref (var), NULL)))

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

extern const gchar* re_find_err;
const gchar* re_find_err = NULL;
extern Buffer* cur_bp;
extern Flags thisflag;
extern gchar* last_search;
gchar* last_search = NULL;
extern Window* cur_wp;
extern Flags lastflag;

gboolean no_upper (const gchar* s,
                   guint len,
                   gboolean regex);
#define REGEX_SYNTAX_PLAIN ((gint) (RE_NO_SUB << 1))
glong find_substr (ImmutableEstr* es,
                   const gchar* n,
                   gboolean forward,
                   gboolean notbol,
                   gboolean noteol,
                   gboolean regex,
                   gboolean icase);
gboolean search (const gchar* s,
                 gboolean forward,
                 gboolean regexp);
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gsize buffer_get_pt (Buffer* self);
gsize buffer_get_length (Buffer* self);
ImmutableEstr* buffer_post_point (Buffer* self);
ImmutableEstr* buffer_pre_point (Buffer* self);
gboolean get_variable_bool (const gchar* name);
void buffer_goto_offset (Buffer* self,
                         gsize o);
GType flags_get_type (void) G_GNUC_CONST ;
gboolean do_search (gboolean forward,
                    gboolean regexp,
                    const gchar* pattern_in);
gchar* minibuf_read (const gchar* fmt,
                     const gchar* value,
                     ...);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg);
void minibuf_error (const gchar* fmt,
                    ...);
gboolean isearch (gboolean forward,
                  gboolean regexp);
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
Marker* marker_copy (Marker* m);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
void minibuf_write (const gchar* fmt,
                    ...);
guint getkey (gint delay);
#define GETKEY_DEFAULT -1
#define KBD_CTRL 01000
#define KBD_CANCEL (KBD_CTRL | 'g')
void marker_unchain (Marker* self);
#define KBD_BS 00411
void ding (void);
guint getkey_unfiltered (gint mode);
#define KBD_META 02000
#define KBD_TAB 00402
#define KBD_RET 00403
void set_mark (void);
void marker_set_o (Marker* self,
                   gsize value);
void minibuf_clear (void);
void ungetkey (guint key);
void window_resync (Window* self);
void term_redisplay (void);
GType case_get_type (void) G_GNUC_CONST ;
Case check_case (ImmutableEstr* a);
void search_init (void);
static gboolean __lambda123_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda123__function (glong uniarg,
                                 GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda124_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda124__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda125_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda125__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda126_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda126__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda127_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda127__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda128_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda128__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda129_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda129__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda130_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda130__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda131_ (glong uniarg,
                       GeeQueue* args);
gpointer region_ref (gpointer instance);
void region_unref (gpointer instance);
GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_region (GValue* value,
                       gpointer v_object);
void value_take_region (GValue* value,
                        gpointer v_object);
gpointer value_get_region (const GValue* value);
GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
Region* region_new (gsize o1,
                    gsize o2);
Region* region_construct (GType object_type,
                          gsize o1,
                          gsize o2);
ImmutableEstr* buffer_get_region (Buffer* self,
                                  Region* r);
gchar* recase (const gchar* s,
               Case rcase);
Marker* marker_point (void);
gsize region_get_start (Region* self);
gboolean buffer_replace_estr (Buffer* self,
                              gsize del,
                              ImmutableEstr* es);
const gchar* buffer_get_eol (Buffer* self);
gsize marker_get_o (Marker* self);
#define KBD_DEL 00410
static gboolean ___lambda131__function (glong uniarg,
                                 GeeQueue* args);

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 424 "search.c"
}

gboolean
no_upper (const gchar* s,
          guint len,
          gboolean regex)
{
	gboolean quote_flag = FALSE;
	gboolean result = FALSE;
#line 24 "src/search.vala"
	g_return_val_if_fail (s != NULL, FALSE);
#line 25 "src/search.vala"
	quote_flag = FALSE;
#line 438 "search.c"
	{
		guint i = 0U;
#line 27 "src/search.vala"
		i = (guint) 0;
#line 443 "search.c"
		{
			gboolean _tmp0_ = FALSE;
#line 27 "src/search.vala"
			_tmp0_ = TRUE;
#line 27 "src/search.vala"
			while (TRUE) {
#line 450 "search.c"
				gboolean _tmp2_ = FALSE;
#line 27 "src/search.vala"
				if (!_tmp0_) {
#line 454 "search.c"
					guint _tmp1_;
#line 27 "src/search.vala"
					_tmp1_ = i;
#line 27 "src/search.vala"
					i = _tmp1_ + 1;
#line 460 "search.c"
				}
#line 27 "src/search.vala"
				_tmp0_ = FALSE;
#line 27 "src/search.vala"
				if (!(i < len)) {
#line 27 "src/search.vala"
					break;
#line 468 "search.c"
				}
#line 28 "src/search.vala"
				if (regex) {
#line 28 "src/search.vala"
					_tmp2_ = string_get (s, (glong) i) == '\\';
#line 474 "search.c"
				} else {
#line 28 "src/search.vala"
					_tmp2_ = FALSE;
#line 478 "search.c"
				}
#line 28 "src/search.vala"
				if (_tmp2_) {
#line 29 "src/search.vala"
					quote_flag = !quote_flag;
#line 484 "search.c"
				} else {
					gboolean _tmp3_ = FALSE;
#line 30 "src/search.vala"
					if (!quote_flag) {
#line 30 "src/search.vala"
						_tmp3_ = g_ascii_isupper (string_get (s, (glong) i));
#line 491 "search.c"
					} else {
#line 30 "src/search.vala"
						_tmp3_ = FALSE;
#line 495 "search.c"
					}
#line 30 "src/search.vala"
					if (_tmp3_) {
#line 31 "src/search.vala"
						result = FALSE;
#line 31 "src/search.vala"
						return result;
#line 503 "search.c"
					}
				}
			}
		}
	}
#line 34 "src/search.vala"
	result = TRUE;
#line 34 "src/search.vala"
	return result;
#line 513 "search.c"
}

static void
regex_registers_destroy (struct re_registers *self)
{
	regoff_t* _tmp0_;
	gint _tmp0__length1;
	regoff_t* _tmp1_;
	gint _tmp1__length1;
#line 3787 "posix.vapi"
	_tmp0_ = (*self).start;
#line 3787 "posix.vapi"
	_tmp0__length1 = (*self).num_regs;
#line 3787 "posix.vapi"
	free (_tmp0_);
#line 3788 "posix.vapi"
	_tmp1_ = (*self).end;
#line 3788 "posix.vapi"
	_tmp1__length1 = (*self).num_regs;
#line 3788 "posix.vapi"
	free (_tmp1_);
#line 535 "search.c"
}

glong
find_substr (ImmutableEstr* es,
             const gchar* n,
             gboolean forward,
             gboolean notbol,
             gboolean noteol,
             gboolean regex,
             gboolean icase)
{
	glong ret = 0L;
	struct re_pattern_buffer pattern = {0};
	struct re_registers search_regs = {0};
	reg_syntax_t syntax = 0U;
	reg_syntax_t _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	glong result = 0L;
#line 40 "src/search.vala"
	g_return_val_if_fail (es != NULL, 0L);
#line 40 "src/search.vala"
	g_return_val_if_fail (n != NULL, 0L);
#line 41 "src/search.vala"
	ret = (glong) -1;
#line 42 "src/search.vala"
	memset (&pattern, 0, sizeof (struct re_pattern_buffer));
#line 43 "src/search.vala"
	memset (&search_regs, 0, sizeof (struct re_registers));
#line 44 "src/search.vala"
	syntax = RE_SYNTAX_EMACS;
#line 46 "src/search.vala"
	if (!regex) {
#line 571 "search.c"
		reg_syntax_t _tmp0_;
#line 47 "src/search.vala"
		_tmp0_ = syntax;
#line 47 "src/search.vala"
		syntax = _tmp0_ | REGEX_SYNTAX_PLAIN;
#line 577 "search.c"
	}
#line 48 "src/search.vala"
	if (icase) {
#line 581 "search.c"
		reg_syntax_t _tmp1_;
#line 49 "src/search.vala"
		_tmp1_ = syntax;
#line 49 "src/search.vala"
		syntax = _tmp1_ | RE_ICASE;
#line 587 "search.c"
	}
#line 50 "src/search.vala"
	_tmp2_ = syntax;
#line 50 "src/search.vala"
	re_set_syntax (_tmp2_);
#line 51 "src/search.vala"
	search_regs.num_regs = (__re_size_t) 1;
#line 53 "src/search.vala"
	_tmp3_ = strlen (n);
#line 53 "src/search.vala"
	_tmp4_ = _tmp3_;
#line 53 "src/search.vala"
	_tmp5_ = re_compile_pattern (n, (gsize) ((gint) _tmp4_), &pattern);
#line 53 "src/search.vala"
	re_find_err = _tmp5_;
#line 54 "src/search.vala"
	pattern.not_bol = notbol;
#line 55 "src/search.vala"
	pattern.not_eol = noteol;
#line 56 "src/search.vala"
	_tmp6_ = re_find_err;
#line 56 "src/search.vala"
	if (_tmp6_ == NULL) {
#line 611 "search.c"
		gsize _tmp7_ = 0UL;
		gsize _tmp10_ = 0UL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gsize _tmp17_;
		gsize _tmp18_;
		struct re_registers _tmp19_ = {0};
		regoff_t _tmp20_;
#line 58 "src/search.vala"
		if (forward) {
#line 58 "src/search.vala"
			_tmp7_ = (gsize) 0;
#line 624 "search.c"
		} else {
			gsize _tmp8_;
			gsize _tmp9_;
#line 58 "src/search.vala"
			_tmp8_ = immutable_estr_get_length (es);
#line 58 "src/search.vala"
			_tmp9_ = _tmp8_;
#line 58 "src/search.vala"
			_tmp7_ = _tmp9_;
#line 634 "search.c"
		}
#line 59 "src/search.vala"
		if (forward) {
#line 638 "search.c"
			gsize _tmp11_;
			gsize _tmp12_;
#line 59 "src/search.vala"
			_tmp11_ = immutable_estr_get_length (es);
#line 59 "src/search.vala"
			_tmp12_ = _tmp11_;
#line 59 "src/search.vala"
			_tmp10_ = _tmp12_;
#line 647 "search.c"
		} else {
			gsize _tmp13_;
			gsize _tmp14_;
#line 59 "src/search.vala"
			_tmp13_ = immutable_estr_get_length (es);
#line 59 "src/search.vala"
			_tmp14_ = _tmp13_;
#line 59 "src/search.vala"
			_tmp10_ = -_tmp14_;
#line 657 "search.c"
		}
#line 57 "src/search.vala"
		_tmp15_ = immutable_estr_get_text (es);
#line 57 "src/search.vala"
		_tmp16_ = _tmp15_;
#line 57 "src/search.vala"
		_tmp17_ = immutable_estr_get_length (es);
#line 57 "src/search.vala"
		_tmp18_ = _tmp17_;
#line 57 "src/search.vala"
		_tmp20_ = re_search (&pattern, (const gchar*) _tmp16_, (regoff_t) _tmp18_, (regoff_t) _tmp7_, (regoff_t) _tmp10_, &_tmp19_);
#line 57 "src/search.vala"
		 (&search_regs);
#line 57 "src/search.vala"
		search_regs = _tmp19_;
#line 57 "src/search.vala"
		ret = (glong) _tmp20_;
#line 675 "search.c"
	}
#line 62 "src/search.vala"
	if (ret >= ((glong) 0)) {
#line 679 "search.c"
		regoff_t _tmp21_ = {0};
#line 63 "src/search.vala"
		if (forward) {
#line 683 "search.c"
			struct re_registers _tmp22_;
			regoff_t* _tmp23_;
			gint _tmp23__length1;
			regoff_t _tmp24_;
#line 63 "src/search.vala"
			_tmp22_ = search_regs;
#line 63 "src/search.vala"
			_tmp23_ = _tmp22_.end;
#line 63 "src/search.vala"
			_tmp23__length1 = _tmp22_.num_regs;
#line 63 "src/search.vala"
			_tmp24_ = _tmp23_[0];
#line 63 "src/search.vala"
			_tmp21_ = _tmp24_;
#line 698 "search.c"
		} else {
#line 63 "src/search.vala"
			_tmp21_ = (regoff_t) ret;
#line 702 "search.c"
		}
#line 63 "src/search.vala"
		ret = (glong) _tmp21_;
#line 706 "search.c"
	}
#line 65 "src/search.vala"
	regex_registers_destroy (&search_regs);
#line 66 "src/search.vala"
	result = ret;
#line 66 "src/search.vala"
	 (&search_regs);
#line 66 "src/search.vala"
	regfree (&pattern);
#line 66 "src/search.vala"
	return result;
#line 718 "search.c"
}

static gpointer
_immutable_estr_ref0 (gpointer self)
{
#line 77 "src/search.vala"
	return self ? immutable_estr_ref (self) : NULL;
#line 726 "search.c"
}

gboolean
search (const gchar* s,
        gboolean forward,
        gboolean regexp)
{
	gint _tmp0_;
	gint _tmp1_;
	gsize o = 0UL;
	Buffer* _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean notbol = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean noteol = FALSE;
	ImmutableEstr* _tmp10_ = NULL;
	ImmutableEstr* es = NULL;
	ImmutableEstr* _tmp15_;
	gboolean _tmp16_ = FALSE;
	glong pos = 0L;
	ImmutableEstr* _tmp19_;
	gsize _tmp20_ = 0UL;
	Buffer* _tmp24_;
	Flags _tmp25_;
	gboolean result = FALSE;
#line 69 "src/search.vala"
	g_return_val_if_fail (s != NULL, FALSE);
#line 70 "src/search.vala"
	_tmp0_ = strlen (s);
#line 70 "src/search.vala"
	_tmp1_ = _tmp0_;
#line 70 "src/search.vala"
	if (_tmp1_ < 1) {
#line 71 "src/search.vala"
		result = FALSE;
#line 71 "src/search.vala"
		return result;
#line 766 "search.c"
	}
#line 74 "src/search.vala"
	_tmp2_ = cur_bp;
#line 74 "src/search.vala"
	_tmp3_ = buffer_get_pt (_tmp2_);
#line 74 "src/search.vala"
	_tmp4_ = _tmp3_;
#line 74 "src/search.vala"
	o = _tmp4_;
#line 75 "src/search.vala"
	if (forward) {
#line 75 "src/search.vala"
		_tmp5_ = o > ((gsize) 0);
#line 780 "search.c"
	} else {
#line 75 "src/search.vala"
		_tmp5_ = FALSE;
#line 784 "search.c"
	}
#line 75 "src/search.vala"
	notbol = _tmp5_;
#line 76 "src/search.vala"
	if (forward) {
#line 76 "src/search.vala"
		_tmp6_ = FALSE;
#line 792 "search.c"
	} else {
		Buffer* _tmp7_;
		gsize _tmp8_;
		gsize _tmp9_;
#line 76 "src/search.vala"
		_tmp7_ = cur_bp;
#line 76 "src/search.vala"
		_tmp8_ = buffer_get_length (_tmp7_);
#line 76 "src/search.vala"
		_tmp9_ = _tmp8_;
#line 76 "src/search.vala"
		_tmp6_ = o < _tmp9_;
#line 805 "search.c"
	}
#line 76 "src/search.vala"
	noteol = _tmp6_;
#line 77 "src/search.vala"
	if (forward) {
#line 811 "search.c"
		Buffer* _tmp11_;
		ImmutableEstr* _tmp12_;
#line 77 "src/search.vala"
		_tmp11_ = cur_bp;
#line 77 "src/search.vala"
		_tmp12_ = buffer_post_point (_tmp11_);
#line 77 "src/search.vala"
		_immutable_estr_unref0 (_tmp10_);
#line 77 "src/search.vala"
		_tmp10_ = _tmp12_;
#line 822 "search.c"
	} else {
		Buffer* _tmp13_;
		ImmutableEstr* _tmp14_;
#line 77 "src/search.vala"
		_tmp13_ = cur_bp;
#line 77 "src/search.vala"
		_tmp14_ = buffer_pre_point (_tmp13_);
#line 77 "src/search.vala"
		_immutable_estr_unref0 (_tmp10_);
#line 77 "src/search.vala"
		_tmp10_ = _tmp14_;
#line 834 "search.c"
	}
#line 77 "src/search.vala"
	_tmp15_ = _immutable_estr_ref0 (_tmp10_);
#line 77 "src/search.vala"
	es = _tmp15_;
#line 79 "src/search.vala"
	if (get_variable_bool ("case-fold-search")) {
#line 842 "search.c"
		gint _tmp17_;
		gint _tmp18_;
#line 79 "src/search.vala"
		_tmp17_ = strlen (s);
#line 79 "src/search.vala"
		_tmp18_ = _tmp17_;
#line 79 "src/search.vala"
		_tmp16_ = no_upper (s, (guint) _tmp18_, regexp);
#line 851 "search.c"
	} else {
#line 79 "src/search.vala"
		_tmp16_ = FALSE;
#line 855 "search.c"
	}
#line 78 "src/search.vala"
	_tmp19_ = es;
#line 78 "src/search.vala"
	pos = find_substr (_tmp19_, s, forward, notbol, noteol, regexp, _tmp16_);
#line 80 "src/search.vala"
	if (pos < ((glong) 0)) {
#line 81 "src/search.vala"
		result = FALSE;
#line 81 "src/search.vala"
		_immutable_estr_unref0 (es);
#line 81 "src/search.vala"
		_immutable_estr_unref0 (_tmp10_);
#line 81 "src/search.vala"
		return result;
#line 871 "search.c"
	}
#line 83 "src/search.vala"
	if (forward) {
#line 875 "search.c"
		Buffer* _tmp21_;
		gsize _tmp22_;
		gsize _tmp23_;
#line 83 "src/search.vala"
		_tmp21_ = cur_bp;
#line 83 "src/search.vala"
		_tmp22_ = buffer_get_pt (_tmp21_);
#line 83 "src/search.vala"
		_tmp23_ = _tmp22_;
#line 83 "src/search.vala"
		_tmp20_ = _tmp23_;
#line 887 "search.c"
	} else {
#line 83 "src/search.vala"
		_tmp20_ = (gsize) 0;
#line 891 "search.c"
	}
#line 83 "src/search.vala"
	_tmp24_ = cur_bp;
#line 83 "src/search.vala"
	buffer_goto_offset (_tmp24_, pos + _tmp20_);
#line 84 "src/search.vala"
	_tmp25_ = thisflag;
#line 84 "src/search.vala"
	thisflag = _tmp25_ | FLAGS_NEED_RESYNC;
#line 85 "src/search.vala"
	result = TRUE;
#line 85 "src/search.vala"
	_immutable_estr_unref0 (es);
#line 85 "src/search.vala"
	_immutable_estr_unref0 (_tmp10_);
#line 85 "src/search.vala"
	return result;
#line 909 "search.c"
}

gboolean
do_search (gboolean forward,
           gboolean regexp,
           const gchar* pattern_in)
{
	gboolean ok = FALSE;
	gchar* pattern = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean result = FALSE;
#line 91 "src/search.vala"
	ok = FALSE;
#line 92 "src/search.vala"
	_tmp0_ = g_strdup (pattern_in);
#line 92 "src/search.vala"
	pattern = _tmp0_;
#line 94 "src/search.vala"
	_tmp1_ = pattern;
#line 94 "src/search.vala"
	if (_tmp1_ == NULL) {
#line 936 "search.c"
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 96 "src/search.vala"
		if (regexp) {
#line 96 "src/search.vala"
			_tmp2_ = "RE search";
#line 945 "search.c"
		} else {
#line 96 "src/search.vala"
			_tmp2_ = "Search";
#line 949 "search.c"
		}
#line 96 "src/search.vala"
		if (forward) {
#line 96 "src/search.vala"
			_tmp3_ = "";
#line 955 "search.c"
		} else {
#line 96 "src/search.vala"
			_tmp3_ = " backward";
#line 959 "search.c"
		}
#line 95 "src/search.vala"
		_tmp4_ = last_search;
#line 95 "src/search.vala"
		_tmp5_ = minibuf_read ("%s%s: ", _tmp4_, _tmp2_, _tmp3_, NULL);
#line 95 "src/search.vala"
		_g_free0 (pattern);
#line 95 "src/search.vala"
		pattern = _tmp5_;
#line 969 "search.c"
	}
#line 98 "src/search.vala"
	_tmp6_ = pattern;
#line 98 "src/search.vala"
	if (_tmp6_ == NULL) {
#line 99 "src/search.vala"
		result = funcall ("keyboard-quit", NULL);
#line 99 "src/search.vala"
		_g_free0 (pattern);
#line 99 "src/search.vala"
		return result;
#line 981 "search.c"
	}
#line 100 "src/search.vala"
	_tmp7_ = pattern;
#line 100 "src/search.vala"
	_tmp8_ = strlen (_tmp7_);
#line 100 "src/search.vala"
	_tmp9_ = _tmp8_;
#line 100 "src/search.vala"
	if (_tmp9_ != 0) {
#line 991 "search.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
#line 101 "src/search.vala"
		_tmp10_ = pattern;
#line 101 "src/search.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 101 "src/search.vala"
		_g_free0 (last_search);
#line 101 "src/search.vala"
		last_search = _tmp11_;
#line 103 "src/search.vala"
		_tmp12_ = pattern;
#line 103 "src/search.vala"
		if (!search (_tmp12_, forward, regexp)) {
#line 1007 "search.c"
			const gchar* _tmp13_;
#line 104 "src/search.vala"
			_tmp13_ = pattern;
#line 104 "src/search.vala"
			minibuf_error ("Search failed: \"%s\"", _tmp13_, NULL);
#line 1013 "search.c"
		} else {
#line 106 "src/search.vala"
			ok = TRUE;
#line 1017 "search.c"
		}
	}
#line 109 "src/search.vala"
	result = ok;
#line 109 "src/search.vala"
	_g_free0 (pattern);
#line 109 "src/search.vala"
	return result;
#line 1026 "search.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 1039 "search.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1481 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1481 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1482 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1483 "glib-2.0.vapi"
		start = string_length + start;
#line 1066 "search.c"
	}
#line 1485 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1486 "glib-2.0.vapi"
		end = string_length + end;
#line 1072 "search.c"
	}
#line 1488 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1078 "search.c"
	} else {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1082 "search.c"
	}
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1489 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1090 "search.c"
	} else {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1094 "search.c"
	}
#line 1489 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1490 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1491 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1491 "glib-2.0.vapi"
	result = _tmp4_;
#line 1491 "glib-2.0.vapi"
	return result;
#line 1106 "search.c"
}

gboolean
isearch (gboolean forward,
         gboolean regexp)
{
	Marker* old_mark = NULL;
	Window* _tmp0_;
	Buffer* _tmp1_;
	Marker* _tmp2_;
	Marker* _tmp3_;
	Window* _tmp4_;
	Buffer* _tmp5_;
	gboolean last = FALSE;
	gchar* pattern = NULL;
	gchar* _tmp6_;
	gsize start = 0UL;
	Buffer* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	gsize cur = 0UL;
	Window* _tmp89_;
	Buffer* _tmp90_;
	Marker* _tmp91_;
	gboolean result = FALSE;
#line 116 "src/search.vala"
	_tmp0_ = cur_wp;
#line 116 "src/search.vala"
	_tmp1_ = _tmp0_->bp;
#line 116 "src/search.vala"
	_tmp2_ = _tmp1_->mark;
#line 116 "src/search.vala"
	_tmp3_ = marker_copy (_tmp2_);
#line 116 "src/search.vala"
	old_mark = _tmp3_;
#line 118 "src/search.vala"
	_tmp4_ = cur_wp;
#line 118 "src/search.vala"
	_tmp5_ = _tmp4_->bp;
#line 118 "src/search.vala"
	_tmp5_->isearch = TRUE;
#line 120 "src/search.vala"
	last = TRUE;
#line 121 "src/search.vala"
	_tmp6_ = g_strdup ("");
#line 121 "src/search.vala"
	pattern = _tmp6_;
#line 122 "src/search.vala"
	_tmp7_ = cur_bp;
#line 122 "src/search.vala"
	_tmp8_ = buffer_get_pt (_tmp7_);
#line 122 "src/search.vala"
	_tmp9_ = _tmp8_;
#line 122 "src/search.vala"
	start = _tmp9_;
#line 122 "src/search.vala"
	cur = start;
#line 1164 "search.c"
	{
		gboolean _tmp10_ = FALSE;
#line 123 "src/search.vala"
		_tmp10_ = TRUE;
#line 123 "src/search.vala"
		while (TRUE) {
#line 1171 "search.c"
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* msg = NULL;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp29_;
			guint c = 0U;
			const gchar* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			Flags _tmp87_;
#line 123 "src/search.vala"
			if (!_tmp10_) {
#line 1186 "search.c"
			}
#line 123 "src/search.vala"
			_tmp10_ = FALSE;
#line 126 "src/search.vala"
			if (last) {
#line 1192 "search.c"
				const gchar* _tmp12_ = NULL;
#line 127 "src/search.vala"
				if (regexp) {
#line 127 "src/search.vala"
					_tmp12_ = "Regexp ";
#line 1198 "search.c"
				} else {
#line 127 "src/search.vala"
					_tmp12_ = "";
#line 1202 "search.c"
				}
#line 127 "src/search.vala"
				_tmp11_ = _tmp12_;
#line 1206 "search.c"
			} else {
				const gchar* _tmp13_ = NULL;
#line 128 "src/search.vala"
				if (regexp) {
#line 128 "src/search.vala"
					_tmp13_ = "Failing regexp ";
#line 1213 "search.c"
				} else {
#line 128 "src/search.vala"
					_tmp13_ = "Failing ";
#line 1217 "search.c"
				}
#line 128 "src/search.vala"
				_tmp11_ = _tmp13_;
#line 1221 "search.c"
			}
#line 129 "src/search.vala"
			if (forward) {
#line 129 "src/search.vala"
				_tmp14_ = "";
#line 1227 "search.c"
			} else {
#line 129 "src/search.vala"
				_tmp14_ = " backward";
#line 1231 "search.c"
			}
#line 125 "src/search.vala"
			_tmp15_ = pattern;
#line 125 "src/search.vala"
			_tmp16_ = g_strdup_printf ("%sI-search%s: %s", _tmp11_, _tmp14_, _tmp15_);
#line 125 "src/search.vala"
			msg = _tmp16_;
#line 133 "src/search.vala"
			_tmp17_ = re_find_err;
#line 133 "src/search.vala"
			if (_tmp17_ != NULL) {
#line 1243 "search.c"
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				const gchar* _tmp20_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
#line 134 "src/search.vala"
				_tmp20_ = re_find_err;
#line 134 "src/search.vala"
				if (g_str_has_prefix (_tmp20_, "Premature ")) {
#line 134 "src/search.vala"
					_tmp19_ = TRUE;
#line 1259 "search.c"
				} else {
					const gchar* _tmp21_;
#line 135 "src/search.vala"
					_tmp21_ = re_find_err;
#line 135 "src/search.vala"
					_tmp19_ = g_str_has_prefix (_tmp21_, "Unmatched ");
#line 1266 "search.c"
				}
#line 134 "src/search.vala"
				if (_tmp19_) {
#line 134 "src/search.vala"
					_tmp18_ = TRUE;
#line 1272 "search.c"
				} else {
					const gchar* _tmp22_;
#line 136 "src/search.vala"
					_tmp22_ = re_find_err;
#line 136 "src/search.vala"
					_tmp18_ = g_str_has_prefix (_tmp22_, "Invalid ");
#line 1279 "search.c"
				}
#line 134 "src/search.vala"
				if (_tmp18_) {
#line 137 "src/search.vala"
					re_find_err = "incomplete input";
#line 1285 "search.c"
				}
#line 139 "src/search.vala"
				_tmp23_ = msg;
#line 139 "src/search.vala"
				_tmp24_ = re_find_err;
#line 139 "src/search.vala"
				_tmp25_ = string_to_string (_tmp24_);
#line 139 "src/search.vala"
				_tmp26_ = g_strconcat (" [", _tmp25_, "]", NULL);
#line 139 "src/search.vala"
				_tmp27_ = _tmp26_;
#line 139 "src/search.vala"
				_tmp28_ = g_strconcat (_tmp23_, _tmp27_, NULL);
#line 139 "src/search.vala"
				_g_free0 (msg);
#line 139 "src/search.vala"
				msg = _tmp28_;
#line 139 "src/search.vala"
				_g_free0 (_tmp27_);
#line 140 "src/search.vala"
				re_find_err = NULL;
#line 1307 "search.c"
			}
#line 143 "src/search.vala"
			_tmp29_ = msg;
#line 143 "src/search.vala"
			minibuf_write ("%s", _tmp29_, NULL);
#line 145 "src/search.vala"
			c = (guint) getkey (GETKEY_DEFAULT);
#line 147 "src/search.vala"
			if (c == ((guint) KBD_CANCEL)) {
#line 1317 "search.c"
				Buffer* _tmp30_;
				Flags _tmp31_;
				Buffer* _tmp32_;
				Marker* _tmp33_;
				Buffer* _tmp36_;
				Marker* _tmp37_;
				Marker* _tmp38_;
#line 148 "src/search.vala"
				_tmp30_ = cur_bp;
#line 148 "src/search.vala"
				buffer_goto_offset (_tmp30_, start);
#line 149 "src/search.vala"
				_tmp31_ = thisflag;
#line 149 "src/search.vala"
				thisflag = _tmp31_ | FLAGS_NEED_RESYNC;
#line 152 "src/search.vala"
				funcall ("keyboard-quit", NULL);
#line 155 "src/search.vala"
				_tmp32_ = cur_bp;
#line 155 "src/search.vala"
				_tmp33_ = _tmp32_->mark;
#line 155 "src/search.vala"
				if (_tmp33_ != NULL) {
#line 1341 "search.c"
					Buffer* _tmp34_;
					Marker* _tmp35_;
#line 156 "src/search.vala"
					_tmp34_ = cur_bp;
#line 156 "src/search.vala"
					_tmp35_ = _tmp34_->mark;
#line 156 "src/search.vala"
					marker_unchain (_tmp35_);
#line 1350 "search.c"
				}
#line 158 "src/search.vala"
				_tmp36_ = cur_bp;
#line 158 "src/search.vala"
				_tmp37_ = old_mark;
#line 158 "src/search.vala"
				_tmp38_ = marker_copy (_tmp37_);
#line 158 "src/search.vala"
				_marker_unref0 (_tmp36_->mark);
#line 158 "src/search.vala"
				_tmp36_->mark = _tmp38_;
#line 159 "src/search.vala"
				_g_free0 (msg);
#line 159 "src/search.vala"
				break;
#line 1366 "search.c"
			} else {
#line 160 "src/search.vala"
				if (c == ((guint) KBD_BS)) {
#line 1370 "search.c"
					const gchar* _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
#line 161 "src/search.vala"
					_tmp39_ = pattern;
#line 161 "src/search.vala"
					_tmp40_ = strlen (_tmp39_);
#line 161 "src/search.vala"
					_tmp41_ = _tmp40_;
#line 161 "src/search.vala"
					if (_tmp41_ > 0) {
#line 1382 "search.c"
						const gchar* _tmp42_;
						gchar* _tmp43_;
						Buffer* _tmp44_;
						Flags _tmp45_;
#line 162 "src/search.vala"
						_tmp42_ = pattern;
#line 162 "src/search.vala"
						_tmp43_ = string_slice (_tmp42_, (glong) 0, (glong) -1);
#line 162 "src/search.vala"
						_g_free0 (pattern);
#line 162 "src/search.vala"
						pattern = _tmp43_;
#line 163 "src/search.vala"
						cur = start;
#line 164 "src/search.vala"
						_tmp44_ = cur_bp;
#line 164 "src/search.vala"
						buffer_goto_offset (_tmp44_, start);
#line 165 "src/search.vala"
						_tmp45_ = thisflag;
#line 165 "src/search.vala"
						thisflag = _tmp45_ | FLAGS_NEED_RESYNC;
#line 1405 "search.c"
					} else {
#line 167 "src/search.vala"
						ding ();
#line 1409 "search.c"
					}
				} else {
					gboolean _tmp46_ = FALSE;
#line 168 "src/search.vala"
					if ((c & KBD_CTRL) != ((guint) 0)) {
#line 168 "src/search.vala"
						_tmp46_ = (c & 0xff) == ((guint) 'q');
#line 1417 "search.c"
					} else {
#line 168 "src/search.vala"
						_tmp46_ = FALSE;
#line 1421 "search.c"
					}
#line 168 "src/search.vala"
					if (_tmp46_) {
#line 1425 "search.c"
						const gchar* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
#line 169 "src/search.vala"
						_tmp47_ = msg;
#line 169 "src/search.vala"
						minibuf_write ("%s^Q-", _tmp47_, NULL);
#line 170 "src/search.vala"
						_tmp48_ = pattern;
#line 170 "src/search.vala"
						_tmp49_ = g_strdup_printf ("%c", (gchar) getkey_unfiltered (GETKEY_DEFAULT));
#line 170 "src/search.vala"
						_tmp50_ = _tmp49_;
#line 170 "src/search.vala"
						_tmp51_ = g_strconcat (_tmp48_, _tmp50_, NULL);
#line 170 "src/search.vala"
						_g_free0 (pattern);
#line 170 "src/search.vala"
						pattern = _tmp51_;
#line 170 "src/search.vala"
						_g_free0 (_tmp50_);
#line 1449 "search.c"
					} else {
						gboolean _tmp52_ = FALSE;
#line 171 "src/search.vala"
						if ((c & KBD_CTRL) != ((guint) 0)) {
#line 1454 "search.c"
							gboolean _tmp53_ = FALSE;
#line 171 "src/search.vala"
							if (((gchar) (c & 0xff)) == 'r') {
#line 171 "src/search.vala"
								_tmp53_ = TRUE;
#line 1460 "search.c"
							} else {
#line 171 "src/search.vala"
								_tmp53_ = ((gchar) (c & 0xff)) == 's';
#line 1464 "search.c"
							}
#line 171 "src/search.vala"
							_tmp52_ = _tmp53_;
#line 1468 "search.c"
						} else {
#line 171 "src/search.vala"
							_tmp52_ = FALSE;
#line 1472 "search.c"
						}
#line 171 "src/search.vala"
						if (_tmp52_) {
#line 1476 "search.c"
							const gchar* _tmp54_;
							gint _tmp55_;
							gint _tmp56_;
#line 173 "src/search.vala"
							if (((gchar) (c & 0xff)) == 'r') {
#line 174 "src/search.vala"
								forward = FALSE;
#line 1484 "search.c"
							} else {
#line 175 "src/search.vala"
								if (((gchar) (c & 0xff)) == 's') {
#line 176 "src/search.vala"
									forward = TRUE;
#line 1490 "search.c"
								}
							}
#line 177 "src/search.vala"
							_tmp54_ = pattern;
#line 177 "src/search.vala"
							_tmp55_ = strlen (_tmp54_);
#line 177 "src/search.vala"
							_tmp56_ = _tmp55_;
#line 177 "src/search.vala"
							if (_tmp56_ > 0) {
#line 1501 "search.c"
								Buffer* _tmp57_;
								gsize _tmp58_;
								gsize _tmp59_;
								const gchar* _tmp60_;
								gchar* _tmp61_;
#line 179 "src/search.vala"
								_tmp57_ = cur_bp;
#line 179 "src/search.vala"
								_tmp58_ = buffer_get_pt (_tmp57_);
#line 179 "src/search.vala"
								_tmp59_ = _tmp58_;
#line 179 "src/search.vala"
								cur = _tmp59_;
#line 181 "src/search.vala"
								_tmp60_ = pattern;
#line 181 "src/search.vala"
								_tmp61_ = g_strdup (_tmp60_);
#line 181 "src/search.vala"
								_g_free0 (last_search);
#line 181 "src/search.vala"
								last_search = _tmp61_;
#line 1523 "search.c"
							} else {
								const gchar* _tmp62_;
#line 182 "src/search.vala"
								_tmp62_ = last_search;
#line 182 "src/search.vala"
								if (_tmp62_ != NULL) {
#line 1530 "search.c"
									const gchar* _tmp63_;
									gchar* _tmp64_;
#line 183 "src/search.vala"
									_tmp63_ = last_search;
#line 183 "src/search.vala"
									_tmp64_ = g_strdup (_tmp63_);
#line 183 "src/search.vala"
									_g_free0 (pattern);
#line 183 "src/search.vala"
									pattern = _tmp64_;
#line 1541 "search.c"
								}
							}
						} else {
							gboolean _tmp65_ = FALSE;
							gboolean _tmp66_ = FALSE;
#line 184 "src/search.vala"
							if ((c & KBD_META) != ((guint) 0)) {
#line 184 "src/search.vala"
								_tmp66_ = TRUE;
#line 1551 "search.c"
							} else {
#line 184 "src/search.vala"
								_tmp66_ = (c & KBD_CTRL) != ((guint) 0);
#line 1555 "search.c"
							}
#line 184 "src/search.vala"
							if (_tmp66_) {
#line 184 "src/search.vala"
								_tmp65_ = TRUE;
#line 1561 "search.c"
							} else {
#line 184 "src/search.vala"
								_tmp65_ = c > ((guint) KBD_TAB);
#line 1565 "search.c"
							}
#line 184 "src/search.vala"
							if (_tmp65_) {
#line 1569 "search.c"
								gboolean _tmp67_ = FALSE;
#line 185 "src/search.vala"
								if (c == ((guint) KBD_RET)) {
#line 1573 "search.c"
									const gchar* _tmp68_;
									gint _tmp69_;
									gint _tmp70_;
#line 185 "src/search.vala"
									_tmp68_ = pattern;
#line 185 "src/search.vala"
									_tmp69_ = strlen (_tmp68_);
#line 185 "src/search.vala"
									_tmp70_ = _tmp69_;
#line 185 "src/search.vala"
									_tmp67_ = _tmp70_ == 0;
#line 1585 "search.c"
								} else {
#line 185 "src/search.vala"
									_tmp67_ = FALSE;
#line 1589 "search.c"
								}
#line 185 "src/search.vala"
								if (_tmp67_) {
#line 186 "src/search.vala"
									do_search (forward, regexp, NULL);
#line 1595 "search.c"
								} else {
									const gchar* _tmp71_;
									gint _tmp72_;
									gint _tmp73_;
#line 188 "src/search.vala"
									_tmp71_ = pattern;
#line 188 "src/search.vala"
									_tmp72_ = strlen (_tmp71_);
#line 188 "src/search.vala"
									_tmp73_ = _tmp72_;
#line 188 "src/search.vala"
									if (_tmp73_ > 0) {
#line 1608 "search.c"
										Buffer* _tmp74_;
										Marker* _tmp75_;
										const gchar* _tmp76_;
										gchar* _tmp77_;
#line 190 "src/search.vala"
										set_mark ();
#line 191 "src/search.vala"
										_tmp74_ = cur_bp;
#line 191 "src/search.vala"
										_tmp75_ = _tmp74_->mark;
#line 191 "src/search.vala"
										marker_set_o (_tmp75_, start);
#line 194 "src/search.vala"
										_tmp76_ = pattern;
#line 194 "src/search.vala"
										_tmp77_ = g_strdup (_tmp76_);
#line 194 "src/search.vala"
										_g_free0 (last_search);
#line 194 "src/search.vala"
										last_search = _tmp77_;
#line 196 "src/search.vala"
										minibuf_write ("Mark saved when search started", NULL);
#line 1631 "search.c"
									} else {
#line 198 "src/search.vala"
										minibuf_clear ();
#line 1635 "search.c"
									}
#line 199 "src/search.vala"
									if (c != ((guint) KBD_RET)) {
#line 200 "src/search.vala"
										ungetkey (c);
#line 1641 "search.c"
									}
								}
#line 202 "src/search.vala"
								_g_free0 (msg);
#line 202 "src/search.vala"
								break;
#line 1648 "search.c"
							} else {
								const gchar* _tmp78_;
								gchar* _tmp79_;
								gchar* _tmp80_;
								gchar* _tmp81_;
#line 204 "src/search.vala"
								_tmp78_ = pattern;
#line 204 "src/search.vala"
								_tmp79_ = g_strdup_printf ("%c", (gchar) c);
#line 204 "src/search.vala"
								_tmp80_ = _tmp79_;
#line 204 "src/search.vala"
								_tmp81_ = g_strconcat (_tmp78_, _tmp80_, NULL);
#line 204 "src/search.vala"
								_g_free0 (pattern);
#line 204 "src/search.vala"
								pattern = _tmp81_;
#line 204 "src/search.vala"
								_g_free0 (_tmp80_);
#line 1668 "search.c"
							}
						}
					}
				}
			}
#line 206 "src/search.vala"
			_tmp82_ = pattern;
#line 206 "src/search.vala"
			_tmp83_ = strlen (_tmp82_);
#line 206 "src/search.vala"
			_tmp84_ = _tmp83_;
#line 206 "src/search.vala"
			if (_tmp84_ > 0) {
#line 1682 "search.c"
				Buffer* _tmp85_;
				const gchar* _tmp86_;
#line 207 "src/search.vala"
				_tmp85_ = cur_bp;
#line 207 "src/search.vala"
				buffer_goto_offset (_tmp85_, cur);
#line 208 "src/search.vala"
				_tmp86_ = pattern;
#line 208 "src/search.vala"
				last = search (_tmp86_, forward, regexp);
#line 1693 "search.c"
			} else {
#line 210 "src/search.vala"
				last = TRUE;
#line 1697 "search.c"
			}
#line 212 "src/search.vala"
			_tmp87_ = thisflag;
#line 212 "src/search.vala"
			if ((_tmp87_ & FLAGS_NEED_RESYNC) == FLAGS_NEED_RESYNC) {
#line 1703 "search.c"
				Window* _tmp88_;
#line 213 "src/search.vala"
				_tmp88_ = cur_wp;
#line 213 "src/search.vala"
				window_resync (_tmp88_);
#line 214 "src/search.vala"
				term_redisplay ();
#line 1711 "search.c"
			}
#line 123 "src/search.vala"
			_g_free0 (msg);
#line 1715 "search.c"
		}
	}
#line 219 "src/search.vala"
	_tmp89_ = cur_wp;
#line 219 "src/search.vala"
	_tmp90_ = _tmp89_->bp;
#line 219 "src/search.vala"
	_tmp90_->isearch = FALSE;
#line 221 "src/search.vala"
	_tmp91_ = old_mark;
#line 221 "src/search.vala"
	if (_tmp91_ != NULL) {
#line 1728 "search.c"
		Marker* _tmp92_;
#line 222 "src/search.vala"
		_tmp92_ = old_mark;
#line 222 "src/search.vala"
		marker_unchain (_tmp92_);
#line 1734 "search.c"
	}
#line 224 "src/search.vala"
	result = TRUE;
#line 224 "src/search.vala"
	_g_free0 (pattern);
#line 224 "src/search.vala"
	_marker_unref0 (old_mark);
#line 224 "src/search.vala"
	return result;
#line 1744 "search.c"
}

Case
check_case (ImmutableEstr* a)
{
	guint i = 0U;
	gsize _tmp8_;
	gsize _tmp9_;
	Case _tmp18_ = 0;
	gsize _tmp19_;
	gsize _tmp20_;
	Case result = 0;
#line 230 "src/search.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 1759 "search.c"
	{
		gboolean _tmp0_ = FALSE;
#line 232 "src/search.vala"
		i = (guint) 0;
#line 232 "src/search.vala"
		_tmp0_ = TRUE;
#line 232 "src/search.vala"
		while (TRUE) {
#line 1768 "search.c"
			gboolean _tmp2_ = FALSE;
			gsize _tmp3_;
			gsize _tmp4_;
#line 232 "src/search.vala"
			if (!_tmp0_) {
#line 1774 "search.c"
				guint _tmp1_;
#line 232 "src/search.vala"
				_tmp1_ = i;
#line 232 "src/search.vala"
				i = _tmp1_ + 1;
#line 1780 "search.c"
			}
#line 232 "src/search.vala"
			_tmp0_ = FALSE;
#line 232 "src/search.vala"
			_tmp3_ = immutable_estr_get_length (a);
#line 232 "src/search.vala"
			_tmp4_ = _tmp3_;
#line 232 "src/search.vala"
			if (((gsize) i) < _tmp4_) {
#line 1790 "search.c"
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar _tmp7_;
#line 232 "src/search.vala"
				_tmp5_ = immutable_estr_get_text (a);
#line 232 "src/search.vala"
				_tmp6_ = _tmp5_;
#line 232 "src/search.vala"
				_tmp7_ = _tmp6_[i];
#line 232 "src/search.vala"
				_tmp2_ = g_ascii_isupper (_tmp7_);
#line 1802 "search.c"
			} else {
#line 232 "src/search.vala"
				_tmp2_ = FALSE;
#line 1806 "search.c"
			}
#line 232 "src/search.vala"
			if (!_tmp2_) {
#line 232 "src/search.vala"
				break;
#line 1812 "search.c"
			}
		}
	}
#line 234 "src/search.vala"
	_tmp8_ = immutable_estr_get_length (a);
#line 234 "src/search.vala"
	_tmp9_ = _tmp8_;
#line 234 "src/search.vala"
	if (((gsize) i) == _tmp9_) {
#line 235 "src/search.vala"
		result = CASE_upper;
#line 235 "src/search.vala"
		return result;
#line 1826 "search.c"
	} else {
#line 236 "src/search.vala"
		if (i == ((guint) 1)) {
#line 1830 "search.c"
			{
				gboolean _tmp10_ = FALSE;
#line 237 "src/search.vala"
				_tmp10_ = TRUE;
#line 237 "src/search.vala"
				while (TRUE) {
#line 1837 "search.c"
					gboolean _tmp12_ = FALSE;
					gsize _tmp13_;
					gsize _tmp14_;
#line 237 "src/search.vala"
					if (!_tmp10_) {
#line 1843 "search.c"
						guint _tmp11_;
#line 237 "src/search.vala"
						_tmp11_ = i;
#line 237 "src/search.vala"
						i = _tmp11_ + 1;
#line 1849 "search.c"
					}
#line 237 "src/search.vala"
					_tmp10_ = FALSE;
#line 237 "src/search.vala"
					_tmp13_ = immutable_estr_get_length (a);
#line 237 "src/search.vala"
					_tmp14_ = _tmp13_;
#line 237 "src/search.vala"
					if (((gsize) i) < _tmp14_) {
#line 1859 "search.c"
						gchar* _tmp15_;
						gchar* _tmp16_;
						gchar _tmp17_;
#line 237 "src/search.vala"
						_tmp15_ = immutable_estr_get_text (a);
#line 237 "src/search.vala"
						_tmp16_ = _tmp15_;
#line 237 "src/search.vala"
						_tmp17_ = _tmp16_[i];
#line 237 "src/search.vala"
						_tmp12_ = !g_ascii_isupper (_tmp17_);
#line 1871 "search.c"
					} else {
#line 237 "src/search.vala"
						_tmp12_ = FALSE;
#line 1875 "search.c"
					}
#line 237 "src/search.vala"
					if (!_tmp12_) {
#line 237 "src/search.vala"
						break;
#line 1881 "search.c"
					}
				}
			}
		}
	}
#line 239 "src/search.vala"
	_tmp19_ = immutable_estr_get_length (a);
#line 239 "src/search.vala"
	_tmp20_ = _tmp19_;
#line 239 "src/search.vala"
	if (((gsize) i) == _tmp20_) {
#line 239 "src/search.vala"
		_tmp18_ = CASE_capitalized;
#line 1895 "search.c"
	} else {
#line 239 "src/search.vala"
		_tmp18_ = CASE_lower;
#line 1899 "search.c"
	}
#line 239 "src/search.vala"
	result = _tmp18_;
#line 239 "src/search.vala"
	return result;
#line 1905 "search.c"
}

static gboolean
__lambda123_ (glong uniarg,
              GeeQueue* args)
{
	gchar* pattern = NULL;
	gpointer _tmp0_;
	gboolean result = FALSE;
#line 247 "src/search.vala"
	_tmp0_ = gee_queue_poll (args);
#line 247 "src/search.vala"
	pattern = (gchar*) _tmp0_;
#line 248 "src/search.vala"
	result = do_search (TRUE, FALSE, pattern);
#line 248 "src/search.vala"
	_g_free0 (pattern);
#line 248 "src/search.vala"
	return result;
#line 1925 "search.c"
}

static gboolean
___lambda123__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda123_ (uniarg, args);
#line 244 "src/search.vala"
	return result;
#line 1936 "search.c"
}

static gboolean
__lambda124_ (glong uniarg,
              GeeQueue* args)
{
	gchar* pattern = NULL;
	gpointer _tmp0_;
	gboolean result = FALSE;
#line 257 "src/search.vala"
	_tmp0_ = gee_queue_poll (args);
#line 257 "src/search.vala"
	pattern = (gchar*) _tmp0_;
#line 258 "src/search.vala"
	result = do_search (FALSE, FALSE, pattern);
#line 258 "src/search.vala"
	_g_free0 (pattern);
#line 258 "src/search.vala"
	return result;
#line 1956 "search.c"
}

static gboolean
___lambda124__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda124_ (uniarg, args);
#line 254 "src/search.vala"
	return result;
#line 1967 "search.c"
}

static gboolean
__lambda125_ (glong uniarg,
              GeeQueue* args)
{
	gchar* pattern = NULL;
	gpointer _tmp0_;
	gboolean result = FALSE;
#line 267 "src/search.vala"
	_tmp0_ = gee_queue_poll (args);
#line 267 "src/search.vala"
	pattern = (gchar*) _tmp0_;
#line 268 "src/search.vala"
	result = do_search (TRUE, TRUE, pattern);
#line 268 "src/search.vala"
	_g_free0 (pattern);
#line 268 "src/search.vala"
	return result;
#line 1987 "search.c"
}

static gboolean
___lambda125__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda125_ (uniarg, args);
#line 264 "src/search.vala"
	return result;
#line 1998 "search.c"
}

static gboolean
__lambda126_ (glong uniarg,
              GeeQueue* args)
{
	gchar* pattern = NULL;
	gpointer _tmp0_;
	gboolean result = FALSE;
#line 277 "src/search.vala"
	_tmp0_ = gee_queue_poll (args);
#line 277 "src/search.vala"
	pattern = (gchar*) _tmp0_;
#line 278 "src/search.vala"
	result = do_search (FALSE, TRUE, pattern);
#line 278 "src/search.vala"
	_g_free0 (pattern);
#line 278 "src/search.vala"
	return result;
#line 2018 "search.c"
}

static gboolean
___lambda126__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda126_ (uniarg, args);
#line 274 "src/search.vala"
	return result;
#line 2029 "search.c"
}

static gboolean
__lambda127_ (glong uniarg,
              GeeQueue* args)
{
	Flags _tmp0_;
	gboolean result = FALSE;
#line 287 "src/search.vala"
	_tmp0_ = lastflag;
#line 287 "src/search.vala"
	result = isearch (TRUE, (_tmp0_ & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG);
#line 287 "src/search.vala"
	return result;
#line 2044 "search.c"
}

static gboolean
___lambda127__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda127_ (uniarg, args);
#line 284 "src/search.vala"
	return result;
#line 2055 "search.c"
}

static gboolean
__lambda128_ (glong uniarg,
              GeeQueue* args)
{
	Flags _tmp0_;
	gboolean result = FALSE;
#line 303 "src/search.vala"
	_tmp0_ = lastflag;
#line 303 "src/search.vala"
	result = isearch (FALSE, (_tmp0_ & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG);
#line 303 "src/search.vala"
	return result;
#line 2070 "search.c"
}

static gboolean
___lambda128__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda128_ (uniarg, args);
#line 300 "src/search.vala"
	return result;
#line 2081 "search.c"
}

static gboolean
__lambda129_ (glong uniarg,
              GeeQueue* args)
{
	Flags _tmp0_;
	gboolean result = FALSE;
#line 314 "src/search.vala"
	_tmp0_ = lastflag;
#line 314 "src/search.vala"
	result = isearch (TRUE, !((_tmp0_ & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG));
#line 314 "src/search.vala"
	return result;
#line 2096 "search.c"
}

static gboolean
___lambda129__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda129_ (uniarg, args);
#line 311 "src/search.vala"
	return result;
#line 2107 "search.c"
}

static gboolean
__lambda130_ (glong uniarg,
              GeeQueue* args)
{
	Flags _tmp0_;
	gboolean result = FALSE;
#line 326 "src/search.vala"
	_tmp0_ = lastflag;
#line 326 "src/search.vala"
	result = isearch (FALSE, !((_tmp0_ & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG));
#line 326 "src/search.vala"
	return result;
#line 2122 "search.c"
}

static gboolean
___lambda130__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda130_ (uniarg, args);
#line 323 "src/search.vala"
	return result;
#line 2133 "search.c"
}

static gboolean
__lambda131_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	gchar* find = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean find_no_upper = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* repl = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean noask = FALSE;
	gsize count = 0UL;
	Flags _tmp71_;
	gboolean result = FALSE;
#line 338 "src/search.vala"
	ok = TRUE;
#line 339 "src/search.vala"
	_tmp0_ = minibuf_read ("Query replace string: ", "", NULL);
#line 339 "src/search.vala"
	find = _tmp0_;
#line 340 "src/search.vala"
	_tmp1_ = find;
#line 340 "src/search.vala"
	if (_tmp1_ == NULL) {
#line 341 "src/search.vala"
		result = funcall ("keyboard-quit", NULL);
#line 341 "src/search.vala"
		_g_free0 (find);
#line 341 "src/search.vala"
		return result;
#line 2176 "search.c"
	}
#line 342 "src/search.vala"
	_tmp2_ = find;
#line 342 "src/search.vala"
	_tmp3_ = strlen (_tmp2_);
#line 342 "src/search.vala"
	_tmp4_ = _tmp3_;
#line 342 "src/search.vala"
	if (_tmp4_ == 0) {
#line 343 "src/search.vala"
		result = FALSE;
#line 343 "src/search.vala"
		_g_free0 (find);
#line 343 "src/search.vala"
		return result;
#line 2192 "search.c"
	}
#line 344 "src/search.vala"
	_tmp5_ = find;
#line 344 "src/search.vala"
	_tmp6_ = find;
#line 344 "src/search.vala"
	_tmp7_ = strlen (_tmp6_);
#line 344 "src/search.vala"
	_tmp8_ = _tmp7_;
#line 344 "src/search.vala"
	find_no_upper = no_upper (_tmp5_, (guint) _tmp8_, FALSE);
#line 346 "src/search.vala"
	_tmp9_ = find;
#line 346 "src/search.vala"
	_tmp10_ = minibuf_read ("Query replace `%s' with: ", "", _tmp9_, NULL);
#line 346 "src/search.vala"
	repl = _tmp10_;
#line 347 "src/search.vala"
	_tmp11_ = repl;
#line 347 "src/search.vala"
	if (_tmp11_ == NULL) {
#line 348 "src/search.vala"
		result = funcall ("keyboard-quit", NULL);
#line 348 "src/search.vala"
		_g_free0 (repl);
#line 348 "src/search.vala"
		_g_free0 (find);
#line 348 "src/search.vala"
		return result;
#line 2222 "search.c"
	}
#line 350 "src/search.vala"
	noask = FALSE;
#line 351 "src/search.vala"
	count = (gsize) 0;
#line 352 "src/search.vala"
	while (TRUE) {
#line 2230 "search.c"
		const gchar* _tmp12_;
		guint c = 0U;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
#line 352 "src/search.vala"
		_tmp12_ = find;
#line 352 "src/search.vala"
		if (!search (_tmp12_, TRUE, FALSE)) {
#line 352 "src/search.vala"
			break;
#line 2244 "search.c"
		}
#line 353 "src/search.vala"
		c = (guint) ' ';
#line 355 "src/search.vala"
		if (!noask) {
#line 2250 "search.c"
			Flags _tmp13_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
#line 356 "src/search.vala"
			_tmp13_ = thisflag;
#line 356 "src/search.vala"
			if ((_tmp13_ & FLAGS_NEED_RESYNC) == FLAGS_NEED_RESYNC) {
#line 2258 "search.c"
				Window* _tmp14_;
#line 357 "src/search.vala"
				_tmp14_ = cur_wp;
#line 357 "src/search.vala"
				window_resync (_tmp14_);
#line 2264 "search.c"
			}
#line 359 "src/search.vala"
			_tmp15_ = find;
#line 359 "src/search.vala"
			_tmp16_ = repl;
#line 359 "src/search.vala"
			minibuf_write ("Query replacing `%s' with `%s' (y, n, !, ., q)? ", _tmp15_, _tmp16_, NULL);
#line 360 "src/search.vala"
			c = (guint) getkey (GETKEY_DEFAULT);
#line 361 "src/search.vala"
			minibuf_clear ();
#line 363 "src/search.vala"
			if (c == ((guint) 'q')) {
#line 364 "src/search.vala"
				break;
#line 2280 "search.c"
			} else {
#line 365 "src/search.vala"
				if (c == ((guint) KBD_CANCEL)) {
#line 366 "src/search.vala"
					ok = funcall ("keyboard-quit", NULL);
#line 367 "src/search.vala"
					break;
#line 2288 "search.c"
				} else {
#line 368 "src/search.vala"
					if (c == ((guint) '!')) {
#line 369 "src/search.vala"
						noask = TRUE;
#line 2294 "search.c"
					}
				}
			}
		}
#line 372 "src/search.vala"
		if (c == ((guint) KBD_RET)) {
#line 372 "src/search.vala"
			_tmp21_ = TRUE;
#line 2303 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp21_ = c == ((guint) ' ');
#line 2307 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp21_) {
#line 372 "src/search.vala"
			_tmp20_ = TRUE;
#line 2313 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp20_ = c == ((guint) 'y');
#line 2317 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp20_) {
#line 372 "src/search.vala"
			_tmp19_ = TRUE;
#line 2323 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp19_ = c == ((guint) 'Y');
#line 2327 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp19_) {
#line 372 "src/search.vala"
			_tmp18_ = TRUE;
#line 2333 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp18_ = c == ((guint) '.');
#line 2337 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp18_) {
#line 372 "src/search.vala"
			_tmp17_ = TRUE;
#line 2343 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp17_ = c == ((guint) '!');
#line 2347 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp17_) {
#line 2351 "search.c"
			gsize _tmp22_;
			gchar* case_repl = NULL;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			Region* r = NULL;
			Buffer* _tmp25_;
			gsize _tmp26_;
			gsize _tmp27_;
			const gchar* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			Buffer* _tmp31_;
			gsize _tmp32_;
			gsize _tmp33_;
			Region* _tmp34_;
			gboolean _tmp35_ = FALSE;
			Marker* m = NULL;
			Marker* _tmp45_;
			Buffer* _tmp46_;
			Region* _tmp47_;
			gsize _tmp48_;
			gsize _tmp49_;
			Buffer* _tmp50_;
			const gchar* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			Buffer* _tmp58_;
			const gchar* _tmp59_;
			const gchar* _tmp60_;
			ImmutableEstr* _tmp61_;
			ImmutableEstr* _tmp62_;
			Buffer* _tmp63_;
			Marker* _tmp64_;
			gsize _tmp65_;
			gsize _tmp66_;
			Marker* _tmp67_;
#line 373 "src/search.vala"
			count = count + 1;
#line 373 "src/search.vala"
			_tmp22_ = count;
#line 374 "src/search.vala"
			_tmp23_ = repl;
#line 374 "src/search.vala"
			_tmp24_ = g_strdup (_tmp23_);
#line 374 "src/search.vala"
			case_repl = _tmp24_;
#line 375 "src/search.vala"
			_tmp25_ = cur_bp;
#line 375 "src/search.vala"
			_tmp26_ = buffer_get_pt (_tmp25_);
#line 375 "src/search.vala"
			_tmp27_ = _tmp26_;
#line 375 "src/search.vala"
			_tmp28_ = find;
#line 375 "src/search.vala"
			_tmp29_ = strlen (_tmp28_);
#line 375 "src/search.vala"
			_tmp30_ = _tmp29_;
#line 375 "src/search.vala"
			_tmp31_ = cur_bp;
#line 375 "src/search.vala"
			_tmp32_ = buffer_get_pt (_tmp31_);
#line 375 "src/search.vala"
			_tmp33_ = _tmp32_;
#line 375 "src/search.vala"
			_tmp34_ = region_new (_tmp27_ - _tmp30_, _tmp33_);
#line 375 "src/search.vala"
			r = _tmp34_;
#line 376 "src/search.vala"
			if (find_no_upper) {
#line 376 "src/search.vala"
				_tmp35_ = get_variable_bool ("case-replace");
#line 2428 "search.c"
			} else {
#line 376 "src/search.vala"
				_tmp35_ = FALSE;
#line 2432 "search.c"
			}
#line 376 "src/search.vala"
			if (_tmp35_) {
#line 2436 "search.c"
				Case case_type = 0;
				Buffer* _tmp36_;
				Region* _tmp37_;
				ImmutableEstr* _tmp38_;
				ImmutableEstr* _tmp39_;
				Case _tmp40_;
				Case _tmp41_;
#line 377 "src/search.vala"
				_tmp36_ = cur_bp;
#line 377 "src/search.vala"
				_tmp37_ = r;
#line 377 "src/search.vala"
				_tmp38_ = buffer_get_region (_tmp36_, _tmp37_);
#line 377 "src/search.vala"
				_tmp39_ = _tmp38_;
#line 377 "src/search.vala"
				_tmp40_ = check_case (_tmp39_);
#line 377 "src/search.vala"
				_immutable_estr_unref0 (_tmp39_);
#line 377 "src/search.vala"
				case_type = _tmp40_;
#line 378 "src/search.vala"
				_tmp41_ = case_type;
#line 378 "src/search.vala"
				if (_tmp41_ != CASE_lower) {
#line 2462 "search.c"
					const gchar* _tmp42_;
					Case _tmp43_;
					gchar* _tmp44_;
#line 379 "src/search.vala"
					_tmp42_ = repl;
#line 379 "src/search.vala"
					_tmp43_ = case_type;
#line 379 "src/search.vala"
					_tmp44_ = recase (_tmp42_, _tmp43_);
#line 379 "src/search.vala"
					_g_free0 (repl);
#line 379 "src/search.vala"
					repl = _tmp44_;
#line 2476 "search.c"
				}
			}
#line 382 "src/search.vala"
			_tmp45_ = marker_point ();
#line 382 "src/search.vala"
			m = _tmp45_;
#line 383 "src/search.vala"
			_tmp46_ = cur_bp;
#line 383 "src/search.vala"
			_tmp47_ = r;
#line 383 "src/search.vala"
			_tmp48_ = region_get_start (_tmp47_);
#line 383 "src/search.vala"
			_tmp49_ = _tmp48_;
#line 383 "src/search.vala"
			buffer_goto_offset (_tmp46_, _tmp49_);
#line 384 "src/search.vala"
			_tmp50_ = cur_bp;
#line 384 "src/search.vala"
			_tmp51_ = find;
#line 384 "src/search.vala"
			_tmp52_ = strlen (_tmp51_);
#line 384 "src/search.vala"
			_tmp53_ = _tmp52_;
#line 384 "src/search.vala"
			_tmp54_ = case_repl;
#line 384 "src/search.vala"
			_tmp55_ = case_repl;
#line 384 "src/search.vala"
			_tmp56_ = strlen (_tmp55_);
#line 384 "src/search.vala"
			_tmp57_ = _tmp56_;
#line 384 "src/search.vala"
			_tmp58_ = cur_bp;
#line 384 "src/search.vala"
			_tmp59_ = buffer_get_eol (_tmp58_);
#line 384 "src/search.vala"
			_tmp60_ = _tmp59_;
#line 384 "src/search.vala"
			_tmp61_ = immutable_estr_of (_tmp54_, (gsize) _tmp57_, _tmp60_);
#line 384 "src/search.vala"
			_tmp62_ = _tmp61_;
#line 384 "src/search.vala"
			buffer_replace_estr (_tmp50_, (gsize) _tmp53_, _tmp62_);
#line 384 "src/search.vala"
			_immutable_estr_unref0 (_tmp62_);
#line 385 "src/search.vala"
			_tmp63_ = cur_bp;
#line 385 "src/search.vala"
			_tmp64_ = m;
#line 385 "src/search.vala"
			_tmp65_ = marker_get_o (_tmp64_);
#line 385 "src/search.vala"
			_tmp66_ = _tmp65_;
#line 385 "src/search.vala"
			buffer_goto_offset (_tmp63_, _tmp66_);
#line 386 "src/search.vala"
			_tmp67_ = m;
#line 386 "src/search.vala"
			marker_unchain (_tmp67_);
#line 388 "src/search.vala"
			if (c == ((guint) '.')) {
#line 389 "src/search.vala"
				_marker_unref0 (m);
#line 389 "src/search.vala"
				_region_unref0 (r);
#line 389 "src/search.vala"
				_g_free0 (case_repl);
#line 389 "src/search.vala"
				break;
#line 2547 "search.c"
			}
#line 372 "src/search.vala"
			_marker_unref0 (m);
#line 372 "src/search.vala"
			_region_unref0 (r);
#line 372 "src/search.vala"
			_g_free0 (case_repl);
#line 2555 "search.c"
		} else {
			gboolean _tmp68_ = FALSE;
			gboolean _tmp69_ = FALSE;
			gboolean _tmp70_ = FALSE;
#line 390 "src/search.vala"
			if (c == ((guint) KBD_RET)) {
#line 390 "src/search.vala"
				_tmp70_ = TRUE;
#line 2564 "search.c"
			} else {
#line 390 "src/search.vala"
				_tmp70_ = c == ((guint) KBD_DEL);
#line 2568 "search.c"
			}
#line 390 "src/search.vala"
			if (_tmp70_) {
#line 390 "src/search.vala"
				_tmp69_ = TRUE;
#line 2574 "search.c"
			} else {
#line 390 "src/search.vala"
				_tmp69_ = c == ((guint) 'n');
#line 2578 "search.c"
			}
#line 390 "src/search.vala"
			if (_tmp69_) {
#line 390 "src/search.vala"
				_tmp68_ = TRUE;
#line 2584 "search.c"
			} else {
#line 390 "src/search.vala"
				_tmp68_ = c == ((guint) 'N');
#line 2588 "search.c"
			}
#line 390 "src/search.vala"
			if (!_tmp68_) {
#line 391 "src/search.vala"
				ungetkey (c);
#line 392 "src/search.vala"
				ok = FALSE;
#line 393 "src/search.vala"
				break;
#line 2598 "search.c"
			}
		}
	}
#line 397 "src/search.vala"
	_tmp71_ = thisflag;
#line 397 "src/search.vala"
	if ((_tmp71_ & FLAGS_NEED_RESYNC) == FLAGS_NEED_RESYNC) {
#line 2606 "search.c"
		Window* _tmp72_;
#line 398 "src/search.vala"
		_tmp72_ = cur_wp;
#line 398 "src/search.vala"
		window_resync (_tmp72_);
#line 2612 "search.c"
	}
#line 400 "src/search.vala"
	if (ok) {
#line 401 "src/search.vala"
		minibuf_write ("Replaced %zu occurrences", count, NULL);
#line 2618 "search.c"
	}
#line 403 "src/search.vala"
	result = ok;
#line 403 "src/search.vala"
	_g_free0 (repl);
#line 403 "src/search.vala"
	_g_free0 (find);
#line 403 "src/search.vala"
	return result;
#line 2628 "search.c"
}

static gboolean
___lambda131__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda131_ (uniarg, args);
#line 335 "src/search.vala"
	return result;
#line 2639 "search.c"
}

void
search_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
	LispFunc* _tmp8_;
	LispFunc* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	LispFunc* _tmp13_;
	LispFunc* _tmp14_;
	LispFunc* _tmp15_;
	LispFunc* _tmp16_;
	LispFunc* _tmp17_;
#line 244 "src/search.vala"
	_tmp0_ = lisp_func_new ("search-forward", ___lambda123__function, TRUE, "Search forward from point for the user specified text.");
#line 244 "src/search.vala"
	_tmp1_ = _tmp0_;
#line 244 "src/search.vala"
	_lisp_func_unref0 (_tmp1_);
#line 254 "src/search.vala"
	_tmp2_ = lisp_func_new ("search-backward", ___lambda124__function, TRUE, "Search backward from point for the user specified text.");
#line 254 "src/search.vala"
	_tmp3_ = _tmp2_;
#line 254 "src/search.vala"
	_lisp_func_unref0 (_tmp3_);
#line 264 "src/search.vala"
	_tmp4_ = lisp_func_new ("search-forward-regexp", ___lambda125__function, TRUE, "Search forward from point for regular expression REGEXP.");
#line 264 "src/search.vala"
	_tmp5_ = _tmp4_;
#line 264 "src/search.vala"
	_lisp_func_unref0 (_tmp5_);
#line 274 "src/search.vala"
	_tmp6_ = lisp_func_new ("search-backward-regexp", ___lambda126__function, TRUE, "Search backward from point for match for regular expression REGEXP.");
#line 274 "src/search.vala"
	_tmp7_ = _tmp6_;
#line 274 "src/search.vala"
	_lisp_func_unref0 (_tmp7_);
#line 284 "src/search.vala"
	_tmp8_ = lisp_func_new ("isearch-forward", ___lambda127__function, TRUE, "Do incremental search forward.\n" \
"With a prefix argument, do an incremental regular expression search in" \
"stead.\n" \
"\n" \
"As you type characters, they add to the search string and are found.\n" \
"\n" \
"Type \\\\[isearch-exit] to exit, leaving point at location found.\n" \
"Type \\\\[isearch-repeat-forward] to search again forward, \\\\[isearc" \
"h-repeat-backward] to search again backward.\n" \
"\\\\[isearch-abort] when search is successful aborts and moves point t" \
"o starting point.");
#line 284 "src/search.vala"
	_tmp9_ = _tmp8_;
#line 284 "src/search.vala"
	_lisp_func_unref0 (_tmp9_);
#line 300 "src/search.vala"
	_tmp10_ = lisp_func_new ("isearch-backward", ___lambda128__function, TRUE, "Do incremental search backward.\n" \
"With a prefix argument, do a regular expression search instead.\n" \
"See the command `isearch-forward' for more information.");
#line 300 "src/search.vala"
	_tmp11_ = _tmp10_;
#line 300 "src/search.vala"
	_lisp_func_unref0 (_tmp11_);
#line 311 "src/search.vala"
	_tmp12_ = lisp_func_new ("isearch-forward-regexp", ___lambda129__function, TRUE, "Do incremental search forward for regular expression.\n" \
"With a prefix argument, do a regular string search instead.\n" \
"Like ordinary incremental search except that your input is treated\n" \
"as a regexp.  See the command `isearch-forward' for more information.");
#line 311 "src/search.vala"
	_tmp13_ = _tmp12_;
#line 311 "src/search.vala"
	_lisp_func_unref0 (_tmp13_);
#line 323 "src/search.vala"
	_tmp14_ = lisp_func_new ("isearch-backward-regexp", ___lambda130__function, TRUE, "Do incremental search backward for regular expression.\n" \
"With a prefix argument, do a regular string search instead.\n" \
"Like ordinary incremental search except that your input is treated\n" \
"as a regexp.  See the command `isearch-forward-regexp` for more inform" \
"ation.");
#line 323 "src/search.vala"
	_tmp15_ = _tmp14_;
#line 323 "src/search.vala"
	_lisp_func_unref0 (_tmp15_);
#line 335 "src/search.vala"
	_tmp16_ = lisp_func_new ("query-replace", ___lambda131__function, TRUE, "Replace occurrences of a string with other text.\n" \
"As each match is found, the user must type a character saying\n" \
"what to do with it.");
#line 335 "src/search.vala"
	_tmp17_ = _tmp16_;
#line 335 "src/search.vala"
	_lisp_func_unref0 (_tmp17_);
#line 2717 "search.c"
}

