/* macro.c generated by valac 0.50.1.44-10688, the Vala compiler
 * generated from macro.vala, do not modify */

/* Macro facility functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_MACRO (macro_get_type ())
#define MACRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MACRO, Macro))
#define MACRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MACRO, MacroClass))
#define IS_MACRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MACRO))
#define IS_MACRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MACRO))
#define MACRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MACRO, MacroClass))

typedef struct _Macro Macro;
typedef struct _MacroClass MacroClass;
typedef struct _MacroPrivate MacroPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecMacro ParamSpecMacro;
#define _macro_unref0(var) ((var == NULL) ? NULL : (var = (macro_unref (var), NULL)))
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
typedef gboolean (*MovementDelegate) (gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Macro {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MacroPrivate * priv;
	GeeList* keys;
};

struct _MacroClass {
	GTypeClass parent_class;
	void (*finalize) (Macro *self);
};

struct _ParamSpecMacro {
	GParamSpec parent_instance;
};

static gpointer macro_parent_class = NULL;
extern Macro* cur_mp;
Macro* cur_mp = NULL;
extern Macro* cmd_mp;
Macro* cmd_mp = NULL;
extern Flags thisflag;
extern GeeList* macro_keys;
GeeList* macro_keys = NULL;

gpointer macro_ref (gpointer instance);
void macro_unref (gpointer instance);
GParamSpec* param_spec_macro (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
void value_set_macro (GValue* value,
                      gpointer v_object);
void value_take_macro (GValue* value,
                       gpointer v_object);
gpointer value_get_macro (const GValue* value);
GType macro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Macro, macro_unref)
Macro* macro_new (void);
Macro* macro_construct (GType object_type);
static void macro_finalize (Macro * obj);
static GType macro_get_type_once (void);
void add_cmd_to_macro (void);
void add_key_to_cmd (guint key);
void remove_key_from_cmd (void);
void cancel_kbd_macro (void);
GType flags_get_type (void) G_GNUC_CONST ;
void process_keys (GeeList* keys);
guint term_buf_len (void);
void pushkey (guint key);
void get_and_run_command (void);
gboolean call_macro (void);
void macro_init (void);
static gboolean __lambda114_ (glong uniarg,
                       GeeQueue* args);
void minibuf_error (const gchar* fmt,
                    ...);
void minibuf_write (const gchar* fmt,
                    ...);
static gboolean ___lambda114__function (glong uniarg,
                                 GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda115_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda115__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda116_ (glong uniarg,
                       GeeQueue* args);
gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _call_macro_movement_delegate (gpointer self);
static gboolean ___lambda116__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda117_ (glong uniarg,
                       GeeQueue* args);
GeeList* keystrtovec (const gchar* key);
static gboolean ___lambda117__function (glong uniarg,
                                 GeeQueue* args);

Macro*
macro_construct (GType object_type)
{
	Macro* self = NULL;
	GeeArrayList* _tmp0_;
#line 25 "src/macro.vala"
	self = (Macro*) g_type_create_instance (object_type);
#line 26 "src/macro.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 26 "src/macro.vala"
	_g_object_unref0 (self->keys);
#line 26 "src/macro.vala"
	self->keys = (GeeList*) _tmp0_;
#line 25 "src/macro.vala"
	return self;
#line 191 "macro.c"
}

Macro*
macro_new (void)
{
#line 25 "src/macro.vala"
	return macro_construct (TYPE_MACRO);
#line 199 "macro.c"
}

static void
value_macro_init (GValue* value)
{
#line 22 "src/macro.vala"
	value->data[0].v_pointer = NULL;
#line 207 "macro.c"
}

static void
value_macro_free_value (GValue* value)
{
#line 22 "src/macro.vala"
	if (value->data[0].v_pointer) {
#line 22 "src/macro.vala"
		macro_unref (value->data[0].v_pointer);
#line 217 "macro.c"
	}
}

static void
value_macro_copy_value (const GValue* src_value,
                        GValue* dest_value)
{
#line 22 "src/macro.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "src/macro.vala"
		dest_value->data[0].v_pointer = macro_ref (src_value->data[0].v_pointer);
#line 229 "macro.c"
	} else {
#line 22 "src/macro.vala"
		dest_value->data[0].v_pointer = NULL;
#line 233 "macro.c"
	}
}

static gpointer
value_macro_peek_pointer (const GValue* value)
{
#line 22 "src/macro.vala"
	return value->data[0].v_pointer;
#line 242 "macro.c"
}

static gchar*
value_macro_collect_value (GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
#line 22 "src/macro.vala"
	if (collect_values[0].v_pointer) {
#line 253 "macro.c"
		Macro * object;
		object = collect_values[0].v_pointer;
#line 22 "src/macro.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "src/macro.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 260 "macro.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "src/macro.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 264 "macro.c"
		}
#line 22 "src/macro.vala"
		value->data[0].v_pointer = macro_ref (object);
#line 268 "macro.c"
	} else {
#line 22 "src/macro.vala"
		value->data[0].v_pointer = NULL;
#line 272 "macro.c"
	}
#line 22 "src/macro.vala"
	return NULL;
#line 276 "macro.c"
}

static gchar*
value_macro_lcopy_value (const GValue* value,
                         guint n_collect_values,
                         GTypeCValue* collect_values,
                         guint collect_flags)
{
	Macro ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "src/macro.vala"
	if (!object_p) {
#line 22 "src/macro.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 291 "macro.c"
	}
#line 22 "src/macro.vala"
	if (!value->data[0].v_pointer) {
#line 22 "src/macro.vala"
		*object_p = NULL;
#line 297 "macro.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "src/macro.vala"
		*object_p = value->data[0].v_pointer;
#line 301 "macro.c"
	} else {
#line 22 "src/macro.vala"
		*object_p = macro_ref (value->data[0].v_pointer);
#line 305 "macro.c"
	}
#line 22 "src/macro.vala"
	return NULL;
#line 309 "macro.c"
}

GParamSpec*
param_spec_macro (const gchar* name,
                  const gchar* nick,
                  const gchar* blurb,
                  GType object_type,
                  GParamFlags flags)
{
	ParamSpecMacro* spec;
#line 22 "src/macro.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MACRO), NULL);
#line 22 "src/macro.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "src/macro.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "src/macro.vala"
	return G_PARAM_SPEC (spec);
#line 328 "macro.c"
}

gpointer
value_get_macro (const GValue* value)
{
#line 22 "src/macro.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MACRO), NULL);
#line 22 "src/macro.vala"
	return value->data[0].v_pointer;
#line 338 "macro.c"
}

void
value_set_macro (GValue* value,
                 gpointer v_object)
{
	Macro * old;
#line 22 "src/macro.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MACRO));
#line 22 "src/macro.vala"
	old = value->data[0].v_pointer;
#line 22 "src/macro.vala"
	if (v_object) {
#line 22 "src/macro.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MACRO));
#line 22 "src/macro.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "src/macro.vala"
		value->data[0].v_pointer = v_object;
#line 22 "src/macro.vala"
		macro_ref (value->data[0].v_pointer);
#line 360 "macro.c"
	} else {
#line 22 "src/macro.vala"
		value->data[0].v_pointer = NULL;
#line 364 "macro.c"
	}
#line 22 "src/macro.vala"
	if (old) {
#line 22 "src/macro.vala"
		macro_unref (old);
#line 370 "macro.c"
	}
}

void
value_take_macro (GValue* value,
                  gpointer v_object)
{
	Macro * old;
#line 22 "src/macro.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MACRO));
#line 22 "src/macro.vala"
	old = value->data[0].v_pointer;
#line 22 "src/macro.vala"
	if (v_object) {
#line 22 "src/macro.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MACRO));
#line 22 "src/macro.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "src/macro.vala"
		value->data[0].v_pointer = v_object;
#line 391 "macro.c"
	} else {
#line 22 "src/macro.vala"
		value->data[0].v_pointer = NULL;
#line 395 "macro.c"
	}
#line 22 "src/macro.vala"
	if (old) {
#line 22 "src/macro.vala"
		macro_unref (old);
#line 401 "macro.c"
	}
}

static void
macro_class_init (MacroClass * klass,
                  gpointer klass_data)
{
#line 22 "src/macro.vala"
	macro_parent_class = g_type_class_peek_parent (klass);
#line 22 "src/macro.vala"
	((MacroClass *) klass)->finalize = macro_finalize;
#line 413 "macro.c"
}

static void
macro_instance_init (Macro * self,
                     gpointer klass)
{
#line 22 "src/macro.vala"
	self->ref_count = 1;
#line 422 "macro.c"
}

static void
macro_finalize (Macro * obj)
{
	Macro * self;
#line 22 "src/macro.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MACRO, Macro);
#line 22 "src/macro.vala"
	g_signal_handlers_destroy (self);
#line 23 "src/macro.vala"
	_g_object_unref0 (self->keys);
#line 435 "macro.c"
}

static GType
macro_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_macro_init, value_macro_free_value, value_macro_copy_value, value_macro_peek_pointer, "p", value_macro_collect_value, "p", value_macro_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MacroClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) macro_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Macro), 0, (GInstanceInitFunc) macro_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType macro_type_id;
	macro_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Macro", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return macro_type_id;
}

GType
macro_get_type (void)
{
	static volatile gsize macro_type_id__volatile = 0;
	if (g_once_init_enter (&macro_type_id__volatile)) {
		GType macro_type_id;
		macro_type_id = macro_get_type_once ();
		g_once_init_leave (&macro_type_id__volatile, macro_type_id);
	}
	return macro_type_id__volatile;
}

gpointer
macro_ref (gpointer instance)
{
	Macro * self;
	self = instance;
#line 22 "src/macro.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "src/macro.vala"
	return instance;
#line 470 "macro.c"
}

void
macro_unref (gpointer instance)
{
	Macro * self;
	self = instance;
#line 22 "src/macro.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "src/macro.vala"
		MACRO_GET_CLASS (self)->finalize (self);
#line 22 "src/macro.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 484 "macro.c"
	}
}

void
add_cmd_to_macro (void)
{
	Macro* _tmp0_;
	Macro* _tmp1_;
	GeeList* _tmp2_;
	Macro* _tmp3_;
	GeeList* _tmp4_;
#line 34 "src/macro.vala"
	_tmp0_ = cmd_mp;
#line 34 "src/macro.vala"
	_vala_assert (_tmp0_ != NULL, "cmd_mp != null");
#line 35 "src/macro.vala"
	_tmp1_ = cur_mp;
#line 35 "src/macro.vala"
	_tmp2_ = _tmp1_->keys;
#line 35 "src/macro.vala"
	_tmp3_ = cmd_mp;
#line 35 "src/macro.vala"
	_tmp4_ = _tmp3_->keys;
#line 35 "src/macro.vala"
	gee_collection_add_all ((GeeCollection*) _tmp2_, (GeeCollection*) _tmp4_);
#line 36 "src/macro.vala"
	_macro_unref0 (cmd_mp);
#line 36 "src/macro.vala"
	cmd_mp = NULL;
#line 514 "macro.c"
}

void
add_key_to_cmd (guint key)
{
	Macro* _tmp0_;
	Macro* _tmp2_;
	GeeList* _tmp3_;
#line 40 "src/macro.vala"
	_tmp0_ = cmd_mp;
#line 40 "src/macro.vala"
	if (_tmp0_ == NULL) {
#line 527 "macro.c"
		Macro* _tmp1_;
#line 41 "src/macro.vala"
		_tmp1_ = macro_new ();
#line 41 "src/macro.vala"
		_macro_unref0 (cmd_mp);
#line 41 "src/macro.vala"
		cmd_mp = _tmp1_;
#line 535 "macro.c"
	}
#line 43 "src/macro.vala"
	_tmp2_ = cur_mp;
#line 43 "src/macro.vala"
	_tmp3_ = _tmp2_->keys;
#line 43 "src/macro.vala"
	gee_collection_add ((GeeCollection*) _tmp3_, (gpointer) ((guintptr) key));
#line 543 "macro.c"
}

void
remove_key_from_cmd (void)
{
	Macro* _tmp0_;
	Macro* _tmp1_;
	GeeList* _tmp2_;
	Macro* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
#line 47 "src/macro.vala"
	_tmp0_ = cmd_mp;
#line 47 "src/macro.vala"
	_vala_assert (_tmp0_ != NULL, "cmd_mp != null");
#line 48 "src/macro.vala"
	_tmp1_ = cmd_mp;
#line 48 "src/macro.vala"
	_tmp2_ = _tmp1_->keys;
#line 48 "src/macro.vala"
	_tmp3_ = cmd_mp;
#line 48 "src/macro.vala"
	_tmp4_ = _tmp3_->keys;
#line 48 "src/macro.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 48 "src/macro.vala"
	_tmp6_ = _tmp5_;
#line 48 "src/macro.vala"
	gee_list_remove_at (_tmp2_, _tmp6_ - 1);
#line 574 "macro.c"
}

static gpointer
_macro_ref0 (gpointer self)
{
#line 52 "src/macro.vala"
	return self ? macro_ref (self) : NULL;
#line 582 "macro.c"
}

void
cancel_kbd_macro (void)
{
	Macro* _tmp0_;
	Macro* _tmp1_;
	Flags _tmp2_;
#line 52 "src/macro.vala"
	_macro_unref0 (cur_mp);
#line 52 "src/macro.vala"
	cur_mp = NULL;
#line 52 "src/macro.vala"
	_tmp0_ = cur_mp;
#line 52 "src/macro.vala"
	_tmp1_ = _macro_ref0 (_tmp0_);
#line 52 "src/macro.vala"
	_macro_unref0 (cmd_mp);
#line 52 "src/macro.vala"
	cmd_mp = _tmp1_;
#line 53 "src/macro.vala"
	_tmp2_ = thisflag;
#line 53 "src/macro.vala"
	thisflag = _tmp2_ & (~FLAGS_DEFINING_MACRO);
#line 607 "macro.c"
}

void
process_keys (GeeList* keys)
{
	gsize cur = 0UL;
#line 56 "src/macro.vala"
	g_return_if_fail (keys != NULL);
#line 57 "src/macro.vala"
	cur = (gsize) term_buf_len ();
#line 618 "macro.c"
	{
		guint i = 0U;
#line 58 "src/macro.vala"
		i = (guint) 0;
#line 623 "macro.c"
		{
			gboolean _tmp0_ = FALSE;
#line 58 "src/macro.vala"
			_tmp0_ = TRUE;
#line 58 "src/macro.vala"
			while (TRUE) {
#line 630 "macro.c"
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gpointer _tmp6_;
#line 58 "src/macro.vala"
				if (!_tmp0_) {
#line 638 "macro.c"
					guint _tmp1_;
#line 58 "src/macro.vala"
					_tmp1_ = i;
#line 58 "src/macro.vala"
					i = _tmp1_ + 1;
#line 644 "macro.c"
				}
#line 58 "src/macro.vala"
				_tmp0_ = FALSE;
#line 58 "src/macro.vala"
				_tmp2_ = gee_collection_get_size ((GeeCollection*) keys);
#line 58 "src/macro.vala"
				_tmp3_ = _tmp2_;
#line 58 "src/macro.vala"
				if (!(i < ((guint) _tmp3_))) {
#line 58 "src/macro.vala"
					break;
#line 656 "macro.c"
				}
#line 59 "src/macro.vala"
				_tmp4_ = gee_collection_get_size ((GeeCollection*) keys);
#line 59 "src/macro.vala"
				_tmp5_ = _tmp4_;
#line 59 "src/macro.vala"
				_tmp6_ = gee_list_get (keys, (gint) ((_tmp5_ - i) - 1));
#line 59 "src/macro.vala"
				pushkey ((guint) ((guintptr) _tmp6_));
#line 666 "macro.c"
			}
		}
	}
#line 61 "src/macro.vala"
	while (TRUE) {
#line 61 "src/macro.vala"
		if (!(((gsize) term_buf_len ()) > cur)) {
#line 61 "src/macro.vala"
			break;
#line 676 "macro.c"
		}
#line 62 "src/macro.vala"
		get_and_run_command ();
#line 680 "macro.c"
	}
}

gboolean
call_macro (void)
{
	GeeList* _tmp0_;
	gboolean result = FALSE;
#line 69 "src/macro.vala"
	_tmp0_ = macro_keys;
#line 69 "src/macro.vala"
	process_keys (_tmp0_);
#line 70 "src/macro.vala"
	result = TRUE;
#line 70 "src/macro.vala"
	return result;
#line 697 "macro.c"
}

static gboolean
__lambda114_ (glong uniarg,
              GeeQueue* args)
{
	Flags _tmp0_;
	Macro* _tmp1_;
	Flags _tmp2_;
	Macro* _tmp3_;
	gboolean result = FALSE;
#line 78 "src/macro.vala"
	_tmp0_ = thisflag;
#line 78 "src/macro.vala"
	if ((_tmp0_ & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO) {
#line 79 "src/macro.vala"
		minibuf_error ("Already defining a keyboard macro", NULL);
#line 80 "src/macro.vala"
		result = FALSE;
#line 80 "src/macro.vala"
		return result;
#line 719 "macro.c"
	}
#line 83 "src/macro.vala"
	_tmp1_ = cur_mp;
#line 83 "src/macro.vala"
	if (_tmp1_ != NULL) {
#line 84 "src/macro.vala"
		cancel_kbd_macro ();
#line 727 "macro.c"
	}
#line 86 "src/macro.vala"
	minibuf_write ("Defining keyboard macro...", NULL);
#line 88 "src/macro.vala"
	_tmp2_ = thisflag;
#line 88 "src/macro.vala"
	thisflag = _tmp2_ | FLAGS_DEFINING_MACRO;
#line 89 "src/macro.vala"
	_tmp3_ = macro_new ();
#line 89 "src/macro.vala"
	_macro_unref0 (cur_mp);
#line 89 "src/macro.vala"
	cur_mp = _tmp3_;
#line 91 "src/macro.vala"
	result = TRUE;
#line 91 "src/macro.vala"
	return result;
#line 745 "macro.c"
}

static gboolean
___lambda114__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda114_ (uniarg, args);
#line 75 "src/macro.vala"
	return result;
#line 756 "macro.c"
}

static gboolean
__lambda115_ (glong uniarg,
              GeeQueue* args)
{
	Flags _tmp0_;
	Flags _tmp1_;
	gboolean result = FALSE;
#line 102 "src/macro.vala"
	_tmp0_ = thisflag;
#line 102 "src/macro.vala"
	if (!((_tmp0_ & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO)) {
#line 103 "src/macro.vala"
		minibuf_error ("Not defining a keyboard macro", NULL);
#line 104 "src/macro.vala"
		result = FALSE;
#line 104 "src/macro.vala"
		return result;
#line 776 "macro.c"
	}
#line 107 "src/macro.vala"
	_tmp1_ = thisflag;
#line 107 "src/macro.vala"
	thisflag = _tmp1_ & (~FLAGS_DEFINING_MACRO);
#line 108 "src/macro.vala"
	result = TRUE;
#line 108 "src/macro.vala"
	return result;
#line 786 "macro.c"
}

static gboolean
___lambda115__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda115_ (uniarg, args);
#line 99 "src/macro.vala"
	return result;
#line 797 "macro.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 126 "src/macro.vala"
	return self ? g_object_ref (self) : NULL;
#line 805 "macro.c"
}

static gboolean
_call_macro_movement_delegate (gpointer self)
{
	gboolean result;
	result = call_macro ();
#line 127 "src/macro.vala"
	return result;
#line 815 "macro.c"
}

static gboolean
__lambda116_ (glong uniarg,
              GeeQueue* args)
{
	Macro* _tmp0_;
	Macro* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gboolean result = FALSE;
#line 119 "src/macro.vala"
	_tmp0_ = cur_mp;
#line 119 "src/macro.vala"
	if (_tmp0_ == NULL) {
#line 120 "src/macro.vala"
		minibuf_error ("No kbd macro has been defined", NULL);
#line 121 "src/macro.vala"
		result = FALSE;
#line 121 "src/macro.vala"
		return result;
#line 837 "macro.c"
	}
#line 126 "src/macro.vala"
	_tmp1_ = cur_mp;
#line 126 "src/macro.vala"
	_tmp2_ = _tmp1_->keys;
#line 126 "src/macro.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 126 "src/macro.vala"
	_g_object_unref0 (macro_keys);
#line 126 "src/macro.vala"
	macro_keys = _tmp3_;
#line 127 "src/macro.vala"
	execute_with_uniarg (uniarg, _call_macro_movement_delegate, NULL, NULL, NULL);
#line 128 "src/macro.vala"
	result = TRUE;
#line 128 "src/macro.vala"
	return result;
#line 855 "macro.c"
}

static gboolean
___lambda116__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda116_ (uniarg, args);
#line 116 "src/macro.vala"
	return result;
#line 866 "macro.c"
}

static gboolean
__lambda117_ (glong uniarg,
              GeeQueue* args)
{
	gchar* keystr = NULL;
	gpointer _tmp0_;
	GeeList* keys = NULL;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	gboolean result = FALSE;
#line 138 "src/macro.vala"
	_tmp0_ = gee_queue_poll (args);
#line 138 "src/macro.vala"
	keystr = (gchar*) _tmp0_;
#line 139 "src/macro.vala"
	_tmp1_ = keystr;
#line 139 "src/macro.vala"
	_tmp2_ = keystrtovec (_tmp1_);
#line 139 "src/macro.vala"
	keys = _tmp2_;
#line 140 "src/macro.vala"
	_tmp3_ = keys;
#line 140 "src/macro.vala"
	if (_tmp3_ == NULL) {
#line 141 "src/macro.vala"
		result = FALSE;
#line 141 "src/macro.vala"
		_g_object_unref0 (keys);
#line 141 "src/macro.vala"
		_g_free0 (keystr);
#line 141 "src/macro.vala"
		return result;
#line 904 "macro.c"
	}
#line 143 "src/macro.vala"
	_tmp4_ = keys;
#line 143 "src/macro.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 143 "src/macro.vala"
	_g_object_unref0 (macro_keys);
#line 143 "src/macro.vala"
	macro_keys = _tmp5_;
#line 144 "src/macro.vala"
	execute_with_uniarg (uniarg, _call_macro_movement_delegate, NULL, NULL, NULL);
#line 145 "src/macro.vala"
	result = TRUE;
#line 145 "src/macro.vala"
	_g_object_unref0 (keys);
#line 145 "src/macro.vala"
	_g_free0 (keystr);
#line 145 "src/macro.vala"
	return result;
#line 924 "macro.c"
}

static gboolean
___lambda117__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda117_ (uniarg, args);
#line 135 "src/macro.vala"
	return result;
#line 935 "macro.c"
}

void
macro_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
#line 75 "src/macro.vala"
	_tmp0_ = lisp_func_new ("start-kbd-macro", ___lambda114__function, TRUE, "Record subsequent keyboard input, defining a keyboard macro.\n" \
"\t\tThe commands are recorded even as they are executed.\n" \
"\t\tUse \\\\[end-kbd-macro] to finish recording and make the macro ava" \
"ilable.");
#line 75 "src/macro.vala"
	_tmp1_ = _tmp0_;
#line 75 "src/macro.vala"
	_lisp_func_unref0 (_tmp1_);
#line 99 "src/macro.vala"
	_tmp2_ = lisp_func_new ("end-kbd-macro", ___lambda115__function, TRUE, "Finish defining a keyboard macro.\n" \
"\t\tThe definition was started by \\\\[start-kbd-macro].\n" \
"\t\tThe macro is now available for use via \\\\[call-last-kbd-macro].");
#line 99 "src/macro.vala"
	_tmp3_ = _tmp2_;
#line 99 "src/macro.vala"
	_lisp_func_unref0 (_tmp3_);
#line 116 "src/macro.vala"
	_tmp4_ = lisp_func_new ("call-last-kbd-macro", ___lambda116__function, TRUE, "Call the last keyboard macro that you defined with \\\\[start-kbd-macr" \
"o].\n" \
"\t\tA prefix argument serves as a repeat count.");
#line 116 "src/macro.vala"
	_tmp5_ = _tmp4_;
#line 116 "src/macro.vala"
	_lisp_func_unref0 (_tmp5_);
#line 135 "src/macro.vala"
	_tmp6_ = lisp_func_new ("execute-kbd-macro", ___lambda117__function, TRUE, "Execute macro as string of editor command characters.");
#line 135 "src/macro.vala"
	_tmp7_ = _tmp6_;
#line 135 "src/macro.vala"
	_lisp_func_unref0 (_tmp7_);
#line 973 "macro.c"
}

