/* killring.c generated by valac 0.50.1.44-10688, the Vala compiler
 * generated from killring.vala, do not modify */

/* Kill ring facility functions

   Copyright (c) 2001-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <estr.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
#define _region_unref0(var) ((var == NULL) ? NULL : (var = (region_unref (var), NULL)))
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);
typedef gboolean (*MovementDelegate) (gpointer user_data);
typedef struct _LispFuncPrivate LispFuncPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _LispFunc {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LispFuncPrivate * priv;
	gchar* name;
	Function func;
	gboolean interactive;
	gchar* doc;
};

struct _LispFuncClass {
	GTypeClass parent_class;
	void (*finalize) (LispFunc *self);
};

extern Estr* kill_ring_text;
Estr* kill_ring_text = NULL;
extern Buffer* cur_bp;

void maybe_destroy_kill_ring (void);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
LispFunc* last_command (void);
LispFunc* lisp_func_find (const gchar* name);
void kill_ring_push (ImmutableEstr* es);
gpointer region_ref (gpointer instance);
void region_unref (gpointer instance);
GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_region (GValue* value,
                       gpointer v_object);
void value_take_region (GValue* value,
                        gpointer v_object);
gpointer value_get_region (const GValue* value);
GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
gboolean copy_or_kill_region (gboolean kill,
                              Region* r);
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
ImmutableEstr* buffer_get_region (Buffer* self,
                                  Region* r);
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
void minibuf_error (const gchar* fmt,
                    ...);
gboolean region_delete (Region* self);
void set_this_command (LispFunc* cmd);
gboolean kill_line (gboolean whole_line);
gsize buffer_line_len (Buffer* self,
                       gsize o);
gsize buffer_get_pt (Buffer* self);
gsize buffer_line_o (Buffer* self);
gchar buffer_get_char (Buffer* self,
                       gsize o);
gboolean buffer_eobp (Buffer* self);
gboolean buffer_eolp (Buffer* self);
Region* region_new (gsize o1,
                    gsize o2);
Region* region_construct (GType object_type,
                          gsize o1,
                          gsize o2);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg);
gboolean kill_whole_line (void);
gboolean kill_line_backward (void);
gboolean buffer_move_line (Buffer* self,
                           glong n);
gboolean copy_or_kill_the_region (gboolean kill);
gboolean buffer_warn_if_no_mark (Buffer* self);
Region* region_calculate (void);
gboolean kill_text (glong uniarg,
                    Function mark_func);
gboolean buffer_warn_if_readonly (Buffer* self);
void push_mark (void);
void pop_mark (void);
void minibuf_write (const gchar* fmt,
                    ...);
void killring_init (void);
static gboolean __lambda95_ (glong uniarg,
                      GeeQueue* args);
gboolean noarg (GeeQueue* args);
gboolean buffer_bolp (Buffer* self);
gboolean get_variable_bool (const gchar* name);
gboolean int_or_uniarg (GeeQueue* args,
                        glong* n,
                        glong uniarg);
gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _kill_whole_line_movement_delegate (gpointer self);
static gboolean _kill_line_backward_movement_delegate (gpointer self);
static gboolean ___lambda95__function (glong uniarg,
                                GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
static gboolean __lambda96_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda96__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda97_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda97__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda98_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda98__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda99_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda99__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda100_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda100__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda101_ (glong uniarg,
                       GeeQueue* args);
gboolean buffer_insert_estr (Buffer* self,
                             ImmutableEstr* es);
static gboolean ___lambda101__function (glong uniarg,
                                 GeeQueue* args);

void
maybe_destroy_kill_ring (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	gboolean _tmp4_;
#line 23 "src/killring.vala"
	_tmp0_ = last_command ();
#line 23 "src/killring.vala"
	_tmp1_ = _tmp0_;
#line 23 "src/killring.vala"
	_tmp2_ = lisp_func_find ("kill-region");
#line 23 "src/killring.vala"
	_tmp3_ = _tmp2_;
#line 23 "src/killring.vala"
	_tmp4_ = _tmp1_ != _tmp3_;
#line 23 "src/killring.vala"
	_lisp_func_unref0 (_tmp3_);
#line 23 "src/killring.vala"
	_lisp_func_unref0 (_tmp1_);
#line 23 "src/killring.vala"
	if (_tmp4_) {
#line 24 "src/killring.vala"
		_immutable_estr_unref0 (kill_ring_text);
#line 24 "src/killring.vala"
		kill_ring_text = NULL;
#line 362 "killring.c"
	}
}

void
kill_ring_push (ImmutableEstr* es)
{
	Estr* _tmp0_;
	Estr* _tmp4_;
#line 27 "src/killring.vala"
	g_return_if_fail (es != NULL);
#line 28 "src/killring.vala"
	_tmp0_ = kill_ring_text;
#line 28 "src/killring.vala"
	if (_tmp0_ == NULL) {
#line 377 "killring.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		Estr* _tmp3_;
#line 29 "src/killring.vala"
		_tmp1_ = immutable_estr_get_eol (es);
#line 29 "src/killring.vala"
		_tmp2_ = _tmp1_;
#line 29 "src/killring.vala"
		_tmp3_ = estr_of_empty (_tmp2_);
#line 29 "src/killring.vala"
		_immutable_estr_unref0 (kill_ring_text);
#line 29 "src/killring.vala"
		kill_ring_text = _tmp3_;
#line 391 "killring.c"
	}
#line 30 "src/killring.vala"
	_tmp4_ = kill_ring_text;
#line 30 "src/killring.vala"
	estr_cat (_tmp4_, es);
#line 397 "killring.c"
}

gboolean
copy_or_kill_region (gboolean kill,
                     Region* r)
{
	Buffer* _tmp0_;
	ImmutableEstr* _tmp1_;
	ImmutableEstr* _tmp2_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	Buffer* _tmp6_;
	gboolean result = FALSE;
#line 33 "src/killring.vala"
	g_return_val_if_fail (r != NULL, FALSE);
#line 34 "src/killring.vala"
	_tmp0_ = cur_bp;
#line 34 "src/killring.vala"
	_tmp1_ = buffer_get_region (_tmp0_, r);
#line 34 "src/killring.vala"
	_tmp2_ = _tmp1_;
#line 34 "src/killring.vala"
	kill_ring_push (_tmp2_);
#line 34 "src/killring.vala"
	_immutable_estr_unref0 (_tmp2_);
#line 36 "src/killring.vala"
	if (kill) {
#line 425 "killring.c"
		Buffer* _tmp3_;
#line 37 "src/killring.vala"
		_tmp3_ = cur_bp;
#line 37 "src/killring.vala"
		if (_tmp3_->readonly) {
#line 38 "src/killring.vala"
			minibuf_error ("Read only text copied to kill ring", NULL);
#line 433 "killring.c"
		} else {
#line 40 "src/killring.vala"
			_vala_assert (region_delete (r), "r.delete ()");
#line 437 "killring.c"
		}
	}
#line 43 "src/killring.vala"
	_tmp4_ = lisp_func_find ("kill-region");
#line 43 "src/killring.vala"
	_tmp5_ = _tmp4_;
#line 43 "src/killring.vala"
	set_this_command (_tmp5_);
#line 43 "src/killring.vala"
	_lisp_func_unref0 (_tmp5_);
#line 44 "src/killring.vala"
	_tmp6_ = cur_bp;
#line 44 "src/killring.vala"
	_tmp6_->mark_active = FALSE;
#line 46 "src/killring.vala"
	result = TRUE;
#line 46 "src/killring.vala"
	return result;
#line 456 "killring.c"
}

gboolean
kill_line (gboolean whole_line)
{
	gboolean ok = FALSE;
	gboolean only_blanks_to_end_of_line = FALSE;
	gsize cur_line_len = 0UL;
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	Buffer* _tmp13_;
	Buffer* _tmp14_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean result = FALSE;
#line 50 "src/killring.vala"
	ok = TRUE;
#line 51 "src/killring.vala"
	only_blanks_to_end_of_line = FALSE;
#line 52 "src/killring.vala"
	_tmp0_ = cur_bp;
#line 52 "src/killring.vala"
	_tmp1_ = cur_bp;
#line 52 "src/killring.vala"
	_tmp2_ = buffer_get_pt (_tmp1_);
#line 52 "src/killring.vala"
	_tmp3_ = _tmp2_;
#line 52 "src/killring.vala"
	cur_line_len = buffer_line_len (_tmp0_, _tmp3_);
#line 54 "src/killring.vala"
	if (!whole_line) {
#line 490 "killring.c"
		gsize i = 0UL;
		{
			Buffer* _tmp4_;
			gsize _tmp5_;
			gsize _tmp6_;
			Buffer* _tmp7_;
			gboolean _tmp8_ = FALSE;
#line 56 "src/killring.vala"
			_tmp4_ = cur_bp;
#line 56 "src/killring.vala"
			_tmp5_ = buffer_get_pt (_tmp4_);
#line 56 "src/killring.vala"
			_tmp6_ = _tmp5_;
#line 56 "src/killring.vala"
			_tmp7_ = cur_bp;
#line 56 "src/killring.vala"
			i = _tmp6_ - buffer_line_o (_tmp7_);
#line 56 "src/killring.vala"
			_tmp8_ = TRUE;
#line 56 "src/killring.vala"
			while (TRUE) {
#line 512 "killring.c"
				gchar c = '\0';
				Buffer* _tmp10_;
				Buffer* _tmp11_;
				gboolean _tmp12_ = FALSE;
#line 56 "src/killring.vala"
				if (!_tmp8_) {
#line 519 "killring.c"
					gsize _tmp9_;
#line 56 "src/killring.vala"
					_tmp9_ = i;
#line 56 "src/killring.vala"
					i = _tmp9_ + 1;
#line 525 "killring.c"
				}
#line 56 "src/killring.vala"
				_tmp8_ = FALSE;
#line 56 "src/killring.vala"
				if (!(i < cur_line_len)) {
#line 56 "src/killring.vala"
					break;
#line 533 "killring.c"
				}
#line 57 "src/killring.vala"
				_tmp10_ = cur_bp;
#line 57 "src/killring.vala"
				_tmp11_ = cur_bp;
#line 57 "src/killring.vala"
				c = buffer_get_char (_tmp10_, buffer_line_o (_tmp11_) + i);
#line 58 "src/killring.vala"
				if (c == ' ') {
#line 58 "src/killring.vala"
					_tmp12_ = TRUE;
#line 545 "killring.c"
				} else {
#line 58 "src/killring.vala"
					_tmp12_ = c == '\t';
#line 549 "killring.c"
				}
#line 58 "src/killring.vala"
				if (!_tmp12_) {
#line 59 "src/killring.vala"
					break;
#line 555 "killring.c"
				}
			}
		}
#line 62 "src/killring.vala"
		only_blanks_to_end_of_line = i == cur_line_len;
#line 561 "killring.c"
	}
#line 65 "src/killring.vala"
	_tmp13_ = cur_bp;
#line 65 "src/killring.vala"
	if (buffer_eobp (_tmp13_)) {
#line 66 "src/killring.vala"
		minibuf_error ("End of buffer", NULL);
#line 67 "src/killring.vala"
		result = FALSE;
#line 67 "src/killring.vala"
		return result;
#line 573 "killring.c"
	}
#line 70 "src/killring.vala"
	_tmp14_ = cur_bp;
#line 70 "src/killring.vala"
	if (!buffer_eolp (_tmp14_)) {
#line 579 "killring.c"
		Buffer* _tmp15_;
		gsize _tmp16_;
		gsize _tmp17_;
		Buffer* _tmp18_;
		Region* _tmp19_;
		Region* _tmp20_;
#line 71 "src/killring.vala"
		_tmp15_ = cur_bp;
#line 71 "src/killring.vala"
		_tmp16_ = buffer_get_pt (_tmp15_);
#line 71 "src/killring.vala"
		_tmp17_ = _tmp16_;
#line 71 "src/killring.vala"
		_tmp18_ = cur_bp;
#line 71 "src/killring.vala"
		_tmp19_ = region_new (_tmp17_, buffer_line_o (_tmp18_) + cur_line_len);
#line 71 "src/killring.vala"
		_tmp20_ = _tmp19_;
#line 71 "src/killring.vala"
		ok = copy_or_kill_region (TRUE, _tmp20_);
#line 71 "src/killring.vala"
		_region_unref0 (_tmp20_);
#line 602 "killring.c"
	}
#line 73 "src/killring.vala"
	if (ok) {
#line 606 "killring.c"
		gboolean _tmp23_ = FALSE;
#line 73 "src/killring.vala"
		if (whole_line) {
#line 73 "src/killring.vala"
			_tmp23_ = TRUE;
#line 612 "killring.c"
		} else {
#line 73 "src/killring.vala"
			_tmp23_ = only_blanks_to_end_of_line;
#line 616 "killring.c"
		}
#line 73 "src/killring.vala"
		_tmp22_ = _tmp23_;
#line 620 "killring.c"
	} else {
#line 73 "src/killring.vala"
		_tmp22_ = FALSE;
#line 624 "killring.c"
	}
#line 73 "src/killring.vala"
	if (_tmp22_) {
#line 628 "killring.c"
		Buffer* _tmp24_;
#line 73 "src/killring.vala"
		_tmp24_ = cur_bp;
#line 73 "src/killring.vala"
		_tmp21_ = !buffer_eobp (_tmp24_);
#line 634 "killring.c"
	} else {
#line 73 "src/killring.vala"
		_tmp21_ = FALSE;
#line 638 "killring.c"
	}
#line 73 "src/killring.vala"
	if (_tmp21_) {
#line 642 "killring.c"
		gint _tmp25_;
		gint _tmp26_;
		ImmutableEstr* _tmp27_;
		ImmutableEstr* _tmp28_;
		LispFunc* _tmp29_;
		LispFunc* _tmp30_;
#line 74 "src/killring.vala"
		if (!funcall ("delete-char", NULL)) {
#line 75 "src/killring.vala"
			result = FALSE;
#line 75 "src/killring.vala"
			return result;
#line 655 "killring.c"
		}
#line 77 "src/killring.vala"
		_tmp25_ = strlen ("\n");
#line 77 "src/killring.vala"
		_tmp26_ = _tmp25_;
#line 77 "src/killring.vala"
		_tmp27_ = immutable_estr_of ("\n", (gsize) _tmp26_, IMMUTABLE_ESTR_eol_lf);
#line 77 "src/killring.vala"
		_tmp28_ = _tmp27_;
#line 77 "src/killring.vala"
		kill_ring_push (_tmp28_);
#line 77 "src/killring.vala"
		_immutable_estr_unref0 (_tmp28_);
#line 78 "src/killring.vala"
		_tmp29_ = lisp_func_find ("kill-region");
#line 78 "src/killring.vala"
		_tmp30_ = _tmp29_;
#line 78 "src/killring.vala"
		set_this_command (_tmp30_);
#line 78 "src/killring.vala"
		_lisp_func_unref0 (_tmp30_);
#line 677 "killring.c"
	}
#line 81 "src/killring.vala"
	result = ok;
#line 81 "src/killring.vala"
	return result;
#line 683 "killring.c"
}

gboolean
kill_whole_line (void)
{
	gboolean result = FALSE;
#line 85 "src/killring.vala"
	result = kill_line (TRUE);
#line 85 "src/killring.vala"
	return result;
#line 694 "killring.c"
}

gboolean
kill_line_backward (void)
{
	gboolean _tmp0_ = FALSE;
	Buffer* _tmp1_;
	gboolean result = FALSE;
#line 89 "src/killring.vala"
	_tmp1_ = cur_bp;
#line 89 "src/killring.vala"
	if (buffer_move_line (_tmp1_, (glong) -1)) {
#line 89 "src/killring.vala"
		_tmp0_ = kill_whole_line ();
#line 709 "killring.c"
	} else {
#line 89 "src/killring.vala"
		_tmp0_ = FALSE;
#line 713 "killring.c"
	}
#line 89 "src/killring.vala"
	result = _tmp0_;
#line 89 "src/killring.vala"
	return result;
#line 719 "killring.c"
}

gboolean
copy_or_kill_the_region (gboolean kill)
{
	gboolean ok = FALSE;
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 93 "src/killring.vala"
	ok = FALSE;
#line 95 "src/killring.vala"
	_tmp0_ = cur_bp;
#line 95 "src/killring.vala"
	if (!buffer_warn_if_no_mark (_tmp0_)) {
#line 734 "killring.c"
		Region* r = NULL;
		Region* _tmp1_;
		Region* _tmp2_;
#line 96 "src/killring.vala"
		_tmp1_ = region_calculate ();
#line 96 "src/killring.vala"
		r = _tmp1_;
#line 97 "src/killring.vala"
		maybe_destroy_kill_ring ();
#line 98 "src/killring.vala"
		_tmp2_ = r;
#line 98 "src/killring.vala"
		ok = copy_or_kill_region (kill, _tmp2_);
#line 95 "src/killring.vala"
		_region_unref0 (r);
#line 750 "killring.c"
	}
#line 101 "src/killring.vala"
	result = ok;
#line 101 "src/killring.vala"
	return result;
#line 756 "killring.c"
}

gboolean
kill_text (glong uniarg,
           Function mark_func)
{
	Buffer* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	gboolean result = FALSE;
#line 105 "src/killring.vala"
	maybe_destroy_kill_ring ();
#line 107 "src/killring.vala"
	_tmp0_ = cur_bp;
#line 107 "src/killring.vala"
	if (buffer_warn_if_readonly (_tmp0_)) {
#line 108 "src/killring.vala"
		result = FALSE;
#line 108 "src/killring.vala"
		return result;
#line 777 "killring.c"
	}
#line 110 "src/killring.vala"
	push_mark ();
#line 111 "src/killring.vala"
	mark_func (uniarg, NULL);
#line 112 "src/killring.vala"
	funcall ("kill-region", NULL);
#line 113 "src/killring.vala"
	pop_mark ();
#line 115 "src/killring.vala"
	_tmp1_ = lisp_func_find ("kill-region");
#line 115 "src/killring.vala"
	_tmp2_ = _tmp1_;
#line 115 "src/killring.vala"
	set_this_command (_tmp2_);
#line 115 "src/killring.vala"
	_lisp_func_unref0 (_tmp2_);
#line 116 "src/killring.vala"
	minibuf_write ("%s", "", NULL);
#line 117 "src/killring.vala"
	result = TRUE;
#line 117 "src/killring.vala"
	return result;
#line 801 "killring.c"
}

static gboolean
_kill_whole_line_movement_delegate (gpointer self)
{
	gboolean result;
	result = kill_whole_line ();
#line 138 "src/killring.vala"
	return result;
#line 811 "killring.c"
}

static gboolean
_kill_line_backward_movement_delegate (gpointer self)
{
	gboolean result;
	result = kill_line_backward ();
#line 138 "src/killring.vala"
	return result;
#line 821 "killring.c"
}

static gboolean
__lambda95_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	Buffer* _tmp12_;
	gboolean result = FALSE;
#line 125 "src/killring.vala"
	maybe_destroy_kill_ring ();
#line 127 "src/killring.vala"
	ok = TRUE;
#line 128 "src/killring.vala"
	if (noarg (args)) {
#line 837 "killring.c"
		gboolean _tmp0_ = FALSE;
		Buffer* _tmp1_;
#line 129 "src/killring.vala"
		_tmp1_ = cur_bp;
#line 129 "src/killring.vala"
		if (buffer_bolp (_tmp1_)) {
#line 129 "src/killring.vala"
			_tmp0_ = get_variable_bool ("kill-whole-line");
#line 846 "killring.c"
		} else {
#line 129 "src/killring.vala"
			_tmp0_ = FALSE;
#line 850 "killring.c"
		}
#line 129 "src/killring.vala"
		ok = kill_line (_tmp0_);
#line 854 "killring.c"
	} else {
		glong arg = 0L;
		gboolean _tmp2_;
#line 131 "src/killring.vala"
		arg = (glong) 1;
#line 132 "src/killring.vala"
		_tmp2_ = int_or_uniarg (args, &arg, uniarg);
#line 132 "src/killring.vala"
		if (!_tmp2_) {
#line 133 "src/killring.vala"
			ok = FALSE;
#line 866 "killring.c"
		} else {
			gboolean _tmp11_ = FALSE;
#line 135 "src/killring.vala"
			if (arg <= ((glong) 0)) {
#line 871 "killring.c"
				gboolean _tmp3_ = FALSE;
				Buffer* _tmp4_;
#line 136 "src/killring.vala"
				_tmp4_ = cur_bp;
#line 136 "src/killring.vala"
				if (buffer_bolp (_tmp4_)) {
#line 136 "src/killring.vala"
					_tmp3_ = TRUE;
#line 880 "killring.c"
				} else {
					Buffer* _tmp5_;
					Buffer* _tmp6_;
					gsize _tmp7_;
					gsize _tmp8_;
					Region* _tmp9_;
					Region* _tmp10_;
#line 136 "src/killring.vala"
					_tmp5_ = cur_bp;
#line 136 "src/killring.vala"
					_tmp6_ = cur_bp;
#line 136 "src/killring.vala"
					_tmp7_ = buffer_get_pt (_tmp6_);
#line 136 "src/killring.vala"
					_tmp8_ = _tmp7_;
#line 136 "src/killring.vala"
					_tmp9_ = region_new (buffer_line_o (_tmp5_), _tmp8_);
#line 136 "src/killring.vala"
					_tmp10_ = _tmp9_;
#line 136 "src/killring.vala"
					_tmp3_ = copy_or_kill_region (TRUE, _tmp10_);
#line 136 "src/killring.vala"
					_region_unref0 (_tmp10_);
#line 904 "killring.c"
				}
#line 136 "src/killring.vala"
				ok = _tmp3_;
#line 908 "killring.c"
			}
#line 137 "src/killring.vala"
			if (arg != ((glong) 0)) {
#line 137 "src/killring.vala"
				_tmp11_ = ok;
#line 914 "killring.c"
			} else {
#line 137 "src/killring.vala"
				_tmp11_ = FALSE;
#line 918 "killring.c"
			}
#line 137 "src/killring.vala"
			if (_tmp11_) {
#line 138 "src/killring.vala"
				ok = execute_with_uniarg (arg, _kill_whole_line_movement_delegate, NULL, _kill_line_backward_movement_delegate, NULL);
#line 924 "killring.c"
			}
		}
	}
#line 142 "src/killring.vala"
	_tmp12_ = cur_bp;
#line 142 "src/killring.vala"
	_tmp12_->mark_active = FALSE;
#line 143 "src/killring.vala"
	result = ok;
#line 143 "src/killring.vala"
	return result;
#line 936 "killring.c"
}

static gboolean
___lambda95__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda95_ (uniarg, args);
#line 122 "src/killring.vala"
	return result;
#line 947 "killring.c"
}

static gboolean
__lambda96_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result = FALSE;
#line 159 "src/killring.vala"
	result = copy_or_kill_the_region (TRUE);
#line 159 "src/killring.vala"
	return result;
#line 959 "killring.c"
}

static gboolean
___lambda96__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda96_ (uniarg, args);
#line 156 "src/killring.vala"
	return result;
#line 970 "killring.c"
}

static gboolean
__lambda97_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result = FALSE;
#line 179 "src/killring.vala"
	result = copy_or_kill_the_region (FALSE);
#line 179 "src/killring.vala"
	return result;
#line 982 "killring.c"
}

static gboolean
___lambda97__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda97_ (uniarg, args);
#line 176 "src/killring.vala"
	return result;
#line 993 "killring.c"
}

static gboolean
__lambda98_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	glong arg = 0L;
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 188 "src/killring.vala"
	ok = TRUE;
#line 189 "src/killring.vala"
	arg = (glong) 1;
#line 190 "src/killring.vala"
	if (!noarg (args)) {
#line 1010 "killring.c"
		gboolean _tmp1_;
#line 191 "src/killring.vala"
		_tmp1_ = int_or_uniarg (args, &arg, uniarg);
#line 191 "src/killring.vala"
		_tmp0_ = !_tmp1_;
#line 1016 "killring.c"
	} else {
#line 190 "src/killring.vala"
		_tmp0_ = FALSE;
#line 1020 "killring.c"
	}
#line 190 "src/killring.vala"
	if (_tmp0_) {
#line 192 "src/killring.vala"
		ok = FALSE;
#line 1026 "killring.c"
	}
#line 193 "src/killring.vala"
	if (ok) {
#line 1030 "killring.c"
		LispFunc* _tmp2_;
		LispFunc* _tmp3_;
		Function _tmp4_;
#line 194 "src/killring.vala"
		_tmp2_ = lisp_func_find ("mark-word");
#line 194 "src/killring.vala"
		_tmp3_ = _tmp2_;
#line 194 "src/killring.vala"
		_tmp4_ = _tmp3_->func;
#line 194 "src/killring.vala"
		ok = kill_text (arg, _tmp4_);
#line 194 "src/killring.vala"
		_lisp_func_unref0 (_tmp3_);
#line 1044 "killring.c"
	}
#line 195 "src/killring.vala"
	result = ok;
#line 195 "src/killring.vala"
	return result;
#line 1050 "killring.c"
}

static gboolean
___lambda98__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda98_ (uniarg, args);
#line 185 "src/killring.vala"
	return result;
#line 1061 "killring.c"
}

static gboolean
__lambda99_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	glong arg = 0L;
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 205 "src/killring.vala"
	ok = TRUE;
#line 206 "src/killring.vala"
	arg = (glong) 1;
#line 207 "src/killring.vala"
	if (!noarg (args)) {
#line 1078 "killring.c"
		gboolean _tmp1_;
#line 208 "src/killring.vala"
		_tmp1_ = int_or_uniarg (args, &arg, uniarg);
#line 208 "src/killring.vala"
		_tmp0_ = !_tmp1_;
#line 1084 "killring.c"
	} else {
#line 207 "src/killring.vala"
		_tmp0_ = FALSE;
#line 1088 "killring.c"
	}
#line 207 "src/killring.vala"
	if (_tmp0_) {
#line 209 "src/killring.vala"
		ok = FALSE;
#line 1094 "killring.c"
	}
#line 210 "src/killring.vala"
	if (ok) {
#line 1098 "killring.c"
		LispFunc* _tmp2_;
		LispFunc* _tmp3_;
		Function _tmp4_;
#line 211 "src/killring.vala"
		_tmp2_ = lisp_func_find ("mark-word");
#line 211 "src/killring.vala"
		_tmp3_ = _tmp2_;
#line 211 "src/killring.vala"
		_tmp4_ = _tmp3_->func;
#line 211 "src/killring.vala"
		ok = kill_text (-arg, _tmp4_);
#line 211 "src/killring.vala"
		_lisp_func_unref0 (_tmp3_);
#line 1112 "killring.c"
	}
#line 212 "src/killring.vala"
	result = ok;
#line 212 "src/killring.vala"
	return result;
#line 1118 "killring.c"
}

static gboolean
___lambda99__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda99_ (uniarg, args);
#line 202 "src/killring.vala"
	return result;
#line 1129 "killring.c"
}

static gboolean
__lambda100_ (glong uniarg,
              GeeQueue* args)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	Function _tmp2_;
	gboolean _tmp3_;
	gboolean result = FALSE;
#line 222 "src/killring.vala"
	_tmp0_ = lisp_func_find ("mark-sexp");
#line 222 "src/killring.vala"
	_tmp1_ = _tmp0_;
#line 222 "src/killring.vala"
	_tmp2_ = _tmp1_->func;
#line 222 "src/killring.vala"
	_tmp3_ = kill_text (uniarg, _tmp2_);
#line 222 "src/killring.vala"
	_lisp_func_unref0 (_tmp1_);
#line 222 "src/killring.vala"
	result = _tmp3_;
#line 222 "src/killring.vala"
	return result;
#line 1155 "killring.c"
}

static gboolean
___lambda100__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda100_ (uniarg, args);
#line 219 "src/killring.vala"
	return result;
#line 1166 "killring.c"
}

static gboolean
__lambda101_ (glong uniarg,
              GeeQueue* args)
{
	Estr* _tmp0_;
	Buffer* _tmp1_;
	Buffer* _tmp2_;
	Estr* _tmp3_;
	Buffer* _tmp4_;
	gboolean result = FALSE;
#line 233 "src/killring.vala"
	_tmp0_ = kill_ring_text;
#line 233 "src/killring.vala"
	if (_tmp0_ == NULL) {
#line 234 "src/killring.vala"
		minibuf_error ("Kill ring is empty", NULL);
#line 235 "src/killring.vala"
		result = FALSE;
#line 235 "src/killring.vala"
		return result;
#line 1189 "killring.c"
	}
#line 238 "src/killring.vala"
	_tmp1_ = cur_bp;
#line 238 "src/killring.vala"
	if (buffer_warn_if_readonly (_tmp1_)) {
#line 239 "src/killring.vala"
		result = FALSE;
#line 239 "src/killring.vala"
		return result;
#line 1199 "killring.c"
	}
#line 241 "src/killring.vala"
	funcall ("set-mark-command", NULL);
#line 242 "src/killring.vala"
	_tmp2_ = cur_bp;
#line 242 "src/killring.vala"
	_tmp3_ = kill_ring_text;
#line 242 "src/killring.vala"
	buffer_insert_estr (_tmp2_, (ImmutableEstr*) _tmp3_);
#line 243 "src/killring.vala"
	_tmp4_ = cur_bp;
#line 243 "src/killring.vala"
	_tmp4_->mark_active = FALSE;
#line 244 "src/killring.vala"
	result = TRUE;
#line 244 "src/killring.vala"
	return result;
#line 1217 "killring.c"
}

static gboolean
___lambda101__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda101_ (uniarg, args);
#line 230 "src/killring.vala"
	return result;
#line 1228 "killring.c"
}

void
killring_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
	LispFunc* _tmp8_;
	LispFunc* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	LispFunc* _tmp13_;
#line 122 "src/killring.vala"
	_tmp0_ = lisp_func_new ("kill-line", ___lambda95__function, TRUE, "Kill the rest of the current line; if no nonblanks there, kill thru ne" \
"wline.\n" \
"With prefix argument ARG, kill that many lines from point.\n" \
"Negative arguments kill lines backward.\n" \
"With zero argument, kills the text before point on the current line.\n" \
"\n" \
"If `kill-whole-line' is non-nil, then this command kills the whole lin" \
"e\n" \
"including its terminating newline, when used at the beginning of a lin" \
"e\n" \
"with no argument.");
#line 122 "src/killring.vala"
	_tmp1_ = _tmp0_;
#line 122 "src/killring.vala"
	_lisp_func_unref0 (_tmp1_);
#line 156 "src/killring.vala"
	_tmp2_ = lisp_func_new ("kill-region", ___lambda96__function, TRUE, "Kill (\\\"cut\\\") text between point and mark.\n" \
"This deletes the text from the buffer and saves it in the kill ring.\n" \
"The command \\\\[yank] can retrieve it from there.\n" \
"\n" \
"Any command that calls this function is a \\\"kill command\\\".\n" \
"If the previous command was also a kill command,\n" \
"the text killed this time appends to the text killed last time\n" \
"to make one entry in the kill ring.\n" \
"\n" \
"If the buffer is read-only, Zile will beep and refrain from deleting\n" \
"the text, but put the text in the kill ring anyway.  This means that\n" \
"you can use the killing commands to copy text from a read-only buffer.");
#line 156 "src/killring.vala"
	_tmp3_ = _tmp2_;
#line 156 "src/killring.vala"
	_lisp_func_unref0 (_tmp3_);
#line 176 "src/killring.vala"
	_tmp4_ = lisp_func_new ("copy-region-as-kill", ___lambda97__function, TRUE, "Save the region as if killed, but don't kill it.");
#line 176 "src/killring.vala"
	_tmp5_ = _tmp4_;
#line 176 "src/killring.vala"
	_lisp_func_unref0 (_tmp5_);
#line 185 "src/killring.vala"
	_tmp6_ = lisp_func_new ("kill-word", ___lambda98__function, TRUE, "Kill characters forward until encountering the end of a word.\n" \
"With argument ARG, do this that many times.");
#line 185 "src/killring.vala"
	_tmp7_ = _tmp6_;
#line 185 "src/killring.vala"
	_lisp_func_unref0 (_tmp7_);
#line 202 "src/killring.vala"
	_tmp8_ = lisp_func_new ("backward-kill-word", ___lambda99__function, TRUE, "Kill characters backward until encountering the end of a word.\n" \
"With argument ARG, do this that many times.");
#line 202 "src/killring.vala"
	_tmp9_ = _tmp8_;
#line 202 "src/killring.vala"
	_lisp_func_unref0 (_tmp9_);
#line 219 "src/killring.vala"
	_tmp10_ = lisp_func_new ("kill-sexp", ___lambda100__function, TRUE, "Kill the sexp (balanced expression) following the cursor.\n" \
"With ARG, kill that many sexps after the cursor.\n" \
"Negative arg -N means kill N sexps before the cursor.");
#line 219 "src/killring.vala"
	_tmp11_ = _tmp10_;
#line 219 "src/killring.vala"
	_lisp_func_unref0 (_tmp11_);
#line 230 "src/killring.vala"
	_tmp12_ = lisp_func_new ("yank", ___lambda101__function, TRUE, "Reinsert (\\\"paste\\\") the last stretch of killed text.\n" \
"More precisely, reinsert the stretch of killed text most recently\n" \
"killed OR yanked.  Put point at end, and set mark at beginning.");
#line 230 "src/killring.vala"
	_tmp13_ = _tmp12_;
#line 230 "src/killring.vala"
	_lisp_func_unref0 (_tmp13_);
#line 1290 "killring.c"
}

