#!/bin/sh
build() {
  # MS Windows have other defaults than linux. The 'sed' I have installed on
  # my windows machine don't support the -i option.
  mv default.config tmp.cfg
  sed -e "s/type=external-midiplayer/type=sequencer-device/" tmp.cfg > default.config
  rm tmp.cfg

  cp solfege.bat solfegedebug.bat.tmp
  echo "pause">> solfegedebug.bat.tmp
  sed -e "s/python.exe solfege/python.exe solfege --debug/" solfegedebug.bat.tmp > solfegedebug.bat
  #./configure PYTHON=/c/Python25/python.exe --disable-pygtk-test --enable-winmidi
  #make skipmanual=yes PYTHON_INCLUDES=-I/c/Python25/include
  #make winbuild
}

prepare_installer() {
  rm win32 -rf
  make DESTDIR=win32 prefix="" install skipmanual=yes PYTHON_INCLUDES=-I/c/Python25/include
  mkdir win32/python
  (cd win32/python && tar zxf ../../../my-python-2.5.tgz)
  cp -a ../gtk-kopi win32/GTK
  (cd win32/python/lib/site-packages && tar zxf ../../../../../pygtk-stuff.tgz)
  (cp soundcard/winmidi.pyd win32/share/solfege/soundcard)
  cp solfege.bat win32/bin/
  cp solfegedebug.bat win32/bin/
  cp README.txt INSTALL.win32.txt INSTALL.txt AUTHORS.txt COPYING.txt win32
  (cd win32 && find -name *.pyc | xargs rm)
  echo "The build process is a mess. Now you can run the python script"
  echo "./tools/trim_win32_installer.py to remove some unused files to"
  echo "make the installer smaller."
  echo "Then you must double click the file windowsinstaller.iss and"
  echo "build the installer"
}

if test "x$1" = "xbuild"; then
  build
fi
if test "x$1" = "xmkinstalldir"; then
  prepare_installer
fi
if test "x$1" = "x-h"; then
  echo "sub commands:"
  echo "   build         build the package"
  echo "   mkinstalldir  create the win32/ folder that the installer will pack"
fi

