#!/usr/bin/python

from __future__ import with_statement

import hashlib
import sys
db = {}

def del_whitespace():
    for digest, k in db.items():
        if not(k['line'].strip()):
            del db[digest]

def do_file(filename):
    with open(filename) as f:
        for lineno, line in enumerate(f):
            h = hashlib.md5(line.strip())
            digest = h.hexdigest()
            e = db.setdefault(digest, {'line': line, 'places': []})
            e['places'].append((lineno, filename))
for fn in sys.argv[1:]:
    do_file(fn)

del_whitespace()

v = db.items()
def ff(a, b):
    return cmp(a[1]['places'][0], b[1]['places'][0])
v.sort(ff)
for l in v:
    if len(l[1]['places']) > 1:
        print l[1]['places'], "\n", l[1]['line'].strip("\n")
