/** @file gsasl_cmd.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.21
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef GSASL_CMD_H
#define GSASL_CMD_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int client_flag;	/**< @brief Act as client. (default=on).  */
  const char *client_help; /**< @brief Act as client. help description.  */
  int server_flag;	/**< @brief Act as server. (default=off).  */
  const char *server_help; /**< @brief Act as server. help description.  */
  int client_mechanisms_flag;	/**< @brief Write name of supported client mechanisms separated by space to stdout. (default=off).  */
  const char *client_mechanisms_help; /**< @brief Write name of supported client mechanisms separated by space to stdout. help description.  */
  int server_mechanisms_flag;	/**< @brief Write name of supported server mechanisms separated by space to stdout. (default=off).  */
  const char *server_mechanisms_help; /**< @brief Write name of supported server mechanisms separated by space to stdout. help description.  */
  char * connect_arg;	/**< @brief Connect to TCP server and negotiate on stream instead of stdin/stdout. PORT is the protocol service, or an integer denoting the port, and defaults to 143 (imap) if not specified. Also sets the --hostname default..  */
  char * connect_orig;	/**< @brief Connect to TCP server and negotiate on stream instead of stdin/stdout. PORT is the protocol service, or an integer denoting the port, and defaults to 143 (imap) if not specified. Also sets the --hostname default. original value given at command line.  */
  const char *connect_help; /**< @brief Connect to TCP server and negotiate on stream instead of stdin/stdout. PORT is the protocol service, or an integer denoting the port, and defaults to 143 (imap) if not specified. Also sets the --hostname default. help description.  */
  int application_data_flag;	/**< @brief After authentication, read data from stdin and run it through the mechanism's security layer and print it base64 encoded to stdout. The default is to terminate after authentication. (default=on).  */
  const char *application_data_help; /**< @brief After authentication, read data from stdin and run it through the mechanism's security layer and print it base64 encoded to stdout. The default is to terminate after authentication. help description.  */
  int imap_flag;	/**< @brief Use a IMAP-like logon procedure (client only). Also sets the --service default to 'imap'. (default=off).  */
  const char *imap_help; /**< @brief Use a IMAP-like logon procedure (client only). Also sets the --service default to 'imap'. help description.  */
  int smtp_flag;	/**< @brief Use a SMTP-like logon procedure (client only). Also sets the --service default to 'smtp'. (default=off).  */
  const char *smtp_help; /**< @brief Use a SMTP-like logon procedure (client only). Also sets the --service default to 'smtp'. help description.  */
  char * mechanism_arg;	/**< @brief Mechanism to use..  */
  char * mechanism_orig;	/**< @brief Mechanism to use. original value given at command line.  */
  const char *mechanism_help; /**< @brief Mechanism to use. help description.  */
  int no_client_first_flag;	/**< @brief Disallow client to send data first (client only). (default=off).  */
  const char *no_client_first_help; /**< @brief Disallow client to send data first (client only). help description.  */
  char * anonymous_token_arg;	/**< @brief Token for anonymous authentication, usually mail address (ANONYMOUS only)..  */
  char * anonymous_token_orig;	/**< @brief Token for anonymous authentication, usually mail address (ANONYMOUS only). original value given at command line.  */
  const char *anonymous_token_help; /**< @brief Token for anonymous authentication, usually mail address (ANONYMOUS only). help description.  */
  char * authentication_id_arg;	/**< @brief Identity of credential owner..  */
  char * authentication_id_orig;	/**< @brief Identity of credential owner. original value given at command line.  */
  const char *authentication_id_help; /**< @brief Identity of credential owner. help description.  */
  char * authorization_id_arg;	/**< @brief Identity to request service for..  */
  char * authorization_id_orig;	/**< @brief Identity to request service for. original value given at command line.  */
  const char *authorization_id_help; /**< @brief Identity to request service for. help description.  */
  char * password_arg;	/**< @brief Password for authentication (insecure for non-testing purposes)..  */
  char * password_orig;	/**< @brief Password for authentication (insecure for non-testing purposes). original value given at command line.  */
  const char *password_help; /**< @brief Password for authentication (insecure for non-testing purposes). help description.  */
  char * realm_arg;	/**< @brief Realm. Defaults to hostname..  */
  char * realm_orig;	/**< @brief Realm. Defaults to hostname. original value given at command line.  */
  const char *realm_help; /**< @brief Realm. Defaults to hostname. help description.  */
  int maxbuf_arg;	/**< @brief Indicate maximum buffer size (DIGEST-MD5 only)..  */
  char * maxbuf_orig;	/**< @brief Indicate maximum buffer size (DIGEST-MD5 only). original value given at command line.  */
  const char *maxbuf_help; /**< @brief Indicate maximum buffer size (DIGEST-MD5 only). help description.  */
  char * passcode_arg;	/**< @brief Passcode for authentication (SECURID only)..  */
  char * passcode_orig;	/**< @brief Passcode for authentication (SECURID only). original value given at command line.  */
  const char *passcode_help; /**< @brief Passcode for authentication (SECURID only). help description.  */
  char * service_arg;	/**< @brief Set the requested service name (should be a registered GSSAPI host based service name)..  */
  char * service_orig;	/**< @brief Set the requested service name (should be a registered GSSAPI host based service name). original value given at command line.  */
  const char *service_help; /**< @brief Set the requested service name (should be a registered GSSAPI host based service name). help description.  */
  char * hostname_arg;	/**< @brief Set the name of the server with the requested service..  */
  char * hostname_orig;	/**< @brief Set the name of the server with the requested service. original value given at command line.  */
  const char *hostname_help; /**< @brief Set the name of the server with the requested service. help description.  */
  char * service_name_arg;	/**< @brief Set the generic server name in case of a replicated server (DIGEST-MD5 only)..  */
  char * service_name_orig;	/**< @brief Set the generic server name in case of a replicated server (DIGEST-MD5 only). original value given at command line.  */
  const char *service_name_help; /**< @brief Set the generic server name in case of a replicated server (DIGEST-MD5 only). help description.  */
  int enable_cram_md5_validate_flag;	/**< @brief Validate CRAM-MD5 challenge and response interactively. (default=off).  */
  const char *enable_cram_md5_validate_help; /**< @brief Validate CRAM-MD5 challenge and response interactively. help description.  */
  int disable_cleartext_validate_flag;	/**< @brief Disable cleartext validate hook, forcing server to prompt for password. (default=off).  */
  const char *disable_cleartext_validate_help; /**< @brief Disable cleartext validate hook, forcing server to prompt for password. help description.  */
  char * quality_of_protection_arg;	/**< @brief How application payload will be protected. 'auth' means no protection, 'auth-int' means integrity protection, 'auth-conf' means integrity and confidentialiy protection.  Currently only used by DIGEST-MD5, where the default is 'auth-conf'..  */
  char * quality_of_protection_orig;	/**< @brief How application payload will be protected. 'auth' means no protection, 'auth-int' means integrity protection, 'auth-conf' means integrity and confidentialiy protection.  Currently only used by DIGEST-MD5, where the default is 'auth-conf'. original value given at command line.  */
  const char *quality_of_protection_help; /**< @brief How application payload will be protected. 'auth' means no protection, 'auth-int' means integrity protection, 'auth-conf' means integrity and confidentialiy protection.  Currently only used by DIGEST-MD5, where the default is 'auth-conf'. help description.  */
  int starttls_flag;	/**< @brief Force use of STARTTLS.  The default is to use STARTTLS when available. (default=off).  */
  const char *starttls_help; /**< @brief Force use of STARTTLS.  The default is to use STARTTLS when available. help description.  */
  int no_starttls_flag;	/**< @brief Unconditionally disable STARTTLS. (default=off).  */
  const char *no_starttls_help; /**< @brief Unconditionally disable STARTTLS. help description.  */
  char * x509_ca_file_arg;	/**< @brief File containing one or more X.509 Certificate Authorities certificates in PEM format, used to verify the certificate received from the server.  If not specified, no verification of the remote server certificate will be done..  */
  char * x509_ca_file_orig;	/**< @brief File containing one or more X.509 Certificate Authorities certificates in PEM format, used to verify the certificate received from the server.  If not specified, no verification of the remote server certificate will be done. original value given at command line.  */
  const char *x509_ca_file_help; /**< @brief File containing one or more X.509 Certificate Authorities certificates in PEM format, used to verify the certificate received from the server.  If not specified, no verification of the remote server certificate will be done. help description.  */
  char * x509_cert_file_arg;	/**< @brief File containing client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair..  */
  char * x509_cert_file_orig;	/**< @brief File containing client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair. original value given at command line.  */
  const char *x509_cert_file_help; /**< @brief File containing client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair. help description.  */
  char * x509_key_file_arg;	/**< @brief Private key for the client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair..  */
  char * x509_key_file_orig;	/**< @brief Private key for the client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair. original value given at command line.  */
  const char *x509_key_file_help; /**< @brief Private key for the client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair. help description.  */
  int verbose_flag;	/**< @brief Produce verbose output. (default=off).  */
  const char *verbose_help; /**< @brief Produce verbose output. help description.  */
  int quiet_flag;	/**< @brief Don't produce any diagnostic output. (default=off).  */
  const char *quiet_help; /**< @brief Don't produce any diagnostic output. help description.  */
  
  int help_given ;	/**< @brief Whether help was given.  */
  int version_given ;	/**< @brief Whether version was given.  */
  int client_given ;	/**< @brief Whether client was given.  */
  int server_given ;	/**< @brief Whether server was given.  */
  int client_mechanisms_given ;	/**< @brief Whether client-mechanisms was given.  */
  int server_mechanisms_given ;	/**< @brief Whether server-mechanisms was given.  */
  int connect_given ;	/**< @brief Whether connect was given.  */
  int application_data_given ;	/**< @brief Whether application-data was given.  */
  int imap_given ;	/**< @brief Whether imap was given.  */
  int smtp_given ;	/**< @brief Whether smtp was given.  */
  int mechanism_given ;	/**< @brief Whether mechanism was given.  */
  int no_client_first_given ;	/**< @brief Whether no-client-first was given.  */
  int anonymous_token_given ;	/**< @brief Whether anonymous-token was given.  */
  int authentication_id_given ;	/**< @brief Whether authentication-id was given.  */
  int authorization_id_given ;	/**< @brief Whether authorization-id was given.  */
  int password_given ;	/**< @brief Whether password was given.  */
  int realm_given ;	/**< @brief Whether realm was given.  */
  int maxbuf_given ;	/**< @brief Whether maxbuf was given.  */
  int passcode_given ;	/**< @brief Whether passcode was given.  */
  int service_given ;	/**< @brief Whether service was given.  */
  int hostname_given ;	/**< @brief Whether hostname was given.  */
  int service_name_given ;	/**< @brief Whether service-name was given.  */
  int enable_cram_md5_validate_given ;	/**< @brief Whether enable-cram-md5-validate was given.  */
  int disable_cleartext_validate_given ;	/**< @brief Whether disable-cleartext-validate was given.  */
  int quality_of_protection_given ;	/**< @brief Whether quality-of-protection was given.  */
  int starttls_given ;	/**< @brief Whether starttls was given.  */
  int no_starttls_given ;	/**< @brief Whether no-starttls was given.  */
  int x509_ca_file_given ;	/**< @brief Whether x509-ca-file was given.  */
  int x509_cert_file_given ;	/**< @brief Whether x509-cert-file was given.  */
  int x509_key_file_given ;	/**< @brief Whether x509-key-file was given.  */
  int verbose_given ;	/**< @brief Whether verbose was given.  */
  int quiet_given ;	/**< @brief Whether quiet was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 0) */
  int check_required; /**< @brief whether to check that all required options were provided (default 0) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char * const *argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to 0
 * @return the initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_init();

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* GSASL_CMD_H */
