'\" t
.TH groff @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
groff \- GNU
.I roff
language reference
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright 2000-2024 Free Software Foundation, Inc.
.\"           2017-2025 G. Branden Robinson
.\"
.\" This file is part of groff, the GNU roff typesetting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_groff_7_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.\" Local definitions
.\" ====================================================================
.
.\" define a string tx for the TeX logo
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el   .ds tx TeX
.
.
.\" ====================================================================
.\" Setup
.\" ====================================================================
.
.\" Man pages should not define page-local macros.  Most of these were
.\" written long ago; someday we'll revise the page without them.
.
.\" ====================================================================
.\" start a macro, escape sequence, or register definition
.
.de TPx
.  TP 11n \" ".linetabs" + 2n
..
.\" ====================================================================
.\" .Text anything ...
.\"
.\" All arguments are printed as text.
.\"
.de Text
.  nop \)\\$*
..
.
.\" ========= characters =========
.
.de squoted_char
.  Text \[oq]\f[B]\\$1\f[]\[cq]\\$2
..
.de dquoted_char
.  Text \[lq]\f[B]\\$1\f[]\[rq]\\$2
..
.\" ========= requests =========
.
.\" synopsis of a request
.de REQ
.  ie \\n[.$]=1 \{\
.    Text \%\f[B]\\$1\f[]
.  \}
.  el \{\
.    Text \%\f[B]\\$1\~\f[]\f[I]\\$2\f[]
.  \}
..
.
.\" reference of a request
.de request
.  ie (\\n[.$] < 2) \
.    B \%\\$*
.  el \
.    BR \%\\$*
..
.
.\" ========= numeric elements =========
.
.\" number with a trailing unit
.de scalednumber
.  Text \\$1\^\f[B]\\$2\f[]\\$3\f[R]
.  ft P
..
.
.\" representation of units within the text
.de scaleindicator
.  Text \f[B]\\$1\f[]\\$2\f[R]
.  ft P
..
.
.\" representation of mathematical operators within the text
.de operator
.  squoted_char \\$@
..
.
.
.\" ========= escape sequences =========
.
.\" ====================================================================
.\" .ESC name [arg]
.\"
.\" Synopsis of an escape sequence, optionally with argument
.\" Args   : 1 or 2; 'name' obligatory, 'arg' optional
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary word
.\" Result : prints \namearg, where 'name' is in B, 'arg' in I
.\"
.de ESC
.  Text "\f[B]\e\\$1\,\f[I]\\$2\/\fR"
..
.\" ====================================================================
.\" .ESC[] name arg
.\"
.\" Synopsis for escape sequence with a bracketed long argument
.\" Args   : 2 obligatory
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary text
.\" Result : prints \name[arg], where 'name' is in B, 'arg' in I
.\"
.de ESC[]
.  Text "\f[B]\e\\$1\[lB]\f[]\,\f[I]\\$2\/\f[]\f[B]\[rB]\f[]"
..
.\" ====================================================================
.\" .ESCq name arg
.\"
.\" Synopsis for escape sequence with a bracketed long argument
.\" Args   : 2 obligatory
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary text
.\" Result : prints \name'arg', where 'name' is in B, 'arg' in I
.\"
.de ESCq
.  Text "\f[B]\e\\$1\[aq]\f[]\,\f[I]\\$2\/\f[]\f[B]\[aq]\f[]"
..
.\" ====================================================================
.\" .ESC? arg
.\"
.\" Synopsis for escape sequence with a bracketed long argument
.\" Args   : 1 obligatory
.\"   arg  : arbitrary text
.\" Result : prints '\?arg\?', where the '\?' are in B, 'arg' in I
.\"
.de ESC?
.  Text "\f[B]\e?\,\f[I]\\$1\/\f[B]\[rs]?\f[R]"
..
.\" ====================================================================
.\" .esc name [punct]
.\"
.\" Reference of an escape sequence (no args), possibly punctuation
.\" Args    : 1 obligatory
.\"   name  : suitable name for an escape sequence (c, (xy, [long])
.\"   punct : arbitrary
.\" Result  : prints \name, where 'name' is in B, 'punct' in R
.\"
.de esc
.  ie (\\n[.$] < 2) \
.    B "\e\\$1"
.  el \
.    BR "\e\\$1" \\$2
..
.\" ====================================================================
.\" .escarg name arg [punct]
.\"
.\" Reference of an escape sequence (no args)
.\" Args    : 1 obligatory, 1 optional
.\"   name  : suitable name for an escape sequence (c, (xy, [long])
.\"   arg   : arbitrary word
.\" Result  : prints \namearg, where
.\"           'name' is in B, 'arg' in I
.\"
.de escarg
.  Text \f[B]\e\\$1\f[]\,\f[I]\\$2\/\f[]\\$3
..
.\" ====================================================================
.\" .esc[] name arg [punct]
.\"
.\" Reference for escape sequence with a bracketed long argument
.\" Args   : 2 obligatory
.\"   name : suitable name for an escape sequence (c, (xy, [long])
.\"   arg  : arbitrary text
.\" Result : prints \name[arg], where 'name' is in B, 'arg' in I
.\"
.de esc[]
.  Text \f[B]\e\\$1\[lB]\f[]\,\f[I]\\$2\/\f[]\f[B]\[rB]\f[]\\$3
..
.
.\" ========= strings =========
.
.\" synopsis for string, with \*[]
.de STRING
.  Text \[rs]*[\f[B]\\$1\f[]] \\$2
..
.\" synopsis for a long string
.de string
.  if \n[.$]=0 \
.    return
.  Text \f[B]\[rs]*\[lB]\\$1\[rB]\f[]\\$2
..
.
.\" ========= registers =========
.
.\" synopsis for registers, with \n[]
.de REG
.  Text \%\[rs]n[\f[B]\\$1\f[]]
..
.\" reference of a register, without decoration
.de register
.  Text register
.  ie (\\n[.$] < 2) \
.    B \\$*
.  el \
.    BR \\$*
..
.
.\" begin list [piloting a possible extension to man(7)]
.de LS
.  nr saved-PD \\n[PD]
.  nr PD 0
..
.
.\" end list [piloting a possible extension to man(7)]
.de LE
.  nr PD \\n[saved-PD]
..
.
.
.\" end of macro definitions
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I groff
is short for GNU
.IR roff ,
a free reimplementation of the AT&T device-independent
.I troff \" AT&T
typesetting system.
.
See
.MR roff @MAN7EXT@
for a survey of and background on
.I roff
systems.
.
.
.P
This document is intended as a reference.
.
The primary
.I groff
manual,
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is a better resource for learners,
containing many examples and much discussion.
.
It is written in Texinfo;
you can browse it interactively with \[lq]info groff\[rq].
.
Additional formats,
including plain text,
HTML,
\*(tx DVI,
and PDF,
may be available in
.IR @DOCDIR@ .
.
.
.\" BEGIN Keep parallel with groff.texi node "Conventions Used in This
.\" Manual", first paragraph.
.P
We apply the term \[lq]groff\[rq] to the language documented here,
the GNU implementation of the overall system,
the project that develops that system,
and the command of that name.
.
In the first sense,
.I groff
is an extended dialect of the
.I roff
language,
for which many
similar implementations exist.
.
We say \[lq]the formatter\[rq] when speaking of behavior
that is generally true of
.I troff \" generic
and
.I nroff \" generic
programs.
.\" END Keep parallel with groff.texi node "Conventions Used in This
.\" Manual", first paragraph.
.
.
.P
GNU
.IR troff , \" GNU
installed on this system as
.MR @g@troff @MAN1EXT@ ,
is the
.I formatter:
a program that reads device and font descriptions
(\c
.MR groff_font @MAN5EXT@ ),
interprets the
.I groff
language expressed in input text,
and translates it into a device-independent page description language
(\c
.MR groff_out @MAN5EXT@ )
that is usually then post-processed by an output driver to produce
PostScript,
PDF,
HTML,
DVI,
or terminal output.
.
.
.\" ====================================================================
.SH "Input format"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Input Format".
Organize input to
GNU
.I troff \" GNU
into lines separated by the Unix newline character
(U+000A),
using the character encoding it recognizes:
ISO\~Latin-1 (8859-1).
.
We recommend use of ISO\~646:1991\~IRV (US-ASCII)
or (equivalently) the Basic Latin subset
of ISO\~10646 (Unicode);
see
.MR groff_char @MAN7EXT@ .
.
.
.P
Some control characters
(from the sets \[lq]C0 Controls\[rq] and \[lq]C1 Controls\[rq]
as Unicode describes them)
are invalid as input characters.
.
GNU
.I troff \" GNU
discards them upon reading.
(It also emits a warning in category
\[lq]input\[rq];
see section \[lq]Warnings\[rq] of
.MR @g@troff @MAN1EXT@ .)
.
It processes
a character sequence \[lq]foo\[rq],
followed by an invalid
character and then \[lq]bar\[rq],
as \[lq]foobar\[rq].
.
.
.P
Invalid input characters comprise
.BR 0x00 ,
.BR 0x0B ,
.BR 0x0D \[en] 0x1F ,
and
.BR 0x80 \[en] 0x9F .
(Historically,
control characters like
ASCII
STX,
ETX,
and
BEL
(Control+B,
Control+C,
and
Control+G)
respectively)
have been observed in
.I roff
documents,
particularly in macro packages employing them as delimiters
with the output comparison operator
to try to avoid collisions with the content
of arbitrary user-supplied parameters
(see subsection \[lq]Conditional expressions\[rq] below).
.
We discourage this expedient;
in
GNU
.I troff \" GNU
it is unnecessary
(outside of compatibility mode)
because the program parses delimited arguments
at a different input level than their surrounding context.
.
See section \[lq]Miscellaneous\[rq] of
.MR groff_diff @MAN7EXT@ .)
.
GNU
.I troff \" GNU
uses some of these code points for internal purposes,
making non-trivial the extension of the program
to accept UTF-8
or other encodings that use characters from these ranges.
.\" END Keep (roughly) parallel with groff.texi node "Input Format".
.
.
.\" ====================================================================
.SH "Syntax characters"
.\" ====================================================================
.
Several input characters are syntactically significant to
.IR groff .
.
The most important of these distinguish
.I "control lines,"
which instruct the formatter,
from
.I "text lines"
that are formatted as output.
.
.
.IP . 4n
A dot at the beginning of an input line marks it as a control line.
.
It can also follow the
.request el
and
.request nop
requests,
and the condition in
.RB \[lq] if \[rq],
.request ie ,
and
.RB \[lq] while \[rq]
requests.
.
The control character invokes requests and calls macros by the name that
follows it.
.
The
.request cc
request can change the control character.
.
.
.IP \[aq]
The neutral apostrophe is the
.I "no-break control character,"
recognized where the control character is.
.
It suppresses the (first) break implied by the
.request bp ,
.request ce ,
.request cf ,
.request fi ,
.request fl ,
.RB \[lq] in \[rq],
.request nf ,
.request rj ,
.request sp ,
.request ti ,
and
.request trf
requests.
.
The requested operation takes effect at the next break.
.
It makes
.request br
and
.request brp
nilpotent.
.
The no-break control character can be changed with the
.request c2
request.
.
When formatted,
.RB \[lq] \[aq] \[rq]
may be typeset as a typographical quotation mark;
use the
.esc [aq]
special character escape sequence to format a neutral apostrophe glyph.
.
.
.IP \[dq]
The neutral double quote can be used to enclose arguments to macros and
strings,
and is required if those arguments contain space or tab characters.
.
The requests
.RB \[lq] as \[rq],
.request as1 ,
.request cf ,
.request char ,
.request ds ,
.request ds1 ,
.request fchar ,
.request fschar ,
.request mso ,
.request msoquiet ,
.request nx ,
.RB \[lq] open \[rq],
.request opena ,
.request pi ,
.request schar ,
.RB \[lq] so \[rq],
.request soquiet ,
.request sy ,
and
.request trf
strip a leading neutral double quote
from their final arguments
to allow embedding of leading spaces.
All such arguments are \[lq]strings\[rq] in a general sense,
representing character sequences,
file names,
operating system commands,
or parameters to an output device extension command.
.
To include a double quote inside a quoted argument,
use the
.esc [dq]
special character escape sequence
(which also serves to typeset the glyph in text).
.
.
.IP \[rs]
A backslash introduces an escape sequence.
.
The escape character can be changed with the
.request ec
request;
.request eo
disables escape sequence recognition.
.
Use the
.esc [rs]
special character escape sequence to format a backslash glyph,
and
.esc e
to typeset the glyph of the current escape character.
.
.
.IP (
An opening parenthesis is special only in certain escape sequences;
when recognized,
it introduces an argument of exactly two characters.
.
.I groff
offers the more flexible square bracket syntax.
.
.
.IP [
An opening bracket is special only in certain escape sequences;
when recognized,
it introduces an argument (list) of any length,
not including a closing bracket.
.
.
.IP ]
A closing bracket is special only when an escape sequence using an
opening bracket as an argument delimiter is being interpreted.
.
It ends the argument (list).
.
.
.P
Additionally,
the Control+A character (U+0001) in text is interpreted as a
.I leader
(see below).
.
.
.P
Horizontal whitespace characters are significant to
.I groff,
but trailing spaces on text lines are ignored.
.\" slack text for widow/orphan control: trailing tabs are not
.
.
.TP 9n \" "newline" + 2n
.I space
On control lines and within bracketed escape sequences,
spaces separate arguments.
.
On text lines,
they separate words.
.
Multiple adjacent space characters in text cause
.I groff
to attempt end-of-sentence detection on the preceding word
(and trailing punctuation).
.
The amount of space between words and sentences is controlled by the
.request ss
request.
.
When filling is enabled
(the default),
a line may be broken at a space.
.
When adjustment is enabled
(the default),
inter-word spaces are expanded until the output line reaches the
configured length.
.
An adjustable but non-breaking space is available with
.esc \[ti] .
.
To get a space of fixed width,
use one of the escape sequences
.squoted_char "\[rs]\~"
(the escape character followed by a space),
.esc 0 ,
.esc | ,
.esc \[ha] ,
or
.esc h ;
see section \[lq]Escape sequences\[rq] below.
.
.
.TP
.I newline
On text lines,
a newline formats an inter-word space and,
if filling is enabled,
triggers end-of-sentence recognition on the preceding text.
.
See section \[lq]Line continuation\[rq] below.
.
.
.TP
.I tab
A tab character on a text line causes the drawing position to advance to
the next defined tab stop.
.
.
.\" ====================================================================
.SH Sentences
.\" ====================================================================
.
Configure the sets of characters that potentially end sentences
or are transparent to sentence endings
with the
.B \%cflags
request.
.\" (@pxref{Using Symbols}).
.
Use the
.B ss
request
to change\[em]or eliminate\[em]supplemental inter-sentence space.
.\" (@pxref{Manipulating Filling and Adjustment}).
.
.\" ====================================================================
.SH "Tabs and leaders"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Tabs and
.\" Leaders".
The formatter interprets input horizontal tab characters
(\[lq]tabs\[rq]) and Control+A characters (\[lq]leaders\[rq]) into
movements to the next tab stop.
.
Tabs simply move to the next tab stop;
leaders place enough periods to fill the space.
.
Tab stops are by default located every half inch measured from the
drawing position corresponding to the beginning of the input line;
see section \[lq]Page geometry\[rq] of
.MR roff 7 .
.
Tabs and leaders do not cause breaks and therefore do not interrupt
filling.
.
Tab stops can be configured with the
.B ta
request,
and tab and leader glyphs with the
.B tc
and
.B lc
requests,
respectively.
.\" END Keep (roughly) parallel with groff.texi node "Tabs and Leaders".
.
.
.\" ====================================================================
.SH "Line continuation"
.\" ====================================================================
.
When filling is enabled,
input and output line breaks generally do not correspond.
.
The
.I roff
language therefore distinguishes input and output line continuation.
.
.
.P
A backslash
.B \[rs]
immediately followed by a newline,
sometimes discussed as
.BI \[rs] newline\c
,
suppresses the effects of that newline
on the input.
.
The next input line thus retains the classification of its predecessor
as a control or text line.
.
.BI \[rs] newline
is useful for managing line lengths in the input during document
maintenance;
you can break an input line at a space,
or in the middle of a word,
request invocation,
macro call,
or escape sequence.
.
Input line continuation is invisible to the formatter,
with two exceptions:
the
.B \[or]
operator recognizes the new input line,
and the input line counter register
.B .c
increments.
.
.
.P
The
.esc c
escape sequence continues an
.I output
line.
.
Nothing on the input line after it is formatted.
.
In contrast to
.BI \[rs] newline\c
,
a line after
.esc c
is treated as a new input line,
so a control character is recognized at its beginning.
.
The visual results depend on whether filling is enabled.
.
An intervening control line that causes a break overrides
.esc c ,
flushing out the pending output line in the usual way.
.
The
.register .int
interpolates a positive value only if the pending output line has been
continued with
.esc c ;
this datum is associated with the
environment.
.
.
.\" ====================================================================
.SH Colors
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Colors".
.I groff
supports color output with a variety of color spaces and up to 16 bits
per channel.
.
Some devices,
particularly terminals,
may be more limited.
.
When color support is enabled,
two colors are current at any given time:
the
.I stroke color,
with which glyphs,
rules (lines),
and geometric objects like circles and polygons are drawn,
and the
.I fill color,
which can be used to paint the interior of a closed geometric figure.
.
The
.BR color ,
.BR \%defcolor ,
.BR gcolor ,
and
.B fcolor
requests;
.B \[rs]m
and
.B \[rs]M
escape sequences;
and
.BR .color ,
.BR .m ,
and
.B .M
registers exercise color support.
.
.
.P
Each output device has a color named
.RB \[lq] default \[rq],
which cannot be redefined.
.
A device's default stroke and fill colors are not necessarily the same.
.
For the
.BR dvi ,
.BR html ,
.BR pdf ,
.BR ps ,
and
.B xhtml
output devices,
.I @g@troff
automatically loads a macro file defining many color names at startup.
.
By the same mechanism,
the devices supported by
.MR grotty @MAN1EXT@
recognize the eight standard ISO\~6429/ECMA-48 color names.
(These are known vulgarly as \[lq]ANSI\[rq] colors,
after its X3.64 standard,
now withdrawn.)
.\" END Keep (roughly) parallel with groff.texi node "Colors".
.
.
.br
.ne 3v
.\" ====================================================================
.SH Measurements
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Measurements".
Express numeric parameters that specify measurements
as integers
or decimal fractions
with an optional scaling unit suffixed.
.
A
.I "scaling unit"
is a letter
that immediately follows the magnitude of a measurement.
.
Digits after the decimal point are optional.
.
.
.P
The formatter scales measurements by the specified scaling unit,
storing them internally
(with any fractional part discarded)
in basic units.
.
The device resolution can therefore be obtained
by storing a value of
.RB \[lq] 1i \[rq]
to a register,
then reading the register.
.
.
.P
.LS
.TP
.B u
Basic unit;
it is at least as small as any other unit.
.
.TP
.B i
Inch;
defined as 2.54\~centimeters.
.
.TP
.B c
Centimeter.
.
.TP
.B p
Point;
a typesetter's unit used for measuring type size.
.
There are 72\~points to an inch.
.
.TP
.B P
Pica;
another typesetter's unit.
.
There are 6\~picas to an inch and 12\~points to a pica.
.
.TP
.B z
Typographical point;
like
.BR p ,
but used only with type sizes,
to overcome a limitation of AT&T
.IR troff . \" AT&T
.
.TP
.B s
Scaled point.
.
.TP
.B f
Multiplication by 65,536;
.
scales decimal fractions in the interval [0, 1] to 16-bit unsigned
integers.
.LE
.
.
.P
The magnitudes of other scaling units depend on the text formatting
parameters in effect.
.
.
.P
.LS
.TP
.B m
Em;
an em is equal to the current type size in points.
.
.TP
.B n
En;
on typesetters,
an en is one-half em,
but on terminals an en equals an em.
.
.TP
.B v
Vee;
distance between text baselines.
.
.TP
.B M
Hundredth of an em.
.LE
.\" END Keep (roughly) parallel with groff.texi node "Measurements".
.
.
.\" ====================================================================
.SS "Motion quanta"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Motion Quanta".
The basic unit
.B u
is not necessarily an output device's smallest addressable length;
.B u
can be smaller to avoid integer rounding errors.
.
The minimum distances that a device can work with
in the horizontal and vertical directions are termed its
.I "motion quanta,"
stored in the
.B .H
and
.B .V
registers,
respectively.
.
The formatter rounds measurements to applicable motion quanta.
.
Half-quantum fractions round toward zero.
.\" END Keep (roughly) parallel with groff.texi node "Motion Quanta".
.
.
.\" ====================================================================
.SS "Default units"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Default Units".
A general-purpose register
(one created or updated with the
.B nr
request;
see section \[lq]Registers\[rq] below)
is implicitly dimensionless,
or reckoned in basic units if interpreted in a measurement context.
.
But it is convenient for many requests and escape sequences to infer a
scaling unit for an argument if none is specified.
.
An explicit scaling unit
(not after a closing parenthesis)
can override an undesirable default.
.
Effectively,
the default unit is suffixed to the expression if a scaling unit is not
already present.
.
GNU
.IR troff 's \" GNU
use of integer arithmetic in numeric expressions
should also be kept in mind.
.\" END Keep (roughly) parallel with groff.texi node "Default Units".
.
.
.br
.ne 5v
.\" ====================================================================
.SH "Numeric expressions"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Numeric
.\" expressions".
When evaluated,
a
.I numeric expression
interpolates an integer.
.\"It can be as simple as a literal
.\".RB \[lq] 0 \[rq]
.\"or it can be a complex sequence of register and string interpolations
.\"interleaved with measurements and operators.
.
GNU
.I troff \" GNU
recognizes the following operators.
.
.
.P
.TS
Rf(CR) L.
+	addition
\-	subtraction
*	multiplication
/	truncating division
%	modulus
_
\f[R]unary\f[] +	assertion, motion, incrementation
\f[R]unary\f[] \-	negation, motion, decrementation
_
;	scaling
>?	maximum
<?	minimum
_
<	less than
>	greater than
<=	less than or equal
>=	greater than or equal
\&=	equal
==	equal
_
&	logical conjunction (\[lq]and\[rq])
:	logical disjunction (\[lq]or\[rq])
!	logical complementation (\[lq]not\[rq])
_
( )	precedence
_
|	boundary-relative measurement
.TE
.
.
.P
.I @g@troff
provides a set of mathematical and logical operators familiar to
programmers\[em]as well as some unusual ones\[em]but supports only
integer arithmetic.
.
(Provision is made for interpreting and
reporting decimal fractions in certain cases.)
.
The internal data type used for computing results depends on the host
machine but is at least a 32-bit signed integer,
which suffices to represent magnitudes within a range of \[+-]2
billion.
.
(If that's not enough, see
.MR groff_tmac @MAN5EXT@
for the
.I 62bit.tmac
macro package.)
.
Arithmetic saturates.
(If overflow would occur,
GNU
.I troff \" GNU
emits a warning in category
.RB \%\[lq] range \[rq].
See section \[lq]Warnings\[rq] of
.MR @g@troff 1 .)
.
.
.P
Arithmetic infix operators perform a function on the numeric expressions
to their left and right;
they are
.B +
(addition),
.B \-
(subtraction),
.B *
(multiplication),
.B /
(truncating division),
and
.B %
(modulus).
.
.I Truncating division
rounds to the integer nearer to zero,
no matter how large the fractional portion.
.
Division and modulus by zero
are errors and abort evaluation of a numeric expression.
.
.
.P
Arithmetic unary operators operate on the numeric expression to their
right;
they are
.B \-
(negation)
and
.B +
(assertion\[em]for completeness;
it does nothing).
.
The unary minus must often be used with parentheses to avoid confusion
with the decrementation operator,
discussed below.
.
.
.P
The sign of the modulus of operands of mixed signs is determined by the
sign of the first.
.
Division and modulus operators satisfy the following property:
given a
.RI dividend\~ a
and a
.RI divisor\~ b ,
a
.RI quotient\~ q
formed by
.RB \[lq] "(a / b)" \[rq]
and a
.RI remainder\~ r
by
.RB \[lq] "(a % b)" \[rq],
then
.IR qb \~+\~ r \~=\~ a .
.
.
.P
GNU
.IR troff 's \" GNU
scaling operator,
used with parentheses as
.BI ( c ; e )\c
,
evaluates a numeric
.RI expression\~ e
.RI using\~ c
as the default scaling unit.
.
If
.I c
is omitted,
scaling units are ignored in the evaluation
.RI of\~ e .
.
GNU
.I troff \" GNU
also provides a pair of operators to compute the extremum of two
operands:
.B >?\&
(maximum)
and
.B <?\&
(minimum).
.
.
.P
Comparison operators comprise
.B <
(less than),
.B >
(greater than),
.B <=
(less than or equal),
.B >=
(greater than or equal),
and
.B =
(equal,
with a synonym
.BR == ).
.
When evaluating a comparison,
the formatter replaces it with
.RB \[lq] 0 \[rq]
if it is false and
.RB \[lq] 1 \[rq]
if true.
.
In the
.I roff
language,
positive values are true,
others false.
.
.
.P
Operate on truth values with the logical operators
.B &
(logical conjunction or \[lq]and\[rq])
and
.B :
(logical disjunction or \[lq]or\[rq]).
.
They evaluate as comparison operators do.
.
A logical complementation (\[lq]not\[rq]) operator,
.B !\&,
works only within
.RB \[lq] if \[rq],
.RB \[lq] ie \[rq],
and
.RB \[lq] while \[rq]
requests.
.
.\" This is worded to avoid implying that the operator doesn't apply to
.\" conditional expressions in general, albeit without mentioning them
.\" because they're out of scope.
Furthermore,
the formatter recognizes
.B !\&
only at the beginning of a numeric expression
not contained by another numeric expression.
.
In other words,
.B !\&
must be the \[lq]outermost\[rq] operator.
.
Its presence elsewhere causes the expression
to evaluate false.
.
(GNU
.I troff \" GNU
emits a warning in category
.RB \%\[lq] number \[rq].
See section \[lq]Warnings\[rq] of
.MR @g@troff @MAN1EXT@ .)
.
This unfortunate limitation maintains compatibility with AT&T
.IR troff .\" AT&T
.
Test a numeric expression for falsity
within a complex expression
by comparing it to a false value.
.
.
.P
The
.I roff
language has no operator precedence:
expressions are evaluated strictly from left to right,
in contrast to schoolhouse arithmetic.
.
Use parentheses
.B ( )
to impose a desired precedence upon subexpressions.
.
.
.P
For many requests and escape sequences that cause motion on the page,
the unary operators
.B +
and
.B \-
work differently when leading a numeric expression.
.
They then indicate a motion relative to the drawing position:
positive is down in vertical contexts,
right in horizontal ones.
.
.
.P
.B +
and
.B \-
are also treated differently by the following requests and escape
sequences:
.BR bp ,
.BR in ,
.BR ll ,
.BR pl ,
.BR pn ,
.BR po ,
.BR ps ,
.BR pvs ,
.BR rt ,
.BR ti ,
.BR \[rs]H ,
.BR \[rs]R ,
and
.BR \[rs]s .
.
Here,
leading plus and minus signs serve as incrementation and decrementation
operators,
respectively.
.
To negate an expression in these contexts,
subtract it from zero
or include the unary minus in parentheses with its argument.
.\" @xref{Setting Registers}, for examples.
.
.
.P
A leading
.B \[or]
operator indicates a motion relative not to the drawing position but to
a boundary.
.
For horizontal motions,
the measurement specifies a distance relative to a drawing position
corresponding to the beginning of the
.I input
line.
.
By default,
tab stops reckon movements in this way.
Most escape sequences do not;
.\" XXX: Which ones do?
.B \[or]
tells them to do so.
.
For vertical motions,
the
.B \[or]
operator specifies a distance from the first text baseline on the page
or in the current diversion,
using the current vertical spacing.
.
.
.P
The
.B \[rs]B
escape sequence tests its argument for validity as a numeric expression.
.
.
.br
.ne 2v
.P
A register interpolated as an operand in a numeric expression must have
an Arabic format;
luckily,
this is the default.\" @xref{Assigning Register Formats}.
.
.
.P
Because spaces separate arguments to requests,
spaces are not allowed in numeric expressions
unless parentheses surround the (sub)expression containing them.
.\"@xref{Invoking Requests}, and
.\"@ref{Conditionals and Loops}.
.\" END Keep (roughly) parallel with groff.texi node "Numeric
.\" expressions".
.
.
.\" ====================================================================
.SH Identifiers
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Identifiers".
An
.I identifier
labels a GNU
.I troff \" GNU
datum such as a register,
name
(macro,
string,
or diversion),
typeface,
color,
special character or character class,
hyphenation language code,
environment,
or stream.
.
Valid identifiers consist of one or more ordinary characters.
.
An
.I "ordinary character"
is any Unicode Basic Latin character
that is not a space and not the escape character;
recall section \[lq]Input format\[rq] above.
.
.
.P
An identifier with a closing bracket (\[lq]]\[rq]) in its name can't be
accessed with bracket-form escape sequences that expect an identifier as
a parameter.
.
Similarly,
the
identifier \[lq](\[rq] can't be interpolated
.I except
with bracket forms.
.
.
.P
Beginning a macro,
string,
or diversion name with the character
\[lq][\[rq]
or
\[lq]]\[rq]
forecloses use of the
.MR @g@refer @MAN1EXT@
preprocessor,
which recognizes input lines starting with
\[lq].[\[rq]
and
\[lq].]\[rq]
as bibliographic reference delimiters.
.
.
.P
The escape sequence
.B \[rs]A
tests its argument for validity as an identifier.
.
.
.P
The formatter's handling of undefined identifiers is context-dependent.
.
There is no way to invoke an undefined request;
such syntax is interpreted as a macro call instead.
.
If the identifier is interpreted as a string,
macro,
or diversion name,
the formatter defines it as empty and interpolates nothing.
(GNU
.I troff \" GNU
emits a warning in category
.RB \[lq] mac \[rq].
See section \[lq]Warnings\[rq] of
.MR @g@troff @MAN1EXT@ .)
.
Similarly,
if the identifier is interpreted as a register name,
the formatter initializes it to zero
and interpolates that value.
GNU
.I troff \" GNU
emits a warning in category
.RB \[lq] reg \[rq];
see section \[lq]Warnings\[rq] in
.MR @g@troff @MAN1EXT@ ,
and subsection \[lq]Interpolating registers\[rq] and section
\[lq]Strings\[rq] below.
.
Attempting to use an undefined
typeface,
special character or character class,
color,
environment,
hyphenation language code,
or
stream
generally provokes an error diagnostic.
.
.
.P
Identifiers for requests,
macros,
strings,
and diversions share one name
space;
special characters and character classes another.
.
No other object types do.
.\" END Keep (roughly) parallel with groff.texi node "Identifiers".
.
.
.br
.ne 4v
.\" ====================================================================
.SH "Control characters"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Control
.\" Characters".
.\" The mechanism of using @code{roff}'s control characters to invoke
.\" requests and call macros was introduced in @ref{Requests and Macros}.
The formatter recognizes a control character
only at the beginning of an input line,
or at the beginning of a branch of a control structure request;
.\" see @ref{Conditionals and Loops}.
see section \[lq]Control structures\[rq] below.
.
.
.P
A few requests cause a break implicitly;
use the no-break control character to prevent the break.
.
Break suppression is its sole behavioral distinction.
.
Employing the no-break control character to invoke requests that don't
cause breaks is harmless but poor style.
.
.
.P
The control character
.RB \[lq] .\& \[rq]
and the no-break control character
.RB \[lq] \|\[aq]\| \[rq]
can be changed with the
.B cc
and
.B c2
requests,
respectively.
.
Within a macro definition,
.\" you might wish to know
register
.B .br
indicates the control character used to call it.
.\" END Keep (roughly) parallel with groff.texi node "Control
.\" Characters".
.
.
.\" ====================================================================
.SH "Invoking requests"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Invoking
.\" Requests".
A control character is optionally followed by tabs and/or spaces and
then an identifier naming a request or macro.
.
The invocation of an unrecognized request is interpreted as a macro
call.
.
Defining a macro with the same name as a request replaces the request.
.
Deleting a request name with the
.B rm
request makes it unavailable.
.
The
.B als
request can alias requests,
permitting them to be wrapped or non-destructively replaced.
.
See section \[lq]Strings\[rq] below.
.
.
.br
.ne 4v
.P
There is no inherent limit on argument length or quantity.
.
Most requests take one or more arguments,
and ignore any they do not expect.
.
A request may be separated from its arguments by tabs or spaces,
but only spaces can separate an argument from its successor.
.
Only one between arguments is necessary;
any excess is ignored.
.
.\" slack text for widow/orphan management
.\" (In compatibility mode,
.\" a space is not necessary
.\" after a request or macro name of two characters' length.)
.
GNU
.I troff \" GNU
does not allow tabs for argument separation.
.
(Plan\~9
.I troff \" Plan 9
does.)
.
.
.br
.ne 3v
.P
Generally,
a space
.I within
a request argument is not relevant,
not meaningful,
or is supported by bespoke provisions,
as with the
.B tl
request's delimiters.
.
Some requests,
like
.BR ds ,
interpret the remainder of the control line as a single argument.
.
See section \[lq]Strings\[rq] below.
.
.
.P
Spaces and tabs immediately after a control character are ignored.
.
Commonly,
authors use them to indent the source of documents or macro files.
.\" END Keep (roughly) parallel with groff.texi node "Invoking
.\" Requests".
.
.
.\" ====================================================================
.SH "Calling macros"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Calling Macros".
If a macro of the desired name does not exist when called,
the formatter creates it
and assigns it an empty definition.
.
(GNU
.I troff \" GNU
emits a warning in category
.RB \[lq] mac \[rq].
.
See section \[lq]Warnings\[rq] in
.MR @g@troff @MAN1EXT@ .)
.
Calling an undefined macro
.I does
end a macro definition naming it as its end macro
(see section \[lq]Writing macros\[rq] below).
.
.
.P
To embed spaces
.I within
a macro argument,
enclose the argument in neutral double quotes
.RB \[oq] \|\[dq]\| \[cq].
.
Horizontal motion escape sequences are sometimes a better choice for
arguments to be formatted as text.
.
.
.P
The foregoing raises the question of how to embed neutral double quotes
or backslashes in macro arguments when
.I those
characters are desired as literals.
.
In GNU
.IR troff , \" GNU
the special character escape sequence
.B \[rs][rs]
produces a backslash and
.B \[rs][dq]
a neutral double quote.
.
.
.P
In GNU
.IR troff 's \" GNU
AT&T compatibility mode,
these characters remain available as
.B \[rs](rs
and
.BR \[rs](dq ,
respectively.
.
AT&T
.I troff \" AT&T
did not consistently define these special characters,
.\" It seems that AT&T troff never recognized \(rs, though DWB 3.3
.\" defined \(bs as an alias of "\" on its "Latin1" device, in
.\" deliberate(?) collision with the Bell System logo identifier.  It
.\" also defined \(dq for several devices (pcl, Latin1, nroff, ...)
.\" along with \(aq.
but its descendants can be made to support them.
.
See
.MR groff_font @MAN5EXT@ .
.
If even that is not feasible,
.\" Nope nope nope--if you're this much of a masochist, go read Texinfo.
see the \[lq]Calling Macros\[rq] section of the
.I groff
Texinfo manual for the complex macro argument quoting rules of AT&T
.IR troff . \" AT&T
.\" END Keep (roughly) parallel with groff.texi node "Calling Macros".
.
.
.\" ====================================================================
.SH "Using escape sequences"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Using Escape
.\" Sequences".
Whereas requests must occur on control lines,
escape sequences can occur intermixed with text and may appear in
arguments to requests,
macros,
and other escape sequences.
.
An escape sequence is introduced by the escape character,
a backslash
.BR \[rs] .
.\" (but see the @code{ec} request below)
.
The next character selects the escape's function.
.
.
.P
Escape sequences vary in length.
.
Some take an argument,
and of those,
some have different syntactical forms for a one-character,
two-character,
or arbitrary-length argument.
.
Others accept
.I only
an arbitrary-length argument.
.
In the former scheme,
a one-character argument follows the function character immediately,
an opening parenthesis
.RB \[lq] ( \[rq]
introduces a two-character argument
(no closing parenthesis is used),
and an argument of arbitrary length is enclosed in brackets
.RB \[lq] [] \[rq].
.
In the latter scheme,
the user selects a delimiter character.
.
A few escape sequences are idiosyncratic,
and support both of the foregoing conventions
.RB ( \|\[rs]s ),
designate their own termination sequence
.RB ( \|\[rs]? ),
consume input until the next newline
.RB ( \|\[rs]! ,
.BR \|\[rs]" ,
.BR \|\[rs]# ),
or support an additional modifier character
.RB ( \|\[rs]s
again,
and
.BR \|\[rs]n ).
.
In no case can an escape sequence parameter contain an unescaped
newline.
.\" As with requests, use of some escape sequences in source documents
.\" may interact poorly with a macro package you use; consult its
.\" documentation to learn of ``safe'' sequences or alternative
.\" facilities it provides to achieve the desired result.
.
.
.P
If the character that follows the escape character
does not identify a defined operation,
the formatter ignores the escape character.
.
(GNU
.I troff \" GNU
emits a warning in category
.RB \%\[lq] escape \[rq].
.
See section \[lq]Warnings\[rq] in
.MR @g@troff @MAN1EXT@ .)
.
.
.P
Escape sequence interpolation is of higher precedence than escape
sequence argument interpretation.
.
This rule affords flexibility in using escape sequences to construct
parameters to other escape sequences.
.
.
.P
The escape character can be interpolated
.RB ( \[rs]e ).
.
Requests permit the escape mechanism to be deactivated
.RB ( eo )
and restored,
or the escape character changed
.RB ( ec ),
and to save and restore it
.RB ( ecs
and
.BR ecr ).
.\" END Keep (roughly) parallel with groff.texi node "Using Escape
.\" Sequences".
.
.
.\" ====================================================================
.SH Delimiters
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Delimiters".
Some escape sequences that require parameters use delimiters.
.
The neutral apostrophe
.B \[aq]
is a popular choice and shown in this document.
.
The neutral double quote
.B \[dq]
is also commonly seen.
.
Punctuation characters are the best choice
(and most portable to other
.IR troff s, \" generic
except for those meaningful in numeric expressions;
see below.
.\" GNU troff happily accepts tabs and leaders; AT&T troff doesn't.
.
.
.br
.ne 3v
.P
The following escape sequences are not themselves delimited,
and thus are allowed as delimiters:
.BI \[rs] space\c
,
.BR \[rs]% ,
.BR \[rs]| ,
.BR \[rs]\[ha] ,
.BR \[rs]{ ,
.BR \[rs]} ,
.BR \[rs]\[aq] ,
.BR \[rs]\[ga] ,
.BR \[rs]\- ,
.BR \[rs]_ ,
.BR \[rs]! ,
.BR \[rs]? ,
.BR \[rs]) ,
.BR \[rs]\|/ ,
.BR \[rs], \^,
.BR \[rs]& ,
.BR \[rs]: ,
.BR \[rs]\[ti] ,
.BR \[rs]0 ,
.BR \[rs]a ,
.BR \[rs]c ,
.BR \[rs]d ,
.BR \[rs]e ,
.BR \[rs]E ,
.BR \[rs]p ,
.BR \[rs]r ,
.BR \[rs]t ,
and
.BR \[rs]u .
.
However,
we discourage using them this way;
they can make the input confusing to read.
.
(The
.MR @g@eqn @MAN1EXT@
and
.MR @g@tbl @MAN1EXT@
preprocessors use parameterized but non-delimited special character
escape sequences
.B \[rs](
and
.B \[rs][
to bracket portions of their output.)
.
An invalid escape sequence is valid as a delimiter
if the character after the escape character would be valid.
.
.
.br
.ne 3v
.P
The escape sequences
.BR \[rs]D ,
.BR \[rs]h ,
.BR \[rs]H ,
.BR \[rs]l ,
.BR \[rs]L ,
.BR \[rs]N ,
.BR \[rs]R ,
.BR \[rs]s ,
.BR \[rs]S ,
.BR \[rs]v ,
and
.B \[rs]x
prohibit delimiters that are meaningful in numeric expressions,
because they accept numeric expressions as
(or within)
their arguments.
.
For consistency,
GNU
.I troff \" GNU
prohibits the same delimiters in the argument to the
.B tl
request.
.
The
.RB \[lq] if \[rq],
.BR ie ,
and
.RB \[lq] while \[rq]
requests each interpret their first argument
as a conditional expression;
only characters that are not meaningful as operators
in that context
can be used as output comparison delimiters.
.
The following inputs are therefore invalid as delimiters in
GNU
.IR troff . \" GNU
.
.
.RS
.IP \[bu] 3n
the numerals 0\[en]9 and the decimal point
.RB \[lq] . \[rq]
.
.
.IP \[bu]
the (single-character) operators
.B +\-/*%<>=&:()|
.
.
.IP \[bu]
any escape sequences other than
.BR \[rs]% ,
.BR \[rs]: ,
.BR \[rs]{ ,
.BR \[rs]} ,
.BR \[rs]\[aq] ,
.BR \[rs]\[ga] ,
.BR \[rs]\- ,
.BR \[rs]_ ,
.BR \[rs]! ,
.BR \[rs]/ ,
.BR \[rs]c ,
.BR \[rs]e ,
and
.B \[rs]p
.RE
.
.
.P
Delimiter syntax is flexible
(and laborious to describe)
primarily for historical reasons;
the foregoing restrictions need be kept in mind mainly when using
GNU
.I troff \" GNU
in AT&T compatibility mode.
.
Normally,
GNU
.I troff \" GNU
keeps track of the nesting depth of escape sequence interpolations,
so the only characters you need to avoid using as delimiters are those
that appear in the arguments you input,
not those that result from interpolation.
.
Typically,
.B \[aq]
works fine.
.
See section \[lq]Implementation differences\[rq] in
.MR groff_diff @MAN7EXT@ .
.\" END Keep (roughly) parallel with groff.texi node "Delimiters".
.
.
.\" ====================================================================
.SH "Dummy characters"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Dummy
.\" Characters".
As discussed in
.MR roff @MAN7EXT@ ,
the first character on an input line is treated specially.
.
Further,
formatting a glyph has many
consequences on formatter state
(see section \[lq]Environments\[rq] below).
.
Occasionally,
we want to escape this context or embrace some of those consequences
without actually rendering a glyph to the output.
.
.B \[rs]&
interpolates a dummy character,
which is constitutive of output but invisible.
.
Its presence alters the interpretation context of a subsequent input
character,
and enjoys several applications:
preventing the insertion of extra space after an end-of-sentence
character,
preventing interpretation of a control character at the beginning of an
input line,
preventing kerning between two glyphs,
and permitting the
.B tr
request to remap a character to \[lq]nothing\[rq].
.
.B \[rs])
works as
.B \[rs]&
does,
except that it does not cancel a pending end-of-sentence state.
.\" END Keep (roughly) parallel with groff.texi node "Dummy Characters".
.
.
.\" ====================================================================
.SH "Page control"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Page Control".
Discretionary page breaks
can prevent the unwanted separation of content.
.
A new page number takes effect during page ejection;
see subsection \[lq]The implicit page trap\[rq] below.
.
The
.B bp
request breaks the page,
incrementing the page number by one
(or setting it per the supplied argument).
.
The
.B ne
request forces a page break if insufficient vertical space is available
(it asserts \[lq]needed\[rq] space).
.
.B sv
requires vertical space as
.B ne
does,
but also
.I saves
it for later output by the
.B os
request.
.
.
.P
The
.B nl
register interpolates the vertical drawing position
as of the most recently typeset output line.
.
It does not necessarily
(and often does not)
represent that of the pending output line,
because the formatter does not determine the position of its baseline
until it is output.
.\" recall @ref{Manipulating Spacing}.
.
Assigning a value to
.B nl
sets the vertical drawing position
in advance of further modifications to baseline positioning
arising from alterations to type size,
changes to vertical spacing,
or application of extra pre- or post-vertical spacing.
.
.
.P
When the formatter starts,
the transition to the first page
.RB "has not yet happened\[em]" nl
is negative.
If you plant a page location trap at vertical position
.RB \[lq] 0 \[rq]
(idiomatically to format a header),
you can assign a negative value to
.B nl
to spring that trap even if the page has already started
(see subsection \[lq]Page location traps\[rq] below).
.\" END Keep (roughly) parallel with groff.texi node "Page Control".
.
.
.\" TODO: Add sections here about characters (including custom
.\" defintions with the `char` request family) and fonts (including
.\" special fonts and the character resolution process).
.\" ====================================================================
.SH "Control structures"
.\" ====================================================================
.
.I groff
has \[lq]if\[rq] and \[lq]while\[rq] control structures like other
languages.
.
However,
the syntax for grouping multiple input lines in the branches or bodies
of these structures is unusual.
.
.
.P
They have a common form:
the request name is
(except for
.request el
\[lq]else\[rq])
followed by a conditional expression
.IR cond-expr ;
the remainder of the line,
.IR input ,
is interpreted as if it were an input line.
.
Any quantity of spaces between arguments to requests serves only to
separate them;
leading spaces in
.I input
are therefore not seen.
.
.I input
effectively
.I cannot
be omitted;
if
.I cond-expr
is true and
.I input
is empty,
the newline at the end of the control line is interpreted as a blank
line
(and therefore a blank text line).
.
.
.P
It is frequently desirable for a control structure to govern more than
one request,
macro call,
or text line,
or combination of the foregoing.
.
The opening and closing brace escape sequences
.esc {
and
.esc }
perform such grouping.
.
Brace escape sequences outside of control structures have no meaning and
produce no output.
.
.
.P
.esc {
should appear
(after optional spaces and tabs)
immediately subsequent to the request's conditional expression.
.
.esc }
should appear on a line with other occurrences of itself as necessary to
match
.esc {
sequences.
.
It can be preceded by a control character,
spaces,
and tabs.
.
Input after any quantity of
.esc }
sequences on the same line is processed only if all the preceding
conditions to which they correspond are true.
.
Furthermore,
a
.esc }
closing the body of a
.RB \[lq] while \[rq]
request must be the last such escape sequence on an input line.
.
.
.P
GNU
.I troff \" GNU
treats the body of a
.RB \[lq] while \[rq]
request similarly to that of a
.B de
request
(albeit one not read in copy mode),
but stores it under an internal name
and deletes it when the loop finishes.
.
The operation of a macro containing a
.RB \[lq] while \[rq]
request can slow significantly if its
body is large.
.
Each time
GNU
.I troff \" GNU
interpolates the macro,
it parses and stores the
.RB \[lq] while \[rq]
body again.
.
An often better solution\[em]and one that is more portable,
since AT&T
.I troff \" AT&T
lacked the
.RB \[lq] while \[rq]
request\[em]is to instead write a recursive macro,
which is parsed only once
(unless you redefine it).
.
To prevent infinite loops,
GNU
.I troff \" GNU
limits the default number of available recursion levels
to 1,000 or somewhat less
(because things other than macro calls can be on the input stack).
.
You can disable this protective measure,
or alter the limit,
by setting the
.B slimit
register.
.
See section \[lq]Debugging\[rq] below.
.
.
.\" ====================================================================
.SS "Conditional expressions"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Operators in
.\" Conditionals".
The
.RB \[lq] if \^\[rq],
.BR ie ,
and
.RB \[lq] while \[rq]
requests test the truth values of numeric expressions.
.
They also support several additional Boolean operators;
the members of this expanded class are termed
.IR "conditional expressions" ;
their truth values are as shown below.
.
.
.br
.ne 3v
.P
.TS
rf(BI) lB
rB lx.
cond-expr\f[B].\|.\|.	.\|.\|.is true if.\|.\|.
_
T{
.BI \[aq] s1 \[aq] s2 \[aq]
T}	T{
.I s1
produces the same formatted output as
.IR s2 .
T}
T{
.BI c\~ g
T}	T{
a character
.I g
is defined.
T}
T{
.BI d\~ m
T}	T{
a string,
macro,
diversion,
or request
.I m
is defined.
T}
e	T{
the current page number is even.
T}
T{
.BI F\~ f
T}	T{
a font named
.I f
is available.
T}
T{
.BI m\~ c
T}	T{
a color named
.I c
is defined.
T}
n	T{
the formatter is in
.I nroff
mode.
T}
o	T{
the current page number is odd.
T}
T{
.BI r\~ n
T}	T{
a register named
.I n
is defined.
T}
T{
.BI S\~ s
T}	T{
a font style named
.I s
is available.
T}
t	T{
the formatter is in
.I troff
mode.
T}
v	T{
n/a
(historical artifact;
always false).
T}
.TE
.
.
.br
.ne 2v
.P
If the first argument to an
.RB \[lq] if \^\[rq],
.BR ie ,
or
.RB \[lq] while \[rq]
request begins with a non-alphanumeric character apart from
.RB \[lq] !\& \[rq]
(see below)
and is not a numeric expression,
the formatter performs an
.I output comparison test.
.
Shown first in the table above,
the
.I output comparison operator
interpolates a true value if formatting its comparands
.I s1
and
.I s2
produces the same output commands.
.
Other delimiters can be used in place of the neutral apostrophes;
see section \[lq]Delimiters\[rq] above.
.
.I troff \" generic
formats
.I s1
and
.I s2
in separate scratch buffers;
after comparison,
it discards the resulting data.
.
The resulting glyph properties,
including font family,
style,
size,
and
slant,
must match,
but not necessarily the requests and/or escape sequences
used to obtain them.
.
Motions must match in orientation and magnitude to within the applicable
horizontal or vertical motion quantum of the device,
after rounding.
.
.\" TODO: Uncomment and add forward reference when we add a "GNU troff
.\" internals" subsection to this page.
.\"(All of this is to say that the lists of output nodes created by
.\"formatting
.\".I s1
.\"and
.\".I s2
.\"must be identical.)
.
.
.P
Surround the comparands with
.B \[rs]?\&
to avoid formatting them;
this causes them to be compared character by character,
as with string comparisons in other programming languages.
.
Since
GNU
.I troff \" GNU
reads comparands protected with
.B \[rs]?\&
in copy mode,
they need not be syntactically valid.
.
The escape character is still lexically recognized,
however,
and consumes the next character.
.\" but see Savannah #67329
.
.
.P
The above operators can't be combined with most others,
but a leading
.RB \[lq] !\& \[rq],
not followed immediately by spaces or tabs,
complements an expression.
.
Spaces and tabs are optional immediately after the
.RB \[lq] c \[rq],
.RB \[lq] d \[rq],
.RB \[lq] F \[rq],
.RB \[lq] m \[rq],
.RB \[lq] r \[rq],
and
.RB \[lq] S \[rq]
operators,
but right after
.RB \[lq] !\& \[rq],
they end the predicate and the conditional evaluates true.
.
(This bizarre behavior maintains compatibility with AT&T
.IR troff .)
.
.
.P
Conditional operators do not create
.I roff
language objects as interpolations with
.B \[rs]n
and
.B \[rs]*
escape sequences do.
.\" END Keep (roughly) parallel with groff.texi node "Operators in
.\" Conditionals".
.
.
.\" ====================================================================
.SH "Syntax reference conventions"
.\" ====================================================================
.
In the following request and escape sequence specifications,
most argument names were chosen to be descriptive.
.
GNU
.I troff \" GNU
reads arguments named
.I character-sequence,
.I command,
.I contents,
.I file,
and
.I message
in copy mode
(see section \[lq]Copy Mode\[rq] below)
until the end of the input line.
.
A
.I character-sequence
comprises one or more ordinary,
special,
or indexed characters;
spaces;
or escape sequences that interpolate only these.
.\" XXX: or tabs, leaders, backspace, and delete characters
.
We name the remaining arguments for clarity;
they are also
.I character-sequences.
.
A neutral double quote
.RB \[oq] \[dq] \[cq] \" single quotes around double quote
can optionally prefix a
.I character-sequence;
the formatter discards one if present,
permitting initial embedded spaces in the argument.
.
.I input
refers to arbitrary character sequences
(up to a newline or delimiter)
that
GNU
.I troff \" GNU
fully interprets,
in contrast to copy mode.
.
.
.P
A few denotations are more specific.
.
.
.P
.LS
.RS
.
.TPx
.I b
is a numerical expression evaluated as a Boolean;
positive values are true,
others false.
.
.TPx
.I c
denotes a single character\[em]\c
ordinary,
special,
or indexed.
.
.TPx
.I command
is an instance of
.I contents
(see below)
to be passed to the system as a command
(potentially with arguments).
.\" ...limiting the file names you can express; see Savannah #64071.
.
GNU
.I troff \" GNU
strips a leading neutral double quote,
allowing embedded leading spaces.
.
.TPx
.I contents
is arbitrary input,
excluding an unescaped newline,
read in copy mode.
.
GNU
.I troff \" GNU
strips a leading neutral double quote,
allowing embedded leading spaces.
.
.TPx
.I div
is a diversion identifier.
.
.TPx
.I env
is an environment identifier.
.
.TPx
.I file
is an instance of
.I contents
naming a file on the system.
.\" ...limiting the file names you can express; see Savannah #65108.
.
GNU
.I troff \" GNU
strips a leading neutral double quote,
allowing embedded leading spaces.
.
GNU
.I troff \" GNU
does not accept newlines
(line feeds)
in file names supplied as arguments to requests.
.
.TPx
.I font
is a typeface specified as a font identifier,
an abstract style,
or a mounting position.
.
.TPx
.I ident
is a valid
.I groff
identifier;
its use often indicates that the operation creates an object of a type
subsequently referred to as
.I mac,
.I reg,
.I str,
and so forth.
.
.TPx
.I mac
is a macro identifier.
.
.TPx
.I message
is an instance of
.I contents
to emit on the standard error stream.
.\" ...limiting the messages you can express; see Savannah #62787.
.
GNU
.I troff \" GNU
strips a leading neutral double quote,
allowing embedded leading spaces.
.
.TPx
.I n
is a numeric expression that evaluates to a non-negative integer.
.
.TPx
.I \[+-]N
is a numeric expression with a meaning dependent on its sign;
see below.
.
.TPx
.I name
is a macro,
string,
or diversion identifier,
or the name of a request.
.
.br
.ne 3v
.TPx
.I npl
is a numeric expression constituting a count of subsequent
.I productive
input lines;
that is,
those that directly produce formatted output.
.
Text lines produce output,
as do control lines containing requests like
.RB \[lq] ".tl //\^Page %//\^" \[rq]
or escape sequences like
.RB \[lq] \[rs]\^l\[aq]1i\[aq] \[rq].
.
Macro calls are not themselves productive,
but their interpolations can be.
.
.TPx
.I reg
is a register identifier.
.
.TPx
.I str
is a string identifier.
.
.TPx
.I stream
is an output stream identifier.
.RE
.LE
.
.
.P
If a numeric expression presented as
.I \[+-]N
starts with a
.squoted_char +
sign,
an increment in the amount of
.RI of\~ N
is applied to the value applicable to the request or escape sequence.
.
If it starts with a
.squoted_char \-
sign,
a decrement of magnitude
.I N
is applied instead.
.
Without a sign,
.I N
replaces any existing value.
.
A
.I roff
formatter always interprets a leading minus sign
.RI in\~ N
as a decrementation operator,
not an algebraic sign.
.
To assign a register a negative value
or the negated value of another interpolation,
you must force the formatter to interpret
.RB \[lq] \- \[rq]
as a negation or minus,
rather than decrementation,
operator:
enclose the
.RB \[lq] \- \[rq]
with its operand in parentheses
or subtract the expression of interest from zero.
.
If a prior value does not exist\c
\[em]the register was undefined\[em]\c
an increment or decrement applies as if to\~0.
.
.
.\" ====================================================================
.SH "Request short reference"
.\" ====================================================================
.
Not all details of request behavior are outlined here.
.
See the
.I groff
Texinfo manual or,
for features new to GNU
.IR troff , \" GNU
.MR groff_diff @MAN7EXT@ .
.
.
.\" Note: The following syntax summaries do _not_ generally use brackets
.\" to mark optional arguments (there are a few exceptions, alas).
.\" Instead, request invocations taking different argument quantities
.\" are synopsized separately.
.P
.LS
.
.TPx
.REQ .ab
Abort the formatter;
exit with failure status.
.
.TPx
.REQ .ab terminal-message
Abort the formatter;
write
.I terminal-message
to the standard error stream and exit with failure status.
.
.TPx
.REQ .ad
Enable output line alignment and adjustment using the mode stored in
.BR \[rs]n[.j] .
.
.TPx
.REQ .ad c
Enable output line alignment and adjustment in mode
.I c
.RI ( c =\c
.BR b , c , l , n , r ).
.
Sets
.BR \[rs]n[.j] .
.
.TPx
.REQ .af "reg c"
Assign format
.I c
to register
.I reg,
where
.I c
is
.RB \[lq] i \[rq],
.RB \[lq] I \[rq],
.RB \[lq] a \[rq],
.RB \[lq] A \[rq],
or a sequence of decimal digits whose quantity denotes the minimum width
in digits to be used when the register is interpolated.
.
.RB \[lq] i \[rq]
and
.RB \[lq] a \[rq]
indicate Roman numerals and basic Latin alphabetics,
respectively,
in the lettercase specified.
.
The default is
.BR 0 .
.
.TPx
.REQ .aln "new-register existing-register"
Create alias
(additional name)
.I new-register
of
.IR existing-register ,
causing the names to refer to the same stored object.
.
If
.I existing-register
is undefined,
the formatter ignores the request.
GNU
.I troff \" GNU
emits a warning in category
.RB \[lq] reg \[rq].
.
.TPx
.REQ .als "new-name existing-name"
Create alias
(additional name)
.I new-name
of request,
string,
macro,
or diversion
.IR existing-name ,
causing the names to refer to the same stored object.
.
If
.I existing-name
is undefined,
the formatter ignores the request.
GNU
.I troff \" GNU
emits a warning in category
.RB \[lq] mac \[rq].
.
If
.I new-name
already exists,
its definition is lost unless already aliased.
.
.TPx
.REQ .am mac
Append to macro
.I mac
until encountering
.RB \[lq] .\|.\& \[rq]
at the start of a control line in the current conditional block.
.
.TPx
.REQ .am "mac end-mac"
Append to macro
.I mac
until
.I end-mac
is called at the start of a control line in the current conditional
block.
.
.I end-mac
can be a request.
.
.TPx
.REQ .am1 mac
As
.RB \[rq] am \[rq],
with compatibility mode disabled when the appendment to macro
.I mac
is interpreted.
.
.TPx
.REQ .am1 "mac end-mac"
As
.RB \[lq] .am
.IR mac \[rq],
with compatibility mode disabled when the appendment to macro
.I mac
is interpreted.
.
.TPx
.REQ .ami str
Append to a macro indirectly\[em]its name is in string
.IR str \[em]until
encountering
.RB \[lq] .\|.\& \[rq].
.
.TPx
.REQ .ami "str end-mac-str"
Append to a macro indirectly.
.
As
.RB \[rq] am \[rq],
but
.I str
and
.I end-mac-str
contain the names of the macro to be appended to,
and that whose call ends the appendment,
respectively.
.
.TPx
.REQ .ami1 str
As
.request ami ,
with compatibility mode disabled when the appendment is interpreted.
.
.TPx
.REQ .ami1 "str end-mac-str"
As
.request ami ,
with compatibility mode disabled when the appendment is interpreted.
.
.\" a degenerate case
.TPx
.REQ .as ident
Create string
.I ident
with empty contents;
no operation if
.I ident
already exists.
.
.TPx
.REQ .as "str contents"
Append
.I contents
to string
.IR str .
.
.\" a doubly degenerate case
.TPx
.REQ .as1 ident
As
.RB \[lq] .as
.IR ident \[rq].
.
.TPx
.REQ .as1 "str contents"
As
.RB \[rq] as \[rq],
with compatibility mode disabled when the appendment to string
.I str
is interpreted.
.
.TPx
.REQ .asciify div
Unformat ordinary characters,
spaces,
and some escape sequences \" XXX: vague
in diversion
.IR div .
.
When transforming a glyph node back into an input sequence
that demands expression as a special character escape sequence,
GNU
.I troff
uses the default escape character.
.
.TPx
.REQ .backtrace
Write the state of the input stack to the standard error stream.
.
See the
.B \-b
option of
.MR groff @MAN1EXT@ .
.
.TPx
.REQ .bd font
Stop emboldening font
.I font.
.
.TPx
.REQ .bd "font n"
Embolden
.I font
by overstriking its glyphs offset by
.IR n \-1
units.
.
See
.register .b .
.\" XXX: negative values accepted; check AT&T troff
.
.TPx
.REQ .bd "special-font font"
Stop emboldening
.I special-font
when
.I font
is selected.
.
.\" XXX: Possibly allow prefixing an integer with `\&` to force
.\" interpretation of this form.
.I special-font
must be a font name,
not a mounting position.
.
.TPx
.REQ .bd "special-font font n"
Embolden
.I special-font,
overstriking its glyphs offset by
.IR n \-1
units when
.I font
is selected.
.
See
.register .b .
.
.TPx
.REQ .blm
Unset blank line macro (trap).
.
Restore default handling of blank lines.
.
.TPx
.REQ .blm mac
Set blank line macro (trap) to
.IR mac .
.
.TPx
.REQ .box
Stop directing output to current diversion;
any pending output line is discarded.
.
.TPx
.REQ .box ident
Direct output to diversion
.IR ident ,
omitting a partially collected line.
.
.TPx
.REQ .boxa
Stop appending output to current diversion;
any pending output line is discarded.
.
.TPx
.REQ .boxa div
Append output to diversion
.IR div ,
omitting a partially collected line.
.
.TPx
.REQ .bp
Break page and start a new one.
.
.TPx
.REQ .bp \[+-]N
Break page,
starting a new one numbered
.IR \[+-]N .
.
.TPx
.REQ .br
Break output line.
.
.TPx
.REQ .brp
Break and force adjustment of the output line
per the current adjustment mode.
.
.TPx
.REQ .break
Break out of a
.RB \[rq] while \[rq]
loop.
.
.TPx
.REQ .c2
Reset no-break control character to
.dquoted_char \[aq] .
.
.TPx
.REQ .c2 o
Recognize ordinary character
.I o
as no-break control character.
.
.TPx
.REQ .cc
Reset control character to
.squoted_char . .
.
.TPx
.REQ .cc o
Recognize ordinary character
.I o
as the control character.
.
.TPx
.REQ .ce
Break,
center the output of the next productive input line without filling,
and break again.
.
.TPx
.REQ .ce npl
Break,
center the output of the next
.I npl
productive input lines without filling,
then break again.
.
If
.I npl
\[<=] 0,
stop centering.
.
.TPx
.REQ .cf file
Break and copy contents of
.I file
as \[lq]throughput\[rq] to GNU
.I troff \" GNU
output
(see
.MR groff_out @MAN5EXT@ ).
.
Each line of
.I file
is output
as if preceded by
.BR \[rs]!\& ,
but is not interpreted by the formatter.
.
Unsafe request;
disabled by default.
.
.TPx
.REQ .cflags "n c\fR\&.\|.\|.\&\fP"
Assign properties encoded by non-negative integer
.I n
to each character or class
.IR c .
.
Spaces need not separate
.I c
arguments.
.\" TODO: Add subsection discussing character flags.
.
.TPx
.REQ .ch mac
Unplant page location trap
.IR mac .
.
.TPx
.REQ .ch "mac vertical-position"
Change page location trap
.I mac
planted by
.request wh
by moving its location to
.I vertical-position
(default scaling unit\~\c
.scaleindicator v ).
.
.TPx
.REQ .char c
Define an
ordinary,
special,
or
indexed
character
.I c
as empty.
.
.TPx
.REQ .char "c contents"
Define an
ordinary,
special,
or
indexed
character
.I c
as
.I contents.
.
.TPx
.REQ .chop name
Remove the last character from the macro,
string,
or diversion
.I name.
.
.TPx
.REQ .class "ident c \fR\&.\|.\|.\&\fP"
Define a (character) class
.I ident
comprising the characters or range expressions
.IR c ,
where each
.I c
is an
ordinary,
special,
or
indexed
character;
or a
.I "range expression."
.
A class thus defined can then be referred to
in a
.B \%cflags
request in lieu of listing all the characters within it.
.
.TPx
.REQ .close stream
Close
.IR stream ,
making it unavailable for
.RB \[rq] write \[rq]
requests.
.
.TPx
.REQ .color
Enable output of color-related device-independent output commands.
.
It is enabled by default.
.
.TPx
.REQ .color b
Enable or disable output of color-related device-independent output
commands per Boolean expression
.IR b .
.
.TPx
.REQ .composite c
Remove composite character mapping for character
.I c.
.
.TPx
.REQ .composite "c1 c2"
Map character
.I c1
to
.I c2
when
.I c1
is a combining component in a composite character.
.
.TPx
.REQ .continue
Skip the remainder of a
.RB \[lq] while \[rq]
loop's body,
immediately retesting its conditional expression.
.
.TPx
.REQ .cp
Enable AT&T
.I troff \" AT&T
compatibility mode.
.
It is disabled by default.
.
.TPx
.REQ .cp b
Enable or disable AT&T
.I troff \" AT&T
compatibility mode per Boolean expression
.IR b .
.
.TPx
.REQ .cs f
Disable constant-width glyph spacing mode for font
.I f.
.
.TPx
.REQ .cs "f n"
Enable constant-width glyph spacing mode for font
.I f
at
.IR n /36
ems.
.
.TPx
.REQ .cs "f n p"
Enable constant-width glyph spacing mode for
.I font
at
.IR n /36
ems,
as if one em equals
.I p
scaled points.
.
.TPx
.REQ .cu
Continuously underline the output of the next productive input line.
.
.TPx
.REQ .cu npl
Continuously underline the output of the next
.I npl
productive input lines.
.
If
.IR npl =0,
stop continuously underlining.
.
.TPx
.REQ .da
Stop appending output to current diversion.
.
.TPx
.REQ .da div
Append output to diversion
.IR div .
.
.TPx
.REQ .de ident
Define macro
.I ident
until
.RB \[lq] .\|.\& \[rq]
occurs at the start of a control line in the current conditional block.
.
.TPx
.REQ .de "ident end-mac"
Define macro
.I ident
until
.I end-mac
is called at the start of a control line in the current conditional
block.
.
.I end-mac
can be a request.
.
.TPx
.REQ .de1 ident
As
.request de ,
with compatibility mode disabled when
.I mac
is interpreted.
.
.TPx
.REQ .de1 "ident end-mac"
As
.RB \[lq] .de
.IR "ident end-mac" \[rq],
with compatibility mode disabled when
.I mac
is interpreted.
.
.TPx
.REQ .defcolor "ident scheme color-component \f[R].\|.\|."
Define a color named
.I ident.
.
.I scheme
identifies a color space and determines the number of required
.IR color-component s;
it must be one of
.RB \[lq] rgb \[rq]
(three components),
.RB \[lq] cmy \[rq]
(three),
.RB \[lq] cmyk \[rq]
(four),
or
.RB \[lq] gray \[rq]
(one).
.
.RB \[lq] grey \[rq]
is accepted as a synonym of
.RB \[lq] gray \[rq].
.
The color components can be encoded as a single hexadecimal value
starting with
.B #
or
.BR ## .
.
The former indicates that each component is in the range 0\[en]255
(0\[en]FF),
the latter the range 0\[en]65,535 (0\[en]FFFF).
.
Alternatively,
each color component can be specified as a decimal fraction in the range
0\[en]1,
interpreted using a default scaling unit
.RB of\~\[lq] f \[rq],
which multiplies its value by 65,536
(but clamps it at 65,535).
.
.TPx
.REQ .dei str
Define macro indirectly.
.
As
.request de ,
but interpolate string
.I str
to obtain the macro's name.
.
.TPx
.REQ .dei "str end-mac-str"
Define macro indirectly.
.
As
.request de ,
but
.I str
and
.I end-mac-str
contain the names of the macro to be defined,
and that whose call ends the definition,
respectively.
.
.TPx
.REQ .dei1 str
As
.request dei ,
with compatibility mode disabled when the macro is interpreted.
.
.TPx
.REQ .dei1 "str end-mac-str"
As
.request dei ,
with compatibility mode disabled when the macro is interpreted.
.
.TPx
.REQ .device character-sequence
Embed
.I character-sequence
into
GNU
.I troff \" GNU
output as parameters to an
.RB \[lq]x X\[rq]
device extension command;
see
.MR groff_out @MAN5EXT@ .
.
The output driver or other postprocessor interprets
.I character-sequence
as it sees fit.
.
.TPx
.REQ .devicem name
Write contents of macro or string
.I name
to
.I @g@troff
output as the argument to a device extension command.
.
.TPx
.REQ .di
Stop directing output to current diversion.
.
.TPx
.REQ .di ident
Direct output to diversion
.IR ident .
.
.TPx
.REQ .do "name argument \fR\&.\|.\|.\&\fP"
Interpret the string,
request,
diversion,
or macro
.I name
(along with any further arguments)
with compatibility mode disabled.
.
Compatibility mode is restored
(only if it was active)
when the interpolation of
.I name
is interpreted.
.
.TPx
.REQ .ds ident
Create empty string named
.IR ident .
.
.TPx
.REQ .ds "ident contents"
Create a string named
.I ident
containing
.I contents.
.
.TPx
.REQ .ds1 ident
.TQ
.REQ .ds1 "ident contents"
As
.request ds ,
with compatibility mode disabled when the string is interpreted.
.
.TPx
.REQ .dt
Clear diversion trap.
.
.TPx
.REQ .dt "vertical-position mac"
Set the diversion trap to macro
.I mac
at
.I vertical-position
(default scaling unit\~\c
.scaleindicator v ).
.
.TPx
.REQ .ec
Recognize
.B \[rs]
as the escape character.
.
.TPx
.REQ .ec o
Recognize ordinary character
.I o
as the escape character.
.
.TPx
.REQ .ecr
Restore escape character saved with
.request ecs .
.
.TPx
.REQ .ecs
Save the escape character.
.
.TPx
.REQ .el
Interpolate a newline if the conditional expression of the corresponding
.request ie
request was false.
.
.TPx
.REQ .el input
Interpret
.I input
as if it were an input line if the conditional expression of the
corresponding
.request ie
request was false.
.
.TPx
.REQ .em
Unset end-of-input macro.
.
.TPx
.REQ .em mac
Call macro
.I mac
after the end of input.
.
.TPx
.REQ .eo
Disable the escape mechanism in interpretation mode.
.
.TPx
.REQ .ev
Pop environment stack,
returning to previous one.
.
.TPx
.REQ .ev env
Push current environment onto stack and switch to
.IR env ,
creating it if necessary.
.
.TPx
.REQ .evc env
Copy environment
.I env
to the current one.
.
.TPx
.REQ .ex
Exit the formatter.
.
.TPx
.REQ .fam
Set default font family to previous value.
.
.TPx
.REQ .fam name
Set default font family to
.IR name .
.
.TPx
.REQ .fc
Disable field mechanism.
.
.TPx
.REQ .fc c
Set field delimiter to\~\c
.I c
and pad glyph to space.
.
.TPx
.REQ .fc "c1 c2"
Set field delimiter to\~\c
.I c1
and pad glyph to\~\c
.IR c2 .
.
.TPx
.REQ .fchar c
Define fallback
.RI character\~ c
as empty.
.
.TPx
.REQ .fchar "c contents"
Define fallback
.RI character\~ c
as
.IR contents .
.
As
.request char ,
but while that request hides a glyph with the same name in the selected
font,
.B fchar
definitions are used only if the font
lacks a glyph for
.IR c .
.
GNU
.I troff \" GNU
performs this test before searching special fonts.
.
.TPx
.REQ .fcolor
Restore previous fill color,
or the default if there is none.
.
.TPx
.REQ .fcolor col
Select
.I col
as the fill color.
.
.TPx
.REQ .fi
Enable filling of output lines;
a pending output line is broken.
.
Sets
.BR \[rs]n[.u] .
.
.TPx
.REQ .fl
Flush any pending output line.
.
.TPx
.REQ .fp "pos id"
Mount font with font description file name
.I id
at non-negative position
.IR pos .
.
.TPx
.REQ .fp "pos id font-description-file-name"
Mount font with
.I font-description-file-name
as name
.I id
at non-negative position
.IR pos .
.
.TPx
.REQ .fschar "f c"
Define fallback
.RI character\~ c
specific to
.RI font\~ f
as empty.
.
.TPx
.REQ .fschar "f c contents"
Define fallback
.RI character\~ c
specific to
.RI font\~ f
as
.IR contents .
.
As
.request char ,
but GNU
.I troff \" GNU
locates a character defined by
.B fschar
after any fonts named as arguments to the
.B \%fspecial
are searched and before those named as arguments to the
.RB \%\[lq] special \[rq]
request.
.
.TPx
.REQ .fspecial f
Empty the list of fonts treated as special when
.I f
is selected.
.
.TPx
.REQ .fspecial "f s \fR\&.\|.\|.\&\fP"
Declare each font
.I s
as special only when
.RB font\~ f
is selected.
.
.\" TODO: Move this sentence to a new (sub)section describing the glyph
.\" resolution procedure.
GNU
.I troff \" GNU
searches fonts specified as arguments to the
.RB \%\[lq] special \[rq]
request after those given as arguments to the
.B \%fspecial
request.
.
.TPx
.REQ .ft
.TQ
.REQ ".ft P"
Select the typeface
.I font.
.
If
.I font
is an integer,
the formatter interprets it as a mounting position;
the font mounted there is selected.
.
If that position refers to an abstract style,
GNU
.I troff \" GNU
combines it with the default family
(see
.B fam
above and
.B \[rs]F
below)
to make a resolved font name.
.
If
.I font
is
.RB \[lq] DESC \[rq],
if the mounting position is not an abstract style
and no font is mounted there,
or the mounting position is negative,
GNU
.I troff \" GNU
ignores the request.
.
(It also
emits a warning in category
.RB \[lq] font \[rq],
or
.RB \[lq] range \[rq],
as appropriate.
.
See section \[lq]Warnings\[rq] in
.MR @g@troff @MAN1EXT@ .)
.
Also see
.B \[rs]f .
.
.TPx
.REQ .ftr f
Remove translation of font named
.IR f .
.
.TPx
.REQ .ftr "f1 f2"
Translate font name
.I f1
to
.IR f2 .
.
.TPx
.REQ .fzoom font\~\f[B]0\f[]
Stop magnifying
.IR font .
.
.TPx
.REQ .fzoom "font zoom"
Set magnification of mounted
.I font
to
.IR zoom ,
a multiplier of the current type size in thousandths
(default:
1000).
.
.TPx
.REQ .gcolor
Restore previous stroke color,
or the default if there is none.
.
.TPx
.REQ .gcolor col
Select
.I col
as the stroke color.
.
.TPx
.REQ .hc
Reset the hyphenation character
.RB to\~ \[rs]%
(the default).
.
.TPx
.REQ .hc c
Change the hyphenation character
.RI to\~ c .
.
.TPx
.REQ .hcode "dst1 src1 \fR[\fPdst2 src2\fR] .\|.\|.\fP"
Set the hyphenation code of character
.I dst1
to that of
.IR src1 ,
and so on.
.
.TPx
.REQ .hla
Clear the environment's hyphenation language
(disabling automatic hyphenation).
.
.TPx
.REQ .hla ident
Set the environment's hyphenation language to
.IR ident .
.
.TPx
.REQ .hlm
Set the consecutive automatically hyphenated line limit to
.B \-1
(the default),
meaning \[lq]no limit\[rq].
.
.TPx
.REQ .hlm n
Set the consecutive automatically hyphenated line limit to
.RI to\~ n.
.
A negative value means \[lq]no limit\[rq].
.
.TPx
.REQ .hpf file
Read hyphenation patterns from
.IR file .
.
.TPx
.REQ .hpfa file
Append hyphenation patterns from
.IR file .
.
.TPx
.REQ .hpfcode "a b \fR[\fPc d\fR] .\|.\|.\fP"
.I Caution:
This request will be withdrawn in a future
.I groff
release.
.
Use
.B hcode
instead.
.
.
.IP
Define mappings for character codes in hyphenation pattern files.
.
.TPx
.REQ .hw "word \fR.\|.\|.\fP"
Define each argument
.I word
(comprising ordinary,
special,
or indexed characters)
as a
.I "hyphenation exception word"
such that each occurence of a hyphen-minus
.RB \[lq] \- \[rq]
in
.I word
indicates a hyphenation point.
.
.TPx
.REQ .hy
Set automatic hyphenation mode to the value of the
.B \%.hydefault
register.
.
.TPx
.REQ .hy\~0
Disable automatic hyphenation;
same as
.BR .nh .
.
.TPx
.REQ .hy mode
Set automatic hyphenation mode to
.IR mode ;
see section \[lq]Hyphenation\[rq] below.
.
.TPx
.REQ .hydefault mode
Set hyphenation mode default to
.IR mode ;
see section \[lq]Hyphenation\[rq] below.
.
.TPx
.REQ .hym
Set the (right) hyphenation margin to
.B 0
(the default).
.
.TPx
.REQ .hym length
Set the (right) hyphenation margin to
.I length
(default scaling unit\~\c
.scaleindicator m ).
.
.TPx
.REQ .hys
Set the hyphenation space to
.B 0
(the default).
.
.TPx
.REQ .hys hyphenation-space
Suppress automatic hyphenation in adjustment modes
.RB \[lq] b \[rq]
or
.RB \[lq] n \[rq]
if that adjustment can be achieved by adding no more than
.I hyphenation-space
to each inter-word space
(default scaling unit\~\c
.scaleindicator m ).
.
.TPx
.REQ .ie cond-expr
Interpolate a newline if
.I cond-expr
is true,
otherwise skip to a corresponding
.request el
request.
.
.TPx
.REQ .ie "cond-expr input"
If
.I cond-expr
is true,
interpret
.I input
as if it were an input line,
otherwise skip to a corresponding
.request el
request.
.
.TPx
.REQ .if cond-expr
Interpolate a newline if
.I cond-expr
is true.
.
.TPx
.REQ .if "cond-expr input"
If
.I cond-expr
is true,
then interpret
.I input
as if it were an input line.
.
.TPx
.REQ .ig
Ignore input
(except for side effects of
.B \[rs]R
on auto-incrementing registers)
until
.RB \[lq] .\|.\& \[rq]
occurs at the start of a control line in the current conditional block.
.
.TPx
.REQ .ig end-mac
Ignore input
(except for side effects of
.B \[rs]R
on auto-incrementing registers)
until
.I end-mac
is called at the start of a control line in the current conditional
block.
.
.I end-mac
can be a request.
.
.TPx
.REQ .in
Set indentation amount to previous value.
.
.TPx
.REQ .in \[+-]N
Set indentation to
.I \[+-]N
(default scaling unit\~\c
.scaleindicator m ).
.
.TPx
.REQ .it
Cancel any pending input line trap.
.
.TPx
.REQ .it "npl mac"
Set
(or replace)
an input line trap in the environment,
calling
.I mac
after the next
.I npl
productive input lines have been read.
.
Lines interrupted with the
.B \[rs]c
escape sequence are counted separately.
.
.TPx
.REQ .itc
Cancel any pending input line trap.
.
.TPx
.REQ .itc "npl mac"
As
.RB \[rq] it \[rq],
but lines interrupted with the
.B \[rs]c
escape sequence do not apply to the line count.
.
.TPx
.REQ .kern
Enable pairwise kerning.
.
.TPx
.REQ .kern b
Enable or disable pairwise kerning
per Boolean expression
.IR b .
.
.TPx
.REQ .lc
Unset leader repetition character.
.
.TPx
.REQ .lc c
Set leader repetition character
.RI to\~ c
(default:
.RB \[lq] . \[rq]).
.
.TPx
.REQ .length "reg contents"
Compute the number of characters in
.I contents
and store the count
in the register
.IR reg .
.
.TPx
.REQ .linetabs
Activate line-tabs in the environment.
.
It is disabled by default.
.
.TPx
.REQ .linetabs b
Activate or deactivate line-tabs in the environment per Boolean
expression
.IR b .
.
.TPx
.REQ .lf input-line-number
Set the input line number
the formatter uses when reporting diagnostics.
The argument becomes the input line number of the
.I next
line the formatter reads.
.
.TPx
.REQ .lf "input-line-number character-sequence"
As
.B lf
with one argument,
but also update the reported file name to
.IR character-sequence .
.\" ...limiting the file names you can express; see Savannah #65108.
.
.TPx
.REQ .lg
Enable ligature mode
.BR 1 .
.
.TPx
.REQ .lg m
Set ligature mode to
.I m
.RB ( 0
= disable,
.B 1
= enable,
.B 2
= enable for two-letter ligatures only).
.\" XXX: negative values accepted (mapped to 1); check AT&T troff
.
.TPx
.REQ .ll
Set line length to previous value.
.
Does not affect a pending output line.
.
.TPx
.REQ .ll \[+-]N
Set line length to
.I \[+-]N
(default length
.scalednumber 6.5 i ,
default scaling unit\~\c
.scaleindicator m ).
.
Does not affect a pending output line.
.
.TPx
.REQ .lsm
Unset the leading space macro (trap).
.
Restore default handling of lines with leading spaces.
.
.TPx
.REQ .lsm mac
Set the leading space macro (trap) to
.IR mac .
.
.TPx
.REQ .ls
Change to the previous value of additional intra-line skip.
.
.TPx
.REQ .ls n
Set additional intra-line skip value to
.IR n ,
i.e.,
.IR n \-1
blank lines are inserted after each text output line.
.\" XXX: negative values accepted; check AT&T troff
.
.TPx
.REQ .lt
Set length of title lines to previous value.
.
.TPx
.REQ .lt \[+-]N
Set length of title lines
(default length
.scalednumber 6.5 i ,
default scaling unit\~\c
.scaleindicator m ).
.
.TPx
.REQ .mc
Cease writing margin character.
.
.TPx
.REQ .mc c
Begin writing margin
.RI character\~ c
to the right of each output line at a distance of
.scalednumber 10 p .
.
.TPx
.REQ .mc "c d"
Begin writing margin
.RI character\~ c
on each output line at
.RI distance\~ d
to the right of the right margin
(default distance
.scalednumber 10 p ,
default scaling unit\~\c
.scaleindicator m ).
.
.TPx
.REQ .mk
Mark vertical drawing position in an internal register;
see
.BR .rt .
.
.TPx
.REQ .mk reg
Mark vertical drawing position in register
.IR reg .
.
.TPx
.REQ .mso file
As
.RB \[rq] so \[rq],
except that GNU
.I troff \" GNU
searches for the specified
.I file
in the same directories as macro files;
see
.I GROFF_TMAC_PATH
in section \[lq]Environment\[rq] of
.MR groff @MAN1EXT@
and
.B \-m
in section \[lq]Options\[rq]
of the same page.
.
.TPx
.REQ .msoquiet file
As
.request mso ,
but no warning is emitted if
.I file
does not exist.
.
.TPx
.REQ .na
Disable output line adjustment.
.
.TPx
.REQ .ne
Break page if distance to next page location trap is less than one vee.
.
.TPx
.REQ .ne d
Break page if distance to next page location trap is less than distance
.I d
(default scaling unit\~\c
.scaleindicator v ).
.
.TPx
.REQ .nf
Disable filling of output lines;
a pending output line is broken.
.
Clears
.BR \[rs]n[.u] .
.
.TPx
.REQ .nh
Disable automatic hyphenation;
same as
.RB \[lq] ".hy 0" \[rq].
.
.TPx
.REQ .nm
Deactivate output line numbering.
.
.TPx
.REQ .nm \[+-]N
.TQ
.REQ .nm "\[+-]N m"
.TQ
.REQ .nm "\[+-]N m s"
.TQ
.REQ .nm "\[+-]N m s i"
Activate output line numbering:
number the next output line
.I \[+-]N,
writing numbers every
.I m
lines
(default 1),
with
.I s
numeral widths
.RB ( \[rs]0 )
between the line number and the output
(default 1),
and indenting the line number by
.I i
numeral widths
(default 0).
.
.TPx
.REQ .nn
Suppress numbering of the next output line counted by
.BR nm .
.
.TPx
.REQ .nn n
Suppress numbering of the next
.I n
output lines counted by
.BR nm .
.
If
.IR n =0,
cancel suppression.
.\" XXX: negative values accepted; check AT&T troff
.
.TPx
.REQ .nop
Interpolate a newline.
.
.TPx
.REQ .nop input
Interpret
.I input
as if it were an input line.
.
.TPx
.REQ .nr "reg \[+-]N"
Define or update register
.I reg
with value
.IR N .
.
.TPx
.REQ .nr "reg \[+-]N I"
Define or update register
.I reg
with value
.I N
and auto-increment
.IR I ,
which may be any integer.
.
.TPx
.REQ .nroff
Make the conditional expressions
.B n
true and
.B t
false.
.
.TPx
.REQ .ns
Enable
.IR "no-space mode" ,
ignoring
.B .sp
requests until a glyph or
.B \[rs]D
primitive is output.
.
See
.BR .rs .
.
.TPx
.REQ .nx
Stop processing the input file and read the next,
if any.
.
.TPx
.REQ .nx file
Stop processing the input file and read
.IR file .
.
.TPx
.REQ .open "ident file"
Open
.I file
for writing and associate a stream named
.I ident
with it,
making it available for
.RB \[rq] write \[rq]
requests.
.
Unsafe request;
disabled by default.
.
.TPx
.REQ .opena "ident file"
As
.RB \[lq] open \[rq],
but if
.I file
already exists,
appends to it instead of overwriting it.
.
Unsafe request;
disabled by default.
.
.TPx
.REQ .os
Output vertical space that was saved by the
.request sv
request.
.
.TPx
.REQ .output character-sequence
Emit
.I character-sequence
\[lq]transparently\[rq]
(directly) to
.IR @g@troff 's
output.
.
.TPx
.REQ .pc
Reset page number character to\~\c
.squoted_char % .
.
.TPx
.REQ .pc c
Change the page number character used in titles
.RI to\~ c .
.
.TPx
.REQ .pchar "c \fR\&.\|.\|.\&\fP"
Report,
to the standard error stream,
information about each character
(be it
ordinary,
special,
or indexed)
.RI "or character class\~" c .
.
A character defined by a request
.RB ( char ,
.BR \%fchar ,
.BR \%fschar ,
or
.BR \%schar )
reports its contents as a JSON-encoded string,
but the output is not otherwise in JSON format.
.
.TPx
.REQ .pcolor
Report,
to the standard error stream,
each defined color name,
its color space identifier,
and channel value assignments.
.
A device's default stroke and/or fill colors,
\[lq]default\[rq],
are not listed since they are immutable and their details unknown to the
formatter.
.
.TPx
.REQ .pcolor "col \fR\&.\|.\|.\&\fP"
Report,
to the standard error stream,
the name,
color space identifier,
and channel value assignments of each color
.IR col .
.
.TPx
.REQ .pcomposite
Report,
to the standard error stream,
the list of configured composite character mappings.
.
See the
.RB \%\[lq] composite \[rq]
request.
.
The \[lq]from\[rq] code point is listed first,
followed by its \[lq]to\[rq] mapping.
.
.TPx
.REQ .pev
Report the state of the current environment followed by that of all
other environments to the standard error stream.
.
.TPx
.REQ .pfp
Report,
to the standard error stream,
the list of occupied font mounting positions.
.\" Recall the @code{fp} request description in @ref{Selecting Fonts}.
.
Occupied mounting positions are listed,
one per line,
in increasing order,
followed by the typeface name;
if the name corresponds to an abstract style,
the entry ends there.
.
Otherwise,
the name of the font description file
and the font's \[lq]internal name\[rq] datum,
the meaning of which varies by output device,
follow.
.
.TPx
.REQ .pftr
Report,
to the standard error stream,
the list of font translations.
.
.TPx
.REQ .phw
Report,
to the standard error stream,
the list of hyphenation exception words
associated with the hyphenation language
selected by the
.B hla
request.
.
A
.RB \[lq] \- \[rq]
marks each hyphenation point.
.
A word prefixed with
.RB \[lq] \- \[rq]
is not hyphenated at all.
.
The report suffixes words
to which automatic hyphenation applies
(meaning those defined in a hyphenation pattern file
rather than with the
.B hw
request)
with a tab and asterisk
.RB \[lq] * \[rq].
.
.
.TPx
.REQ .pi command
Pipe GNU
.I troff \" GNU
output through
.I command
(which is read in copy mode)
by passing it to
.MR popen 3 .
.
Multiple
.B pi
requests construct a multi-stage pipeline in the same order as the
formatter encounters the requests.
.
Unsafe request;
disabled by default.
.
.TPx
.REQ .pl
Set page length to default
.scalednumber 11 i .
The current page length is stored in register
.BR .p .
.
.TPx
.REQ .pl \[+-]N
Change page length to
.I \[+-]N
(default scaling unit\~\c
.scaleindicator v ).
.
.TPx
.REQ .pline
Report,
in JSON syntax to the standard error stream,
the list of output nodes corresponding to the pending output line.
.
In JSON,
a pair of empty brackets
.RB \[lq] "[ ]" \[rq]
represents an empty list.
.
A
.I pending
output line has not yet undergone adjustment,
and lacks a line number and margin character
(all as applicable).
.
.TPx
.REQ .pm
Report,
to the standard error stream,
the names of all defined macros,
strings,
and diversions and their lengths in characters or nodes.
.
.TPx
.REQ .pm "name \fR\&.\|.\|.\&\fP"
Report,
to the standard error stream,
the JSON-encoded name and contents of each macro,
string,
or diversion
.IR name .
.
.TPx
.REQ .pn \[+-]N
Set next page number.
.
.TPx
.REQ .pnr
Report the names,
values,
and
(as applicable)
autoincrement amounts and
assigned formats of all defined registers to the standard error stream.
.
.TPx
.REQ .pnr "reg \fR\&.\|.\|.\&\fP"
Report the name and value and,
if its type is numeric,
the autoincrement amount and assigned format,
of each register
.I reg
to the standard error stream.
.
.TPx
.REQ .po
Change to previous page offset.
.
The current page offset is available in register
.BR .o .
.
.TPx
.REQ .po \[+-]N
Alter page offset
(default scaling unit\~\c
.scaleindicator m ).
.
.TPx
.REQ .ps
Restore previous type size.
.TPx
.
.REQ .ps \[+-]N
Set/increase/decrease the type size to/by
.I N
scaled points
(a non-positive resulting type size is set to 1\~u);
also see
.esc[] s \[+-]N .
.
.TPx
.REQ .psbb postscript-file
Retrieve the bounding box of the PostScript image found in
.I postscript-file,
which must conform to Adobe's Document Structuring Conventions (DSC).
.
See registers
.BR llx ,
.BR lly ,
.BR urx ,
.BR ury .
.
.TPx
.REQ .pso command
As
.RB \[lq] so \[rq],
except that input comes from the standard output stream of
.IR command ,
which is passed to
.MR popen 3 .
.
Unsafe request;
disabled by default.
.
.TPx
.REQ .pstream
Report,
in
JSON
syntax to the standard error stream,
the list of open streams,
including the name of each open stream,
the name of the file backing it,
and its mode
(writing or appending).
.
.TPx
.REQ .pwh
Report names and positions of all page location traps to the standard
error stream.
.
.TPx
.REQ .pvs
Change to previous post-vertical line spacing.
.
.TPx
.REQ .pvs \[+-]N
Change post-vertical line spacing according to
.I \[+-]N
(default scaling unit\~\c
.scaleindicator p ).
.
.TPx
.REQ .rchar "c\fR.\|.\|.\&\fP"
Remove definition of each
ordinary,
special,
or
indexed
character
.IR c ,
undoing the effect of a
.BR char ,
.BR \%fchar ,
or
.B \%schar
request.
.
Spaces need not separate
.I c
arguments.
.\" XXX: Removal of a class is unspecified.
.
The character definition removed
(if any)
is the first encountered in the resolution process documented
in section \[lq]Using Symbols\[rq] of
.IR "Groff: The GNU Implementation of troff" .
.\" TODO: Get that information into this man page!
.
Glyphs,
which are defined by font description files,
cannot be removed.
.
.TPx
.REQ .rd
Read insertion from standard input stream,
ringing terminal bell as prompt.
.
.TPx
.REQ .rd terminal-message
Read insertion from standard input stream,
writing
.I terminal-message
to standard error stream as prompt.
.
.TPx
.REQ .return
.\" XXX: useless request warning if not interpreting a macro?
Stop interpreting an interpolated macro,
skipping the remainder of its definition.
.
.TPx
.REQ .return input
As
.BR return ,
but perform the skip twice\[em]once within the macro being interpreted
and once in an enclosing macro.
.
.TPx
.REQ .rfschar "f c\fR\&.\|.\|.\&\fP"
Remove each fallback special
.RI character\~ c
for font
.IR f .
.
Spaces need not separate
.I c
arguments.
.
See
.BR fschar .
.
.TPx
.REQ .rj
Break,
right-align the output of the next productive input line without
filling,
then break again.
.
.TPx
.REQ .rj npl
Break,
right-align the output of the next
.I npl
productive input lines without filling,
then break again.
.
If
.I npl
\[<=] 0,
stop right-aligning.
.
.TPx
.REQ .rm "name \f[R].\|.\|."
Remove each request,
macro,
diversion,
or string
.IR name .
.
.TPx
.REQ .rn "old new"
Rename request,
macro,
diversion,
or string
.I old
to
.IR new .
.
.TPx
.REQ .rnn "reg1 reg2"
Rename register
.I reg1
to
.IR reg2 .
.
.TPx
.REQ .rr "reg \f[R].\|.\|."
Remove each register
.IR reg .
.
.TPx
.REQ .rs
Restore spacing;
disable no-space mode.
.
See
.BR .ns .
.
.TPx
.REQ .rt
Return
.I (upward only)
to vertical position marked by
.B .mk
on the current page.
.
.TPx
.REQ .rt N
Return
.I (upward only)
to vertical position
.I N
(default scaling
unit\~\c
.scaleindicator v ).
.\" XXX: negative values accepted; check AT&T troff
.
.TPx
.REQ .schar c
Define global fallback character
.I c
as empty.
.
.TPx
.REQ .schar "c contents"
Define global fallback character
.I c
as
.IR contents .
.
As
.BR char ,
but GNU
.I troff \" GNU
locates a character defined with
.B schar
after any fonts named as arguments to the
.RB \%\[lq] special \[rq]
request and before any mounted special fonts.
.
.TPx
.REQ .shc
Reset the soft hyphen character to
.esc [hy] .
.
.TPx
.REQ .shc c
Set the soft hyphen character
.RI to\~ c .
.
.TPx
.REQ .shift
Shift macro or string parameters one place
.I n
places:
.RI argument\~ i
becomes argument
.IR i \|\-\| 1 ;
argument 1
becomes unavailable.
.
.TPx
.REQ .shift n
Shift macro or string parameters
.I n
places:
.RI argument\~ i
becomes argument
.IR i \|\-\| n ;
arguments 1
.RI to\~ n
become unavailable.
.
.TPx
.REQ .sizes "s1 s2 \f[R].\|.\|.\&\f[] sn \f[R][\f[B]0\f[]]"
Set available type sizes to the list of values or ranges;
each
.IR s i
is interpreted in units of scaled points (\c
.scaleindicator s ).
.
GNU
.I troff \" GNU
strips a leading neutral double quote from
.IR s1 ;
it reads
each
.IR s i
in copy mode.
.
.TPx
.REQ .so file
Replace the request's control line
with the contents of
.IR file ,
\[lq]sourcing\[rq] it.
GNU
.I troff \" GNU
searches for
.I file
in any directories specified by
.B \-I
command-line options,
followed by the current working directory.
.
If
.I file
does not exist,
the formatter ignores the request.
(GNU
.I troff \" GNU
emits a warning in category
.RB \[lq] file \[rq].)
.
.TPx
.REQ .soquiet file
As
.RB \[rq] so \[rq],
but no warning is emitted if
.I file
does not exist.
.
.TPx
.REQ .sp
Break and move the next text baseline down by one vee,
or until springing a page location trap.
.
If invoked with the no-break control character,
.B sp
moves the text baseline applicable to the entire pending output line.
.
.TPx
.REQ .sp vertical-distance
As
.BR sp ,
but move by
.I vertical-distance
instead of
.BR 1v .
.
Inside a diversion,
the formatter ignores any argument.
.
A negative
.I vertical-distance
cannot reduce the position of the text baseline below zero.
.
Applying the boundary-relative measurement operator
.B \[or]
operator to
.I vertical-distance,
as in
.RB \[lq] \[or]\c
.IR N \[rq],
moves to a position relative to the page top for positive
.IR N ,
and the bottom if
.I N
is negative.
.
.TPx
.REQ .special
Empty the list of special fonts designated by this request
when given arguments.
.
.TPx
.REQ .special "s \fR\&.\|.\|.\&\fP"
Declare each font
.I s
as special,
irrespective of its description file,
populating a list that
GNU
.I troff \" GNU
searches,
in order,
to find the glyph demanded.
.
.\" TODO: Move this sentence to a new (sub)section describing the glyph
.\" resolution procedure.
GNU
.I troff \" GNU
searches fonts specified as arguments to the
.RB \%\[lq] special \[rq]
request after those given as arguments to the
.B \%fspecial
request.
.
.TPx
.REQ .spreadwarn
Toggle the spread warning on and off (the default) without changing its
value.
.
.TPx
.REQ .spreadwarn N
Emit a
.B break
warning if the additional space inserted for each space between words in
an adjusted output line is greater than or equal to
.IR N .
.
A negative
.I N
is treated as 0.
.
The default scaling unit is\~\c
.scaleindicator m .
.
At startup,
.request spreadwarn
is inactive and
.I N
is
.scalednumber "3 m" .
.\" XXX: Negative values are accepted to make future implementation of
.\" "squeezable" adjustable spaces smoother; see Savannah #40963.
.
.TPx
.REQ .ss n
Set minimum inter-word space and supplemental inter-sentence space sizes
to
.IR n \~12ths
of the selected font's
.B spacewidth
parameter
(default: 12).
.
.TPx
.REQ .ss "n m"
As
.RB \[lq] .ss\~\c
.IR n \[rq],
but set supplemental inter-sentence space size to
.IR m \~12ths
of the selected font's
.B spacewidth
parameter.
.
.TPx
.REQ .stringdown str
Replace each byte in the string named
.I str
with its lowercase version.
.
.TPx
.REQ .stringup str
Replace each byte in the string named
.I str
with its uppercase version.
.
.TPx
.REQ .sty "pos style"
Associate abstract
.I style
with non-negative font position
.IR pos .
.
.TPx
.REQ .substring "str start \fR[\fPend\fR]\fP"
Replace the string named
.I str
with its substring bounded by the indices
.I start
and
.IR end ,
inclusive.
.
Negative indices count backward from the end of the string.
.
.TPx
.REQ .sv
As
.request ne ,
but save
.scalednumber "1 v"
for output with
.request os
request.
.
.TPx
.REQ .sv d
As
.request ne ,
but save distance
.I d
for later output with
.request os
request
(default scaling unit\~\c
.scaleindicator v ).
.\" XXX: negative values accepted; check AT&T troff
.
.TPx
.REQ .sy command
Execute
.I command
(which is read in copy mode)
in the operating environment
by passing it to
.MR system 3 .
.
See register
.BR \%systat .
.
Unsafe request;
disabled by default.
.
.TPx
.REQ .ta
Clear tab stops.
.
.TPx
.REQ .ta "n1 n2 \fR\&.\|.\|.\&\fP n\fRn\fP \f[B]T\f[] r1 r2 \
\fR\&.\|.\|.\&\fP r\fRn\fP"
Set tabs at positions
.IR n1 ,
.IR n2 ,
\&.\|.\|.\&,
.IR n n,
then set tabs at
.IR n n+ m \[tmu] r n+ r1
through
.IR n n+ m \[tmu] r n+ r n,
where
.I m
increments from 0,
1,
2,
\&.\|.\|.\& to the output line length.
.
Each
.IR n \~argument
can be prefixed with
.RB a\~\[lq] + \[rq]
to place the tab stop
.I ni
at a distance relative to the previous,
.IR n ( i \-1).
.
Each argument
.IR ni \~or\~ ri
can be suffixed with a letter to align text within the tab column
bounded by tab stops
.IR i \~and\~ i +1;
.RB \[lq] L \[rq]
for left-aligned
(the default),
.RB \[lq] C \[rq]
for centered,
and
.RB \[lq] R \[rq]
for right-aligned.
.
.TPx
.REQ .tag
Reserved for internal use.
.
.TPx
.REQ .taga
Reserved for internal use.
.
.TPx
.REQ .tc
Unset tab repetition character.
.
.TPx
.REQ .tc c
Set tab repetition character
.RI to\~ c
(default: none).
.
.TPx
.REQ .ti \[+-]N
Temporarily indent next output line
(default scaling unit\~\c
.scaleindicator m ).
.
.TPx
.REQ .tkf "font s1 n1 s2 n2"
Enable track kerning for
.IR font .
.
.TPx
.REQ .tl \f[B]\[aq]\f[]left\f[B]\[aq]\f[]center\f[B]\[aq]\f[]right\
\f[B]\[aq]\f[]
Format three-part title.
.
.TPx
.REQ .tm
Write a newline to the standard error stream.
.
.TPx
.REQ .tm terminal-message
Send
.IR terminal-message ,
followed by a newline,
to the standard error stream.
The formatter reads the argument
to the end of the input line in copy mode,
but does
.I not
remove a leading double quote;
contrast
.BR .tm1 .
.
.TPx
.REQ .tm1
As
.request tm .
.
.TPx
.REQ .tm1 message
As
.request tm ,
but removes a leading neutral double quote
.RB \[oq] \[dq] \[cq]
from
.IR message ,
permitting initial embedded spaces in it,
and reads it to the end of the input line in copy mode.
.
.TPx
.REQ .tmc
No operation.
.
.TPx
.REQ .tmc message
As
.request tm1 ,
but does not append a newline.
.
.TPx
.REQ .tr abcd\fR\&.\|.\|.\&\fP
Translate ordinary or special characters
.I a
to
.IR b ,
.I c
to
.IR d ,
and so on prior to output.
.
.TPx
.REQ .trf file
Break and copy contents of
.I file
as \[lq]throughput\[rq] to GNU
.I troff \" GNU
output
(see
.MR groff_out @MAN5EXT@ ).
.
Unlike
.request cf ,
characters invalid as input to GNU
.I troff \" GNU
are discarded.
.
If
.IR file 's
contents do not end with a newline,
.B trf
appends one.
.
.TPx
.REQ .trin abcd\fR\&.\|.\|.\&\fP
As
.request tr ,
except that
.request asciify
ignores the translation when a diversion is interpolated.
.
.TPx
.REQ .trnt abcd\fR\&.\|.\|.\&\fP
As
.request tr ,
except that translations are suppressed in the argument to
.esc ! .
.
.TPx
.REQ .troff
Make the conditional expressions
.B t
true and
.B n
false.
.
.TPx
.REQ .uf font
Set underline font used by
.request ul
to
.I font.
.
.TPx
.REQ .ul
Underline
(italicize in
.I troff
mode)
the output of the next productive input line.
.
.TPx
.REQ .ul npl
Underline
(italicize in
.I troff
mode)
the output of the next
.I npl
productive input line.
.
If
.IR npl =0,
stop underlining.
.
.TPx
.REQ .unformat div
Unformat space characters and tabs in diversion
.IR div ,
preserving font information.
.\" XXX: too vague
.
.TPx
.REQ .vpt
Enable vertical position traps.
.
They are enabled by default.
.
.TPx
.REQ .vpt b
Enable or disable vertical position traps per Boolean expression
.IR b .
.
.TPx
.REQ .vs
Change to previous vertical spacing.
.
.TPx
.REQ .vs \[+-]N
Set vertical spacing to
.I \[+-]N
(default scaling unit\~\c
.scaleindicator p ).
.
.TPx
.REQ .warn
Enable all warning categories.
.
.TPx
.REQ .warn\~0
Disable all warning categories.
.
.TPx
.REQ .warn n
Enable warnings in categories whose codes sum
.RI to\~ n ;
.\" TODO: Move that table here, perhaps.
see
.MR @g@troff @MAN1EXT@ .
.
.TPx
.REQ .warnscale scaling-unit
Select scaling unit used in certain warnings \" `output_warning()`
(one of
.BR u ,
.BR i ,
.BR c ,
.BR p ,
or
.BR P ;
default:
.BR i ).
.
Ignored on
.IR nroff -mode
output devices,
for which these diagnostics report the vertical page location in lines,
and the horizontal page location in ens.
.
.TPx
.REQ .wh vertical-position
Remove visible page location trap at
.I vertical-position
(default scaling unit\~\c
.scaleindicator v ).
.
.TPx
.REQ .wh "vertical-position mac"
Plant macro
.I mac
as page location trap at
.I vertical-position
(default scaling unit\~\c
.scaleindicator v ),
removing any visible trap already there.
.
.TPx
.REQ .while cond-expr
Interpolate newlines unless and until
.I cond-expr
evaluates false.
.
.TPx
.REQ .while "cond-expr input"
Repeatedly execute
.I input
unless and until
.I cond-expr
evaluates false.
.
.TPx
.REQ .write "stream character-sequence"
Write
.IR character-sequence ,
a sequence of ordinary characters,
spaces,
or tabs,
.\" ...or, technically, backspace and delete characters, but let's not
.\" dwell on that.
to
.IR stream ,
which must previously have been the subject of an
.RB \[lq] open \[rq]
(or
.BR opena )
request,
followed by a newline.
.
GNU
.I troff \" GNU
flushes the stream after writing to it.
.
.TPx
.REQ .writec "stream character-sequence"
As
.RB \[rq] write \[rq],
but does not write a newline to the output.
.
.TPx
.REQ .writem "stream name"
Write the contents of the macro or string
.I name
to
.IR stream ,
which must previously have been the subject of an
.RB \[lq] open \[rq]
(or
.BR opena )
request.
.
GNU
.I troff \" GNU
reads the contents of
.I name
in copy mode.
.
.LE
.
.
.\" ====================================================================
.SH "Escape sequence short reference"
.\" ====================================================================
.
The escape sequences
.esc \[dq] ,
.esc # ,
.esc $ ,
.esc * ,
.esc ? ,
.esc a ,
.esc e ,
.esc n ,
.esc t ,
.esc g ,
.esc V ,
and
.escarg \& newline
are interpreted even in copy mode.
.
.
.P
The escape sequences
.esc f ,
.esc F ,
.esc H ,
.esc m ,
.esc M ,
.esc R ,
.esc s ,
and
.esc S
are not tokenized when
GNU
.I troff \" GNU
reads its input.
.
.esc R
updates only the formatter's register dictionary,
and does not contribute (directly) to output.
.
The others alter the environment
(see section \[lq]Environments\[rq] below).
.
See the \[lq]Gtroff Internals\[rq] section of the
.I groff
Texinfo manual.
.
.
.P
.LS
.
.\" ========= comments =========
.
.TP
.ESC \[dq]
Comment;
read everything up to the next newline in copy mode and discard it.
.
.
.TP
.ESC #
Whole-line comment;
read everything up to and including the next newline in copy mode and
discard it.
.
.
.\" ========= strings =========
.
.TP
.ESC * s
Interpolate string with one-character
.RI name\~ s .
.
.
.TP
.ESC *( st
Interpolate string with two-character
.RI name\~ st .
.
.
.TP
.ESC[] * string
Interpolate string with name
.I string
(of arbitrary length).
.
.
.TP
.ESC[] * "string arg \fR\&.\|.\|.\fP"
Interpolate string with name
.I string
(of arbitrary length),
taking
.I arg
\&.\|.\|.\&
as arguments.
.
.
.\" ========= macro arguments =========
.
.TP
.ESC $0
Interpolate name by which currently executing macro was invoked.
.
.
.TP
.ESC $ n
Interpolate macro or string parameter
.RI numbered\~ n
.RI (1\|\[<=]\| n \|\[<=]\|9).
.
.
.TP
.ESC $( nn
Interpolate macro or string parameter
.RI numbered\~ nn
.RI (01\|\[<=]\| nn \|\[<=]\|99).
.
.TP
.ESC[] $ nnn
Interpolate macro or string parameter
.RI numbered\~ nnn
.RI ( nnn \|\[>=]\|1).
.
.
.TP
.ESC $*
Interpolate catenation of all macro or string parameters,
separated by spaces.
.
.
.TP
.ESC $@
Interpolate catenation of all macro or string parameters,
with each surrounded by double quotes and separated by spaces.
.
.
.TP
.ESC $\[ha]
Interpolate catenation of all macro or string parameters
as if they were arguments to the
.request ds
request.
.
.
.\" ========= escaped characters =========
.
.
.TP
.ESC \[aq]
is a synonym for
.esc [aa] ,
the acute accent special character.
.
.
.TP
.ESC \[ga]
is a synonym for
.esc [ga] ,
the grave accent special character.
.
.
.TP
.ESC \-
is a synonym for
.esc [\-] ,
the minus sign special character.
.
.
.TP
.ESC _
is a synonym for
.esc [ul] ,
the underrule special character.
.
.
.TP
.ESC %
Mark a hyphenation point within a word.
At the beginning of a word,
prevent it from being otherwise hyphenated.
.
.
.TP
.ESC ! character-sequence
.I Transparently
embed
.IR character-sequence ,
up to and including the end of the line,
into the current diversion,
requests,
macro calls,
and escape sequences
when reading them into a diversion.
.
Doing so prevents them from taking effect
until the diverted text is actually output.
.
.
.TP
.ESC? character-sequence
Transparently embed
.IR character-sequence ,
up to its own next occurrence on the input line,
into a diversion,
or unformatted as an output comparand in a conditional expression.
.
Ignored in the top-level diversion.
.
.
.\" ========= spaces and fixed-width horizontal motions =========
.
.TP 8n \" "\space" + 2n
.ESC \f[I]space
Move right one inter-word space.
.
.
.TP
.ESC \[ti]
Insert an unbreakable,
adjustable space.
.
.
.TP
.ESC 0
Move right by the width of a numeral in the current font.
.
.
.TP
.ESC |
Move one-sixth em to the right on typesetters.
.
.
.TP
.ESC \[ha]
Move one-twelfth em to the right on typesetters.
.
.
.TP
.ESC &
Interpolate a dummy character.
.
.
.TP
.ESC \|)
Interpolate a dummy character that is transparent to end-of-sentence
recognition.
.
.
.TP
.ESC \|/
Apply italic correction.
.
Use between an immediately adjacent oblique glyph on the left and an
upright glyph on the right.
.
.
.TP
.ESC \|,
Apply left italic correction.
.
Use between an immediately adjacent upright glyph on the left and an
oblique glyph on the right.
.
.
.TP
.ESC :
Non-printing break point
(similar to
.esc % ,
but never produces a hyphen glyph).
.
.
.TP
.ESC "" newline
Continue current input line on the next.
.
.
.\" ========= structuring =========
.
.TP
.ESC {
Begin conditional input.
.
.TP
.ESC }
End conditional input.
.
.\" ========= longer escape names =========
.
.TP
.ESC ( sc
Interpolate glyph of special character with two-character identifier
.IR sc .
.
.
.TP
.ESC[] "" spchar
Interpolate glyph of special character with identifier
.I spchar
(of arbitrary length).
.
.
.TP
.ESC[] "" "base-char comp \fR\&.\|.\|."
Interpolate composite glyph constructed from
.I base-char
and each component
.IR comp .
.
.
.TP
.ESC[] "" "\f[B]char\f[]nnn"
Interpolate glyph of eight-bit encoded character
.IR nnn ,
where
.RI 0\|\[<=]\| nnn \|\[<=]\|255.
.
.
.TP
.ESC[] "" "\f[B]u\f[]nnnn\f[R][\f[]n\f[R][\f[]n\f[R]]]"
Interpolate glyph of Unicode character with code point
.IR nnnn [ n [ n ]]
in uppercase hexadecimal.
.
.
.TP
.ESC[] "" "\f[B]u\f[]base-char\f[R][\f[]\f[B]_\f[]\
combining-component\f[R]].\|.\|."
Interpolate composite glyph from Unicode character
.I base-char
and
.IR combining-components .
.
.
.\" ========= alphabetical escape sequences =========
.
.TP
.ESC a
Interpolate a leader in copy mode.
.
.TP
.ESCq A input
Interpolate 1 if
.I input
is a valid identifier,
and\~0 otherwise.
.
Because GNU
.I troff \" GNU
ignores any input character with an invalid code when reading it,
invalid identifiers are empty or contain
spaces,
tabs,
newlines,
or
escape sequences
that interpolate something other than a sequence of ordinary characters.
.
.TP
.ESCq b string
Build bracket:
pile a sequence of glyphs corresponding to each character in
.I string
vertically,
and center it vertically on the output line.
.
.TP
.ESCq B input
Interpolate 1 if
.I input
is a valid numeric expression,
and\~0 otherwise.
.
.
.TP
.ESC c
Continue output line at next input line.
.
.
.TP
.ESCq C glyph
As
.esc[] "" glyph ,
but compatible with other
.I troff \" generic
implementations.
.
.
.TP
.ESC d
Move downward \[12]\~em on typesetters.
.\" XXX: No current groff nroff-mode output driver supports half-line
.\" motions.
.\" (\[12]\~line in
.\" .I nroff
.\" contingent on device support).
.
.
.TP
.ESCq D drawing-command
See subsection \[lq]Drawing commands\[rq] below.
.
.
.TP
.ESC e
Interpolate the escape character.
.
.
.TP
.ESC E
As
.esc e ,
but not interpreted in copy mode.
.
.TP
.ESC fP
Select previous font mounting position
(abstract style or font);
same as
.RB \[lq] .ft \[rq]
or
.RB \[lq] .ft\~P \[rq].
.
.TP
.ESC f F
Select font mounting position,
abstract style,
or font with one-character name or one-digit
.RI position\~ F .
.
.IR F \~cannot
be
.BR P .
.
.TP
.ESC f( ft
Select font mounting position,
abstract style,
or font with two-character name or two-digit
.RI position\~ ft .
.
.TP
.ESC[] f font
Select font mounting position,
abstract style,
or font with arbitrarily long name or position
.IR font .
.
.I font
cannot be
.BR P .
.
.TP
.ESC[] f ""
Select previous font mounting position
(abstract style or font).
.
.TP
.ESC F f
Set default font family to that with one-character
.RI name\~ f .
.
.TP
.ESC F( fm
Set default font family to that with two-character
.RI name\~ fm .
.
.TP
.ESC[] F fam
Set default font family to that with arbitrarily long name
.IR fam .
.
.TP
.ESC[] F ""
Set default font family to previous value.
.
.TP
.ESC g r
Interpolate format of register with one-character
.RI name\~ r .
.
.
.TP
.ESC g( rg
Interpolate format of register with two-character
.RI name\~ rg .
.
.
.TP
.ESC[] g reg
Interpolate format of register with arbitrarily long name
.IR reg .
.
.
.TP
.ESCq h N
Horizontally move the drawing position by
.IR N \~ems
(or specified units);
.B \[or]
may be used.
.
Positive motion is rightward.
.
.
.TP
.ESCq H N
Set
(increment, decrement)
the height of the current font,
but not its width.
.
If
.I N
is zero,
the formatter uses the font's inherent height for its type size
default scaling unit\~\c
.scaleindicator z ).
.
.TP
.ESC k r
Store the horizontal drawing position,
relative to that corresponding to the start of the input line
(ignoring page offset and indentation),
in register
.RI name\~ r .
.
.TP
.ESC k( rg
Store the horizontal drawing position,
relative to that corresponding to the start of the input line
(ignoring page offset and indentation),
in register
.RI name\~ rg .
.
.
.TP
.ESC[] k reg
Store the horizontal drawing position,
relative to that corresponding to the start of the input line
(ignoring page offset and indentation),
in register
.RI name\~ reg .
.
.
.TP
.ESCq l N\/\f[R][\f[]c\f[R]]
Draw horizontal line of length
.I N
with character
.I c
(default:
.BR \[rs][ru] ;
default scaling unit\~\c
.scaleindicator m ).
.
.
.TP
.ESCq L N\/\f[R][\f[]c\f[R]]
Draw vertical line of length
.I N
with character
.I c
(default:
.BR \[rs][br] ;
default scaling unit\~\c
.scaleindicator v ).
.
.
.TP
.ESC m c
Select stroke color with one-character
.RI name\~ c .
.
.
.TP
.ESC m( cl
Select stroke color with two-character
.RI name\~ cl .
.
.
.TP
.ESC[] m color
Select stroke color with arbitrarily long
.RI name\~ color .
.
.
.TP
.ESC[] m ""
Restore previous stroke color.
.
.
.TP
.ESC M c
Select fill color with one-character
.RI name\~ c .
.
.
.TP
.ESC M( cl
Select fill color with two-character
.RI name\~ cl .
.
.
.TP
.ESC[] M color
Select fill color with arbitrarily long
.RI name\~ color .
.
.
.TP
.ESC[] M ""
Restore previous fill color.
.
.
.br
.ne 4v \" XXX: why not 3v?
.TP
.ESC n r
Interpolate value of register with one-character
.RI name\~ r .
.
.
.TP
.ESC n( rg
Interpolate value of register with two-character
.RI name\~ rg .
.
.
.TP
.ESC[] n reg
Interpolate value of register with arbitrarily long
.RI name\~ reg .
.
.
.TP
.ESCq N n
Format indexed character numbered
.I n
in the current font.
.
.TP
.ESCq o abc\f[R].\|.\|.\f[]
Overstrike centered glyphs of characters
.IR a ,
.IR b ,
.IR c ,
and so on.
.
.TP
.ESC O0
At the outermost suppression level,
disable emission of glyphs and geometric objects to the output
driver.
.
.
.TP
.ESC O1
At the outermost suppression level,
enable emission of glyphs and geometric objects to the output driver.
.
.
.TP
.ESC O2
At the outermost suppression level,
enable glyph and geometric primitive emission to the output driver and
write to the standard error stream the page number,
four bounding box registers enclosing glyphs written since the previous
.B \[rs]O
escape sequence,
the page offset,
line length,
image file name
(if any),
horizontal and vertical device motion quanta,
and input file name.
.
.
.TP
.ESC O3
Begin a nested suppression level.
.
.
.TP
.ESC O4
End a nested suppression level.
.
.
.TP
.ESC[] O "\f[B]5\f[]Pfile"
At the outermost suppression level,
write the name
.I file
to the standard error stream at
.RI position\~ P ,
which must be one of
.BR l ,
.BR r ,
.BR c ,
or
.BR i .
.
.
.TP
.ESC p
Break output line at next word boundary;
adjust if applicable.
.
.
.TP
.ESC r
Move \[lq]in reverse\[rq] (upward) 1\~em.
.
.
.TP
.ESCq R "name\~\[+-]N"
Set,
increment,
or decrement register
.I name
.RI by\~ N .
.
.
.TP
.ESC s \[+-]N
Set/increase/decrease the type size to/by
.I N
scaled points.
.
.I N
must be a single digit.
.
If
.IR n \~is
an unsigned
\[lq]0\[rq],
restore the previous size.
.
(In compatibility mode only,
a non-zero
.I N
must be in the range 4\[en]39.)
.
Otherwise,
as
.request ps
request.
.
.
.TP
.ESC s( \[+-]N
.TQ
.BI \es \[+-] ( N
Set/increase/decrease the type size to/by
.I N
scaled points;
.I N
is a two-digit number \[>=]1.
.
If
.IR n \~is
an unsigned
\[lq]00\[rq],
restore the previous size.
.
Otherwise,
as
.request ps
request.
.
.
.TP
.ESC[] s \[+-]N
.TQ
.BI \es \[+-] [ N ]
.TQ
.ESCq s \[+-]N
.TQ
.BI \es \[+-] \[aq] N \[aq]
Set/increase/decrease the type size to/by
.I N
scaled points.
.
If
.IR n \~is
an unsigned
\[lq]0\[rq]
(with any number of leading zeroes),
restore the previous size.
.
Otherwise,
as
.request ps
request.
.
.
.TP
.ESCq S N
Slant the glyphs of the currently selected font by
@var{N}
degrees.
.
Positive values slant in the direction of text flow.
.
Only integer values are possible.
.
.
.TP
.ESC t
Interpolate a tab in copy mode.
.
.
.TP
.ESC u
Move upward \[12]\~em on typesetters.
.\" XXX: No current groff nroff-mode output driver supports half-line
.\" motions.
.\" (\[12]\~line in
.\" .I nroff
.\" contingent on device support).
.
.
.TP
.ESCq v N
Vertically move the drawing position by
.IR N \~vees
(or specified units);
.B \[or]
may be used.
.
Positive motion is downward.
.
.
.TP
.ESC V e
Interpolate value of system environment variable with one-character
.RI name\~ e
as returned by
.MR getenv 3 .
.
.
.TP
.ESC V( ev
Interpolate value of system environment variable with two-character
.RI name\~ ev
as returned by
.MR getenv 3 .
.
.
.TP
.ESC[] V env
Interpolate value of system environment variable with arbitrarily
long
.RI name\~ env
as returned by
.MR getenv 3 .
.
.
.TP
.ESCq w input
Interpolate the width of
.IR input ,
as interpreted,
in basic units.
.
This escape sequence
allows several properties of formatted output to be measured
without writing it out.
.
The formatter processes
.I input
in a dummy environment:
this means that font and type size changes,
for example,
may occur within it without affecting subsequent output.
.
.
.TP
.ESCq x N
Increase vertical spacing of pending output line by
.IR N \~vees
(or specified units;
negative before,
positive after).
.
.TP
.ESCq X character-sequence
Write
.I character-sequence
to
.I @g@troff
output as a device extension command.
.
The
.I groff
special character repertoire is unknown to output drivers outside of
glyphs named in a device's fonts,
and even then they may not possess complete coverage of the names
documented in
.MR groff_char @MAN7EXT@ .
.
Further,
escape sequences that produce horizontal or vertical motions,
hyphenation breaks,
or that are dummy characters may appear in strings
or be converted to nodes,
particularly in diversions. \" (@pxref{Gtroff Internals})
.
These are not representable when interpolated directly into
device-independent output,
as might be done when writing out tag names for PDF bookmarks,
which can appear in a viewer's navigation pane.
.
.
.\" XXX: Force paragraph spacing here.  I know--it's terrible.  And
.\" unnecessary once we get this giant discussion moved to its own
.\" (sub)section.
.if t .sp 0.4v
.if n .sp 1v
.\"IP
So that documents or macro packages do not have to laboriously
\[lq]sanitize\[rq] strings destined for interpolation
in device extension commands,
this escape sequence
.\" XXX: and soon other things
performs certain transformations on its argument.
.
For these transformations,
character translations and definitions are ignored.
.
.
.if t .sp 0.4v
.if n .sp 1v
.\"IP
GNU
.I troff \" GNU
converts several ordinary characters that typeset as non-basic Latin
code points to code points outside that range so that they are used
consistently whether they are formatted as glyphs or used in a device
control command argument.
.
These ordinary characters are
.RB \[lq]\| \[aq] \|\[rq],
.RB \[lq]\| \- \|\[rq],
.RB \[lq]\| \[ha] \|\[rq],
.RB \[lq]\| \[ga] \|\[rq],
and
.RB \[lq]\| \[ti] \|\[rq];
others are written as-is.
.
.
.if t .sp 0.4v
.if n .sp 1v
.\"IP
Special characters that typeset as Unicode basic Latin characters
are translated to basic Latin characters accordingly.
.
So that any Unicode code point can be represented in device extension
commands,
for example in an author's name in document metadata
or as a usefully named bookmark or hyperlink anchor,
GNU
.I troff \" GNU
maps other special characters to Unicode special character notation.
.
Special characters without a Unicode representation,
and escape sequences that do not interpolate a sequence
of ordinary and/or special characters,
produce warnings in category
.RB \[lq] char \[rq].
.
.TP
.ESC Y n
Write contents of macro or string
.I n
to
.I @g@troff
output as a device extension command.
.
.TP
.ESC Y( nm
Write contents of macro or string
.I nm
to
.I @g@troff
output as a device extension command.
.
.TP
.ESC[] Y name
Write contents of macro or string
.I name
to
.I @g@troff
output as a device extension command.
.
.TP
.ESC z c
Format character
.I c
with zero width\[em]without advancing the drawing position.
.
.TP
.ESCq Z input
Save the drawing position,
format
.IR input ,
then restore it.
.
GNU
.I troff \" GNU
ignores tabs and leaders in
.I input
with an error diagnostic.
.LE
.
.
.\" ====================================================================
.SS "Drawing commands"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Drawing
.\" commands".
Drawing commands direct the output device to render geometrical objects
rather than glyphs.
.
Specific devices may support only a subset,
or may feature additional ones;
consult the man page for the output driver in use.
.
Terminals in particular implement almost none.
.
.
.P
Rendering starts at the drawing position;
when finished,
the drawing position is left at the rightmost point of the object,
even for closed figures,
except where noted.
.
GNU
.I troff \" GNU
draws stroked (outlined) objects with the stroke color,
and shades filled ones with the fill color.
.
See section \[lq]Colors\[rq] above.
.
Coordinates
.I h
and
.I v
are horizontal and vertical motions relative to the drawing position
or previous point in the command.
.
The default scaling unit for horizontal measurements
(and diameters of circles)
.RB is\~ m ;
for vertical ones,
.BR v .
.
.
.P
Circles,
ellipses,
and polygons can be drawn stroked or filled.
.
These are independent properties;
if you want a filled,
stroked figure,
you must draw the same figure twice using each drawing command.
.
A filled figure is always smaller than an outlined one because the
former is drawn only within its defined area,
whereas strokes have a line thickness
(set with
.BR \[rs]D\[aq]t\[aq] ).
.
.
.P
.LS
.TP
.BI \[rs]D\[aq]\[ti]\~ "h1 v1"\~\c
.RI .\|.\|.\~ "hn vn"\c
.B \[aq]
Draw B-spline to each point in sequence,
leaving drawing position at
.RI ( hn ,\~ vn ).
.
.\" XXX: This is one case where a valid coordinate pair could be off the
.\" page (even negative) and we need to discuss this frankly.
.TP
.BI \[rs]D\[aq]a\~ "hc vc h v" \[aq]
Draw circular arc centered at
.RI ( hc ,\~ vc )
counterclockwise from the drawing position to a point
.RI ( h ,\~ v )
relative to the center.
.
.RI ( hc ,\~ vc )
is adjusted to the point nearest the perpendicular bisector of the arc's
chord.
.
.TP
.BI \[rs]D\[aq]c\~ "d" \[aq]
Draw circle of diameter
.I d
with its leftmost point at the drawing position.
.
.TP
.BI \[rs]D\[aq]C\~ "d" \[aq]
As
.BR \[rs]D\[aq]C\[aq] ,
but the circle is filled.
.
.TP
.BI \[rs]D\[aq]e\~ "h v" \[aq]
Draw ellipse of width
.I h
and height
.I v
with its leftmost point at the drawing position.
.
.\" How do we draw an ellipse with rotated axes?
.TP
.BI \[rs]D\[aq]E\~ "h v" \[aq]
As
.BR \[rs]D\[aq]e\[aq] ,
but the ellipse is filled.
.
.\" XXX: Df and dF are taken care of by \M and .defcolor.
.TP
.BI \[rs]D\[aq]l\~ "h v" \[aq]
Draw line from the drawing position to
.RI ( h ,\~ v ).
.
.TP
.BI \[rs]D\[aq]p\~ "h1 v1"\~\c
.RI .\|.\|.\~ "hn vn"\c
.B \[aq]
Draw polygon with vertices at the drawing position
and each point in sequence.
.
GNU
.I troff \" GNU
closes the polygon by drawing a line from
.RI ( hn ,\~ vn )
back to the initial drawing position.
.
.\" XXX: This would be the "STUPID_DRAWING_POSITIONING" complained of in
.\" src/libs/libdriver/input.cpp.  It is neither the rightmost point
.\" of the figure nor the initial drawing position that GNU troff
.\" automatically returned to close the figure.
Afterward,
the drawing position is left at
.RI ( hn ,\~ vn ).
.
.TP
.BI \[rs]D\[aq]P\~ "h1 v1"\~\c
.RI .\|.\|.\~ "hn vn"\c
.B \[aq]
As
.BR \[rs]D\[aq]p\[aq] ,
but the polygon is filled.
.
.TP
.BI \[rs]D\[aq]t\~ "n" \[aq]
Set stroke thickness of geometric objects to
.RI to\~ n
basic units.
.
A zero
.I n
selects the minimum supported thickness.
.
A negative
.I n
selects a thickness proportional to the type size;
this is the default.
.LE
.\" END Keep (roughly) parallel with groff.texi node "Drawing
.\" commands".
.
.
.\" ====================================================================
.SH Strings
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Strings".
.I groff
supports strings primarily for user convenience.
.
Conventionally,
if one would define a macro only to interpolate a small amount of text,
without invoking requests or calling any other macros,
one defines a string instead.
.
Only one string is predefined by the language.
.
.
.TPx
.STRING .T
Contains the name of the output device
(for example,
.RB \[lq] utf8 \[rq]
or
.RB \[lq] pdf \[rq] ).
.
.
.P
The
.request ds
request creates a string with a specified name and contents.
.
If the identifier named by
.request ds
already exists as an alias,
the target of the alias is redefined.
.
If
.request ds
is invoked with only one argument,
the named string becomes empty.
.
The formatter removes a leading neutral double quote
.RB \[oq] \[dq] \[cq] \" single quotes around double quote
from
.I contents
to permit the embedding of leading spaces.
.
It interprets any other
.RB \[oq] \[dq] \[cq] \" single quotes around double quote
literally,
but the wise author uses the special character escape sequence
.B \[rs][dq]
instead if the string
might be interpolated as part of a macro argument;
see section \[lq]Calling macros\[rq] above.
.
.
.P
The
.esc *
escape sequence dereferences a string's name,
interpolating its contents.
.
If the name does not exist,
the formatter defines it as empty,
interpolates nothing,
and emits a warning in category
.RB \%\[lq] mac \[rq].
.
See section \[lq]Warnings\[rq] in
.MR @g@troff 1 .
.
The bracketed interpolation form accepts arguments that are handled as
macro arguments are;
see section \[lq]Calling macros\[rq] above.
.
In contrast to macro calls,
an argument containing a closing bracket
.B ]
must be enclosed in double quotes.
.
When defining strings,
argument interpolations must be escaped if they are to reference
parameters from the calling context;
see section \[lq]Parameters\[rq] below.
.
Any non-initial neutral double quote
.B \[dq]
is interpreted literally,
but it is wise to use the special character escape sequence
.B \[rs][dq]
instead if the string might be interpolated as part of a macro argument;
see section \[lq]Calling macros\[rq] above.
.
Strings are not limited to a single input line of text.
.BI \[rs] newline
works just as it does elsewhere.
.
The resulting string is stored
.I without
the newlines.
.
When filling is disabled,
care is required to avoid overrunning the line length when interpolating
strings.
.
Conversely,
when filling is enabled,
it is not necessary to append
.B \[rs]c
to a string interpolation to prevent a break afterward,
as might be required in a macro argument.
.
Nor does a string require use of
the GNU
.I troff \" GNU
.B chop
request to excise a trailing newline as is often done with diversions.
.
It is not possible to embed a newline in a string that will be
interpreted as such when the string is interpolated.
.
To achieve that effect,
use
.B \[rs]*
to interpolate a macro instead;
see section \[lq]Punning names\[rq] below.
.
.
.P
The
.RB \[lq] as \[rq]
request is similar to
.request ds
but appends to a string instead of redefining it.
.
If
.RB \[lq] as \[rq]
is invoked with only one argument,
no operation is performed
(beyond dereferencing the string).
.
.
.P
Because strings are similar to macros,
they too can be defined to suppress AT&T
.I troff \" AT&T
compatibility mode enablement when interpolated;
see section \[lq]Compatibility mode\[rq] below.
.
The
.request ds1
request defines a string that suspends compatibility mode when the
string is later interpolated.
.
.request as1
is likewise similar to
.RB \[lq] as \[rq],
with compatibility mode suspended when the appended portion of the
string is later interpolated.
.
.
.P
.I Caution:
These requests treat the remainder of the input line
as their second argument,
including any spaces,
up to a newline or comment escape sequence.
.
Ending string definitions
(and appendments)
with a comment,
even an empty one,
prevents unwanted space from creeping into them during source document
maintenance.
.
This rule and suggestion also applies to the second argument of the
.RB \[lq] length \[rq]
request,
to requests that define characters
.RB ( char ,
.BR fchar ,
.BR fschar ,
and
.BR schar ),
and to the file name or command arguments of the
.BR cf ,
.BR hpf ,
.BR hpfa ,
.BR mso ,
.BR msoquiet ,
.BR nx ,
.RB \[lq] open \[rq],
.BR opena ,
.BR pi ,
.BR pso ,
.RB \[lq] so \[rq],
.BR soquiet ,
and
.B trf
requests.
.
.
.br
.ne 3v
.P
Several requests exist to perform rudimentary string operations.
.
Strings can be queried
(\c
.request length )
and modified
(\c
.request chop ,
.request substring ,
.request stringup ,
.request stringdown ),
and their names can be manipulated through renaming,
removal,
and aliasing
(\c
.request rn ,
.request rm ,
.request als).
.
.
.br
.ne 2v
.P
Redefinitions and appendments \[lq]write through\[rq] request,
macro,
string,
and diversion names.
.
To replace an aliased object with a separately defined one,
you must use the
.B rm
request on its name first.
.\" END Keep (roughly) parallel with groff.texi node "Strings".
.
.
.\" ====================================================================
.SH Registers
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Registers".
In the
.I roff
language,
numbers and measurements can be stored in
.I registers.
.
Many built-in registers exist,
supplying anything from components of the date
to details of formatting parameters;
some of these are read-only.
.
You can also define your own.
.
See section \[lq]Identifiers\[rq] above
regarding the construction of valid names for registers.
.
.
.P
Each register
(except read-only ones)
can be assigned a
.IR format ,
causing its value to interpolate with leading zeroes,
in Roman numerals,
or alphabetically.
.
Some read-only registers are string-valued,
meaning that they interpolate text and lack a format.
.
.
.P
Define registers and update their values with the
.B nr
request or the
.B \[rs]R
escape sequence.
.
.
.P
User-defined registers can also be incremented or decremented
by a configured amount
at the time they are interpolated.
.
The value of the increment is specified with a third argument to the
.B nr
request,
and a special interpolation syntax,
.BI \[rs]n \[+-]\c
,
alters and then retrieves the register's value.
.
Together,
these features are called
.IR auto-increment .
.
(A negative auto-increment can be
considered an \[lq]auto-decrement\[rq].)
.
.
.P
Many predefined registers are available.
.
The following presentation uses
register interpolation syntax
.BI \[rs]n[ name ]
to refer to a register
.I name
to clearly distinguish it from a string or request
.IR name ;
the symbols
.B \[rs]n[]
are
.I not
part of the register name.
.
The register name space is separate from that used for requests,
macros,
strings,
and diversions.
.\" END Keep (roughly) parallel with groff.texi node "Registers".
.
.
.\" ====================================================================
.SS "Read-only registers"
.\" ====================================================================
.
Predefined registers whose identifiers start with a dot are read-only.
.
Many are Boolean-valued.
.
.
.P
.I Caution:
Built-in registers are subject to removal like others;
once removed,
they can be recreated only as normal writable registers
and will not otherwise reflect the configuration of the formatter.
.
.
.P
A register name
is often associated with a request of the same name
(without the dot);
exceptions are noted.
.
.
.P
.LS
.
.TP 15n
.REG .$
Count of arguments passed to currently interpolated macro or string.
.
.TP
.REG .a
Amount of extra post-vertical line space;
see
.esc x .
.
.TP
.REG .A
Approximate output is being formatted (Boolean-valued);
see
.I @g@troff
.B \-a
option.
.
.TP
.REG .b
Font emboldening offset;
see
.request bd .
.
.TP
.REG .br
The normal control character was used to call the macro being
interpreted (Boolean-valued).
.
.TP
.REG .c
Input line number;
see
.request lf
and
.register \f[R]\[lq]\f[]c.\f[R]\[rq]\f[] .
.
.TP
.REG .C
AT&T
.I troff \" AT&T
compatibility mode is enabled (Boolean-valued);
see
.request cp .
.
Always false when processing
.RB \[rq] do \[rq];
see
.register .cp .
.
.TP
.REG .cdp
Depth of last glyph formatted in the environment;
.\" TODO: Give page a discussion of glyph properties and move this.
positive if glyph extends below the baseline.
.
.TP
.REG .ce
Count of input lines remaining to be centered
in the environment.
.
.TP
.REG .cht
Height of last glyph formatted in the environment;
.\" TODO: Give page a discussion of glyph properties and move this.
positive if glyph extends above the baseline.
.
.TP
.REG .color
Color output is enabled (Boolean-valued).
.
.TP
.REG .cp
Within
.RB \[rq] do \[rq],
the saved value of compatibility mode;
see
.register .C .
.
.TP
.REG .csk
Skew of the last glyph formatted in the environment;
see
.register skw .
.
.TP
.REG .d
Vertical drawing position in diversion.
.
.TP
.REG .ev
Name of environment (string-valued).
.
.TP
.REG .f
Mounting position of selected font;
see
.request ft
and
.esc f .
.
.TP
.REG .F
Name of input file (string-valued);
see
.request lf .
.
.TP
.REG .fam
Name of the environment's default font family (string-valued).
.
.TP
.REG .fn
Resolved name of font selected in the environment (string-valued);
see
.request ft
and
.esc f .
.
.TP
.REG .fp
Next non-zero free font mounting position index.
.
.TP
.REG .g
Always true in GNU
.I troff \" GNU
(Boolean-valued).
.
.TP
.REG .h
Text baseline high-water mark on page or in diversion.
.
.TP
.REG .H
Horizontal motion quantum of output device in basic units.
.
.TP
.REG .height
Height of the environment's selected font;
see
.esc H .
.
.TP
.REG .hla
Hyphenation language in environment (string-valued).
.
.TP
.REG .hlc
Count of immediately preceding consecutive hyphenated lines in
environment.
.
.TP
.REG .hlm
Maximum quantity of consecutive hyphenated lines allowed in environment.
.
.TP
.REG .hy
Automatic hyphenation mode in environment.
.
.TP
.REG .hydefault
Hyphenation mode default in environment.
.
.TP
.REG .hym
Hyphenation margin in environment.
.
.TP
.REG .hys
Hyphenation space adjustment threshold in environment.
.
.TP
.REG .i
Environment's indentation amount;
see
.RB \[rq] in \[rq].
.
.TP
.REG .in
Indentation amount applicable to the output line pending
in the environment;
see
.request ti .
.
.TP
.REG .int
The text most recently formatted in the environment
was \[lq]interrupted\[rq] or continued with
.esc c
(Boolean-valued).
.
.TP
.REG .it
Count of input lines remaining
in the environment's pending input trap.
.
.TP
.REG .itc
The environment's pending input trap honors output line continuation
with
.esc c
(Boolean-valued).
.
.TP
.REG .itm
Name of the macro associated with the pending input trap
(string-valued).
.
.TP
.REG .j
The environment's adjustment mode encoded as an integer;
see
.request ad
and
.request na .
.
Do not interpret or perform arithmetic on its value.
.
.TP
.REG .k
The environment's horizontal drawing position relative to indentation.
.
.TP
.REG .kern
Pairwise kerning is enabled (Boolean-valued).
.
.TP
.REG .l
Line length;
see
.request ll .
.
.TP
.REG .L
Line spacing;
see
.request ls .
.
.TP
.REG .lg
Ligature mode.
.
.TP
.REG .linetabs
Line-tabs mode is enabled in the environment (Boolean-valued).
.
.TP
.REG .ll
Line length applicable to the environment's pending output line.
.
.TP
.REG .lt
Environment's title line length.
.
.TP
.REG .m
Stroke color (string-valued);
see
.request gcolor
and
.esc m .
.
The default stroke color is named
.RB \%\[lq] default \[rq].
.
.TP
.REG .M
Fill color (string-valued);
see
.request fcolor
and
.esc M .
.
The default fill color is named
.RB \&\[lq] default \[rq].
.
.TP
.REG .n
Length of formatted output on previous output line.
.
.TP
.REG .ne
Amount of vertical space required by last
.request ne
that caused a trap to be sprung;
also see
.register .trunc .
.
.TP
.REG .nm
Output line numbering is enabled in the environment (Boolean-valued).
.
.TP
.REG .nn
Count of lines remaining in the environment
for which numbering is suppressed
while output line numbering is enabled.
.
.TP
.REG .ns
No-space mode is enabled (Boolean-valued).
.
.TP
.REG .o
Page offset;
see
.request po .
.
.TP
.REG .O
Output suppression nesting level;
see
.esc O .
.
.TP
.REG .p
Page length;
see
.request pl .
.
.TP
.REG .P
The page is selected for output (Boolean-valued);
see
.I @g@troff
.B \-o
option.
.
.TP
.REG .pe
Page ejection is in progress (Boolean-valued).
.
.TP
.REG .pn
Number of the next page.
.
.TP
.REG .ps
The environment's type size in scaled points.
.
.TP
.REG .psr
The environment's most recently requested type size in scaled points;
see
.request ps
and
.esc s .
.
.TP
.REG .pvs
The environment's post-vertical line spacing.
.
.TP
.REG .R
Maximum representable integer in GNU
.IR troff . \" GNU
.
.TP
.REG .rj
Count of input lines remaining to be right-aligned
in the environment.
.
.TP
.REG .s
The environment's type size in points as a decimal fraction
(string-valued);
see
.request ps
and
.esc s .
.
.TP
.REG .slant
Slant in degrees of the environment's selected font;
see
.esc S .
.
.TP
.REG .sr
The environment's most recently requested type size
in points as a decimal fraction
(string-valued);
see
.request ps
and
.esc s .
.
.TP
.REG .ss
Size of the environment's minimum inter-word space
in twelfths of the space width of the selected font.
.
.TP
.REG .sss
Size of the environment's supplemental inter-sentence space
in twelfths of the space width of the selected font.
.
.TP
.REG .sty
The environment's selected abstract style (string-valued);
see
.request ft
and
.esc f .
.
.TP
.REG .t
Distance to next vertical position trap;
see
.request wh
and
.request ch .
.
If no such traps exist between the drawing position
and the bottom of the page,
.I @g@troff
interpolates the distance to the page bottom.
.
Within a diversion,
in the absence of a diversion trap,
this distance is
the maximum possible vertical position supported by the output device.
.
.
.TP
.REG .T
An output device was explicitly selected (Boolean-valued);
see
.I @g@troff
.B \-T
option.
.
.TP
.REG .tabs
The environment's tab stop settings
(if any)
suitable for use as argument to
.request ta
(string-valued).
.
.TP
.REG .trap
Name of the next vertical position trap
after the vertical drawing position.
(string-valued);
see
.request wh ,
.request ch ,
and
.request dt .
.
.TP
.REG .trunc
Amount of vertical space truncated by the most recently sprung
vertical position trap,
or,
if the trap was sprung by an
.request ne ,
minus the amount of vertical motion produced by
.request ne ;
also see
.register .ne .
.
.TP
.REG .u
Filling is enabled in the environment (Boolean-valued);
see
.request fi
and
.request nf .
.
.TP
.REG .U
Unsafe mode is enabled (Boolean-valued);
see
.I @g@troff
.B \-U
option.
.
.TP
.REG .v
The environment's vertical line spacing;
see
.request vs .
.
.TP
.REG .V
Vertical motion quantum of the output device in basic units.
.
.TP
.REG .vpt
Vertical position traps are enabled (Boolean-valued).
.
.TP
.REG .w
Width of last glyph formatted in the environment.
.
.TP
.REG .warn
Sum of the numeric codes of enabled warning categories.
.
.TP
.REG .x
Major version number of the running
.I @g@troff
formatter.
.
.TP
.REG .y
Minor version number of the running
.I @g@troff
formatter.
.
.TP
.REG .Y
Revision number of the running
.I @g@troff
formatter.
.
.TP
.REG .z
Name of diversion (string-valued).
.
Empty if output is directed to the top-level diversion.
.
.TP
.REG .zoom
Magnification of the environment's selected font
(in thousandths;
zero if no magnification);
see
.request fzoom .
.LE
.
.
.\" ====================================================================
.SS "Writable predefined registers"
.\" ====================================================================
.
Several registers are predefined but also modifiable;
some are updated upon interpretation of certain requests or escape
sequences.
.
Date- and time-related registers are set to the local time as determined
by
.MR localtime 3
when the formatter launches.
.
This initialization can be overridden by
.I \%SOURCE_DATE_EPOCH
and
.IR TZ ;
see section \[lq]Environment\[rq] of
.MR groff @MAN1EXT@ .
.
.
.P
.LS
.
.TP 15n
.REG $$
Process ID of
.IR @g@troff .
.
.TP
.REG %
Page number.
.
.TP
.REG c.
Input line number.
.
.TP
.REG ct
Union of character types of each glyph rendered into dummy environment
by
.esc w .
.
.TP
.REG dl
Width of last closed diversion.
.
.TP
.REG dn
Height of last closed diversion.
.
.TP
.REG dw
Day of the week (1\[en]7;
1 is Sunday).
.
.TP
.REG dy
Day of the month (1\[en]31).
.
.TP
.REG hours
Count of hours elapsed since midnight (0\[en]23).
.
.TP
.REG hp
Horizontal drawing position relative to that at the start of the input
line.
.
.TP
.REG llx
Lower-left
.I x
coordinate
(in PostScript units)
of PostScript image;
see
.request psbb .
.
.TP
.REG lly
Lower-left
.I y
coordinate
(in PostScript units)
of PostScript image;
see
.request psbb .
.
.TP
.REG ln
Output line number;
see
.request nm .
.
.TP
.REG lsn
Count of leading spaces on input line.
.
.TP
.REG lss
Amount of horizontal space corresponding to leading spaces on input
line.
.
.TP
.REG minutes
Count of minutes elapsed in the hour (0\[en]59).
.
.TP
.REG mo
Month of the year (1\[en]12).
.
.TP
.REG nl
Vertical drawing position.
.
.TP
.REG opmaxx
.TP
.REG opmaxy
.TP
.REG opminx
.TP
.REG opminy
These four registers mark the top left- and bottom right-hand corners of
a rectangle encompassing all formatted output on the page.
.
They are reset to \-1 by
.B \[rs]O0
or
.BR \[rs]O1 .
.
.TP
.REG rsb
As
.register sb ,
adding maximum glyph height to measurement.
.
.TP
.REG rst
As
.register st ,
adding maximum glyph depth to measurement.
.
.TP
.REG sb
Maximum displacement of text baseline below its original position
after rendering into dummy environment by
.esc w .
.
.TP
.REG seconds
Count of seconds elapsed in the minute (0\[en]60). \" not 59; see POSIX
.
.TP
.REG skw
Skew of last glyph rendered into dummy environment by
.esc w .
.
.TP
.REG slimit
The maximum depth of
.IR @g@troff 's
internal input stack.
.
If \[<=]0,
there is no limit:
recursion can continue until available memory is exhausted.
.
The default is 1,000.
.
.TP
.REG ssc
Subscript correction of last glyph rendered into dummy environment by
.esc w .
.
.TP
.REG st
Maximum displacement of text baseline above its original position
after rendering into dummy environment by
.esc w .
.
.TP
.REG systat
Return value of
.MR system 3 ;
see
.request sy .
.
.TP
.REG urx
Upper-right
.I x
coordinate
(in PostScript units)
of PostScript image;
see
.request psbb .
.
.TP
.REG ury
Upper-right
.I y
coordinate
(in PostScript units)
of PostScript image;
see
.request psbb .
.
.TP
.REG year
Gregorian year.
.
.TP
.REG yr
Gregorian year minus 1900.
.LE
.
.
.\" ====================================================================
.SH "Using fonts"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Using Fonts".
In digital typography,
a
.I font
is a collection of characters in a specific typeface that a device can
render as glyphs at a desired size.
.
(Terminals and some typesetters have fonts that render at only one or
two sizes.
.
As examples,
take the
.I groff
.B lj4
device's
Lineprinter,
and
.BR lbp 's
Courier and Elite faces.)
.
.
A
.I roff
formatter can change typefaces at any point in the text.
.
The basic faces are a set of
.I styles
combining upright and slanted shapes with normal and heavy stroke
weights:
.RB \[lq] R \[rq],
.RB \[lq] I \[rq],
.RB \[lq] B \[rq],
and
.RB \[lq] BI \[rq]\[em]\c
these stand for
.I roman,
.I bold,
.I italic,
and
.I bold-italic.
.
For linguistic text,
GNU
.I troff \" GNU
groups typefaces into
.I families
containing each of these styles.
.
(Font designers prepare families such that the styles share esthetic
properties.)
.
A
.I "text font"
is thus often a family combined with a style,
but it need not be:
consider the
.B ps
and
.B pdf
devices'
.B ZCMI
(Zapf Chancery Medium italic)\[em]\c
often,
no other style of Zapf Chancery Medium is provided.
.
On typesetters,
at least one
.I "special font"
is available,
comprising
.I unstyled
glyphs for mathematical operators and other purposes.
.
.
.P
Like the AT&T
.I troff \" AT&T
formatter,
GNU
.I troff \" GNU
does not itself load or manipulate a digital font file;
.\" @footnote{Historically, the fonts @code{troff}s dealt with were not
.\" Free Software or, as with the Graphic Systems C/A/T, did not even
.\" exist in the digital domain.}
instead it
works with a
.I font description file
that characterizes it,
including its glyph repertoire and the
.I metrics
(dimensions) of each glyph.
.
This information permits the formatter to accurately place glyphs with
respect to each other.
.
Before using a font description,
the formatter associates it with a
.I "mounting position,"
a place in an ordered list of available typefaces.
.
So that a document need not be strongly coupled to a specific font
family,
in GNU
.I troff \" GNU
an output device can associate a style in the abstract sense with a
mounting position.
.
Thus the default family can be combined with a style dynamically,
producing a
.I "resolved font name."
.
A user-specified font name that combines family and style,
or refers to a font that is not a member of a family,
is already \[lq]resolved\[rq].
.
.
.P
Fonts often have trademarked names,
and even Free Software fonts can require renaming upon modification.
.
.I groff
maintains a convention that a device's serif font family is given the
name
.B T
(\[lq]Times\[rq]),
its sans-serif family
.B H
(\[lq]Helvetica\[rq]),
and its
monospaced family
.B C
(\[lq]Courier\[rq]).
.
Historical inertia has driven
.IR groff 's
font identifiers to short uppercase abbreviations of font names,
as with
.BR TR ,
.BR TB ,
.BR TI ,
.BR TBI ,
and a special font
.BR S .
.
.
.P
The default family used with abstract styles can be changed at any time;
initially,
it
.RB is\~ T .
.
Typically,
abstract styles are arranged in the first four mounting positions in the
order shown above.
.
The default mounting position,
and therefore style,
is always
.B 1
.RB ( R ).
.
By issuing appropriate formatter instructions,
you can override these defaults before your document writes its first
glyph.
.
.
.P
Terminals cannot change font families and lack special fonts.
.
They support style changes by overstriking,
or by altering ISO\~6429/\:ECMA-48
.I "graphic renditions"
(character cell attributes).
.\" END Keep (roughly) parallel with groff.texi node "Using Fonts".
.
.
.P
The
.B ft
request
and
.B \[rs]f
escape sequence select a typeface by name,
abstract style,
or mounting position.
.
The
.B fam
request
and
.B \[rs]F
escape sequence set the default font family.
.
The
.B ftr
request translates one font name to another;
.B fzoom
magnifies or reduces the typeface corresponding to a resolved one.
.
.B sty
and
.B fp
associate abstract styles and font names with mounting positions.
.
.
.\" ====================================================================
.SS "Special fonts"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Special Fonts".
Special fonts are those that the formatter searches,
in mounting position order,
when it cannot find a requested glyph in the selected font.
.
Typically,
they are declared as such in their description files
.\" @footnote{@xref{Font Description File Format}.}
(see
.MR groff_font @MAN5EXT@ ),
and
contain unstyled glyphs.
.
The \[lq]Symbol\[rq] and \[lq]Zapf Dingbats\[rq] fonts
of the PostScript and PDF standards are examples.
.
Ordinarily,
only typesetters have special fonts.
.
.
.P
GNU
.IR troff 's \" GNU
.B \%special
and
.B \%fspecial
requests permit a document
to supplement the set of fonts the device configures
for glyph search
without having to use
the
.B fp
request to manipulate the list of mounting positions,
which can be tedious\[em]by default,
GNU
.I troff \" GNU
mounts 40 fonts at startup
when using the
.B ps
device.
.\" END Keep (roughly) parallel with groff.texi node "Special Fonts".
.
.\" ====================================================================
.SH Hyphenation
.\" ====================================================================
.
When filling,
.I groff
hyphenates words as needed at user-specified and automatically
determined hyphenation points.
.
Explicitly hyphenated words such as \[lq]mother-in-law\[rq] are always
eligible for breaking after each of their hyphens.
.
The hyphenation
.RB character\~ \[rs]%
and non-printing break
.RB point\~ \[rs]:
escape sequences may be used to control the hyphenation and breaking of
individual words.
.
The
.B hw
request sets user-defined hyphenation points for specified words at any
subsequent occurrence.
.
Otherwise,
.I groff
determines hyphenation points automatically by default.
.
.
.P
Several requests influence automatic hyphenation.
.
Because conventions vary,
a variety of hyphenation modes is available to the
.B hy
request;
these determine whether hyphenation will apply to a word prior to
breaking a line at the end of a page
(more or less;
see below for details),
and at which positions within that word automatically determined
hyphenation points are permissible.
.
The localization macro files loaded by
.I troffrc
configure a default hyphenation mode appropriate to the language.
.
.
.br
.ne 3v
.TP
.B 0
disables hyphenation.
.
.
.TP
.B 1
enables hyphenation except after the first and before the last character
of a word.
.
.
.P
The remaining values \[lq]imply\[rq]
.BR 1 ;
that is,
they enable hyphenation under the same conditions as
.RB \[lq] ".hy 1" \[rq],
and then apply or lift restrictions relative to that basis.
.
.
.TP
.B 2
disables hyphenation of the last word on a page or column,
even for explicitly hyphenated words.
.
(Hyphenation is prevented if the next page location trap is closer to
the vertical drawing position than the next text baseline would be.
.
See section \[lq]Traps\[rq] below.)
.
.
.TP
.B 4
disables hyphenation before the last two characters of a word.
.
.
.TP
.B 8
disables hyphenation after the first two characters of a word.
.
.
.TP
.B 16
enables hyphenation before the last character of a word.
.
.
.TP
.B 32
enables hyphenation after the first character of a word.
.
.
.P
Apart from value\~2,
restrictions imposed by the hyphenation mode are
.I not
respected for words whose hyphenations have been specified with the
hyphenation character
.RB (\[lq] \|\[rs]% \[rq]
by default)
or the
.B .hw
request.
.
.
.P
Nonzero values are additive.
.
For example,
mode\~12 causes
.I groff
to hyphenate neither the last two nor the first two characters of a
word.
.
Some values cannot be used together because they contradict;
for instance,
values 4 and\~16,
and values 8 and\~32.
.
As noted,
it is superfluous to add\~1 to any non-zero even mode.
.
.
.br
.ne 2v
.P
The places within a word that are eligible for hyphenation are
determined by language-specific data
.RB ( hla ,
.BR hpf ,
and
.BR hpfa )
and lettercase relationships
.RB ( hcode
and
.BR hpfcode ).
.
Furthermore,
hyphenation of a word might be suppressed due to a limit on
consecutive hyphenated lines
.RB ( hlm ),
a minimum line length threshold
.RB ( hym ),
or because the line can instead be adjusted with additional inter-word
space
.RB ( hys ).
.
.
.\" ====================================================================
.SH Localization
.\" ====================================================================
.
GNU
.I troff \" GNU
ties the set of hyphenation patterns
to the hyphenation language code
selected by the
.B hla
request.
.
The
.B hpf
request is usually invoked by a localization file loaded by the
.I troffrc
file.
.
.I groff
provides localization files for several languages;
See subsection \[lq]Localization packages\[rq] of
.MR groff_tmac @MAN5EXT@ .
.
For Western languages,
the localization file
sets the default hyphenation mode
and loads hyphenation patterns and exceptions.
.
By default,
.I troffrc
loads the localization file for English.
.
.
.\" ====================================================================
.SH "Writing macros"
.\" ====================================================================
.
The
.B .de
request defines a macro named for its argument.
.
If that name already exists as an alias,
the target of the alias is redefined;
see section \[lq]Strings\[rq] above.
.
.I @g@troff
enters \[lq]copy mode\[rq]
(see below),
storing subsequent input lines as the definition.
.
If the optional second argument is not specified,
the definition ends with the control line
.RB \[lq] .\|. \[rq]\&
(two dots).
.
Tabs and spaces are permitted between the dots.
.
Alternatively,
a second argument to
.B .de
names a macro whose call
(or request whose invocation)
syntax ends the definition;
this
.I "end macro"
is then interpreted normally.
.
Spaces or tabs are permitted after the first control character in the
line containing this ending token,
but a tab immediately after the token prevents its recognition as the
end of a macro definition.
.
Macro definitions can be nested if they use distinct end macros or if
their ending tokens are sufficiently escaped.
.
An end macro need not be defined until it is called.
.
This fact enables a nested macro definition to begin inside one macro
and end inside another.
.
.
.P
Variants of
.B .de
disable compatibility mode and/or indirect the names of the macros
specified for definition or termination:
these are
.BR .de1 ,
.BR .dei ,
and
.BR .dei1 .
.
Append to macro definitions with
.BR .am ,
.BR .am1 ,
.BR .ami ,
and
.BR .ami1 .
.
The
.BR .als ,
.BR .rm ,
and
.B .rn
requests create an alias of,
remove,
and rename a macro,
respectively.
.
.B \%.return
stops the execution of a macro immediately,
returning to the enclosing context.
.
.
.\" ====================================================================
.SS Parameters
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Parameters".
Macro call and string interpolation parameters can be accessed using
escape sequences starting with
.RB \[lq] \|\[rs]$ \[rq].
.
The
.B \[rs]n[.$]
read-only register stores the count of parameters available to a macro
or string;
change its value with the
.B .shift
request,
which dequeues parameters from the current list.
.
The
.B \[rs]$0
escape sequence interpolates the name by which a macro was called.
.
Applying string interpolation to a macro does not change this name.
.\" END Keep (roughly) parallel with groff.texi node "Parameters".
.
.
.\" ====================================================================
.SS "Copy mode"
.\" ====================================================================
.
GNU
.I troff \" GNU
processes certain requests in
.I "copy mode:"
it copies ordinary,
special,
and indexed characters as-is;
interpolates the escape sequences
.BR \[rs]n ,
.BR \[rs]g ,
.BR \[rs]$ ,
.BR \[rs]* ,
.BR \[rs]V ,
and
.B \[rs]?\&
normally;
discards comments
.B \[rs]"
and
.BR \[rs]# ;
interpolates
.BR \[rs]a ,
.BR \[rs]e ,
and
.BR \[rs]t ,
as the current
leader,
escape,
or
tab
character with
respectively;
represents
.\" see src/roff/troff/input.h
.BI \[rs] newline \c
,
.BR \[rs]& ,
.BR \[rs]_ ,
.BR \[rs]| ,
.BR \[rs]\[ha] ,
.BR \[rs]{ ,
.BR \[rs]} ,
.BR \[rs]\[ga] ,
.BR \[rs]\[aq] ,
.BR \[rs]\- ,
.BR \[rs]! ,
.BR \[rs]c ,
.BR \[rs]% ,
.BI \[rs] space \c
,
.BR \[rs]E ,
.BR \[rs]) ,
.BR \[rs]\[ti] ,
and
.B \[rs]:
in an encoded form,
and copies other escape sequences as-is.
.
The term \[lq]copy mode\[rq] reflects its most visible application
in requests that populate macros and strings,
but other requests also use it when interpreting arguments
that can't meaningfully represent typesetting operations.
For example,
a font selection escape sequence has no meaning
in a hyphenation pattern file name
.RB ( hpf )
or a diagnostic message written to the terminal
.RB ( tm ).
.
The complement of copy mode\[em]a
.I roff
formatter's behavior when not defining or appending to a macro,
string,
or diversion\[em]where all macros are interpolated,
requests invoked,
and valid escape sequences processed immediately upon recognition,
can be termed
.IR "interpretation mode" .
.
.
.P
The escape character
.RB ( \[rs]
by default)
when used before itself
.I quotes
an escape character for later interpreation
in an enclosing context.
.
Escape character quotation enables you to control
whether the formatter interprets a given
.BR \[rs]n ,
.BR \[rs]g ,
.BR \[rs]$ ,
.BR \[rs]* ,
.BR \[rs]V ,
or
.B \[rs]?\&
escape sequence at the time the macro containing it is defined,
or later when the macro is called.
.
.
.P
You can think of
.B \[rs]\[rs]
as a \[lq]delayed\[rq] backslash;
it is the escape character followed by a backslash from which the escape
character has removed its special meaning.
.
Consequently,
.B \[rs]\[rs]
is not best considered an escape sequence,
but a quoted escape character.
.
In any escape sequence
.BI \[rs] X
that
.I @g@troff
does not recognize,
the formatter discards the escape character and outputs
.I X.
.
An unrecognized escape sequence causes a warning in category
.RB \%\[lq] escape \[rq],
with two exceptions,
.B \[rs]\[rs]
being one.
.
The other is
.BR \[rs]. ,
which quotes the control character.
.
It is used to permit nested macro definitions to end
without a named macro call to conclude them.
.
Without a syntax for quoting the control character,
this would not be possible.
.
Outside of copy mode,
.I roff
documents should not use the
.B \[rs]\[rs]
or
.B \[rs].\&
character sequences;
they serve only to obfuscate the input.
.
Use
.B \[rs]e
to represent the escape character,
.B \[rs][rs]
to obtain a backslash glyph,
and
.B \[rs]&
before
.B .\&
and
.B \[aq]
where
.I @g@troff
expects them as control characters
if you mean to use them literally.
.
.
.br
.ne 2v
.P
Macro definitions can be nested to arbitrary depth.
.
Given the input character sequence
.RB \[lq] \|\[rs]\[rs] \[rq]
in a macro or string definition,
the formatter interpets each escape character in multiple contexts;
once,
when populating the macro or string,
where the first
.RB \[lq] \[rs] \[rq]
serves its quotation function\[em]thus
only one
.RB \[lq] \[rs] \[rq]
is stored in the definition.
.
(Verify this fact with the
.B pm
request.)
.
The formatter interprets the second
.RB \[lq] \[rs] \[rq]
as an escape character
(assuming the escape character hasn't been changed in the meantime)
each time it interpolates the macro or string definition.
.
This fact leads to exponential growth
in the quantity of escape characters
required to quote and thereby delay interpolation of
.BR \[rs]n ,
.BR \[rs]g ,
.BR \[rs]$ ,
.BR \[rs]* ,
.BR \[rs]V ,
and
.B \[rs]?\&
at each nesting level.
.
An alternative is to use
.BR \[rs]E ,
which represents an escape character that is not interpreted in copy
mode.
.
Because
.B \[rs].\&
is not a true escape sequence,
we can't use
.B \[rs]E
to keep
.RB \[lq] .\|.\& \[rq]
from ending a macro definition prematurely.
.
If the multiplicity of backslashes complicates maintenance,
use end macros.
.
.
.\" ====================================================================
.SH Traps
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Traps".
.I Traps
are locations in the output,
or conditions on the input that,
when reached or fulfilled,
call a specified macro.
.
A
.I "vertical position trap"
calls a macro when the formatter's vertical drawing position reaches or
passes,
in the downward direction,
a certain location on the output page or in a diversion.
.
Its applications include setting page headers and footers,
body text in multiple columns,
and footnotes.
.
These traps can occur at a given location either on the page
.RB ( wh ,\~ ch )
or in the current diversion
.RB ( dt )\[em]together,
these are known as
vertical position traps,
which can be disabled and re\[e ad]nabled
.RB ( vpt ).
.
.
.P
A diversion is not formatted in the context of a page,
so it lacks page location traps;
instead it can have a
.I "diversion trap."
.
There can exist at most one such vertical position trap per diversion.
.
.
.P
Other kinds of trap can be planted
at a blank line
.RB ( blm );
at a line with leading space characters
.RB ( lsm );
after a certain number of productive input lines
.RB ( it ,\~ itc );
or at the end of input
.RB ( em ).
.
.
.P
Setting a trap is also called
.I planting
one.
.
It is said that a trap is
.I sprung
if its condition is fulfilled.
.
.
.P
The formatter passes no arguments to macros called by traps.
.\" END Keep (roughly) parallel with groff.texi node "Traps".
.
.
.br
.ne 5v
.P
Registers associated with trap management include
vertical position trap enablement status
.RB ( \[rs]n[.vpt] ),
distance to the next trap
.RB ( \[rs]n[.t] ),
and the name of that trap
.RB ( \[rs]n[.trap] );
the count of lines remaining in the pending input trap
.RB ( \[rs]n[.it] ),
the name of the macro associated with it
.RB ( \[rs]n[.itm] ),
and whether that input trap honors the
.B \[rs]c
output line continuation escape sequence
.RB ( \[rs]n[.itc] );
amount of needed
.RB ( .ne -requested)
space that caused the most recent vertical position trap to be sprung
.RB ( \[rs]n[.ne] ),
amount of needed space truncated from the amount requested
.RB ( \[rs]n[.trunc] );
page ejection status
.RB ( \[rs]n[.pe] );
and
leading space count
.RB ( \[rs]n[lsn] )
with its corresponding amount of motion
.RB ( \[rs]n[lss] ).
.
.
.\" ====================================================================
.SS "Page location traps"
.\" ====================================================================
.
A
.I "page location trap"
is a vertical position trap that applies to the page;
that is,
to the top-level diversion.
.
Many can be present;
manage them with the
.B wh
and
.B ch
requests.
.
Non-negative page locations given to these requests set the trap
relative to the top of the page;
negative values set the trap relative to the bottom of the page.
.
It is not possible to plant a trap less than one basic unit from the
page bottom:
a location of \[lq]\-0\[rq] is interpreted as \[lq]0\[rq],
the top of the page.
.
An existing
.I visible
trap
(see below)
at the same location is removed;
this is
.BR wh 's
sole function if its second argument is missing.
.
.
.P
A trap is sprung only if it is
.I visible,
meaning that its location is reachable on the page and it is not hidden
by another trap at the same location already planted there.
.
(A trap planted at \[lq]20i\[rq] or \[lq]\-30i\[rq] will not be sprung
on a page of length \[lq]11i\[rq].)
.
.
.P
A trap above the top or at or below the bottom of the page
can be made visible
by either moving it into the page area
or increasing the page length so that the trap is on the page.
.
A negative trap value always uses the
.I current
page length;
the formatter does not convert it to an absolute vertical position.
.
We can use the
.B pwh
request to dump page location traps to the standard error stream;
see section \[lq]Debugging\[rq] below.
.
GNU
.I troff \" GNU
reports their positions in basic units,
and includes empty slots in the list,
where a trap had been planted
but subsequently (re)moved,
because they can affect the visibility of subsequently planted traps.
.
.
.br
.ne 6v
.\" ====================================================================
.SS "The implicit page trap"
.\" ====================================================================
.
An
.I implicit page trap
always exists in the top-level diversion
(see below);
its purpose is to eject the current page and start the next one.
.
It works like a trap in some ways but not others.
.
It has no name,
so it cannot be moved or deleted with
.B wh
or
.B ch
requests.
.
You cannot hide it by placing another trap at its location,
and can move it only by redefining the page length with
.BR pl .
.
Its operation is suppressed when vertical page traps are disabled with
GNU
.I troff's \" GNU
.B vpt
request.
.
.
.\" ====================================================================
.SH Diversions
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Diversions".
In
.I roff
systems it is possible to format text as if for output,
but instead of writing it immediately,
one can
.I divert
the formatted text into a named storage area.
.
It is retrieved later by specifying its name after a control character.
.
The formatter uses the same name space for such
.I diversions
as for strings and macros;
see section \[lq]Identifiers\[rq] above.
.
Such text is sometimes said to be \[lq]stored in a macro\[rq],
but this coinage obscures the important distinction
between macros and strings on one hand
and diversions on the other;
the former store
.I unformatted
input text,
and the latter capture
.I formatted
output.
.\" TODO: Add forward reference when we add a "GNU troff internals"
.\" subsection to this page.
.
Diversions also do not interpret arguments.
.
Applications of diversions include
footnotes,
tables of contents,
indices,
and \[lq]keeps\[rq]
(preventing a page break from occurring at an inconvenient place
by forcing a set of output lines to be set as a group).
.
For orthogonality it is said that GNU
.I troff \" GNU
populates the
.I top-level diversion
if no diversion is active
(that is,
formatted output is being \[lq]diverted\[rq] directly
to the output device).
.
The top-level diversion has no name.
.
.
.P
Dereferencing an undefined diversion creates an empty one of that name.
.
(GNU
.I troff \" GNU
also emits a warning in category
\[lq]mac\[rq];
see section \[lq]Warnings\[rq] of
.MR @g@troff @MAN1EXT@ .)
.
A diversion does not exist for the purpose of testing with the
.B d
conditional expression operator
until its initial definition ends;
see subsection \[lq]Conditional expressions\[rq] above.
.\" The following requests create and alter diversions.
.
.
.P
The
.B di
request creates a diversion,
including any partially collected line.
.
.B da
appends to a diversion,
creating one if it does not already exist.
.
If the diversion's name already exists as an alias,
the target of the alias is replaced or appended to;
see section \[lq]Strings\[rq] above.
.
The pending output line is diverted as well.
.
Switching to another environment
(with the
.B ev
request)
before invoking
.B di
or
.B da
avoids including any pending output line in the diversion.
(See section \[lq]Environments[\[rq] below.)
.
.
.P
Invoking
.B di
or
.B da
without an argument stops diverting output
to the diversion named by the most recent corresponding request.
.
Invoking
.B di
or
.B da
without an argument
when no diversion is being populated does nothing.
.
(GNU
.I troff \" GNU
emits a warning in category
\[lq]di\[rq];
see section \[lq]Warnings\[rq] of
.MR @g@troff @MAN1EXT@ .)
.
.
.P
.B box
and
.B boxa
work similarly,
but ignore partially collected lines.
.
Call any of these macros again without an argument to end the diversion.
.
.
.br
.ne 2v
.P
Diversion requests can be nested.
.
The registers
.B .d
and
.B .z
report information about the current diversion,
and
.B dn
and
.B dl
about the most recently closed one.
.
.B .h
is meaningful in diversions,
including the top-level one.
.
.
.P
After output to a (named) diversion stops,
the formatter stores its vertical and horizontal sizes,
to the writable registers
.B dn
and
.BR dl ,
respectively.
.\" XXX Do these measure:
.\"  net motion of the drawing position,
.\"  maximal motion of the drawing position relative to that where the
.\"  diversion started,
.\" or
.\"  the maximal bounds of spilled ink relative to the drawing position
.\"  where the diversion started?
.\" Savannah #64728.
.
Only the lines just processed are counted:
for the computation of
.B dn
and
.BR dl ,
the requests
.B da
and
.B boxa
are handled as if
.B di
and
.B box
had been used,
respectively\[em]lines that have been already stored in the diversion
(box) are not taken into account.
.
.
.P
The
.B \[rs]!\&
and
.B \[rs]?\&
escape sequences and
.B output
request escape from a diversion,
the first two to the enclosing level and the last to the top level.
.
This facility is termed
.IR "transparent embedding" .
.
.
.P
The
.B \%asciify
and
.RB \%\[lq] unformat \[rq]
requests reprocess diversions.
.\" XXX: That's a weak statement.  What we need is a `for` request and
.\" a new conditional expression operator that tests whether an item in
.\" a node list is an (otherwise unrepresentable) node.  See Savannah
.\" #62264.
.\" END Keep (roughly) parallel with groff.texi node "Diversions".
.
.
.\" ====================================================================
.SH "Punning names"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Punning Names".
Macros,
strings,
and diversions share a name space;
see section \[lq]Identifiers\[rq] above.
.
Internally,
the same mechanism is used to store them.
.
You can thus call a macro with string interpolation syntax and vice
versa.
.
Interpolating a string does not hide existing macro arguments.
.
Place the sequence
.B \[rs]\[rs]
at the end of a line in a macro definition or,
within a macro definition,
immediately after the interpolation of a macro as a string,
to suppress the effect of a newline.
.\" END Keep (roughly) parallel with groff.texi node "Punning Names".
.
.
.\" ====================================================================
.SH Environments
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Environments".
Environments store most of the parameters that control text processing.
.
A default environment named
.RB \[lq] 0 \[rq]
(zero)
exists when
exists when the formatter starts up;
formatting-related requests and escape sequences modify its properties.
.
.
.P
You can create new environments and switch among them.
.
Only one is current at any given time.
.
Active environments are managed using a
.I stack,
a data structure supporting \[lq]push\[rq] and \[lq]pop\[rq] operations.
.
The current environment is at the top of the stack.
.
The same environment name can be pushed onto the stack multiple times,
possibly interleaved with others.
.
Popping the environment stack does not destroy the current environment;
it remains accessible by name and can be made current again
by pushing it at any time.
.
Environments cannot be renamed or deleted,
and can only be modified when current.
.
To inspect the environment stack,
use the
.B pev
request;
see section \[lq]Debugging\[rq] below.
.
.
.P
Environments store the following information.
.
.
.IP \[bu] 3n
a partially collected line, if any
.
.
.IP \[bu]
data about the most recently output glyph and line
(registers
.BR .cdp ,
.BR .cht ,
.BR .csk ,
.BR .n ,
.BR .w )
.
.
.IP \[bu]
typeface parameters
(size,
family,
style,
height and slant,
inter-word and inter-sentence space sizes)
.
.
.IP \[bu]
page parameters
(line length,
title length,
vertical spacing,
line spacing,
indentation,
line numbering,
centering,
right-alignment,
underlining,
hyphenation parameters)
.
.
.IP \[bu]
filling enablement;
adjustment enablement and mode
.
.
.IP \[bu]
tab stops;
tab,
leader,
escape,
control,
no-break control,
hyphenation,
and
margin characters
.
.
.IP \[bu]
input line traps
.
.
.IP \[bu]
stroke and fill colors
.
.
.P
The
.B ev
request
(with an argument)
pushes to
and
(without)
pops from the environment stack,
while
.B evc
copies a named environment's parameters to the current one.
.\" END Keep (roughly) parallel with groff.texi node "Environments".
.
.
.\" ====================================================================
.SH "Postprocessor access"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Postprocessor
.\" Access".
Beyond the
.B cf
and
.B trf
requests,
two escape sequences and two requests enable documents
to pass information directly to a postprocessor.
.
These are useful for exercising device-specific capabilities that the
.I groff
language does not abstract or generalize;
examples include the embedding of hyperlinks and image files.
.
Device-specific functions are documented
in each output driver's man page,
such as
.MR gropdf @MAN1EXT@ ,
.MR grops @MAN1EXT@ ,
or
.MR grotty @MAN1EXT@ .
.
.
.P
The
.RB \[lq] device \[rq]
request and
.B \[rs]X
escape sequence embed their arguments into GNU
.I troff \" GNU
output as parameters to an
.RB \[lq] "x X" \[rq]
device extension command
(see
.MR groff_out @MAN5EXT@ ).
.
The interpretation of such parameters is determined by the output driver
or other postprocessor.
.
.
.P
GNU
.I troff \" GNU
also permits the interpolation of macro or string contents
as a device extension command.
.
The
.B \%devicem
request and
.B \[rs]Y
escape sequence correspond to
.RB \[lq] ".device \[rs]*[\c"
.IB name ]\c
\[rq]
and
.RB \[lq] \[rs]X\[aq]\[rs]*[\c
.IB name ]\c
\[rq],
respectively.
.
They differ from their counterparts
in that GNU
.I troff \" GNU
does not interpret the contents of the string or macro
.IR name ;
further,
.I name
may be a macro and thus contain newlines.
.
(There is no way to embed a newline in the arguments to
.RB \%\[lq] device \[rq]
or
.BR \[rs]X .)
.
The inclusion of newlines requires an extension to the AT&T
.I troff \" AT&T
device-independent page description language,
and their presence confuses drivers that do not know about it
(see subsection \[lq]Device control commands\[rq] of
.MR groff_out @MAN5EXT@ ).
.
.
.P
The
.B tag
and
.B taga
requests are reserved for internal use.
.\" END Keep (roughly) parallel with groff.texi node "Postprocessor
.\" Access".
.
.
.\" ====================================================================
.SH Underlining
.\" ====================================================================
.
In
.I RUNOFF
(see
.MR roff @MAN7EXT@ ),
underlining,
even of lengthy passages,
was straightforward because only fixed-pitch printing devices were
targeted.
.
Typesetter output posed a greater challenge.
.
There exists a
.I groff
request
.B .ul
(see above)
that underlines subsequent source lines on terminals,
but on typesetters,
it selects an italic font style instead.
.
.
The
.I ms
macro package
(see
.MR groff_ms @MAN7EXT@ )
offers a macro
.BR .UL ,
but it too produces the desired effect only on typesetters,
and has other limitations.
.
.
.P
One could adapt
.IR ms 's
approach to the construction of a macro as follows.
.
.RS
.EX
\&.de UNDERLINE
\&. ie n \[rs]\[rs]$1\[rs]f[I]\[rs]\[rs]$2\[rs]f[P]\[rs]\[rs]$3
\&. el \[rs]\[rs]$1\[rs]Z\[aq]\[rs]\[rs]$2\[aq]\[rs]v\[aq].25m\[aq]\
\[rs]D\[aq]l \[rs]w\[aq]\[rs]\[rs]$2\[aq]u 0\[aq]\[rs]v\[aq]\-.25m\
\[aq]\[rs]\[rs]$3
\&..
.EE
.RE
.
If
.MR doclifter 1
makes trouble, change the macro name
.B UNDERLINE
into some 2-letter word, like
.BR Ul .
.
Moreover,
change the form of the font selection escape sequence from
.B \[rs]f[P]
to
.BR \[rs]fP .
.
.
.\" ====================================================================
.SS "Underlining without macro definitions"
.\" ====================================================================
.
If one does not want to use macro definitions,
e.g.,
when
.I doclifter
gets lost,
use the following.
.
.RS
.EX
\&.ds u1 before
\&.ds u2 in
\&.ds u3 after
\&.ie n \[rs]*[u1]\[rs]f[I]\[rs]*[u2]\[rs]f[P]\[rs]*[u3]
\&.el \[rs]*[u1]\[rs]Z\[aq]\[rs]*[u2]\[aq]\[rs]v\[aq].25m\[aq]\[rs]D\
\[aq]l \[rs]w\[aq]\[rs]*[u2]\[aq]u 0\[aq]\[rs]v\[aq]\-.25m\[aq]\[rs]*\
[u3]
.EE
.RE
.
.ne 2v
When using
.IR doclifter ,
it might be necessary to change syntax forms such as
.B \e[xy]
and
.B \e*[xy]
to those supported by AT&T
.IR troff :
.B \e*(xy
and
.BR \e(xy ,
and so on.
.
.
.P
Then these lines could look like
.RS
.EX
\&.ds u1 before
\&.ds u2 in
\&.ds u3 after
\&.ie n \[rs]*[u1]\[rs]fI\[rs]*(u2\[rs]fP\[rs]*(u3
\&.el \[rs]*(u1\[rs]Z\[aq]\[rs]*(u2\[aq]\[rs]v\[aq].25m\[aq]\[rs]D\
\[aq]l \[rs]w\[aq]\[rs]*(u2\[aq]u 0\[aq]\[rs]v\[aq]\-.25m\[aq]\[rs]*(u3
.EE
.RE
.
.
.P
The result looks like
.RS
.ft CR
before
\z\[ul]i\
\z\[ul]n
after
.ft R
.RE
.
.
.\" ====================================================================
.SS "Underlining by overstriking with \[rs](ul"
.\" ====================================================================
.
The
.B \[rs]z
escape sequence writes a glyph without advancing the
drawing position,
enabling overstriking.
.
Thus,
.BI \[rs]z c \[rs](ul
formats
.I c
with an underrule glyph on top of it.
.
Video terminals implement the underrule by setting a character cell's
underline attribute,
so this technique works in both
.I nroff \" mode
and
.I troff \" mode
modes.
.
.
.P
Long words may then look intimidating in the input;
a clarifying approach might be to use the input line continuation escape
sequence
.BI \[rs] newline
to place each underlined character on its own input line.
.
Thus,
.
.RS
.EX
\&.nf
\[rs]&\[rs]fB: ${\[rs]fIvar\[rs]fR\[rs]c
\[rs]zo\[rs](ul\[rs]
\[rs]zp\[rs](ul\[rs]c
\[rs]&\[rs]fIvalue\[rs]fB}
\&.fi
.EE
.RE
.
produces
.
.RS
.EX
.BI ": ${" var \c
\zo\(ul\
\zp\(ul\c
.IB value }
.EE
.RE
.
as output.
.
.
.\" ====================================================================
.SH "Compatibility mode"
.\" ====================================================================
.
.MR groff_diff @MAN7EXT@
documents differences between the
.I roff
language recognized by
GNU
.I troff \" GNU
and that of
AT&T
.IR troff , \" AT&T
as well as the device,
font,
and device-independent page description formats described by
CSTR\~#54.
.
GNU
.I troff \" GNU
provides an
AT&T
.I troff \" AT&T
compatibility mode.
.
The
.request cp
request and registers
.B .C
and
.B .cp
set and test the enablement of this mode.
.
.
.\" ====================================================================
.SH Debugging
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Debugging".
Preprocessors use the
.B lf
request to preserve the identities of line numbers and names of input
files.
.
.I groff
emits a variety of error diagnostics and supports several categories of
warning;
the output of these can be selectively suppressed with
.RB \[lq] warn \[rq]
(and see the
.BR \-E ,
.BR \-w ,
and
.B \-W
options of
.MR @g@troff @MAN1EXT@ ).
.
A trace of the formatter's input processing stack can be emitted when
errors or warnings occur by means of
.MR @g@troff @MAN1EXT@ 's
.B \-b
option,
or produced on demand with the
.request backtrace
request.
.
.BR tm ,
.BR tmc ,
and
.B tm1
can be used to emit customized diagnostic messages or for
instrumentation while troubleshooting.
.
.B ex
and
.B ab
cause early termination with successful and error exit codes
respectively,
to halt further processing when continuing would be fruitless.
.
Examine the state of the formatter with requests that write lists of
defined names\[em]macros,
strings,
and
.RB diversions\[em]( pm );
characters
.RB ( pchar "; experimental);"
colors
.RB ( pcolor );
composite character mappings
.RB ( pcomposite );
environments
.RB ( pev );
occupied font mounting positions
.RB ( pfp );
font translations
.RB ( pftr );
automatic hyphenation codes
.RB ( pchar )
and exceptions
.RB ( phw );
registers
.RB ( pnr );
open streams
.RB ( pstream );
and
page location traps
.RB ( pwh ).
.
Requests can also disclose
to the standard error stream
the internal properties and representations of
characters and classes
.RB ( pchar ),
macros
(and strings and diversions)
.RB ( pm ),
and the list of output nodes corresponding to the pending input line
.RB ( pline ).
.\" END Keep (roughly) parallel with groff.texi node "Debugging".
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
This document was written by
Trent A.\& Fisher,
.MT wl@\:gnu\:.org
Werner Lemberg
.ME ,
and
.MT g.branden\:.robinson@\:gmail\:.com
G.\& Branden Robinson
.ME .
.
Section \[lq]Underlining\[rq] was primarily written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.ne 2v
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \[lq]info groff\[rq].
.
.
.br
.ne 4v
.P
\[lq]Troff User's Manual\[rq]
by Joseph F.\& Ossanna,
1976
(revised by Brian W.\& Kernighan,
1992),
AT&T Bell Laboratories Computing Science Technical Report No.\& 54,
widely called simply \[lq]CSTR\~#54\[rq],
documents the language,
device and font description file formats,
and device-independent page description language
referred to collectively in
.I groff
documentation as
.RI \[lq]AT&T\~ troff \[rq].
.
.
.br
.ne 3v
.P
\[lq]A Typesetter-independent TROFF\[rq]
by Brian W.\& Kernighan,
1982,
AT&T Bell Laboratories Computing Science Technical Report No.\& 97
(CSTR\~#97),
provides additional insights into the
device and font description file formats
and device-independent page description language.
.
.
.TP
.MR groff @MAN1EXT@
is the preferred interface to the
.I groff
system;
it manages the pipeline that carries a source document through
preprocessors,
the
.I @g@troff
formatter,
and an output driver to viewable or printable form.
.
It also exhaustively lists the man pages provided with the GNU
.I roff
system.
.
.
.TP
.MR groff_char @MAN7EXT@
discusses character encoding issues
and escape sequences that produce glyphs.
.
.
.TP
.MR groff_diff @MAN7EXT@
covers differences between the
GNU
.I troff \" GNU
formatter,
its device and font description file formats,
its device-independent page description language,
and those of AT&T
.IR troff .\" AT&T
.
.
.TP
.MR groff_font @MAN5EXT@
describes the formats of the files that describe devices
.RI ( DESC )
and fonts.
.
.
.TP
.MR groff_tmac @MAN5EXT@
surveys macro packages provided with
.IR groff ,
describes how documents can take advantage of them,
offers guidance on writing macro packages and using diversions,
and includes historical information.
.\" slack text for widow/orphan management
.\" on macro package naming conventions.
.
.
.TP
.MR roff @MAN7EXT@
presents a detailed history of
.I roff
systems and summarizes concepts common to them.
.
.
.\" Clean up.
.rm tx
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_groff_7_man_C]
.do rr *groff_groff_7_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
