.TH glilypond @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
glilypond \- embed LilyPond musical notation in
.I groff
documents
.
.
.\" TODO: This page needs a thorough edit by a fluent English speaker.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright 2013-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of glilypond.
.\"
.\" glilypond is distributed with groff, the GNU roff typesetting
.\" system.
.\"
.\" groff is free software; you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" groff is distributed in the hope that it will be useful, but WITHOUT
.\" ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
.\" or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
.\" License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <https://www.gnu.org/licenses/>.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_glilypond_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY glilypond
.RB [ \-k ]
.RB [{ \-\-ly2eps | \-\-pdf2eps }]
.RB [ \-e
.IR directory ]
.RB [ \-o
.IR output-file ]
.RB [ \-p
.IR filename-prefix ]
.RB [ \-t
.IR tdir ]
.RB [{ \-v | \-V }]
.RB [ \-\- ]
.RI [ file\~ .\|.\|.]
.YS
.
.SY glilypond
.RB [{ \-\-ly2eps | \-\-pdf2eps }]
.RB [ \-\-eps_dir
.IR directory ]
.RB [ \-\-keep_all ]
.RB [ \-\-output
.IR output-file ]
.RB [ \-\-prefix
.IR filename-prefix ]
.RB [ \-\-temp_dir
.IR tdir ]
.RB [ \-\-verbose ]
.RB [ \-\- ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY glilypond
.B \-?
.YS
.
.SY glilypond
.B \-h
.YS
.
.SY glilypond
.B \-\-help
.YS
.
.SY glilypond
.B \-\-usage
.YS
.
.
.P
.SY glilypond
.B \-l
.YS
.
.SY glilypond
.B \-\-license
.YS
.
.
.P
.SY glilypond
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I glilypond
is a
.MR groff @MAN7EXT@
preprocessor that enables the embedding of LilyPond music scores in
.I groff
documents.
.\".
.\".B .PDFPIC
.\"is available, but does not yet work with lilypond.
.
If no operands are given,
or if
.I file
is
.RB \[lq] \- \[rq],
.I glilypond
reads the standard input stream.
.
A double-dash argument
.RB (\[lq] \-\- \[rq])
causes all subsequent arguments to be interpreted as
.I file
operands,
even if their names start with a dash.
.
.
.P
.I \%glilypond
requires the
.I \%File::HomeDir
Perl module,
available via
.UR \%https://\:www\:.cpan\:.org/
CPAN
.UE .
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
At present,
.I glilypond
works with the
.I groff
.BR ps ,
.BR dvi ,
.BR html ,
and
.B xhtml
devices.
.
The
.B lbp
and
.B lj4
devices are untested.
.
Unfortunately,
the
.B pdf
device does not yet work.
.
.
.\" ====================================================================
.SH "Option overview"
.\" ====================================================================
.
.
.TP
.BR \-? | \-h | \-\-help | \-\-usage
Display usage information and exit.
.
.TP
.B \%\-\-version
Display version information and exit.
.
.TP
.BR \-l | \-\-license
Display copyright license information and exit.
.
.
.\" ====================================================================
.SS "Options for building EPS files"
.\" ====================================================================
.
.TP
.B \-\-ly2eps
Direct
.MR lilypond 1
to create Encapsulated PostScript (EPS) files.
.
This is the default.
.
.
.TP
.B \-\-pdf2eps
The program
.I glilypond
generates a PDF file using
.IR lilypond .
.
Then the EPS file is generated by
.I pdf2ps
and
.IR ps2eps .
.
.
.\" ====================================================================
.SS "Directories and files"
.\" ====================================================================
.
.TP
.BR \-e | \-\-eps_dir "\fI directory_name\fP"
Normally all
.I EPS
files are sent to the temporary directory.
.
With this option,
you can generate your own directory,
in which all useful
.I EPS
files are send.
.
So at last, the temporary directory can be removed.
.
.
.TP
.BR \-p | \-\-prefix "\fI begin_of_name\fP"
Normally all temporary files get names that start with the
.BI ly .\|.\|.\&
prefix.
.
With this option, you can freely change this prefix.
.
.
.TP
.BR \-k | \-\-keep_all
Normally all temporary files without the
.I eps
files are deleted.
.
With this option, all generated files either by the
.I lilypond
program or other format transposers are kept.
.
.
.TP
.BR \-t | \-\-temp_dir "\fI dir\fP"
With this option, you call a directory that is the base for the
temporary directory.
.
This directory name is used as is without any extensions.
.
If this directory does not exist it is be created.
.
The temporary directory is created by Perl's security operations
directly under this directory.
.
In this temporary directory, the temporary files are stored.
.
.
.\" ====================================================================
.SS Output
.\" ====================================================================
.
.TP
.BR \-o | \-\-output "\fI file_name\fP"
Normally all
.I groff
output of this program is sent to
.BR STDOUT .
.
With this option, that can be changed, such that the output is stored
into a file named in the option argument
.IR file_name .
.
.
.TP
.BR \-v | \-V | \-\-verbose
A lot more of information is sent to STDERR.
.
.
.\" ====================================================================
.SS "Short option collections"
.\" ====================================================================
.
The argument handling of options
.
.
.P
.I "Short options"
are arguments that start with a single dash
.BR \- .
.
Such an argument can consist of arbitrary many options without option
argument, composed as a collection of option characters following the
single dash.
.
.
.P
Such a collection can be terminated by an option character that
expects an option argument.
.
If this option character is not the last character of the argument,
the following final part of the argument is the option argument.
.
If it is the last character of the argument, the next argument is
taken as the option argument.
.
.
.P
This is the standard for
.I POSIX
and
.I GNU
option management.
.
.
.P
For example,
.
.TP
.BI \-kVe " some_dir"
is a collection of the short options
.B \-k
and
.B \-V
without option argument, followed by the short option
.B \-e
with option argument that is the following part of the argument
.IR some_dir .
.
So this argument could also be written as several arguments
.B \-k \-V \-e
.IR some_dir .
.
.
.\" ====================================================================
.SS "Handling of long options"
.\" ====================================================================
.
Arguments that start with a double dash
.B \-\-
are so-called
.I "long options" R .
.
Each double dash argument can only have a single long option.
.
.
.P
.I "Long options"
have or have not an option argument.
.
An option argument can be the next argument or can be appended with an
equal sign
.B =
to the same argument as the long option.
.
.
.TP
.B \-\-help
is a long option without an option argument.
.
.TP
.BI \-\-eps_dir " some_dir"
.TQ
.BI \-\-eps_dir= some_dir
is the long option
.B \-\-eps_dir
with the option argument
.IR some_dir .
.
.
.P
Moreover the program allows abbreviations of long options, as much as
possible.
.
.
.P
The
.I "long option"
.B \-\-keep_all
can be abbreviated from
.B \-\-keep_al
up to
.B \-\-k
because the program does not have another
.I "long option"
whose name starts with the character
.BR k .
.
.
.P
On the other hand, the option
.B \%\-\-version
cannot be abbreviated further than
.B \-\-vers
because there is also the
.I long option
.B \-\-verbose
that can be abbreviated up to
.BR \-\-verb .
.
.
.P
An option argument can also be appended to an abbreviation.
.
So is
.BI \-\-e= some_dir
the same as
.B \-\-eps_dir
.IR some_dir .
.
.
.P
Moreover the program allows an arbitrary usage of upper and lower case
in the option name.
.
This is
.I Perl
style.
.
.
.P
For example, the
.I "long option"
.B \-\-keep_all
can as well be written as
.B \-\-Keep_All
or even as an abbreviation like
.BR \-\-KeE .
.
.
.br
.ne 6v
.\" ====================================================================
.SH "LilyPond regions in \f[I]roff\f[] input"
.\" ====================================================================
.
.\" ====================================================================
.SS "Integrated LilyPond code"
.\" ====================================================================
.
A
.I lilypond
part within a structure written in the
.I groff
language is the whole part between the marks
.RS
.EX
.B ".lilypond start"
.EE
.RE
and
.RS
.EX
.B ".lilypond end"
.EE
.RE
.
A
.I groff
input can have several of these
.I lilypond
parts.
.
.
.P
When processing such a
.I lilypond
part between
.B ".lilypond start"
and
.B ".lilypond end"
we say that the
.B glilypond
program is in
.IR "lilypond mode" .
.
.
.P
These
.I lilypond
parts are sent into temporary
.I lilypond
files with the file name extension
.BR .ly .
.
These files are transformed later on into
.I EPS
files.
.
.
.\" ====================================================================
.SS "Inclusion of \f[I].ly\f[] files"
.\" ====================================================================
.
An additional command line for file inclusion of
.I lilypond
files is given by
.EX
.BI ".lilypond include" " file_name"
.EE
in
.I groff
input.
.
For each such
.I include
command, one file of
.I lilypond
code can be included into the
.I groff
code.
.
Arbitrarily many of these commands can be included in the
.I groff
input.
.
.
.P
These include commands can only be used outside the
.I lilypond
parts.
.
Within the
.IR "lilypond mode" ,
this inclusion is not possible.
.
So
.B ".lilypond include"
may not be used in
.IR "lilypond mode" ,
i.e.\& between
.B ".lilypond start"
and
.BR ".lilypond end" .
.
.
These included
.IR ly -files
are also transformed into
.I EPS
files.
.
.
.\" ====================================================================
.SH "Generated files"
.\" ====================================================================
.
By the transformation process of
.I lilypond
parts into
.I EPS
files, there are many files generated.
.
By default, these files are regarded as temporary files and as such
stored in a temporary directory.
.
This process can be changed by command-line options.
.
.
.\" ====================================================================
.SS "Command-line options for directories"
.\" ====================================================================
.
The temporary directory for this program is either created
automatically or can be named by the option
.BR \-t | \-\-temp_dir
.IR dir .
.
.
.P
Moreover, the
.I EPS
files that are later on referred by
.B .PSPIC
command in the final
.I groff
output can be stored in a different directory that can be set by the
command-line option
.BR \-e | \-\-eps_dir
.IR directory_name .
.
With this option, the temporary directory can be removed completely at
the end of the program.
.
.
.P
The beginning of the names of the temporary files can be set by the
command-line options
.B \-p
or
.BR \-\-prefix .
.
.
.P
All of the temporary files except the
.I EPS
files are deleted finally.
.
This can be changed by setting the command-line options
.B \-k
or
.BR \-\-keep_files .
.
With this, all temporary files and directories are kept, not deleted.
.
.
.P
These
.I EPS
files are stored in a temporary or
.I EPS
directory.
.
But they cannot be deleted by the transformation process because they
are needed for the display which can take a long time.
.
.
.\" ====================================================================
.SH "Transformation processes for generating EPS files"
.\" ====================================================================
.
.\" ====================================================================
.SS "Mode pdf2eps"
.\" ====================================================================
.
In this mode,
the current default,
.B .ly
files are transformed by the
.MR lilypond 1
program into
.I PDF
files, using
.RS
.EX
.BI "lilypond \-\-pdf \-\-output=" file-name
.EE
.RE
for each
.B .ly
file.
.
The
.I file-name
must be provided without the extension
.BR .pdf .
.
By this process, a file
.IB file-name .pdf
is generated.
.
.
.P
The next step is to transform these
.I PDF
files into a
.I PS
file.
.
This is done by the
.MR pdf2ps 1
program using
.RS
.EX
$\~\c
.B pdf2ps\~\c
.IB file-name .pdf\~\c
.IB file-name .pds
.EE
.RE
.
.
The next step creates an
.I EPS
file from the
.I PS
file.
.
This is done by the
.MR ps2eps 1
program using
.RS
.EX
.RB "$ " "ps2eps " \fIfile-name\fP ".ps"
.EE
.RE
.
.
.P
By that, a file
.IB file-name .eps
is created for each
.I lilypond
part in the
.I groff
file or standard input.
.
.
.P
The last step to be done is replacing all
.I lilypond
parts by the
.I groff
command
.RS
.EX
.BI ".PSPIC " file-name .eps
.EE
.RE
.
.
.\" ====================================================================
.SS "Mode ly2eps"
.\" ====================================================================
.
In earlier time, this mode was the default.
.
But now it does not work any more, so accept the new default
.IR pdf2eps .
.
For testing, this mode can also be chosen by the
.I glilypond
option
.BR \-\-ly2eps .
.
.
.P
In this mode, the
.B .ly
files are transformed by the
.I lilypond
program into many files of different formats, including
.I eps
files, using
.RS
.EX
$\~\c
.B lilypond \-\-ps \-dbackend=eps \-dgs\-load\-fonts \-\-output=\c
.I file-name
.EE
.RE
for each
.B .ly
file.
.
The output
.I file\-name
must be provided without an extension, its directory is temporary.
.
.
.P
There are many
.I EPS
files created.
.
One having the complete transformed
.B ly
file, named
.IB file\-name .eps \fR.\fP
.
.
.P
Moreover there are
.I EPS
files for each page, named
.IB file\-name \- digit .eps \fR.\fP
.
.
.P
The last step to be done is replacing all
.I lilypond
parts by the collection of the corresponding
.I EPS
page files.
.
This is done by
.I groff
commands
.EX
.BI ".PSPIC " file-name \- digit .eps
.EE
.
.
.\" ====================================================================
.SH "Generated \f[I]groff\f[] output"
.\" ====================================================================
.
The new
.MR groff @MAN7EXT@
structure generated by
.I glilypond
is either
.
.TP
1)
sent to standard output and can there be saved into a file or piped into
.MR groff @MAN1EXT@
or
.
.TP
2)
stored into a file by given the option
.BR \-o\ \~| \~\-\-output
.I file_name
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I glilypond
was written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.TP
.MR groff @MAN1EXT@
describes the usage of the
.I groff
command and contains pointers to further documentation of the
.I groff
system.
.
.
.TP
.MR groff_tmac @MAN5EXT@
describes the
.B .PSPIC
request.
.
.
.TP
.MR lilypond 1
briefly describes the
.I lilypond
command and contains pointers to further documentation.
.
.
.TP
.MR pdf2ps 1
transforms a
.I PDF
file into a
.I PostScript
format.
.
.
.TP
.MR ps2eps 1
transforms a
.I PS
file into an
.I EPS
format.
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_glilypond_1_man_C]
.do rr *groff_glilypond_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
